<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>
        <div class="row">

            <div class="col-xs-12 col-md-9">
                <div class="form-group">
                    <label for="booking_name">Name:</label>
                    <input type="text" name="booking_name" id="booking_name" class="form-control" placeholder="Enter Name Here" value="<?php echo $this->objModel->strBookingName; ?>">
                </div>
                <div class="form-group">
                    <label for="booking_title">Title:</label>
                    <input type="text" name="booking_title" id="booking_title" class="form-control" placeholder="Enter Email Here" value="<?php echo $this->objModel->strTitle; ?>">
                </div>
                <div class="form-group">
                    <label for="booking_email">Email:</label>
                    <input type="text" name="booking_email" id="booking_email" class="form-control" placeholder="Enter Email Here" value="<?php echo $this->objModel->strEmail; ?>">
                </div>
                <div class="form-group">
                    <label for="booking_phone">Office Phone:</label>
                    <input type="text" name="booking_phone" id="booking_phone" class="form-control" placeholder="Enter Phone Here" value="<?php echo $this->objModel->strPhone; ?>">
                </div>
                <div class="form-group">
                    <label for="booking_cell">Cell Phone:</label>
                    <input type="text" name="booking_cell" id="booking_cell" class="form-control" placeholder="Enter Phone Here" value="<?php echo $this->objModel->strCell; ?>">
                </div>
                
                <div class="form-group">
                    <label for="booking_description">Coments:</label>
                    <textarea name="booking_description" id="booking_description" class="form-control" rows="15"><?php echo $this->objModel->strDescription; ?></textarea>
                    <script type="text/javascript">loadRTE('booking_description','booking_description');</script>
                </div>
                
            </div>

            <div class="col-xs-12 col-md-3">
                
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Booking Agent Image</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <label for="booking_image" class="sr-only">Display Image:</label>
                            <input type="file" name="booking_image" id="booking_image" class="form-control">
                        </div>

                        <?php if (!empty($this->objModel->strDisplayImage)) { ?>
                        <div class="well well-sm"><?php Util::displayThumb($this->objModel->strDisplayImage, 333, 150, 3); ?></div>
                        <div class="checkbox">
                            <label><input type="checkbox" name="files_to_delete[booking_image]" id="files_to_delete" value="<?php echo $this->objModel->strDisplayImage; ?>"> Remove Image</label>
                        </div>
                        <?php } ?>
                    </div>
                </div>

                 <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Reporting Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="form-group">
                            <input type="checkbox" name="payment_status_cron" id="payment_status_cron" <?php echo ($this->objModel->strPaymentReports == 1) ? 'checked' : ''; ?> value="1">
                            <label for="payment_status_cron">Recieve Payment Reports</label>
                        </div>
                
                        <div class="form-group hidden">
                            <input type="checkbox" name="detail_reports_cron" id="detail_reports_cron" <?php echo ($this->objModel->strDetailReports == 1) ? 'checked' : ''; ?> value="1">
                            <label for="detail_reports_cron">Recieve Booking Reports</label>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </form>
</div>