<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="detail-view">
    <h1 class="page-header">Add / Edit <?php echo $this->objModel->strTitle; ?></h1>
    <form action="<?php echo $this->strOptions; ?>" role="form" id="detail-form" method="post" enctype="multipart/form-data">
        <?php
        if($this->strErrorMessage != '') {
            echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
        } else if($this->strSuccessMessage != '') {
            echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
        }
        ?>
        <div class="row">
            <div class="col-xs-12 col-md-9">
                <div class="form-group">
                    <label for="ad_title">Title:</label>
                    <input type="text" name="ad_title" id="ad_title" class="form-control" placeholder="Enter Title Here" value="<?php echo $this->objModel->strAdTitle; ?>">
                </div>
                <div class="form-group">
                    <label for="ad_detail">Content:</label>
                    <textarea name="ad_detail" id="ad_detail" class="form-control" rows="15"><?php echo $this->objModel->strAdDetail; ?></textarea>
                    <script type="text/javascript">loadRTE('ad_detail','adimages');</script>
                </div>
                <hr />
            </div>
            <?php if(checkpageaccess('region','edit') == 'ture'){ ?>
            <div class="col-xs-12 col-md-3">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Save Options</h3>
                    </div>
                    <div class="panel-body">
                        <div class="btn-group btn-group-justified">
                            <div class="btn-group"><input type="button" name="cancel" id="cancel" class="btn btn-secondary" value="Cancel" onclick="location.href='<?php echo $this->strAdminSlug.$this->strOptions; ?>';"></div>
                            <?php  if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){ ?>
                            <div class="btn-group"><input type="submit" name="trash" id="trash" class="btn btn-secondary" value="Trash"></div>
                            <?php  } ?>
                            <div class="btn-group"><input type="submit" name="submit" id="submit" class="btn btn-primary" value="Save"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </form>
</div>