<?php
/**
* The main template file for the admin
*
* This is the most generic template file for the site.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @since HTML 5 Boiler Template 1.0
*/

?>

<div class="grid-view">

	<h1 class="page-header">
		Manage <?php echo $this->objModel->strTitle; ?>
		<?php if(checkpageaccess($_REQUEST['controller'],'add') == 'ture' ){ ?>
		<a href="<?php echo $this->strAdminSlug;?>add/" class="btn btn-sm btn-secondary">Add New</a>
		<?php } ?>
	</h1>

	<form class="grid-filters" role="form">

		<div class="grid-table-header">
			<div class="row">

				<?php
	            if($this->strErrorMessage != '') {
	                echo '<div class="alert alert-danger">' . $this->strErrorMessage . '</div>';
	            } else if($this->strSuccessMessage != '') {
	                echo '<div class="alert alert-success">' . $this->strSuccessMessage . '</div>';
	            }
	            ?>

				<div class="col-xs-12 col-sm-6">

					<ul class="grid-statuses list-inline clearfix">
						<li class="<?php echo Util::isValue($this->strStatus, array('Active', 'all'), 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/all/">All <span class="count">(<?php echo $this->objModel->getPageCount(); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'active', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/active/">Active <span class="count">(<?php echo $this->objModel->getPageCount('Active'); ?>)</span></a></li>
						<li class="<?php echo Util::isValue($this->strStatus, 'trash', 'active'); ?>"><a href="<?php echo $this->strAdminSlug.$this->strPg;?>/trash/">Trash <span class="count">(<?php echo $this->objModel->getPageCount('Trash'); ?>)</span></a></li>
					</ul>
					<!-- Statuses -->

					<div class="input-group bulk-actions">
						<select name="bulk_action" id="bulk_action1" class="form-control input-sm">
							<option value="">Bulk Action</option>
							<option value="trash">Move to Trash</option>
							<option value="restore">Restore</option>
						</select>
						<div class="input-group-btn">
							<input type="submit" name="bulk" id="bulk1" class="btn btn-secondary btn-sm" value="Apply">
						</div>

					</div>
					<!-- Bulk Actions -->

				</div>

				<div class="col-xs-12 col-sm-6">

					<div class="input-group grid-search">
						<input type="text" name="searchWord" id="searchWord" class="form-control input-sm" placeholder="Search" value="<?php echo $this->strSearchWord;?>">
						<div class="input-group-btn">
							<input type="submit" name="search" id="search" class="btn btn-secondary btn-sm" value="Search">
						</div>
					</div>

					<?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, $this->strOptions, $this->strPgSize); ?>

				</div>

			</div>


			<div class="row">


					<?php if (!empty($this->arrCategories)) { ?>
					<div class="col-xs-12 filter-bar form-inline">


						<strong>Filters:</strong>
						<div class="form-group">
							<select name="grid_categories" id="" class="form-control input-sm" >
								<option value="">All Categories</option>
								<?php
								foreach($this->arrCategories AS $cat) {
									echo '<option value="'.$cat['id'].'" '.Util::isSelected($cat['id'], $this->intGridCategories) .'>'.$cat['title'].'</option>';
								}
								?>
							</select>
							<input type="submit" name="bulk" id="bulk2" class="btn btn-secondary btn-sm" value="Apply">

							<?php if ($this->objModel->strTitle == 'Courses') { ?>
							<input type="submit" name="export" class="btn btn-default btn-sm" value="Export As CSV">
							<?php } ?>

						</div>
					</div>
					<!-- Filters -->
					<?php } ?>


			</div>


		</div>

		<hr>

		<div class="table-responsive">
			<table class="table table-hover">
				<thead>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, $this->strOptions); ?>
				</thead>

				<tfoot>
					<?php echo Util::sortingTableHeader($this->strAdminSlug, $this->arrTableSQLArray, $this->arrTableDisplayArray, $this->arrTableSortArray, $this->strSortBy, $this->strSortOrder, $this->strPg, $this->strPgSize, $this->strOptions); ?>
				</tfoot>

				<tbody>
				<?php

				// Get our customized grid view
				include(ROOT_DIR.'/application/views/admin/list/'.$this->strView.'.php');

				?>
				</tbody>
			</table>
		</div>

		<hr>

		<div class="grid-table-footer">
			<div class="row">

				<div class="col-xs-12 col-sm-6">
					<div class="input-group bulk-actions">
						<select name="bulk_action2" id="bulk_action2" class="form-control input-sm">
							<option value="">Bulk Action</option>
							<option value="trash">Move to Trash</option>
							<option value="restore">Restore</option>
						</select>
						<div class="input-group-btn">
							<input type="submit" name="bulk" id="bulk2" class="btn btn-secondary btn-sm" value="Apply">
						</div>
					</div>
				</div>
				<!-- Bulk Actions -->

				<div class="col-xs-12 col-sm-6">
					<?php Util::getAdminPagination($this->strPg, $this->objModel->records, $this->strAdminSlug, $this->strOptions, $this->strPgSize); ?>
				</div>

			</div>

			<hr>

		</div>

	</form>

</div>