<div class="row">
    <main class="col-lg-8 col-lg-offset-2">

        <header class="detail-header">
            <div class="row">
                <?php if (Util::isFile($this->arrDetails['display_image'])) { ?>
                <div class="col-sm-3">
                    <figure class="detail-image">
                        <img class="img-responsive center-block" src="<?php echo Util::createImageSrc($this->arrDetails['display_image'], 200, 150, 2); ?>" alt="<?php echo $this->arrDetails['course_name']; ?>">
                    </figure>
                </div>
                <?php } ?>
                <div class="col-sm-9">
                    <h1 class="title">
                        <small><?php echo $this->objPage->strTitle; ?></small>
                        <?php echo $this->arrDetails['course_name']; ?>
                    </h1>
                </div>
            </div>
        </header>

        <div class="content">
            <?php echo $this->objPage->strContent; ?>
        </div>

        <hr>

        <?php if ($this->objModel->strErrorMessage != '') { ?>
        <div class="alert alert-danger">
            <?php echo $this->objModel->strErrorMessage; ?>
        </div>
        <?php } ?>

        <?php if ($this->objModel->strSuccessMessage != '') { ?>

        <div class="alert alert-success">
            <?php echo $this->objModel->strSuccessMessage; ?>
        </div>

        <?php } else { ?>

        <form action="" method="post" role="form" id="detail-form" enctype="multipart/form-data" class="form">

            <div class="row">
                <div class="col-sm-6">

                    <div class="form-group">
                        <label>First Name: <span class="required">*</span></label>
                        <input type="text" name="first_name" id="first_name" class="form-control" placeholder="Enter First Name Here" value="<?php echo $this->objModel->strFirstName; ?>">
                    </div>

                </div>
                <div class="col-sm-6">

                    <div class="form-group">
                        <label>Last Name: <span class="required">*</span></label>
                        <input type="text" name="last_name" id="last_name" class="form-control" placeholder="Enter Last Name Here" value="<?php echo $this->objModel->strLastName; ?>">
                    </div>

                </div>
            </div>

            <div class="form-group">
                <label>Your Email: <span class="required">*</span></label>
                <input type="text" name="user_email" id="user_email" class="form-control" placeholder="Enter Email Here" value="<?php echo $this->objModel->strEmail; ?>">
            </div>

            <div class="form-group">
                <label for="played_date">Played Date: <span class="required">*</span></label>
                <input type="text" class="form-control datepicker" placeholder="YYYY-MM-DD" name="played_date" id="played_date" value="<?php echo $this->objModel->strPlayedDate; ?>">
            </div>

            <div class="form-group">
                <label>Country: <span class="required">*</span></label>
                <input type="text" name="country" id="country" class="form-control" placeholder="Enter Country Here" value="<?php echo $this->objModel->strCountry; ?>">
            </div>

            <div class="form-group">
                <label>State: <span class="required">*</span></label>
                <input type="text" name="state" id="state" class="form-control" placeholder="Enter State Here" value="<?php echo $this->objModel->strState; ?>">
            </div>

            <div class="form-group">
                <label>City: <span class="required">*</span></label>
                <input type="text" name="city" id="city" class="form-control" placeholder="Enter City Here" value="<?php echo $this->objModel->strCity; ?>">
            </div>

            <div class="form-group">
                <label>Your Review: <span class="required">*</span></label>
                <textarea name="review" id="review" class="form-control" rows="5"><?php echo $this->objModel->strReview; ?></textarea>
            </div>

            <input type="submit" name="submit" id="submit" class="btn btn-primary btn-lg" value="Submit Review">

        </form>

        <?php } ?>

    </main>
</div>
