
<div class="step step-form">

    <?php if ($objPartner->strErrorMessage != '') { ?>
    <div class="alert alert-danger">
        <?php echo $objPartner->strErrorMessage; ?>
    </div>
    <?php } ?>

    <h2>Contact Details</h2>
    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label for="user_name">Full Name: <span class="required">*</span></label>
                <input class="form-control" type="text" name="user_name" id="user_name" value="<?php echo $_SESSION['package']['user_name']; ?>" >
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label for="user_email">Email: <span class="required">*</span></label>
                <input class="form-control" type="email" name="user_email" id="user_email" value="<?php echo $_SESSION['package']['user_email']; ?>" >
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label for="user_phone">Preferred Call Back Number: <span class="required">*</span></label>
                <input class="form-control" type="tel" name="user_phone" id="user_phone" value="<?php echo $_SESSION['package']['user_phone']; ?>" >
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label for="cell">Cell Number:</label>
                <input class="form-control" type="tel" name="cell" id="cell" value="<?php echo $_SESSION['package']['cell']; ?>" >
            </div>

        </div>
    </div>

    <h2>Additional Information</h2>
    <p>
        For any custom requirements, questions, or special requests, please enter them in the Special Notes / Extra Information section of this step.
        <strong><span class="required">*</span> Indicates a required field.</strong>
    </p>

    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label for="players_num">Number of Golfers: (min 2) <span class="required">*</span></label>
                <div class="slider" data-slider-min="2" data-slider-max="16" data-slider-step="2">
                    <div class="slider-object"></div>
                    <input type="number" name="players_num" id="players_num" class="form-control slider-range" value="<?php echo $_SESSION['package']['players_num']; ?>">
                </div>
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label for="rounds_num">Total rounds interested in playing (per person): (min 1)</label>
                <div class="slider" data-slider-min="1" data-slider-max="6" data-slider-step="1">
                    <div class="slider-object"></div>
                    <input type="number" name="rounds_num" id="rounds_num" class="form-control slider-range" value="<?php echo $_SESSION['package']['rounds_num']; ?>">
                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label for="couples_num">Number of Couples: (ex. 2 people sharing 1 bed)</label>
                <div class="slider" data-slider-min="0" data-slider-max="4" data-slider-step="1">
                    <div class="slider-object"></div>
                    <input type="number" name="couples_num" id="couples_num" class="form-control slider-range" value="<?php echo $_SESSION['package']['couples_num']; ?>">
                </div>
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label for="ng_num">Number of Non Golfers:</label>
                <div class="slider" data-slider-min="0" data-slider-max="4" data-slider-step="1">
                    <div class="slider-object"></div>
                    <input type="number" name="ng_num" id="ng_num" class="form-control slider-range" value="<?php echo $_SESSION['package']['ng_num']; ?>">
                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label>Are you interested in upgraded room options?</label><br>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="smoking" value="yes"<?php echo Util::isChecked($_SESSION['package']['smoking'], "yes"); ?>>
                    <span class="input"></span> Yes
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="smoking" value="no"<?php echo Util::isChecked($_SESSION['package']['smoking'], "no"); ?>>
                    <span class="input"></span> No
                </label>
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label>Are you interested in single occupancy pricing?</label><br>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="bedshare1" value="yes"<?php echo Util::isChecked($_SESSION['package']['bedshare1'], "yes"); ?>>
                    <span class="input"></span> Yes
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="bedshare1" value="no"<?php echo Util::isChecked($_SESSION['package']['bedshare1'], "no"); ?>>
                    <span class="input"></span> No
                </label>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label>Have you been to this region before?</label><br>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="bedshare2" value="yes"<?php echo Util::isChecked($_SESSION['package']['bedshare2'], "yes"); ?>>
                    <span class="input"></span> Yes
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="bedshare2" value="no"<?php echo Util::isChecked($_SESSION['package']['bedshare2'], "no"); ?>>
                    <span class="input"></span> No
                </label>
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label>Are you planning to golf on the day of arrival?</label><br>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="shuttle" value="yes" <?php echo Util::isChecked($_SESSION['package']['shuttle'], "yes"); ?>>
                    <span class="input"></span> Yes
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="shuttle" value="no" <?php echo Util::isChecked($_SESSION['package']['shuttle'], "no"); ?>>
                    <span class="input"></span> No
                </label>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label for="tee_times">Preferred Tee-Times:</label><br>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="tee_times" value="am" <?php echo Util::isChecked($_SESSION['package']['tee_times'], "am"); ?>>
                    <span class="input"></span> AM
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="tee_times" value="noon" <?php echo Util::isChecked($_SESSION['package']['tee_times'], "noon"); ?>>
                    <span class="input"></span> Noon
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="tee_times" value="pm" <?php echo Util::isChecked($_SESSION['package']['tee_times'], "pm"); ?>>
                    <span class="input"></span> PM
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="tee_times" value="anytime" <?php echo Util::isChecked($_SESSION['package']['tee_times'], "anytime"); ?>>
                    <span class="input"></span> Anytime
                </label>
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label>Are your dates flexible? <span class="required">*</span></label><br>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="date_flex" value="yes"<?php echo Util::isChecked($_SESSION['package']['date_flex'], 'yes'); ?>>
                    <span class="input"></span> Yes
                </label>
                <label class="radio-inline radio-inline-fancy">
                    <input type="radio" name="date_flex" value="no"<?php echo Util::isChecked($_SESSION['package']['date_flex'], 'no'); ?>>
                    <span class="input"></span> No
                </label>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">

            <div class="form-group">
                <label for="theorigin">How did you discover our website?</label>
                <textarea class="form-control" name="theorigin" id="theorigin" rows="5"><?php echo $_SESSION['package']['theorigin']; ?></textarea>
            </div>

        </div>
        <div class="col-sm-6">

            <div class="form-group">
                <label for="comments">What is your group composition and your budget per person? <span class="required">*</span></label>
                <textarea placeholder="guys group, ladies group, couples, please elaborate here" class="form-control" name="comments" id="comments" rows="5"><?php echo $_SESSION['package']['comments']; ?></textarea>
            </div>

        </div>
    </div>

    <div class="g-recaptcha" data-sitekey="<?php echo GOOGLE_RECAPTCHA_V2_SITE_KEY; ?>"></div>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

    <button type="submit" class="btn btn-primary btn-block step-next partner_step_submit" js-step="4"><?php echo $strNavNext; ?></button>

    <script>
    jQuery(function() {

        var jobjSliders = $('.slider').each(function() {
            // Create a variable for the instance
            var jobjControl = $(this);

            // Register the slider object
            var a = jobjControl.find('.slider-object').slider({
                range: 'min',
                min: jobjControl.data('slider-min'),
                max: jobjControl.data('slider-max'),
                step: jobjControl.data('slider-step'),
                value: jobjControl.find('.form-control').val(),
                slide: function(event, ui) {
                    jobjControl.find('.form-control').val(ui.value);
                }
            });
        });

    });
    </script>

</div>
