<article class="detail-page">

    <header class="detail-header">
        <h1 class="title">
            <small><?php echo $objFeature->arrPackage['region_name']; ?></small>
            <?php echo $objFeature->arrPackage['title']; ?>
        </h1>
    </header>

    <?php
    if(Util::isFile($objFeature->arrPackage['file_name'])) {
        $strSrc = Util::createImageSrc($objFeature->arrPackage['file_name'], 1140, 500);
        echo '<img src="'.$strSrc.'" class="img-responsive package-img" style="margin-bottom: 15px;">';
    }
    ?>

    <div class="well">
        <div class="row">
            <div class="col-sm-9">
                <p class="small">
                    This is a recommended package - you are welcome to book this "as is" or customize to your liking.
                    <br>Prices vary based on season, day of week, event weekends, and occupancy.
                </p>
            </div>
            <div class="col-sm-3">
                <p><button type="button" name="Submit" class="btn btn-primary btn-lg btn-block" onclick="location.href='/feature/<?php echo $objFeature->strbrandSlug; ?>/<?php echo $objFeature->arrPackage['id']; ?>/request/';">Request Pricing</button></p>
            </div>
        </div>
    </div>

    <div class="group clearfix">
        <ul class="nav nav-tabs" id="myTab">
            <li class="package active"><a href="#package" data-toggle="tab" id="package_tab">Package details</a></li>
            <li class="course"><a href="#course" data-toggle="tab" id="course_tab">Course Details</a></li>
            <li class="hotel"><a href="#hotel" data-toggle="tab" id="hotel_tab">Hotel details</a></li>
            <li class="map"><a href="#map" data-toggle="tab" id="map_tab">Map</a></li>
        </ul>
        <div class="tab-content">

            <div class="tab-pane active" id="package">
                <div class="row">
                    <div class="col-xs-12 col-sm-4">
                        <?php
                        if (!empty($objFeature->arrPackage['hotel'])) {
                            foreach ($objFeature->arrPackage['hotel'] as $arrHotel) {
                                $strTitle = $arrHotel['item_name'];
                                $strImage = Util::createImageSrc($arrHotel['display_image'], 360, 230);
                                ?>
                                <figure class="location-preview">
                                    <?php if (Util::isFile($arrHotel['display_image'])) { ?>
                                    <img class="img-responsive" src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>">
                                    <?php } ?>
                                    <figcaption class="caption"><?php echo $strTitle; ?></figcaption>
                                </figure>
                                <?php
                            }
                        }
                        if (!empty($objFeature->arrPackage['golf_course'])) {
                            foreach ($objFeature->arrPackage['golf_course'] as $arrCourse) {
                                $strTitle = $arrCourse['item_name'];
                                $strImage = Util::createImageSrc($arrCourse['display_image'], 360, 230);
                                ?>
                                <figure class="location-preview">
                                    <?php if (Util::isFile($arrCourse['display_image'])) { ?>
                                    <img class="img-responsive" src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>">
                                    <?php } ?>
                                    <figcaption class="caption"><?php echo $strTitle; ?></figcaption>
                                </figure>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <div class="col-xs-8">
                        <div class="content">
                            <?php echo Util::nl2br($objFeature->arrPackage['description']); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane" id="hotel">
                <?php
                if (!empty($objFeature->arrPackage['hotel'])) {
                    foreach($objFeature->arrPackage['hotel'] as $arrHotel) {
                        $strTitle = $arrHotel['item_name'];
                        $strImage = Util::createImageSrc($arrHotel['logo'], 250, 150, 2);
                        $strDescription = $arrHotel['description'];
                        ?>
                        <div class="media">
                            <?php if (Util::isFile($arrHotel['logo'])) { ?>
                            <img src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>" class="media-object pull-left img-responsive">
                            <?php } ?>
                            <div class="media-body">
                                <h3 class="media-heading"><?php echo $strTitle; ?></h3>
                                <div class="content">
                                    <?php echo $strDescription; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>

            <div class="tab-pane" id="course">
                <?php
                if (!empty($objFeature->arrPackage['golf_course'])) {
                    foreach($objFeature->arrPackage['golf_course'] as $arrCourse) {
                        $strTitle = $arrCourse['item_name'];
                        $strImage = Util::createImageSrc($arrCourse['logo'], 250, 150, 2);
                        $strDescription = $arrCourse['description'];
                        ?>
                        <div class="media">
                            <?php if (Util::isFile($arrCourse['logo'])) { ?>
                            <img src="<?php echo $strImage; ?>" alt="<?php echo $arrCourse['item_name']; ?>" class="media-object pull-left img-responsive">
                            <?php } ?>
                            <div class="media-body">
                                <h3 class="media-heading"><?php echo $arrCourse['item_name']; ?></h3>
                                <div class="content">
                                    <?php echo $strDescription; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>

            <div class="tab-pane" id="map">
                <div id="gmap" class="gmap"></div>

                <hr>

                <h3>Get Directions</h3>

                <form method="POST" role="form" class="map-direction-form clearfix">

                    <div class="row">
                        <div class="col-xs-12 col-sm-5">
                            <div class="form-group">
                                <label for="start_address">Start Address:</label>
                                <input type="text" name="start_address" id="start_address" class="form-control" value="">
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-2">
                            <div class="form-group">
                                <label for="method">Method:</label>
                                <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                                    <option value="DRIVING">Driving</option>
                                    <option value="WALKING">Walking</option>
                                    <option value="BICYCLING">Bicycling</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-5">
                            <div class="form-group">
                                <label for="end_address">Destination:</label>
                                <select name="eaddr" id="eaddr" class="form-control">
                                    <?php
                                    if (!empty($objFeature->arrPackage['golf_course'])) {
                                        foreach ($objFeature->arrPackage['golf_course'] as $arrCourse) {
                                            echo '<option value="' . $arrCourse['latitude'] . ' ' . $arrCourse['longitude'] . '">' . $arrCourse['item_name'] . '</option>';
                                        }
                                    }
                                    if (!empty($objFeature->arrPackage['hotel'])) {
                                        foreach ($objFeature->arrPackage['hotel'] as $arrHotel) {
                                            echo '<option value="' . $arrHotel['latitude'] . ' ' . $arrHotel['longitude'] . '">' . $arrHotel['item_name'] . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <button type="button" class="btn btn-primary pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

                </form>

                <hr>

                <div id="directions_panel"></div>

            </div>

        </div>

    </div>

    <div class="package-next-step">
        <h2>Finalize Your Package Details</h2>
        <button type="button" name="Submit" class="btn btn-primary btn-lg" onclick="location.href='/feature/<?php echo $objFeature->strbrandSlug; ?>/<?php echo $objFeature->arrPackage['id']; ?>/request/';">Request Pricing</button>
    </div>

</article>

<?php
echo Location::getMapData2(array(
    'courses' => $objFeature->arrPackage['golf_course'],
    'hotels' => $objFeature->arrPackage['hotel'],
    'show_directions' => true,
    'show_directions_id' => 'directions_panel',
    'tab_id' => 'map_tab',
    'map_id' => 'gmap',
    'latitude' => $objFeature->arrPackage['rlat'],
    'longitude' => $objFeature->arrPackage['rlong'],
    'zoom' => $objFeature->arrPackage['rzlevel']
));
?>
