
<h1>Recommended Packages</h1>

<div class="listing-container">
<?php
if (!empty($objFeature->arrPackages)) {

    foreach($objFeature->arrPackages As $arrPackage) {
        $strTitle = $arrPackage['title'];
        $strLink = $objFeature->strBaseUrl.'/feature/'.$objFeature->strbrandSlug.'/'.$arrPackage['id'].'/';
        $strDescription = Util::shortenString($arrPackage['excerpt'], 75);
        $strPrice = Util::formatPrice($arrPackage['price']);
        $strDates = Util::formatDates(array($arrPackage['start_date'], $arrPackage['end_date']));

        $strImage = !empty($arrPackage['file_name']) ? $arrPackage['file_name'] : '/application/images/open-graph-image.png';
        $strImage = Util::createImageSrc($strImage, 445, 300);
        ?>
        <article class="listing-item clearfix">
            <div class="row">
                <figure class="col-xs-12 col-sm-5">
                    <a href="<?php echo $strLink; ?>">
                        <img src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>" class="img-responsive">
                    </a>
                </figure>
                <div class="col-xs-12 col-sm-7">
                    <h2 class="title">
                        <small><?php echo $arrPackage['region_name']; ?></small>
                        <a href="<?php echo $strLink; ?>"><?php echo $arrPackage['title']; ?></a>
                    </h2>
                    <div class="well well-sm small">
                        This is a recommended package - you are welcome to book this "as is" or customize to your liking.
                        <br>Prices vary based on season, day of week, event weekends, and occupancy.
                    </div>
                    <div class="description">
                        <?php echo $strDescription; ?>
                    </div>
                    <a href="<?php echo $strLink; ?>" class="btn btn-primary">See Package Details</a>
                </div>
            </div>
        </article>
        <?php
    }

}
?>
</div>
