<?php
include($_SERVER['DOCUMENT_ROOT'].'/application/config.php');
include($_SERVER['DOCUMENT_ROOT'].'/application/includes/header.php');
?>

<style>
body > * {
    display: none;
}
.page-404 {
    display: block;
    width: 100%;
    height: 100vh;
    position: relative;
    background: url('/application/images/bg-404.jpg') center;
    background-size: cover;
}
.page-404-header {
    padding: 30px;
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
}
.page-404-header::after {
    content: '';
    display: block;
    width: 100%;
    height: 150px;
    position: absolute;
    z-index: 10;
    top: 0;
    left: 0;
    background: linear-gradient(to bottom, rgba(0,0,0,0.65) 0%, rgba(0,0,0,0) 100%);
}
.page-404-logo {
    display: block;
    width: 230px;
    position: relative;
    z-index: 20;
    text-align: left;
}
.page-404-content {
    width: 80%;
    max-width: 1200px;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
    color: #fff;
    text-shadow: 0 0 50px rgba(0,0,0,0.25);
}
@media (min-width: 768px) {
    .page-404-title {
        font-size: 5vw;
    }
}
</style>

<main class="page-404">

    <header class="page-404-header">
        <a class="page-404-logo" href="/">
            <img class="img-responsive" src="<?php echo ROOT_URL . '/application/images/logo.png'; ?>" alt="BCgolfguide.com">
        </a>
    </header>

    <div class="page-404-content">
        <h1 class="page-404-title">Oops, you're lost in the rough</h1>
        <p>The page you were trying to view does not exist.</p>
        <a class="btn btn-primary" href="/">Take a Mulligan</a>
    </div>

</main>

<?php include($_SERVER['DOCUMENT_ROOT'].'/application/includes/footer.php'); ?>
