/*
ALTER TABLE `dev_bcgolfguide`.`package_hotel` 
ADD COLUMN `last_update_sent` TIMESTAMP NULL DEFAULT NULL AFTER `last_edit`;
ADD COLUMN `check_in_date_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `check_in_date`,
ADD COLUMN `check_out_date_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `check_out_date`,
ADD COLUMN `nights_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `nights`,
ADD COLUMN `rooms_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `rooms`,
ADD COLUMN `confirm_num_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `confirm_num`,
ADD COLUMN `notes_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `notes`;

ALTER TABLE `dev_bcgolfguide`.`package_golf` 
ADD COLUMN `tee_time_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `tee_ap`,
ADD COLUMN `carts_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `carts`,
ADD COLUMN `range_ball_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `range_ball`,
ADD COLUMN `shuttle_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `shuttle`,
ADD COLUMN `golfer_num_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `golfer_num`,
ADD COLUMN `confirm_num_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `confirm_num`,
ADD COLUMN `notes_last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `notes`,
ADD COLUMN `last_edit` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP AFTER `course_teetimes_update_email`,
ADD COLUMN `last_update_sent` TIMESTAMP NULL DEFAULT NULL AFTER `last_edit`;
*/

ALTER TABLE `golfguid_wp`.`package_hotel` 
ADD COLUMN `last_update_sent` TIMESTAMP NULL DEFAULT NULL AFTER `last_edit`;
ADD COLUMN `check_in_date_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `check_in_date`,
ADD COLUMN `check_out_date_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `check_out_date`,
ADD COLUMN `nights_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `nights`,
ADD COLUMN `rooms_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `rooms`,
ADD COLUMN `confirm_num_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `confirm_num`,
ADD COLUMN `notes_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `notes`;

ALTER TABLE `golfguid_wp`.`package_golf` 
ADD COLUMN `tee_time_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `tee_ap`,
ADD COLUMN `carts_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `carts`,
ADD COLUMN `range_ball_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `range_ball`,
ADD COLUMN `shuttle_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `shuttle`,
ADD COLUMN `golfer_num_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `golfer_num`,
ADD COLUMN `confirm_num_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `confirm_num`,
ADD COLUMN `notes_last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `notes`,
ADD COLUMN `last_edit` TIMESTAMP NULL DEFAULT NULL AFTER `course_teetimes_update_email`,
ADD COLUMN `last_update_sent` TIMESTAMP NULL DEFAULT NULL AFTER `last_edit`;

USE `dev_bcgolfguide`;

DELIMITER $$

DROP TRIGGER IF EXISTS dev_bcgolfguide.package_hotel_BUPD$$
USE `dev_bcgolfguide`$$


CREATE TRIGGER `package_hotel_BUPD` BEFORE UPDATE ON `package_hotel` FOR EACH ROW
BEGIN
	IF NEW.nights <> OLD.nights THEN
	 SET NEW.nights_last_edit = now();
	END IF;
	IF NEW.check_in_date <> OLD.check_in_date THEN
	 SET NEW.check_in_date_last_edit = now();
	END IF;
	IF NEW.check_out_date <> OLD.check_out_date THEN
	 SET NEW.check_out_date_last_edit = now();
	END IF;
	IF NEW.rooms <> OLD.rooms THEN
	 SET NEW.rooms_last_edit = now();
	END IF;
	IF NEW.confirm_num <> OLD.confirm_num THEN
	 SET NEW.confirm_num_last_edit = now();
	END IF;
	IF NEW.public_notes <> OLD.public_notes THEN
	 SET NEW.notes_last_edit = now();
	END IF;
END;$$
DELIMITER ;

USE `dev_bcgolfguide`$$

CREATE TRIGGER `package_golf_BUPD` BEFORE UPDATE ON `package_golf` FOR EACH ROW
BEGIN
	IF NEW.tee_date <> OLD.tee_date 
		OR NEW.tee_day <> OLD.tee_day 
		OR NEW.tee_time <> OLD.tee_time
		OR NEW.tee_ap <> OLD.tee_ap THEN
	 SET NEW.tee_time_last_edit = now();
	END IF;
	IF NEW.carts <> OLD.carts THEN
	 SET NEW.carts_last_edit = now();
	END IF;
	IF NEW.range_ball <> OLD.range_ball THEN
	 SET NEW.range_ball_last_edit = now();
	END IF;
	IF NEW.shuttle <> OLD.shuttle THEN
	 SET NEW.shuttle_last_edit = now();
	END IF;
	IF NEW.golfer_num <> OLD.golfer_num THEN
	 SET NEW.golfer_num_last_edit = now();
	END IF;
	IF NEW.confirm_num <> OLD.confirm_num THEN
	 SET NEW.confirm_num_last_edit = now();
	END IF;
	IF NEW.public_notes <> OLD.public_notes THEN
	 SET NEW.notes_last_edit = now();
	END IF;
END;$$
DELIMITER ;
