CREATE TABLE `hotel_rates` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `hotel_id` INT(11) NOT NULL,
  `start_date` DATETIME NOT NULL,
  `end_date` DATETIME NOT NULL,
  `length` INT NULL DEFAULT NULL,
  `parent_id` INT(11) NULL DEFAULT NULL,
  `price` FLOAT NULL DEFAULT NULL,
  `rack_rate` FLOAT NULL DEFAULT NULL,
  `room_type` INT(11) NULL DEFAULT NULL,
  `occupancy` INT NULL DEFAULT NULL,
  `additional_guest_fee` FLOAT NULL DEFAULT NULL,
  `minimum_stay` INT NULL DEFAULT NULL,
  `deposit` VARCHAR(255) NULL DEFAULT NULL,
  `notes` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `in_dates` (`start_date` ASC, `end_date` ASC),
  INDEX `in_hotel_id` (`hotel_id` ASC));

CREATE TABLE `rate_detail_types` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `type` VARCHAR(255) NOT NULL,
  `name` VARCHAR(255) NOT NULL,
  `description` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `in_type` (`type` ASC))
COMMENT = 'Lookup table for hotel room types and golf types.';

ALTER TABLE `hotel_rates` 
ADD COLUMN `name` VARCHAR(255) NULL DEFAULT NULL AFTER `end_date`;

ALTER TABLE `rate_detail_types` 
ADD COLUMN `rating` INT(2) NULL DEFAULT NULL AFTER `description`;

ALTER TABLE `dev_bcgolfguide`.`hotel_rates` 
CHANGE COLUMN `price` `price` FLOAT(11,2) NULL DEFAULT NULL ,
CHANGE COLUMN `rack_rate` `rack_rate` FLOAT(11,2) NULL DEFAULT NULL ;

ALTER TABLE `dev_bcgolfguide`.`hotel_rates` 
ADD COLUMN `status` VARCHAR(255) NOT NULL DEFAULT 'active' AFTER `notes`;

ALTER TABLE `dev_bcgolfguide`.`hotel_rates` 
ADD INDEX `in_parent_id` (`parent_id` ASC);


CREATE TABLE `course_rates` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `course_id` INT(11) NOT NULL,
  `start_date` DATETIME NOT NULL,
  `end_date` DATETIME NOT NULL,
  `name` VARCHAR(255) NULL DEFAULT NULL,
  `length` INT(11) NULL DEFAULT NULL,
  `parent_id` INT(11) NULL DEFAULT NULL,
  `price` FLOAT(11,2) NULL DEFAULT NULL,
  `rack_rate` FLOAT(11,2) NULL DEFAULT NULL,
  `rate_based_count` INT(11) NULL DEFAULT 2 COMMENT 'Number of players price is based on (like occupancy for hotels)',
  `course_type` INT(11) NULL DEFAULT NULL,
  `deposit` VARCHAR(255) NULL DEFAULT NULL,
  `notes` TEXT NULL DEFAULT NULL,
  `status` VARCHAR(255) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`));

ALTER TABLE `dev_bcgolfguide`.`course_rates` 
ADD INDEX `in_parent_id` (`parent_id` ASC),
ADD INDEX `in_course_id` (`course_id` ASC),
ADD INDEX `in_dates` (`start_date` ASC, `end_date` ASC);
