CREATE TABLE IF NOT EXISTS `groups` (
  `id` int(11) NOT NULL,
  `group_name` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT 'Active',
  `admin_note` text
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `quotes` (
  `id` int(11) NOT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `blnProcessed` tinyint(4) NOT NULL DEFAULT '0',
  `region_id` int(11) DEFAULT NULL,
  `user_name` varchar(255) NOT NULL DEFAULT '',
  `user_email` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) DEFAULT NULL,
  `price` varchar(25) DEFAULT NULL,
  `phone` varchar(255) NOT NULL DEFAULT '',
  `fax` varchar(255) DEFAULT NULL,
  `cell_phone` varchar(255) DEFAULT NULL,
  `emergency` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `couples_num` varchar(255) DEFAULT NULL,
  `players_num` varchar(255) DEFAULT NULL,
  `ng_num` varchar(255) DEFAULT NULL,
  `players_notes` longtext,
  `golfcourses` varchar(255) DEFAULT NULL,
  `accommodations` varchar(255) DEFAULT NULL,
  `smoking` varchar(255) DEFAULT NULL,
  `bedshare1` varchar(255) DEFAULT NULL,
  `bedshare2` varchar(255) DEFAULT NULL,
  `carts` varchar(255) DEFAULT NULL,
  `shuttle` varchar(255) DEFAULT NULL,
  `dates_arrival` mediumtext,
  `dates_depart` mediumtext,
  `dates_booking` date DEFAULT NULL,
  `tee_times` longtext,
  `comments` longtext,
  `theorigin` varchar(255) DEFAULT NULL,
  `origin_comment` text,
  `admin_note` longtext,
  `voucher_text_1` longtext,
  `voucher_text_2` longtext,
  `voucher_text_3` longtext,
  `voucher_text_4` longtext,
  `voucher_text_5` longtext,
  `mini_content` text,
  `cc_form` longtext,
  `order_date` date NOT NULL DEFAULT '0000-00-00',
  `edit_date` date DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `completed` int(11) NOT NULL DEFAULT '0',
  `paid` tinyint(1) DEFAULT NULL COMMENT '0:Unpaid, 1:Check, 2:Visa, 3:Comp',
  `invoice` varchar(255) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `mini_enabled` tinyint(1) DEFAULT '0',
  `rounds_num` varchar(255) DEFAULT NULL,
  `date_flex` varchar(10) DEFAULT NULL,
  `last_payment_date` varchar(255) DEFAULT NULL,
  `exempt_from_report` int(1) DEFAULT '1',
  `blnRepeat` tinyint(1) NOT NULL DEFAULT '0',
  `blnNotify` tinyint(1) NOT NULL DEFAULT '1',
  `brandID` int(11) NOT NULL DEFAULT '18',
  `regionID` int(11) DEFAULT NULL,
  `bookingID` int(11) DEFAULT NULL,
  `total_people` int(11) DEFAULT NULL,
  `total_rounds` int(11) DEFAULT NULL,
  `total_rooms` int(11) DEFAULT NULL,
  `currency` varchar(4) NOT NULL DEFAULT 'CAD',
  `status` varchar(15) NOT NULL DEFAULT 'Active',
  `date_created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `additional_details` text
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `quote_brand` (
  `brand_id` int(11) NOT NULL,
  `quote_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `quote_golf` (
  `id` int(11) NOT NULL,
  `quote_id` int(11) NOT NULL DEFAULT '0',
  `course_id` int(11) NOT NULL DEFAULT '0',
  `tee_date` date NOT NULL DEFAULT '0000-00-00',
  `tee_day` varchar(20) DEFAULT NULL,
  `tee_time` varchar(5) NOT NULL DEFAULT '',
  `tee_ap` char(2) NOT NULL DEFAULT '',
  `carts` varchar(255) DEFAULT NULL,
  `range_ball` varchar(255) DEFAULT NULL,
  `shuttle` varchar(255) DEFAULT NULL,
  `rental_club` varchar(255) DEFAULT NULL,
  `golfer_num` int(11) DEFAULT NULL,
  `confirm_num` varchar(255) DEFAULT NULL,
  `notes` text,
  `public_notes` text,
  `track_code` varchar(255) DEFAULT NULL,
  `net_rate` text,
  `note_id` int(11) NOT NULL DEFAULT '1',
  `paidout` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `quote_group` (
  `group_id` int(11) NOT NULL,
  `quote_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `quote_hotel` (
  `id` int(11) NOT NULL,
  `quote_id` int(11) NOT NULL DEFAULT '0',
  `hotel_id` int(11) NOT NULL DEFAULT '0',
  `check_in_date` date NOT NULL DEFAULT '0000-00-00',
  `check_out_date` date NOT NULL DEFAULT '0000-00-00',
  `nights` int(11) NOT NULL DEFAULT '0',
  `rooms` int(11) NOT NULL DEFAULT '0',
  `golfers` int(11) NOT NULL DEFAULT '0',
  `non_golfers` int(11) NOT NULL DEFAULT '0',
  `guests_name` mediumtext,
  `confirm_num` varchar(255) NOT NULL DEFAULT '',
  `notes` text,
  `public_notes` text,
  `room_notes` text,
  `email_content` text,
  `note_id` int(11) NOT NULL DEFAULT '1',
  `default` int(1) DEFAULT '0',
  `paidout` int(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `quote_hotel_detail` (
  `id` int(11) NOT NULL,
  `member_id` int(11) DEFAULT NULL,
  `quote_hotel_id` int(11) NOT NULL,
  `people_num` int(11) DEFAULT NULL,
  `people_name` varchar(255) DEFAULT NULL,
  `people_lname` varchar(255) DEFAULT NULL,
  `people_email` varchar(255) DEFAULT NULL,
  `people_phone` varchar(255) DEFAULT NULL,
  `people_city` varchar(255) DEFAULT NULL,
  `room_num` char(50) DEFAULT NULL,
  `nights_num` char(50) DEFAULT NULL,
  `package_price` float NOT NULL DEFAULT '0',
  `deposit_price` float NOT NULL DEFAULT '0',
  `final_price` float NOT NULL DEFAULT '0',
  `cc_processed` char(50) DEFAULT NULL,
  `notes` text,
  `last_payment_date` varchar(255) DEFAULT NULL
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `quote_mini_notes` (
  `id` int(11) NOT NULL,
  `group_id` int(11) DEFAULT NULL,
  `comment` text,
  `timestamp` datetime DEFAULT NULL,
  `direction` tinyint(1) DEFAULT '0',
  `sales_id` int(11) DEFAULT '1'
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

ALTER TABLE `groups`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `quotes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `id` (`id`),
  ADD KEY `session id` (`session_id`),
  ADD KEY `region id` (`region_id`);

ALTER TABLE `quote_brand`
  ADD UNIQUE KEY `pb_idx` (`brand_id`,`quote_id`);

ALTER TABLE `quote_golf`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_id` (`quote_id`);

ALTER TABLE `quote_group`
  ADD PRIMARY KEY (`group_id`,`quote_id`);

ALTER TABLE `quote_hotel`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_id` (`quote_id`);

ALTER TABLE `quote_hotel_detail`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`),
  ADD UNIQUE KEY `pri_hd_idx` (`quote_hotel_id`,`people_num`),
  ADD KEY `hotel_id` (`quote_hotel_id`);

ALTER TABLE `quote_mini_notes`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `groups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `quotes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `quote_golf`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `quote_hotel`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `quote_hotel_detail`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `quote_mini_notes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `packages` 
ADD COLUMN `quote_id` INT(11) NULL DEFAULT NULL;

ALTER TABLE `brands` 
ADD COLUMN `mini_quote_email_text` TEXT NULL DEFAULT NULL,
ADD COLUMN `mini_quote_page_text` TEXT NULL DEFAULT NULL;

ALTER TABLE `groups` 
ADD COLUMN `admin_note` TEXT NULL DEFAULT NULL;
