<?php

include('../config.php');

// Get our models
$objPage = new Page('');
$objCourse = new Course();
$objHotel = new Hotel();
$objRegion = new Region();
$objPackage = new Featured();

$dateFormat = 'c';

// Get our active records
$arrPages = $objPage->getMysqliResults("SELECT * FROM $objPage->strTableName WHERE `status` = 'Active' AND `slug` != 'home'", true);
$arrCourses = $objCourse->getMysqliResults("SELECT * FROM $objCourse->strTableName WHERE `status` = 'Active'", true);
$arrHotels = $objHotel->getMysqliResults("SELECT * FROM $objHotel->strTableName WHERE `status` = 'Active'", true);
$arrRegions = $objRegion->getMysqliResults("SELECT * FROM $objRegion->strTableName WHERE `status` = 'Active'", true);
$arrPackages = $objPackage->getMysqliResults("SELECT * FROM $objPackage->strTableName WHERE `status` = 'Active'", true);

// Our ouput variable
$strXml = '';

// Start building output
$strXml .= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
$strXml .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\">\n";

// Home URL
$strXml .= "\t<url>\n";
$strXml .= "\t\t<loc>".ROOT_URL."/</loc>\n";
$strXml .= "\t\t<lastmod>".date('c')."</lastmod>\n";
$strXml .= "\t\t<changefreq>weekly</changefreq>\n";
$strXml .= "\t\t<priority>1</priority>\n";
$strXml .= "\t</url>\n";

// Loop through the pages
if (!empty($arrPages)) {
    foreach ($arrPages as $page) {
        // Url to the page
        $url = ROOT_URL.'/'.$page['slug'].'/';
        $date = date($dateFormat, strtotime($page['date_modified']));

        // Output
        $strXml .= "\t<url>\n";
        $strXml .= "\t\t<loc>".$url."</loc>\n";
        $strXml .= "\t\t<lastmod>".$date."</lastmod>\n";
        $strXml .= "\t\t<changefreq>weekly</changefreq>\n";
        $strXml .= "\t\t<priority>0.8</priority>\n";
        $strXml .= "\t</url>\n";
    }
}

// Loop through the courses
if (!empty($arrCourses)) {
    foreach ($arrCourses as $course) {
        // URL to the course
        $url = ROOT_URL.'/golf-courses/'.$course['slug'].'/';

        // Output
        $strXml .= "\t<url>\n";
        $strXml .= "\t\t<loc>".$url."</loc>\n";
        $strXml .= "\t\t<lastmod>".date($dateFormat, strtotime($course['edit_date']))."</lastmod>\n";
        $strXml .= "\t\t<changefreq>weekly</changefreq>\n";
        $strXml .= "\t\t<priority>0.8</priority>\n";
        $strXml .= "\t</url>\n";
    }
}

// Loop through the hotels
if (!empty($arrHotels)) {
    foreach ($arrHotels as $hotel) {
        // URL to the hotel
        $url = ROOT_URL.'/golf-accommodations/'.$hotel['slug'].'/';

        // Output
        $strXml .= "\t<url>\n";
        $strXml .= "\t\t<loc>".$url."</loc>\n";
        $strXml .= "\t\t<lastmod>".date($dateFormat, strtotime($hotel['edit_date']))."</lastmod>\n";
        $strXml .= "\t\t<changefreq>weekly</changefreq>\n";
        $strXml .= "\t\t<priority>0.8</priority>\n";
        $strXml .= "\t</url>\n";
    }
}

// Loop through the regions
if (!empty($arrRegions)) {
    foreach ($arrRegions as $region) {
        // URL to the region
        $url = ROOT_URL.'/regions/'.$region['slug'].'/';

        // Output
        $strXml .= "\t<url>\n";
        $strXml .= "\t\t<loc>".$url."</loc>\n";
        $strXml .= "\t\t<lastmod>".date($dateFormat)."</lastmod>\n";
        $strXml .= "\t\t<changefreq>weekly</changefreq>\n";
        $strXml .= "\t\t<priority>0.8</priority>\n";
        $strXml .= "\t</url>\n";
    }
}

// Loop through the packages
if (!empty($arrPackages)) {
    foreach ($arrPackages as $package) {
        // URL to the package
        $url = ROOT_URL.'/featured-golf-packages/'.$package['slug'].'/';

        // Output
        $strXml .= "\t<url>\n";
        $strXml .= "\t\t<loc>".$url."</loc>\n";
        $strXml .= "\t\t<lastmod>".date($dateFormat)."</lastmod>\n";
        $strXml .= "\t\t<changefreq>weekly</changefreq>\n";
        $strXml .= "\t\t<priority>0.8</priority>\n";
        $strXml .= "\t</url>\n";
    }
}

// End building output
$strXml .= '</urlset>';


// Set the headers and output
header('HTTP/1.1 200 OK');
header('X-Robots-Tag: noindex, follow', true);
header('Content-Type: application/rss+xml; charset=utf-8');

echo $strXml;
