<?php


include('../config.php');
include(ROOT_DIR.'/application/models/admin/package.php');
include(ROOT_DIR.'/application/models/admin/package_hotel.php');
include(ROOT_DIR.'/application/models/admin/member.php');
include(ROOT_DIR.'/application/models/admin/brand.php');

$session_id = isset($_REQUEST['session']) ? $_REQUEST['session'] : '';
$dopost = isset($_REQUEST['dopost']) ? $_REQUEST['dopost'] : '';
$intCityId = isset($_REQUEST['city']) ? $_REQUEST['city'] : '6345';
$intCountryId = isset($_REQUEST['country']) ? $_REQUEST['country'] : '261';
$intStateId = isset($_REQUEST['state']) ? $_REQUEST['state'] : '2';
$strProvider = isset($_REQUEST['provider']) ? $_REQUEST['provider'] : '';
$id = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
$intTotal = isset($_POST['make_payment_total_hidden']) ? $_REQUEST['make_payment_total_hidden'] : '0';

$debug = $objSettings->intPayPalMode;
//die($debug);
//var_dump($_POST);

//Cannot process requests with a total of 0 -- perhaps someone passed the payment link directly?
if ($intTotal == 0) {
    // Redirect back to the package overview,
    header('Location: ' . ROOT_URL . '/package2/' . $session_id);
    die();
}

if($session_id != '' ) {

    $objPackage = new Package;
    $objPackageHotel = new Packagehotels;
    $objMember = new Member;
    $objBrand = new Brand('brands');
    $objLocation = new Location;




    $arrDetails =  $objPackage->getDetail('',$session_id);
    $arrProviders =  $objMember->getProviders();
    $arrStates = $objLocation->getStates($intCountryId);
    $arrCities = $objLocation->getCities($intStateId);
    $strCurrency = $arrDetails['currency'];

    if($_POST['moneris_token'] == '' ) {

        $arrPeopleName = isset($_POST['people_name']) ? $_POST['people_name'] : array();
        $arrPeopleLName = isset($_POST['people_lname']) ? $_POST['people_lname'] : array();
        $arrPeopleEmail = isset($_POST['people_email']) ? $_POST['people_email'] : array();
        $arrMakePaymentVal = isset($_POST['make_payment_val']) ? $_POST['make_payment_val'] : array();
        $arrPeopleId = isset($_POST['people_id']) ? $_POST['people_id'] : array();
        $arrDeposit = isset($_POST['deposit']) ? $_POST['deposit'] : array();
        $arrPackagePrice = isset($_POST['package_price']) ? $_POST['package_price'] : array();

        //var_dump($objPackage->arrHotelVouchers[0]);


        if(!isset($_POST['people_name']) && isset($objPackage->arrHotelVouchers)) {
            foreach($objPackage->arrHotelVouchers As $row){
                $package_hotel_id = $row["phid"];

                $arrD = $objPackage->getPackageHotelDetail($package_hotel_id);

                $i = 0;
                foreach($arrD As $d) {
                    $arrPeopleId[] = $d['id'];
                    $arrPeopleName[] = $d['people_name'];
                    $arrPeopleLName[] = $d['people_lname'];
                    $arrPeopleEmail[] = $d['people_email'];
                    $arrDeposit[] = $d['deposit_price'];
                    $arrMakePaymentVal[] = $d['final_price'];
                    $i++;
                }

            }
        }

        //var_dump($arrPeopleName);

        $csvPeopleName = implode(',',$arrPeopleName);
        $csvPeoplelName = implode(',',$arrPeopleLName);
        $csvPeopleEmail = implode(',',$arrPeopleEmail);
        $csvMakePaymentVal = implode(',',$arrMakePaymentVal);
        $csvPeopleId = implode(',',$arrPeopleId);
        $csvDeposit = implode(',',$arrDeposit);
        $csvPackagePrice = implode(',',$arrPackagePrice);


    } else {

        //This is for concurrency Detection - We will Reject any submissions with a timestamp on the form that does not match the timestamp in the database
        if (is_numeric($_POST['package_hotel_id'])) {

            $arrPackageHotel = $objPackageHotel->getByID($_POST['package_hotel_id']);

            //If the date / time on the page is not the same as the value of the database
            if ($_POST['last_edit'] != $arrPackageHotel['last_edit']) {

                //Reject the changes and inform the user
                $strErrorMessage = 'Sorry, your changes could not be saved, someone else submitted changes. Please try again.';

                // Redirect back to the package overview, with the message displayed
                header('Location: ' . ROOT_URL . '/package/' . $session_id . '?message=2');

            } else {

                $csvPeopleName = isset($_POST['people_name']) ? $_POST['people_name'] : '';
                $csvPeoplelName = isset($_POST['people_lname']) ? $_POST['people_lname'] : '';
                $csvPeopleEmail = isset($_POST['people_email']) ? $_POST['people_email'] : '';
                $csvMakePaymentVal = isset($_POST['make_payment_val']) ? $_POST['make_payment_val'] : '';
                $csvPeopleId = isset($_POST['people_id']) ? $_POST['people_id'] : '';
                $csvDeposit = isset($_POST['deposit']) ? $_POST['deposit'] : '';
                $csvPackagePrice = isset($_POST['package_price']) ? $_POST['package_price'] : '';


                $arrPeopleName = explode(',',$csvPeopleName);
                $arrPeoplelName = explode(',',$csvPeoplelName);
                $arrPeopleEmail = explode(',',$csvPeopleEmail);
                $arrMakePaymentVal = explode(',',$csvMakePaymentVal);
                $arrPeopleId = explode(',',$csvPeopleId);
                $arrDeposit = explode(',',$csvDeposit);
                $arrPackagePrice = explode(',',$csvPackagePrice);

                // validate data
                //var_dump($_POST);

                if($objMember->validatePaymentPostMoneris($_POST)) {

                    /**************************** Request Variables *******************************/
                    $store_id='store3';
                    $api_token='yesguy';
                    /************************* Transactional Variables ****************************/
                    $type='res_purchase_cc';
                    //$cust_id='cust id';
                    $order_id='ord-'.date("dmy-G:i:s");
                    //$amount='1.00';
                    //$pan=$_POST['moneris_token'];
                    //$expiry_date='2011';
                    $crypt='1';
                    $dynamic_descriptor='123';
                    $status_check = 'false';
                    //var_dump(floatval($intTotal));

                    /*********************** Transactional Associative Array **********************/
                    $txnArray=array('type'=>$type,
                                    'order_id'=>$order_id,
                                    //'cust_id'=>$cust_id,
                                    'amount'=>number_format($intTotal, 2),
                                    'data_key'=>$_POST['moneris_token'],
                                    //'expdate'=>$expiry_date,
                                    'currency' => $strCurrency,
                                    'crypt_type'=>$crypt,
                                    'dynamic_descriptor'=>$dynamic_descriptor
                                    //,'wallet_indicator' => '' //Refer to documentation for details
                                    //,'cm_id' => '8nAK8712sGaAkls56' //set only for usage with Offlinx - Unique max 50 alphanumeric characters transaction id generated by merchant
                                   );
                    /**************************** Transaction Object *****************************/
                    $mpgTxn = new moneris\mpgTransaction($txnArray);
                    /******************* Credential on File **********************************/
                    $cof = new moneris\CofInfo();
                    $cof->setPaymentIndicator("U");
                    $cof->setPaymentInformation("2");
                    $cof->setIssuerId("168451306048014");
                    $mpgTxn->setCofInfo($cof);
                    /****************************** Request Object *******************************/
                    $mpgRequest = new moneris\mpgRequest($mpgTxn);
                    //$mpgRequest->setProcCountryCode("CA"); //"US" for sending transaction to US environment
                    $mpgRequest->setTestMode(true); //false or comment out this line for production transactions
                    /***************************** HTTPS Post Object *****************************/
                    /* Status Check Example
                    $mpgHttpPost  =new mpgHttpsPostStatus($store_id,$api_token,$status_check,$mpgRequest);
                    */
                    $mpgHttpPost = new moneris\mpgHttpsPost($store_id,$api_token,$mpgRequest);
                    /******************************* Response ************************************/
                    $mpgResponse=$mpgHttpPost->getMpgResponse();
/*
                    print("\nCardType = " . $mpgResponse->getCardType());
                    print("\nTransAmount = " . $mpgResponse->getTransAmount());
                    print("\nTxnNumber = " . $mpgResponse->getTxnNumber());
                    print("\nReceiptId = " . $mpgResponse->getReceiptId());
                    print("\nTransType = " . $mpgResponse->getTransType());
                    print("\nReferenceNum = " . $mpgResponse->getReferenceNum());
                    print("\nResponseCode = " . $mpgResponse->getResponseCode());
                    print("\nISO = " . $mpgResponse->getISO());
                    print("\nMessage = " . $mpgResponse->getMessage());
                    print("\nIsVisaDebit = " . $mpgResponse->getIsVisaDebit());
                    print("\nAuthCode = " . $mpgResponse->getAuthCode());
                    print("\nComplete = " . $mpgResponse->getComplete());
                    print("\nTransDate = " . $mpgResponse->getTransDate());
                    print("\nTransTime = " . $mpgResponse->getTransTime());
                    print("\nTicket = " . $mpgResponse->getTicket());
                    print("\nTimedOut = " . $mpgResponse->getTimedOut());
                    print("\nStatusCode = " . $mpgResponse->getStatusCode());
                    print("\nStatusMessage = " . $mpgResponse->getStatusMessage());
                    print("\nHostId = " . $mpgResponse->getHostId());
                    print("\nIssuerId = " . $mpgResponse->getIssuerId());
*/
                    if ($mpgResponse->getResponseCode() == '027') {
                        //die('approved?');
                        ////this inserts/updates the member record, returns the id for new members
                        $objMember->handlePayemntPostMoneris($_POST,$id);
                        $member_id = $objMember->intID;
                        $email_id = $objMember->strEmail;

                        //update the package detail record
                        $strMessage = $objBrand->getMiniPaymentEmailContent($arrDetails['brandID'],false);
                        $strMessage = str_replace("[group_name]",$arrDetails['group_name'],$strMessage);
                        $strMessage = str_replace("[terms]",$arrDetails['business_terms'],$strMessage);
                        $strMessage = str_replace("[mini_url]",ROOT_URL."/package/".$session_id,$strMessage);
                        $strBusinessName = $objBrand->strBusinessName;

                        $data = "";
                        $i = 0;
                        $ptotal = 0;

                        if( isset($objPackage->arrHotelVouchers)) {
                            foreach($objPackage->arrHotelVouchers As $row){
                                $package_hotel_id = $row["phid"];

                                if($row["default"] == 1){
                                    $arrD = $objPackage->getPackageHotelDetail($package_hotel_id);
                                    //var_dump($arrMakePaymentVal);die();

                                    foreach($arrPeopleId As $key=>$person) {
                                        $name = $arrPeopleName[$i] . ' ' . $arrPeoplelName[$i];
                                        $email = $arrD[$i]['people_email'];
                                        $roomNum = $arrD[$i]['room_num'];
                                        $roomResNum = $arrD[$i]['room_reservation_num'];
                                        $nightsNum = $arrD[$i]['nights_num'];

                                        $deposit = $arrD[$i]['deposit_price'];
                                        $payment = $arrMakePaymentVal[$i] == '' ? 0 : intval($arrMakePaymentVal[$i]);
                                        $amount = $arrD[$i]['package_price'];

                                        $data .= "
                                           <tr>
                                            <td style=\"padding:5px;width:200px;\"><strong>".$name."</strong></td>
                                            <td style=\"padding:5px;\">".$email."</td>
                                            <td style=\"padding:5px;\">".$roomNum."</td>
                                            <td style=\"padding:5px;\">".$roomResNum."</td>
                                            <td style=\"padding:5px;\">".$nightsNum."</td>
                                            <td style=\"padding:5px;\" >$".number_format($payment, 2). ' ' .$strCurrency."</td>
                                            <td style=\"padding:5px;\" >$".number_format( ( intval($amount) ) , 2). ' ' .$strCurrency."</td>
                                            <td style=\"padding:5px;\" >$".number_format($deposit, 2). ' ' .$strCurrency."</td>
                                            <td style=\"padding:5px;\" >$".number_format($amount-$payment-$deposit, 2). ' ' .$strCurrency."</td>
                                           </tr>";

                                        $ptotal += $payment;
                                        $i++;
                                    }
                                }
                            }
                        }

                        $strAdminName = 'Ross Marrington';
                        $strAdminEmail = 'ross@bcgolfguide.com';

                        $arrAgents =  $objPackage->getEmailsForPackage($arrDetails['id']);

                        foreach ($arrAgents as $arrAgent) {
                            if ($arrAgent['primary_contact'] == '1') {
                                $strAdminName = $arrAgent['booking_name'];
                                $strAdminEmail = $arrAgent['booking_email'];
                            }
                        }

                        $strMessage = str_replace("[table_data]",$data,$strMessage);
                        $strMessage = str_replace("[Total]",'$'.number_format($ptotal, 2). ' ' .$strCurrency ,$strMessage);

                        if ($strCurrency == 'CAD') {
                            $gst = 0.04761905 * $ptotal;
                            $taxlessTotal = $ptotal - $gst;
                            $strMessage = str_replace("[no_gst]", "GST $".number_format($ptotal, 2). " CAD, trip without GST = $".number_format($gst, 2). ' CAD' ,$strMessage);
                        } else {
                            $strMessage = str_replace("[no_gst]", "", $strMessage);
                        }

                        $objMember->strSuccessMessage .= 'Moneris Response: ' . $mpgResponse->getMessage();

                        Util::sendMail($objMember->strEmail, 'Your '.$strBusinessName.' golf package is ready to view', $strMessage, $strAdminEmail);
                        //Util::sendMail('graham@navigator.ca', 'Your '.$strBusinessName.' golf package is ready to view', $strMessage, $strAdminEmail);

                        if($objMember->strEmail != $arrDetails['user_email']){
                            Util::sendMail($arrDetails['user_email'], 'Your '.$strBusinessName.' golf package is ready to view', $strMessage, $strAdminEmail);
                            //Util::sendMail('graham@navigator.ca', 'Your '.$strBusinessName.' golf package is ready to view', $strMessage, $strAdminEmail);
                        }

                        $arrAgents =  $objPackage->getEmailsForPackage($arrDetails['id']);

                        foreach ($arrAgents as $arrAgent) {
                            Util::sendMail($arrAgent['booking_email'], 'Payment received for the "'.$arrDetails['group_name'].'" by "'.$_POST['first_name'] . '' . $_POST['last_name'].'"', $strMessage, $strAdminEmail);
                            //Util::sendMail('graham@navigator.ca', 'Payment received for the "'.$arrDetails['group_name'].'" by "'.$_POST['first_name'] . '' . $_POST['last_name'].'"', $strMessage, $strAdminEmail);
                        }

                        //updates the package HOtel Details with any new data collected from the form
                        $objMember->updatePaymentDetail($_POST,$member_id,$email_id,$objMember->strFirstName,$objMember->strLastName,false);

                        //Update the concurrency timestamp in the database
                        $objPackageHotel->short_query('UPDATE package_hotel SET last_edit = now() WHERE id = ' . $_POST['package_hotel_id']);

                        //$sql = "UPDATE packages SET blnProcessed=1 WHERE session_id='$session_id'";
                        //$this->short_query($sql);

                        //$TransactionID = $PayPal->getTXID();
                        $TransactionID = $mpgResponse->getTxnNumber();
                        //$d = $PayPal->getTransactionDetails($TransactionID);
                        //$ReceiptID = $PayPal->getReceiptId();
                        //$ReceiptID = str_replace("%2d","-",$ReceiptID);
                        $ReceiptID = $mpgResponse->getReceiptId();
                        //$Fee = $PayPal->getFee();
                        $Fee = 0; // Moneris will not provide fees at time of transaction

                        //save the paypal transaction info
                        $objTrans = new Transaction();
                        $objTrans->insertTransaction($TransactionID, $member_id, floatval($intTotal), $Fee, $ReceiptID,
                            Date('Y-m-d H:i:s'),$arrDetails['id'],$arrDetails['group_name'],
                            $_POST['first_name'] . '' . $_POST['last_name'],$objMember->strEmail, $strCurrency);

                        // Redirect back to the package overview, with the message displayed
                        header('Location: ' . ROOT_URL . '/package/' . $session_id . '?message=1');
                    } else {
                        // Transaction Failure
                        $objMember->strErrorMessage .= 'Moneris Response: '.$mpgResponse->getMessage();
                    }
                } else {
                    // data was not valid

                    $arrPeopleName = isset($_POST['people_name']) ? $_POST['people_name'] : array();
                    $arrPeopleLName = isset($_POST['people_lname']) ? $_POST['people_lname'] : array();
                    $arrMakePaymentVal = isset($_POST['make_payment_val']) ? $_POST['make_payment_val'] : array();
                    $arrPeopleId = isset($_POST['people_id']) ? $_POST['people_id'] : array();
                    $arrDeposit = isset($_POST['deposit']) ? $_POST['deposit'] : array();

                    if(!isset($_POST['people_name']) && isset($objPackage->arrHotelVouchers)) {
                        foreach($objPackage->arrHotelVouchers As $row){
                            $package_hotel_id = $row["phid"];

                            $arrD = $objPackage->getPackageHotelDetail($package_hotel_id);
                                $i = 0;
                                foreach($arrD As $d) {
                                    $arrPeopleId[] = $d['id'];
                                    $arrPeopleName[] = $d['people_name'];
                                    $arrPeopleLName[] = $d['people_lname'];
                                    $arrDeposit[] = $d['deposit_price'];
                                    $arrMakePaymentVal[] = $d['final_price'];
                                    $i++;
                                }

                        }
                    }

                    //var_dump($arrPeopleName);
                    if(!is_array($arrPeopleName)){
                        $arrPeopleName = explode(',', $arrPeopleName);
                    }

                    if(!is_array($arrPeopleLName)){
                        $arrPeopleLName = explode(',', $arrPeopleLName);
                    }

                    if(!is_array($arrMakePaymentVal)){
                        $arrMakePaymentVal = explode(',', $arrMakePaymentVal);
                    }

                    if(!is_array($arrPeopleId)){
                        $arrPeopleId = explode(',', $arrPeopleId);
                    }

                    if(!is_array($arrDeposit)){
                        $arrDeposit = explode(',', $arrDeposit);
                    }

                    $csvPeopleName = implode(',',$arrPeopleName);
                    $csvPeoplelName = implode(',',$arrPeopleLName);
                    $csvMakePaymentVal = implode(',',$arrMakePaymentVal);
                    $csvPeopleId = implode(',',$arrPeopleId);
                    $csvDeposit = implode(',',$arrDeposit);
                }
            }
        }
    }
}
//echo '<pre>';
//var_dump($objMember);
//echo '</pre>';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex,nofollow">

    <title>Secure Payment Page</title>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="/application/css/style.css">

    <!-- SCRIPTS -->
    <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="/application/js/payment_funcs.js"></script>
    <script src="/application/js/scripts.js"></script>
    <script src="/application/js/admin/admin.js"></script>

    <?php echo $objSettings->getHeaderScripts(); // Custom analytics or tracking scripts from the settings ?>
</head>
<body class="secure-payment-page">

    <?php include(ROOT_DIR.'/application/includes/header_whitelabel.php'); ?>

    <div class="container">

        <?php if($objMember->strSuccessMessage != '') {?>

        <!-- Redirected back to the overview page -->

        <?php } else { ?>


        <form id="secure-payment-form" method="post" role="form">
            <input type="hidden" name="session" id="session" value="<?php echo $session_id;?>"  />
            <input type="hidden" name="people_name" id="people_name" value="<?php echo $csvPeopleName;?>"  />
            <input type="hidden" name="people_lname" id="people_lname" value="<?php echo $csvPeoplelName;?>"  />
            <input type="hidden" name="people_email" id="people_email" value="<?php echo $csvPeopleEmail;?>"  />
            <input type="hidden" name="make_payment_val" id="make_payment_val" value="<?php echo $csvMakePaymentVal;?>"  />
            <input type="hidden" name="people_id" id="people_id" value="<?php echo $csvPeopleId;?>"  />
            <input type="hidden" name="deposit" id="deposit" value="<?php echo $csvDeposit;?>"  />
            <input type="hidden" name="package_price" id="package_price" value="<?php echo $csvPackagePrice;?>"  />
            <input type="hidden" name="make_payment_total_hidden" id="make_payment_total_hidden" value="<?php echo $intTotal;?>"  />

            <input type="hidden" name="last_edit" id="last_edit" value="<?php echo $_POST['last_edit']; ?>"  />
            <input type="hidden" name="package_hotel_id" id="package_hotel_id" value="<?php echo $_POST['package_hotel_id']; ?>"  />

            <h1>
                Secure Payment page
                <br><small>SSL - Live Credit Card Processing for Deposits and Final Payments</small>
            </h1>

            <p>Please read through and complete the payment form below. This is <u>now a live credit card processing page</u>,
                where we provide a secure transmission of your personal data in order to process deposits and final amounts.</p>
            <p>Golf Package terms and conditions for deposits and final payments are noted at the bottom of the page.
                Please read completely before completing this form. For all payments made on this page,
                <strong>Moneris</strong> is our Merchant Credit Card Provider.</p>

            <div class="form-group">
                <label>Group or Organizer's Name:</label>
                <input type="text" class="input-lg form-control" value="<?php echo($arrDetails['group_name']); ?>" readonly>
            </div>

            <?php if(!empty($objMember->strErrorMessage)) {?>
            <div class="alert alert-danger">
                <?php echo ($objMember->strErrorMessage );?>
            </div>
            <?php } ?>

            <div class="js-error-message alert alert-danger" style="display: none;"></div>

            <hr>

            <?php
            $blnShowForm = 'display:none;';
            if(isset($arrPeopleLName) && count($arrPeopleLName) > 1){
                ?>
                <div class="form-group">

                    <h2>Please Select Your Name</h2>
                    <label for="name">Your Name <span class="required">*</span></label>
                    <select class="form-control" id="people_name_ddl" name="member_id">
                        <option value="">Please Choose</option>
                        <?php
                        $i = 0;
                        foreach($arrPeopleLName As $p){
                            $i ++;
                            echo '<option value="'.$arrPeopleId[$i-1].'" data="'.$arrPeopleName[$i-1].'|'.$p.'">'.$arrPeopleName[$i-1].' '.$p.'</option>';

                        } ?>
                    </select>
                </div>
                <?php
            } else {


                $objMember->strEmail = $arrDetails['user_email'];
                echo '<input type="hidden" value="'.$arrDetails['userID'].'" name="member_id" />';
                $blnShowForm = 'display:block;';
            }
            ?>

            <div class="form-group">
                <label for="email">Your Email <span class="required">*</span></label>
                <input type="text" name="email" id="email" value="<?php echo $objMember->strEmail;?>" class="form-control" />
                <div id="check_result" style="color:red;"></div>
            </div>

            <div id="hiddeninfo" style="<?php echo $blnShowForm; ?>">

                <hr>

                <h3>Contact Information</h3>

                <div class="form-group">
                    <label for="first_name">First Name <span class="required">*</span></label>
                    <input type="text" value="<?php echo $objMember->strFirstName;?>" class="form-control" name="first_name" id="first_name">
                </div>

                <div class="form-group">
                    <label for="last_name">Last Name <span class="required">*</span></label>
                    <input type="text" value="<?php echo $objMember->strLastName;?>" class="form-control" name="last_name" id="last_name">
                </div>

                <div class="form-group">
                    <div class="form-inline">
                        <label for="phone">Phone or Cell: <span class="required">*</span></label><br />
                        <input type="text" placeholder="###" id="first_block" name="first_block" maxlength="3" size="3" class="form-control" value="<?php echo $objMember->strPhone;?>">
                        <input type="text" placeholder="###" id="second_block" name="second_block" maxlength="3" size="3" class="form-control">
                        <input type="text" placeholder="####" id="third_block" name="third_block" maxlength="4" size="4" class="form-control">
                        <input type="hidden" name="phone" id="phone_number" value="<?php echo $objMember->strPhone;?>">
                    </div>
                </div>

                <hr />

                <h3>Address Information</h3>

                <div class="form-group">
                    <label for="address">Address <span class="required">*</span></label>
                    <input id="address" name="address" class="form-control" type="text"value="<?php echo $objMember->strAddress;?>">
                </div>

                <div class="form-group">
                    <label for="country">Country <span class="required">*</span></label>
                    <select id="country" name="country" class="form-control">
                        <option value="261" <?php echo Util::isSelected('261',$objMember->intCountryId); ?>>Canada</option>
                        <option value="148" <?php echo Util::isSelected('148',$objMember->intCountryId); ?>>United States</option>

                    </select>
                </div>

                <div class="form-group">
                    <label for="state">Province <span class="required">*</span></label>
                    <select id="state" name="state" class="form-control">
                        <?php foreach($arrStates As $s){
                            echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $objMember->intStateId).'>'.$s['state_name'].'</option>';
                        } ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="city">City <span class="required">*</span></label>
                    <select id="city" name="city" class="form-control">
                        <?php foreach($arrCities As $s){
                            echo '<option value="'.$s['id'].'" '.Util::isSelected($s['id'], $objMember->intCityId).'>'.$s['title'].'</option>';
                        } ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="postal_code">Postal Code <span class="required">*</span></label>
                    <input id="postal_code" name="postal_code" class="form-control" type="text" value="<?php echo $objMember->strPostalCode;?>">
                </div>

                <p>If you couldn't find your country, province or city in the list, then type the entire address with city in the address field and use CANADA - BC - VANCOUVER (for clients outside USA/Canada)</p>

                <hr />

                 <h3>
                    Credit Card Information
                    <img src="/application/uploads/images/logo-visa.jpg" border="0" alt="Visa">
                    <img src="/application/uploads/images/logo-mastercard.jpg" border="0" alt="Master Card">
                </h3>

                <iframe name="monerisFrame" id="monerisFrame" src="https://esqa.moneris.com/HPPtoken/index.php?id=htTKJM2KDZ2X98F&pmmsg=true&display_labels=1&css_body=background:rgb(247, 247, 247);&css_textbox=border-width:2px;border-color:rgb(185,185,185);height:42px;border-radius:3px;font-size: 16px;display: block;width: 100%;height: 34px;padding: 6px 12px;font-size: 14px;line-height: 1.42857143;color: rgb(85, 85, 85);background-color: rgb(255, 255, 255);background-image: none;border: 1px solid rgb(204, 204, 204);border-radius: 4px;-webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);box-shadow: inset 0 1px 1px rgba(0,0,0,.075);-webkit-transition: border-color ease-in-out .15s,-webkit-box-shadow ease-in-out .15s;-o-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;&css_textbox_pan=width:250px;&enable_exp=1&css_textbox_exp=width:100px;&enable_cvd=1&css_textbox_cvd=width:60px" frameborder='0' width="100%" height="175"></iframe>

                <div class="form-group">
                    <label for="amount">Payment Amount</label>
                    <p class="control-form-static">
                        $<?php echo $intTotal . ' ' . $strCurrency; ?>
                    </p>
                </div>

                <hr />

                <h3>Terms &amp; Conditions</h3>
                <div class="well">
                    <div style="height: 300px; overflow-y:scroll;"><?php echo $objPackage->strTerms;?></div>
                </div>

                <div class="checkbox">
                    <label>
                        <input type="checkbox" id="payment_terms_accepted" value="yes" onclick="checkSubmit()">
                        I agree to the Terms and Conditions of Payment [Required]
                    </label>
                </div>

                <div id="monerisResponse" style="font-weight:bold;color:#cd2525"></div>

                <hr />

            </div>

            <div class="buttons">
                <div class="loading" style="display: none; margin-left: 35px;"><i class="fa fa-spinner fa-spin fa-3x"></i></div>
                <input type="submit" name="dopost" id="submitbutton" style="display: none;" value="Pay Now - Please click only once - do not double click" class="btn btn-primary btn-lg" />
                <input type="hidden" name="id" id="id" value="<?php echo $id;?>" />
                <input type="hidden" name="moneris_token" id="moneris_token" value="" />
            </div>

        </form>


        <?php } // end success message check?>


    </div>

    <script type="text/javascript">
    $('#submitbutton').click(function(event){
        // Payment button has been clicked, replace it with a loading image
        $(this).closest('.buttons').find('.loading').show();
        $(this).hide();
    });

    jQuery(document).ready(function($){

        function doMonerisSubmit()
        {
            console.log('mon submit');
            var monFrameRef = document.getElementById('monerisFrame').contentWindow;
            monFrameRef.postMessage('tokenize','https://esqa.moneris.com/HPPtoken/index.php');
            //change link according to table above
            return false;
        }

        var respMsg = function(e)
        {
            var respData = eval("(" + e.data + ")");
            console.log(respData);
            if (respData.dataKey !== undefined) {
                $('#moneris_token').val(respData.dataKey);
                console.log($('#moneris_token').val());
                $('#secure-payment-form').submit();
            } else {
                document.getElementById("monerisResponse").innerHTML = 'Error with Card info, please try again';

                // Payment button has been clicked, replace it with a loading image
                $('.loading').hide();
                $('#submitbutton').show();

                var $container = $("html,body");
                var $scrollTo = $('#monerisResponse');

                $container.animate({scrollTop: $scrollTo.offset().top - $container.offset().top + $container.scrollTop(), scrollLeft: 0},300);

            }
            //respData.responseCode + "-" + respData.dataKey + "-" + respData.errorMessage;
            //document.getElementById("monerisFrame").style.display = 'none';
        }

        window.onload = function()
        {
            if (window.addEventListener)
            {
                window.addEventListener ("message", respMsg, false);
            }
            else
            {
                if (window.attachEvent)
                {
                window.attachEvent("onmessage", respMsg);
                }
            }
        }

        $('#secure-payment-form #submitbutton').click(function(event){
            var jobjForm = $(this).closest('form');

            // reset errors
            var blnError = false;
            var strError = '';
            jobjForm.find('.has-error').removeClass('.has-error');

            //doMonerisSubmit();
            //return false;

            // validate required fields
            var jobjRequiredFields = jobjForm.find('.required');

            jobjRequiredFields.each(function(){
                try{
                    // get form-group
                    var jobjFormGroup = $(this).closest('.form-group');

                    // check if field empty

                    // try textbox
                    var strValue = jobjFormGroup.find('input[type=text]').val();

                    if(typeof(strValue) == 'undefined'){
                        // try email box
                        strValue = jobjFormGroup.find('input[type=email]').val();
                    }

                    if(typeof(strValue) == 'undefined'){
                        // try select box
                        strValue = jobjFormGroup.find('select :selected').val();
                    }

                    if(strValue.length == 0){
                        // it's empty
                        // highlight form-group
                        jobjFormGroup.addClass('has-error');
                        strError += 'Please enter ' + jobjFormGroup.find('label').text().replace('*','').replace(':','').trim() + '<br />';

                        blnError = true;
                    }
                }catch(exp){
                    console.log(this);
                }
            });

            if(blnError){
                // if some not valid then don't submit
                event.preventDefault();

                // show the payment button again
                jobjForm.find('.buttons .loading').hide();
                jobjForm.find('.buttons #submitbutton').show();

                // show error message
                $('.js-error-message').html(strError).show();

                // scroll to top of page
                $("html, body").animate({ scrollTop: 0 });

                return false;
            }

            $('.js-error-message').hide().html('');

            doMonerisSubmit();

            // no errors
            return false;
        });
    });
    </script>

    <?php echo $objSettings->getFooterScripts(); ?>

</body>
</html>
