<?php

include('../config.php');

include(ROOT_DIR.'/application/models/admin/brand.php');
// include(ROOT_DIR.'/application/models/admin/hotel.php');

$objQuote = new Quote;
$objBrand = new Brand;
$objHotel = new Hotel;
$objCourse = new Course;

$strSessionId = isset($_REQUEST['session']) ? $_REQUEST['session'] : '';
$strUrl = ROOT_URL . '/quote-preview/' . $strSessionId . '/';

// get required info
$arrDetails = $objQuote->getDetail('',$strSessionId);

// If empty 404 the page
if (empty($arrDetails)) {
    include ROOT_DIR . '/application/services/404.php'; die;
}

$intGroupID = Quote::getGroupId($arrDetails['id']);
$strGroupName = Quotegroups::getGroupNameById($intGroupID);
$arrGroupQuotes = Quotegroups::getQuotesByGroup($intGroupID);
$arrBrand = $objBrand->getDetail($arrDetails['brandID']);
$arrDBCourses = $objQuote->getCoursesForQuote($arrDetails['id']);
$arrDBHotels = $objQuote->getHotelsForQuote($arrDetails['id']);
$strActiveTab = 'tb_my_quote';

$objQuote = new Quote;
$arrRecord = $objQuote->getByID($intQuoteId);

// Update Quote Email Status to Read
if (!isset($_SESSION['user_access']) || $_SESSION['user_access'] == 50) {
    Quote::updateQuoteEmailStatus($arrDetails['id'], true);
}

// save message if there was one
if(isset($_POST['action']) && $_POST['action'] == 'book_now'){
	$arrMessage = Quote::setBookNow($_POST);
	$arrDetails = $objQuote->getDetail('',$strSessionId);
}elseif(isset($_POST['action']) && $_POST['action'] == 'send_message'){
	$strComment = $_POST['comment'];
	$objQuote->setQuoteNote($intGroupID,$strComment,0);
    $objQuote->sendQuoteNoteAlert(Quotegroups::getLastQuoteByGroup($intGroupID), $strComment, 0);

	$strActiveTab = 'tb_conversation_history';

	$arrMessage = array(
		'blnError' => false,
		'strMessage' => 'Message Sent'
	);
}

// get notes after we have updated them
$arrNotes =  $objQuote->getNotesForQuoteGroup($intGroupID);

// rearrange courses by id
$arrCourses = array();
foreach($arrDBCourses as $arrCourse){
	if(isset($arrCourses[$arrCourse['course_id']])){
		// already in our list
		continue;
	}

	$arrCourses[$arrCourse['course_id']] = $arrCourse;
}

// course images
$arrCourseImages = array();
foreach($arrCourses as $arrCourse){
	$arrCourseImage = $objQuote->getQuoteCourseImages($arrCourse['course_id']);

	if(empty($arrCourseImage)){
		// nothing found
		continue;
	}

	$arrCourseImages[$arrCourse['course_id']] = $arrCourseImage;
}

// rearrange hotels by id
$arrHotels = array();
foreach($arrDBHotels as $arrHotel){
	if(isset($arrHotels[$arrHotel['hotel_id']])){
		// already in our list
		continue;
	}

	$arrHotels[$arrHotel['hotel_id']] = $arrHotel;
}

// get hotel images
$arrHotelImages = array();
foreach($arrHotels as $arrHotel){
	$arrHotelImage = $objQuote->getQuoteHotelImages($arrHotel['hotel_id']);

	if(empty($arrHotelImage)){
		// nothing found
		continue;
	}

	$arrHotelImages[$arrHotel['hotel_id']] = $arrHotelImage;
}

$strTitle = 'Golf Trip Quotation For ' . (!empty($arrDetails['quote_name']) ? $arrDetails['quote_name'] : $arrDetails['group_name']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex,nofollow">

	<title><?php echo $strTitle; ?></title>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="/application/css/style.css">

    <!-- SCRIPTS -->
    <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="//maps.googleapis.com/maps/api/js?key=AIzaSyCAEI0_8xMbaP_3Z7MBgAisGPqPZA2MeZ4"></script>
    <script src="//www.google.com/jsapi"></script>
    <script src="/application/js/map_funcs.js"></script>

    <?php echo $objSettings->getHeaderScripts(); // Custom analytics or tracking scripts from the settings ?>
</head>
<body class="detail-page">

	<?php include(ROOT_DIR.'/application/includes/header_whitelabel.php'); ?>

	<div class="container">
		<h1>Golf Trip Quotation for <?php echo $arrDetails['group_name']; ?><?php
			if(!empty($arrDetails['quote_name'])){
				echo '<br />';
				echo $arrDetails['quote_name'];
			}

			if(!empty($arrDetails['ready_to_book'])){
				echo '<br />';
				echo ' <span class="helper-text small">(This quote has been marked as ready to book)<span>';
			}
		?></h1>

		<div class="row">
			<div class="col-md-12">
				<div class="slideshow group clearfix">
					<div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
						<!-- Indicators -->
						<ol class="carousel-indicators">
							<?php

							if(!empty($arrCourseImages) && count($arrCourseImages) > 1){
								$strActive = 'active';
								for($intCourseImage = 0; $intCourseImage < count($arrCourseImages); $intCourseImage++){
									echo '<li data-target="#carousel-example-generic" data-slide-to="' . $intCourseImage . '" class="' . $strActive . '"></li>';

									$strActive = '';
								}
							}

							?>
						</ol>

						<!-- Wrapper for slides -->
						<div class="carousel-inner" role="listbox">
							<?php
							$strActive = 'active';
							foreach($arrCourseImages as $arrCourseImage){
								?>

								<div class="item <?php echo $strActive; ?>">
									<img src="<?php echo ROOT_URL; ?>/application/images/timthumb.php?src=<?php echo urlencode($arrCourseImage['file_name']); ?>&w=1920&h=735&zc=1&a=c&q=80&rnd=18945" alt="<?php echo $arrCourseImage['alt']; ?>">
								</div>

								<?php
								$strActive = '';
							}


							?>
						</div>

						<!-- Controls -->
						<?php
						if(!empty($arrCourseImages) && count($arrCourseImages) > 1){
						?>
						<a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
							<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
							<span class="sr-only">Previous</span>
						</a>
						<a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
							<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
							<span class="sr-only">Next</span>
						</a>
						<?php } ?>
					</div>
				</div>

				<?php
				if(isset($arrMessage) && !empty($arrMessage)){
					$strClass = 'danger';
					if(!$arrMessage['blnError']){
						$strClass = 'success';
					}
					?>

					<div class="group clearfix">
						<div class="alert alert-<?php echo $strClass; ?>" role="alert">
							<?php echo $arrMessage['strMessage']; ?>
							<button type="button" class="close" data-dismiss="alert" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
					</div>
					<?php
				}
				?>

				<div class="tabs group clearfix">
					<!-- Nav tabs -->
					<ul class="nav nav-tabs" role="tablist">
						<li role="presentation" class="<?php if($strActiveTab == 'tb_my_quote'){echo 'active';} ?>"><a href="#tb_my_quote" aria-controls="tb_my_quote" role="tab" data-toggle="tab">My Quote</a></li>
						<li role="presentation" class="<?php if($strActiveTab == 'tb_hotel_options'){echo 'active';} ?>"><a href="#tb_hotel_options" aria-controls="tb_hotel_options" role="tab" data-toggle="tab">Hotel Options</a></li>
						<li role="presentation" class="<?php if($strActiveTab == 'tb_course_options'){echo 'active';} ?>"><a href="#tb_course_options" aria-controls="tb_course_options" role="tab" data-toggle="tab">Course Options</a></li>
						<li role="presentation" class="<?php if($strActiveTab == 'tb_conversation_history'){echo 'active';} ?>"><a href="#tb_conversation_history" aria-controls="tb_conversation_history" role="tab" data-toggle="tab">Conversation History</a></li>
						<li role="presentation" class="<?php if($strActiveTab == 'tb_map_directions'){echo 'active';} ?>"><a id="map_tab" href="#tb_map_directions" aria-controls="tb_map_directions" role="tab" data-toggle="tab">Map Directions</a></li>
						<li role="presentation" class="<?php if($strActiveTab == 'tb_my_agent'){echo 'active';} ?>"><a href="#tb_my_agent" aria-controls="tb_my_agent" role="tab" data-toggle="tab">My Specialist</a></li>
                        <li role="presentation" class="<?php if($strActiveTab == 'tb_terms'){echo 'active';} ?>"><a href="#tb_terms" aria-controls="tb_terms" role="tab" data-toggle="tab">Terms &amp; Conditions</a></li>
                        <?php

						if(!empty($arrGroupQuotes) && count($arrGroupQuotes) > 1){
							?>
							<li role="presentation" class="<?php if($strActiveTab == 'tb_quote_history'){echo 'active';} ?>"><a href="#tb_quote_history" aria-controls="tb_quote_history" role="tab" data-toggle="tab">Quote History</a></li>
							<?php
						}

						if(empty($arrDetails['ready_to_book'])){
							?>
							<li role="presentation" class="<?php if($strActiveTab == 'tb_book_this'){echo 'active';} ?>"><a href="#" class="js-btn-book-now btn btn-primary btn-block" aria-controls="tb_book_this" data-toggle="modal" data-target="#book_now">I want to book this</a></li>
							<?php
						}
						?>
					</ul>

					<!-- Tab panes -->
					<div class="tab-content">

						<div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_my_agent'){echo 'active';} ?>" id="tb_my_agent">
							<h3>My Specialist</h3>
			                <div class='col-sm-8'>

			                        <p><strong>Name:</strong> <?php echo $arrDetails['booking_agent']['booking_name']; ?></p>
			                        <p><strong>Title:</strong> <?php echo $arrDetails['booking_agent']['booking_title']; ?></p>
			                        <p><strong>Phone #:</strong> <?php echo $arrDetails['booking_agent']['booking_phone']; ?></p>

			                        <p></p>
			                        <p><?php echo nl2br($arrDetails['booking_agent']['booking_description']); ?></p>


			                </div>

			                <div class='col-sm-4'>
			                    <?php Util::displayThumb($arrDetails['booking_agent']['booking_image'], 333, 350, 3); ?>
			                </div>
						</div>

                        <div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_terms'){echo 'active';} ?>" id="tb_terms">
                            <h3>Terms &amp; Conditions</h3>
                            <div class='col-sm-12'>
                                <p><?php echo nl2br($arrDetails['business_terms']); ?></p>
                            </div>
                        </div>

						<div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_my_quote'){echo 'active';} ?>" id="tb_my_quote">

							<div class="row">
								<div class="col-md-4">
									<div class="images">
										<?php

										// show course images first
										foreach($arrCourseImages as $arrCourseImage){
											?>

											<figure class="location-preview course-image">
                                                <img src="<?php echo ROOT_URL; ?>/application/images/timthumb.php?src=<?php echo urlencode($arrCourseImage['file_name']); ?>&amp;w=360&amp;h=230&amp;zc=1&amp;a=c&amp;q=80&amp;rnd=8486" alt="<?php echo $arrCourseImage['alt']; ?>" class="img-responsive">
                                                <figcaption class="caption"><?php echo $arrCourses[$arrCourseImage['course_id']]['course_name']; ?></figcaption>
                                        	</figure>

											<?php
										}

										// hotel images
										foreach($arrHotelImages as $arrHotelImage){
											?>

											<figure class="location-preview hotel-image">
                                                <img src="<?php echo ROOT_URL; ?>/application/images/timthumb.php?src=<?php echo urlencode($arrHotelImage['file_name']); ?>&amp;w=360&amp;h=230&amp;zc=1&amp;a=c&amp;q=80&amp;rnd=8486" alt="<?php echo $arrHotelImage['alt']; ?>" class="img-responsive">
                                                <figcaption class="caption"><?php echo $arrHotels[$arrHotelImage['hotel_id']]['hotel_name']; ?></figcaption>
                                        	</figure>

											<?php
										}

										?>
									</div>
								</div>
								<div class="col-md-8">
									<?php

									echo nl2br($arrDetails['additional_details']);

									?>

									<br/ >

									<div class="buttons">
										<?php
										if(empty($arrDetails['ready_to_book'])){
											echo '<a href="#" class="js-btn-book-now btn btn-primary btn-block" data-toggle="modal" data-target="#book_now">Proceed and book this golf trip</a>';
										}
										?>
									</div>
								</div>
							</div>

						</div>
						<div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_hotel_options'){echo 'active';} ?>" id="tb_hotel_options">
							<h3>Hotel Options</h3>

							<?php

							if(empty($arrHotels)){
								// no hotels
								echo 'No hotels have been selected for this package.';
							}else{
								foreach($arrHotels as $arrQuoteHotel){
									$arrHotelImage = $arrHotelImages[$arrQuoteHotel['hotel_id']];
									$arrHotel = $objHotel->getHotelDetailById($arrQuoteHotel['hotel_id']);

									?>
									<div class="hotel row" style="margin-bottom: 10px;">
										<div class="col-md-3">
											<figure class="location-preview hotel-image">
                                                <img src="<?php echo ROOT_URL; ?>/application/images/timthumb.php?src=<?php echo urlencode($arrHotelImage['file_name']); ?>&amp;w=360&amp;h=230&amp;zc=1&amp;a=c&amp;q=80&amp;rnd=8486" alt="<?php echo $arrHotelImage['alt']; ?>" class="img-responsive">
                                                <figcaption class="caption"><?php echo $arrHotels[$arrHotelImage['hotel_id']]['hotel_name']; ?></figcaption>
                                        	</figure>
                                        </div>
										<div class="col-md-9">
											<h3><?php echo $arrQuoteHotel['hotel_name'] ?></h3>
											<?php echo Hotel::getRating($arrHotel['level']); ?>
											<?php echo Util::shortenString($arrHotel['description'], 50); ?>
											<br />
											<a href="<?php echo ROOT_URL . '/golf-accommodations/' . $arrHotel['slug']; ?>" target="_blank">Learn More</a>
										</div>
									</div>
									<?php
								}
							}

							?>
						</div>
						<div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_course_options'){echo 'active';} ?>" id="tb_course_options">
							<h3>Course Options</h3>

							<?php

							if(empty($arrCourses)){
								// no courses
								echo 'No courses have been selected for this package.';
							}else{
								foreach($arrCourses as $arrQuoteCourse){
									$arrCourseImage = $arrCourseImages[$arrQuoteCourse['course_id']];
									$arrCourse = $objCourse->getCourseDetailById($arrQuoteCourse['course_id']);

									?>
									<div class="hotel row" style="margin-bottom: 10px;">
										<div class="col-md-3">
											<figure class="location-preview hotel-image">
                                                <img src="<?php echo ROOT_URL; ?>/application/images/timthumb.php?src=<?php echo urlencode($arrCourseImage['file_name']); ?>&amp;w=360&amp;h=230&amp;zc=1&amp;a=c&amp;q=80&amp;rnd=8486" alt="<?php echo $arrCourseImage['alt']; ?>" class="img-responsive">
                                                <figcaption class="caption"><?php echo $arrCourses[$arrCourseImage['course_id']]['course_name']; ?></figcaption>
                                        	</figure>
                                        </div>
										<div class="col-md-9">
											<h3><?php echo $arrQuoteCourse['course_name'] ?></h3>

											<?php

							                if(!empty($arrCourse['level'])){ ?>
							                    <div class="meta" style="margin-bottom: 10px;">
							                        <strong>Price:</strong>

							                        <?php

							                        for($intLevel = 0; $intLevel < (int)$arrCourse['level']; $intLevel++){
							                        	echo '<span class="fa fa-dollar active"></span>';
							                        }
							                        ?>
							                        1 x $ = $20 / <?php echo $arrCourse['level']; ?> x $ = $<?php echo (int)$arrCourse['level'] * 20;?><br />
							                        <span class="helper-text">(Price scale reflects peak time frame full green fee price with cart – pre tax)</span>
							                    </div>
							                <?php } ?>
											<?php echo Util::shortenString($arrCourse['comments'], 50); ?>
											<br />
											<a href="<?php echo ROOT_URL . '/golf-courses/' . $arrCourse['slug']; ?>" target="_blank">Learn More</a>
										</div>
									</div>
									<?php
								}
							}

							?>
						</div>
                        <div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_map_directions'){echo 'active';} ?>" id="tb_map_directions">
                            <h3>Map Directions</h3>

                            <div id="gmap" class="gmap"></div>
                            <br>

                            <form method="POST" role="form" class="map-direction-form clearfix">

                                <div class="row">
                                    <div class="col-xs-12 col-sm-5">
                                        <div class="form-group">
                                            <label for="start_address">Start Address:</label>
                                            <input type="text" name="start_address" id="start_address" class="form-control" value="">
                                        </div>
                                    </div>

                                    <div class="col-xs-12 col-sm-2">
                                        <div class="form-group">
                                            <label for="method">Method:</label>
                                            <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                                                <option value="DRIVING">Driving</option>
                                                <option value="WALKING">Walking</option>
                                                <option value="BICYCLING">Bicycling</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-xs-12 col-sm-5">
                                        <div class="form-group">
                                            <label for="end_address">Destination:</label>
                                            <select name="eaddr" id="eaddr" class="form-control">
                                                <?php
                                                if (!empty($arrCourses)) {
                                                    foreach ($arrCourses as $arrCourse) {
                                                        echo '<option value="' . $arrCourse['latitude'] . ' ' . $arrCourse['longitude'] . '">' . $arrCourse['course_name'] . '</option>';
                                                    }
                                                }
                                                if (!empty($arrHotels)) {
                                                    foreach ($arrHotels as $arrHotel) {
                                                        echo '<option value="' . $arrHotel['latitude'] . ' ' . $arrHotel['longitude'] . '">' . $arrHotel['hotel_name'] . '</option>';
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <button type="button" class="btn btn-primary btn-icon-after pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

                            </form>

                            <hr>

                            <div id="directions_panel"></div>

                        </div>
						<div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_conversation_history'){echo 'active';} ?>" id="tb_conversation_history">
							<?php

							if(!empty($arrDetails['comments'])){
								echo '<h3>Additional Details</h3>';
								echo '<p>' . nl2br($arrDetails['comments']) . '</p>';
							}

							?>

							<h3>Conversation History</h3>

							<?php

							if(empty($arrNotes)){
								echo 'No conversation history to show.';
							}else{
								?>

								<table class="table table-hover">
									<thead>
										<tr>
											<th width="60%">Message Threads</th>
											<th width="20%">From</th>
											<th width="20%">Time Stamp</th>
										</tr>
									</thead>
									<tbody>
										<?php

										foreach($arrNotes as $arrNote){
											?>

											<tr>
												<td width="60%" align="left" cellspacing="2">
													<?php echo Util::shortenStringWithExtention(Util::nl2br($arrNote['comment']), 100); ?>
												</td>
												<td>
													<?php
													if($arrNote['direction'] == '1'){
														if($arrNote['sales_id'] == '1'){
															echo 'Ross Marrington';
														}
														if($arrNote['sales_id'] == '2'){
															echo 'Danny Leitch';
														}
													}else{
														echo $arrNote['user_name'];
													}
													?>
												</td>
												<td>
													<?php echo Util::formatDate($arrNote['timestamp'], true); ?>
												</td>
											</tr>

											<?php
										}

										?>
									</tbody>
								</table>


								<?php
							}

							?>

							<div class="row" style="margin-top: 10px;">
								<div class="col-xs-12">

									<form name="frmMessage" method="post" role="form">
										<input type="hidden" name="action" value="send_message" />
										<input type="hidden" name="session" id="id" value="<?php echo $arrDetails['session_id']; ?>">
										<input type="hidden" name="quote_id" id="quote_id" value="<?php echo $arrDetails['id']; ?>">

										<h3>Type New Messages Below</h3>
										<div class="form-group">
											<textarea rows="7" name="comment" id="comment" class="form-control"></textarea>
										</div>
										<div class="form-group">

											<input type="submit" value="Send Message" name="Submit" class="btn btn-primary">
											<span class="loading hide"><i class="fa fa-refresh fa-spin"></i></span>

										</div>
									</form>
								</div>
							</div>
						</div>
						<?php

						if(!empty($arrGroupQuotes) && count($arrGroupQuotes) > 1){
							?>
							<div role="tabpanel" class="tab-pane <?php if($strActiveTab == 'tb_quote_history'){echo 'active';} ?>" id="tb_quote_history">
								<h3>Quote History</h3>

								<table class="table table-hover">
									<thead>
										<tr>
											<th colspan="2">Quote Name</th>
										</tr>
									</thead>
									<tbody>
										<?php

										foreach($arrGroupQuotes as $arrGroupQuote){
											$strName = $strGroupName;
											if(!empty($arrGroupQuote['quote_name'])){
												$strName = $arrGroupQuote['quote_name'];
											}

											$strLink = '';

											if($arrGroupQuote['id'] != $arrDetails['id']){
												// only link if not current quote
												$strLink = ROOT_URL . '/quote-preview/' . $arrGroupQuote['session_id'];
											}

											echo '<tr><td>';

											if(!empty($strLink)){
												echo '<a href="' . $strLink . '">';
											}

											echo $strName . ' <span class="helper-text">(' . Util::formatDate($arrGroupQuote['date_created']) . ')</span>';

											if(!empty($strLink)){
												echo '</a>';
											}

											echo '</td><td>';

											if(!empty($strLink)){
												echo '<a href="' . $strLink . '">View</a>';
											}else{
												echo 'Current Quote';
											}

											echo '</td></tr>';
										}

										?>
									</tbody>
								</table>
							</div>
							<?php
						}
						?>
					</div>
				</div>


			</div>

		</div>
	</div>

	<form method="post">
		<div class="hide">
			<input type="hidden" name="action" value="book_now" />
			<input type="hidden" name="quote_id" value="<?php echo $arrDetails['id']; ?>" />
		</div>


		<div class="modal fade" id="book_now" tabindex="-1" role="dialog" aria-labelledby="Ready to Book">
			<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title" id="myModalLabel">Ready to Book</h4>
					</div>
					<div class="modal-body">
						<p>Ready to book this quote? Click "Send Request" below and we will contact you with the final details.</p>

						<div class="form-group">
						    <label for="taComment">Comments:</label>
						    <textarea class="form-control" id="taComment" name="comment" placeholder="Any extra details?"></textarea>
						</div>

					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						<button type="submit" class="btn btn-primary">Send Request</button>
					</div>
				</div>
			</div>
		</div>
	</form>

    <?php
    // Generate the javascript for the map

    // var_dump($arrCourses); die;
    // var_dump($arrHotels); die;

    echo Location::getMapData2(array(
        'hotels' => $arrHotels,
        'courses' => $arrCourses,
        'show_directions' => true,
        'show_directions_id' => 'directions_panel',
        'tab_id' => 'map_tab',
        'map_id' => 'gmap',
    ));
    ?>

    <?php echo $objSettings->getFooterScripts(); ?>

</body>
</html>
