<?php

include('../config.php');
include(ROOT_DIR.'/application/models/admin/package.php');
include(ROOT_DIR.'/application/models/admin/package_hotel.php');
include(ROOT_DIR.'/application/models/admin/member.php');

$objPackage = new Package;
$objMember = new Member;
$objPackageHotel = new Packagehotels;

$session_id = isset($_REQUEST['session']) ? $_REQUEST['session'] : '';
$arrDetails =  $objPackage->getDetail('',$session_id);

$url = ROOT_URL.'/package/'.$session_id.'/';
$intTotal = isset($_POST['make_payment_total_hidden']) ? $_REQUEST['make_payment_total_hidden'] : '0';
$strCurrency = $arrDetails['currency'];
$strErrorMessage = '';
$strSuccessMessage = '';

$strPreselectTab = 'general';

//<input type="submit" value="Save Details" id="save_details" class="btn btn-primary btn-block" name="Submit" />
//die($_POST['Submit']);

if(isset($_POST['submit_send_voucher_to']) && $_POST['submit_send_voucher_to'] == 'Send Voucher Documents') {

    $strPreselectTab = 'course';
    $strRecaptcha = isset($_POST['g-recaptcha-response']) ? $_POST['g-recaptcha-response'] : '';
    $strNote = isset($_POST['send_voucher_to_note']) ? $_POST['send_voucher_to_note'] : '';

    // Verify the recaptcha
    if (!Util::recaptcha($strRecaptcha)) {
        $strErrorMessage = 'Please validate that you are not a robot';
    }

    // Validate Email
    $email = $_POST["send_voucher_to"];
    if (($email == '') || (!filter_var($_POST["send_voucher_to"], FILTER_VALIDATE_EMAIL))) {
        $strErrorMessage = "Missing or Invalid email address";
    }

    if ($strErrorMessage == '') {
        $strFrom = '';

        $headers = "From: ".$arrDetails['user_email']. "\r\n" .
            'Reply-To: '.$arrDetails['user_email']. "\r\n" .
            'Content-Type: text/html; charset=UTF-8' . "\r\n" .
            'X-Mailer: PHP/' . phpversion();

        $subject = 'Vouchers for your golf group ' . $arrDetails['group_name'] . ' from ' . $arrDetails['user_name'];

        $strContent = "<a href='".ROOT_URL."/application/services/track_pdf_click.php?package_session=" . $arrDetails['session_id'] . "'>Click Here</a> to download the PDF of all course vouchers";
        if ($strNote != '') {
            $strContent .= "<br /> <br />Note From Group: <br />" . nl2br($strNote);
        }

        Util::sendMailCore($_POST['send_voucher_to'], $subject, $strContent, $headers);
        $strSuccessMessage = 'Vouchers sent to ' . $_POST['send_voucher_to'];
        $_POST['send_voucher_to'] = '';
        $_POST['send_voucher_to_note'] = '';
    }
}

if(isset($_POST['Submit']) && $_POST['Submit'] != ''&& $_POST['Submit'] == 'Save Details') {

    //This is for concurrency Detection - Reject any submissions with a timestamp on the form that does not match the timestamp in the database
    if (is_numeric($_POST['package_hotel_id'])) {

        $arrPackageHotel = $objPackageHotel->getByID($_POST['package_hotel_id']);

        //If the date / time on the page is not the same as the value of the database
        if ($_POST['last_edit'] != $arrPackageHotel['last_edit']) {

            //Reject the changes and inform the user
            $strErrorMessage = 'Sorry, your changes could not be saved, someone else submitted changes. Please try again.';

        } else {

            //Update the timestamp in the database
            $objPackageHotel->short_query('UPDATE package_hotel SET last_edit = now() WHERE id = ' . $_POST['package_hotel_id']);

            //Execute Update
            $objMember->updatePeopleDetail($_POST,true);

            //Re-Aquire Details
            $arrDetails =  $objPackage->getDetail('',$session_id);

            $strSuccessMessage = 'Updates Saved Successfully';
        }
    }



    //$arrDetails['blnProcessed'] = true;
} else if(isset($_POST['Submit']) && $_POST['Submit'] == 'Send Message'){

    $comment = $_POST['comment'];
    $objPackage->setPackageNote($objPackage->intId,$comment,0);
    $objPackage->sendPackageNoteAlert($objPackage->intId, $comment, 0);

}

$arrNotes =  $objPackage->getNotesForPackage($objPackage->intId);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex,nofollow">

    <title>Preview Package</title>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="/application/css/style.css">

    <!-- SCRIPTS -->
    <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="//maps.googleapis.com/maps/api/js?key=AIzaSyCAEI0_8xMbaP_3Z7MBgAisGPqPZA2MeZ4"></script>
    <script src="//www.google.com/jsapi"></script>
    <script src="/application/js/map_funcs.js"></script>
    <script src="/application/js/payment_funcs.js"></script>
    <script src="/application/js/scripts.js"></script>
    <script src="/application/js/admin/admin.js"></script>

    <script>
    jQuery(document).ready(function($) {
        $(".makepayment").on('click', function(event) {
            $(".makepayment").attr('disabled','disabled');
            var total = $('#make_payment_total').val();

            if(total == '' || !isNumeric(total) || total == 0){
                alert('You must enter a payment amount greater than zero');
                $(".makepayment").removeAttr("disabled");
            } else {
                $('#main_form').get(0).setAttribute('action', '/package/secure_payment2/<?php echo $session_id; ?>/'); //this works
                $('#main_form').submit();
            }
        });
    });
    function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    }
    </script>

    <?php echo $objSettings->getHeaderScripts(); // Custom analytics or tracking scripts from the settings ?>
</head>
<body>

    <?php include(ROOT_DIR.'/application/includes/header_whitelabel.php'); ?>

    <div class="container">

        <?php

        if(count($objPackage->arrCourseVouchers) == 0 || count($objPackage->arrHotelVouchers) == 0) {
            $business_text = str_replace("[client_name]", $arrDetails['user_name'],$arrDetails['business_text']);
            $business_text = str_replace("[client_email]", $arrDetails['user_email'],$business_text);
            ?>

            <div class="well">
                <?php echo $business_text; ?>
            </div>

        <?php } else { ?>
    <div class="row package-preview-social">
        <div class="well col-md-6">

            <h3>Golf Trip Itinerary For - <?php echo $arrDetails['group_name']; ?></h3>
            <h4><?php echo $arrDetails['user_name']; ?> - Arrival Date of <?php echo $arrDetails['check_in_date']; ?></h4>
<!--
            <strong>Group Name:</strong> <?php echo $arrDetails['group_name']; ?>
            <br><strong>Contact Name:</strong> <?php echo $arrDetails['user_name']; ?>
-->
<!--
            <br><strong>Share this Package:</strong> <?php echo $url; ?>
-->
            <?php
            $strPDF = '/application/uploads/pdfs/'.$objPackage->intId.'_voucher.pdf';
            if (Util::isFile($strPDF)) {
                $link = "/application/services/track_pdf_click.php?package_id=".$objPackage->intId;
                //echo '<a href="'.$link.'" target="_blank">Download and Print Golf Trip Vouchers</a>';
                echo '<h4 class="voucher_link vocher_link_active"><a class="preview_voucher" href="'.$link.'" target="_blank"><i class="fa fa-ticket"></i> ACCESS TRIP VOUCHERS <i class="fa fa-ticket"></i></a></h4>';
            } else {
                echo '<h4 class="voucher_link"><i class="fa fa-ticket"></i> Vouchers Not Available for Download <i class="fa fa-ticket"></i></a></h4>';
            }
            ?>

        </div>

        <div class="col-md-6" style="text-align:right;margin-top:40px;">
        <?php
            if ($arrDetails['link_fb'] !=  '') {
                echo '<a class="preview_social_link" href="'.$arrDetails['link_fb'].'" target="_blank"><i class="fa fa-facebook"></i></a>';
            }
            if ($arrDetails['link_ig'] !=  '') {
                echo '<a class="preview_social_link"class="preview_social_link"href="'.$arrDetails['link_ig'].'" target="_blank"><i class="fa fa-instagram"></i></a>';
            }
            if ($arrDetails['link_google'] !=  '') {
                echo '<a class="preview_social_link" href="'.$arrDetails['link_google'].'" target="_blank"><i class="fa fa-google"></i></a>';
            }
            if ($arrDetails['link_youtube'] !=  '') {
                echo '<a class="preview_social_link" href="'.$arrDetails['link_youtube'].'" target="_blank"><i class="fa fa-youtube"></i></a>';
            }
            if ($arrDetails['link_enews'] !=  '') {
                echo '<a class="preview_social_link" href="'.$arrDetails['link_enews'].'" target="_blank"><i class="fa fa-newspaper-o"></i></a>';
            }
        ?>
        </div>
    </div>
        <?php if(!empty($strErrorMessage)) {?>
            <div class="alert alert-danger">
                <?php echo ($strErrorMessage );?>
            </div>
        <?php } ?>


        <?php if(!empty($strSuccessMessage)) {?>
            <div class="alert alert-success">
                <?php echo ($strSuccessMessage );?>
            </div>
        <?php } ?>


        <?php if (!empty($_GET['message']) && $_GET['message'] == 1) { ?>
            <div class="alert alert-success">Thank you for your purchase, a confirmation email has been sent to your inbox!</div>
        <?php } ?>

        <?php if (!empty($_GET['message']) && $_GET['message'] == 2) { ?>
            <div class="alert alert-danger">Sorry, your payment was not be processed, another user paid or submitted changes. Please review the form and try again.</div>
        <?php } ?>

        <hr>

        <ul class="nav nav-tabs" id="myTab">
            <li class="general <?php echo ($strPreselectTab == 'general') ? 'active' : ''; ?>"><a href="#general" data-toggle="tab">General Details</a></li>
            <li class="hotel"><a href="#hotel" data-toggle="tab">Hotel Details</a></li>
            <li class="course <?php echo ($strPreselectTab == 'course') ? 'active' : ''; ?>"><a href="#course" data-toggle="tab">Golf Course Details</a></li>
            <li class="maps"><a id="maps_tab" href="#tb_map_directions" data-toggle="tab">Map Directions</a></li>
            <?php

            if(!empty($arrDetails['additional_details'])){
                echo '<li class="additional_details"><a href="#additional_details" data-toggle="tab">Trip Itinerary Notes</a></li>';
            }

            ?>
            <li class="message"><a href="#message" data-toggle="tab">Messages</a></li>
            <li class="agent"><a href="#agent" data-toggle="tab">My Specialist</a></li>
            <li class="terms"><a href="#tos" data-toggle="tab">Terms & Conditions</a></li>
        </ul>
                <!-- Nav tabs -->

        <div class="tab-content">


            <div class="tab-pane" id="agent">
                <h3>My Specialist</h3>
                <div class='col-sm-8'>

                    <div class='well'>
                        <p><strong>Name:</strong> <?php echo $arrDetails['booking_agent']['booking_name']; ?></p>
                        <p><strong>Title:</strong> <?php echo $arrDetails['booking_agent']['booking_title']; ?></p>
                        <p><strong>Phone #:</strong> <?php echo $arrDetails['booking_agent']['booking_phone']; ?></p>
                        <p></p>
                        <p><?php echo nl2br($arrDetails['booking_agent']['booking_description']); ?></p>
                    </div>

                </div>

                <div class='col-sm-4'>
                    <?php Util::displayThumb($arrDetails['booking_agent']['booking_image'], 333, 350, 3); ?>
                </div>


            </div>

            <div class="tab-pane <?php echo ($strPreselectTab == 'general') ? 'active' : ''; ?>" id="general">

                <h3>Payments</h3>
                <form action="/package/<?php echo $session_id;?>/" method="post" role="form" id="main_form">

                    <table class="table text-small">
                        <thead>
                            <tr>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Email</th>
                                <th>Room</th>
                                <th>Nights</th>
                                <th width="140">Today's Payment</th>
                                <th>Price</th>
                                <th>Previously Paid</th>
                                <th>Balance</th>
                                <th>Payment Notes</th>
                                <!--<th>Last Payment Date</th>-->

                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td align="left"><?php if(!$arrDetails['blnProcessed']) {?><input type="submit" value="Save Details" id="save_details" class="btn btn-primary btn-block" name="Submit" /><?php } ?></td>
                                <td colspan="8"><?php if(!$arrDetails['blnProcessed']) {?>This will save the people's information from the form below<?php } ?></td>
                                <td>

                                    <button id="makepayment" class="makepayment btn btn-primary " name="Payment">Enter Payment<br />Amount Below <br />then Click Submit</button></td>
                            </tr>


                            <?php
                            $total_p = 0;
                            $total_d = 0;
                            $total_f = 0;
                            $golfers = 0;
                            $non_golfers = 0;

                            foreach($objPackage->arrHotelVouchers As $row) {

                                $golfers += $row["golfers"];
                                $non_golfers += $row["non_golfers"];
                                $tgolfers = $non_golfers + $golfers;
                                $package_hotel_id = $row["phid"];
                                $blnDefault = $row["default"];


                                if($blnDefault){
                                    $arrD = $objPackage->getPackageHotelDetail($package_hotel_id);
                                    $i = 0;
                                    $total_final = 0;

                                    //For Concurrency Control (prevent double submit, first submit wins)
                                    echo '<input type="hidden" name="package_hotel_id" value="'.$package_hotel_id.'" />';
                                    echo '<input type="hidden" name="last_edit" value="'.$row['last_edit'].'" />';

                                    foreach($arrD As $d) {
                                        $i++;
                                        $id = $d['id'];
                                        $total_p += intval($d['package_price']);
                                        $total_d += intval($d['deposit_price']);
                                        $balance = intval($d['package_price']) - intval($d['deposit_price']);
                                        $total_f += $balance;
                                        ?>
                                        <tr>
                                            <td style="position:relative;width:120px;">
                                                <span name="people_name_<?php echo $i;?>" id="people_name_<?php echo $i;?>" size="15" style="position:relative;">

                                                    <?php $d_type = $arrDetails['blnProcessed'] ? "hidden" : "text"; ?>
                                                    <div class="row">
                                                        <div class="form-group col-sm-*">
                                                            <input type="<?php echo $d_type; ?>" class="updateName form-control" size="10" name="people_name[]" people_id="<?php echo $id;?>" people_num="<?php echo $d['people_num']; ?>" value="<?php echo $d['people_name']; ?>" />
                                                        </div>
                                                    </div>
                                                    <?php echo $arrDetails['blnProcessed'] ? $d['people_name'] : ""; ?>


                                                    <div id="hidden_<?php echo $id;?>" style="display:none;position:absolute;background:white;width:150px;z-index:9999;top:-20px;left:100px;padding:10px;border:1px solid grey;">Please enter a players name</div>
                                                    <input type="hidden" name="people_id[]" value="<?php echo $d['id'];?>" />
                                                </span>
                                            </td>
                                            <td style="position:relative;width:120px;">
                                                <div class="row">
                                                    <div class="form-group col-sm-*">
                                                        <input type="<?php echo $d_type; ?>" class="updateName form-control" size="10" name="people_lname[]" people_id="<?php echo $id;?>" people_num="<?php echo $d['people_num']; ?>" value="<?php echo $d['people_lname']; ?>" />
                                                    </div>
                                                </div>
                                                <?php echo $arrDetails['blnProcessed'] ? $d['people_lname'] : ""; ?>
                                            </td>
                                            <td style="position:relative;width:120px;">
                                                <div class="row">
                                                    <div class="form-group col-sm-*">
                                                        <input type="<?php echo $d_type; ?>" class="updateName form-control" size="10" name="people_email[]" people_id="<?php echo $id;?>" people_num="<?php echo $d['people_num']; ?>" value="<?php echo $d['people_email']; ?>" />
                                                    </div>
                                                </div>
                                                <?php echo $arrDetails['blnProcessed'] ? $d['people_email'] : ""; ?>
                                            </td>
                                            <td><span ><?php echo $d['room_num']; ?></span></td>
                                            <td><span><?php echo $d['nights_num']; ?></span></td>

                                            <td style="text-align:center;">
                                                <span style="position:relative;">
                                                    <?php if ($balance == 0) { ?>
                                                        <a href="/package/itinerary/<?php echo $session_id;?>/<?php echo $id;?>" target="_blank">View Confirmed Itinerary</a>
                                                        <input style="border:1px solid #cccccc;display:none;" type="text" size="5" class="make_payment new_mouse form-control" name="make_payment_val[]" id="make_payment_<?php echo $i;?>" people_id="<?php echo $id;?>" onKeyUp="ForceNumber(this, <?php echo $balance; ?>)" onBlur="UpdateTotal()" placeholder="Enter Amount" />
                                                    <?php } else { ?>
                                                        <input style="border:1px solid #cccccc;" type="text" size="5" class="make_payment new_mouse form-control" name="make_payment_val[]" id="make_payment_<?php echo $i;?>" people_id="<?php echo $id;?>" onKeyUp="ForceNumber(this, <?php echo $balance; ?>)" onBlur="UpdateTotal()" placeholder="Enter Amount" />
                                                    <?php } ?>
                                                    <div id="hidden_price_<?php echo $id;?>" style="display:none;position:absolute;background:white;width:200px;z-index:9999;top:-20px;right:80px;padding:10px;border:1px solid grey;">Enter amount shown to your left &amp; proceed to bottom of this column to pay </div>
                                                </span>
                                            </td>

                                            <td>$<span><?php echo $d['package_price'] . ' ' .$strCurrency; ?></span>
                                                <input type="hidden" name="package_price[]" value="<?php echo $d['package_price']; ?>" />
                                            </td>
                                            <td>$<span><?php echo $d['deposit_price'] . ' ' .$strCurrency; ?></span>
                                                <input type="hidden" name="deposit[]" value="<?php echo $d['deposit_price']; ?>" />
                                            </td>
                                            <td>$<span><?php echo $balance . ' ' .$strCurrency; ?></span></td>
                                            <td><span name="notes_<?php echo $i;?>" id="notes_<?echo $i;?>"><?php echo $d['notes']; ?></span></td>
                                            <!--<td><span><?php //echo Util::formatDate($d['last_payment_date'], true); ?></span></td>-->

                                        </tr>
                                        <?php
                                    }
                                }
                            }
                            ?>
                            <tr>
                                <td colspan="6" align="right"><b>Total amount :</b></td>
                                <td>$<span name="total_p" id="total_p" size="5"><?php echo $total_p . ' ' .$strCurrency;?></span></td>
                                <td>$<span name="total_d" id="total_d" size="5"><?php echo $total_d . ' ' .$strCurrency;?></span></td>
                                <td>$<span name="total_f" id="total_f" size="5"><?php echo $total_f . ' ' .$strCurrency;?></span></td>
                                <td><input type="text" id="make_payment_total" class="form-control" name="make_payment_total" disabled="disabled"/></td>
                            </tr>
<!--
                            <tr>
                                <td colspan="9" align="right">
                                    <?php if(!$arrDetails['blnProcessed']) {?>
                                        Note: Once saved you will not be able to adjust peoples names.<br />
                                        Please ensure the information above is accurate.
                                    <?php } ?>
                                </td>
                                <td>
                                    <?php if($arrDetails['blnProcessed']) {?>
                                        <input type="button" value="Make Payment" id="makepayment" class="btn btn-primary btn-block" name="Payment" />
                                    <?php } else { ?>

                                        <input type="submit" value="Save Details" id="save_details" class="btn btn-primary btn-block" name="Submit" />
                                    <?php } ?>
                                </td>
                            </tr>
-->
                            <tr>
                                <td align="left"><?php if(!$arrDetails['blnProcessed']) {?><input type="submit" value="Save Details" id="save_details" class="btn btn-primary btn-block" name="Submit" /><?php } ?></td>
                                <td colspan="8"><?php if(!$arrDetails['blnProcessed']) {?>This will save the people's information from the form above<?php } ?></td>
                                <td><input type="button" value="Make Payment" id="makepayment2" class="makepayment btn btn-primary btn-block" name="Payment" /></td>
                            </tr>
                            <tr>
                                <td colspan="10" align="center">
                                    <h4>Need Assistance with Name List or Payments?</h4>
                                    <button type="button" name="Submit" class="btn btn-primary btn-lg help-button">Request Help</button>

                                    <div id="dialog" title="Request Help" style="display:none;">

                                        <label for="help_name">Your Name</label><br />
                                        <input type="text" name="help_name" id="help_name" style="form-control;" /><br />

                                        <label for="help_email">Your Email</label><br />
                                        <input type="text" name="help_email" id="help_email" style="form-control;" /><br />

                                        <label for="help_phone">Your Phone</label><br />
                                        <input type="text" name="help_phone" id="help_phone" style="form-control;" /><br />

                                        <label for="help_comment">Comment Or Question</label><br />
                                        <textarea name="help_comment" style="form-control;" rows="5" cols="40" id="help_comment"></textarea><br />

                                        <button type="button" name="Submit" class="btn btn-primary btn-lg help-button-submit">Request Help</button>

                                    </div>


                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <input type="hidden" value="<?echo $session_id;?>" name="session" id="session"  />
                    <input type="hidden" id="make_payment_total_hidden" name="make_payment_total_hidden" size="5" />

                </form>

                <hr>


                <h3>Terms &amp; Conditions</h3>
                <div class="well">
                    <div style="height: 300px; overflow-y:scroll"><?php echo $objPackage->strTerms;?></div>
                </div>

                <hr>

            </div>

            <div class="tab-pane  <?php echo ($strPreselectTab == 'course') ? 'tos' : ''; ?>" id="tos">
                <h3>Terms & Conditions</h3>
                <div class="well">
                    <div><?php echo $objPackage->strTerms;?></div>
                </div>
            </div>

            <div class="tab-pane <?php echo ($strPreselectTab == 'course') ? 'active' : ''; ?>" id="course">

                <h3>Golf Course Info</h3>
                <?php if(!empty($objPackage->arrCourseVouchers)) { ?>

                <div class="row">
                    <form action="/package/<?php echo $session_id;?>/" method="post" role="form" id="send_voucher_to_form">
                        <div class="col-md-4">
                            <label for='send_voucher_to'>Send Voucher Documents to: </label>
                            <input type='text' style='width:250px;' name='send_voucher_to' value='<?php echo isset($_POST['send_voucher_to']) ? $_POST['send_voucher_to'] : ''; ?>' placeholder='Email Address'/>
                            <textarea name="send_voucher_to_note" style='width:250px;margin-top:10px;' placeholder='Optional Message'><?php echo isset($_POST['send_voucher_to_note']) ? $_POST['send_voucher_to_note'] : ''; ?></textarea>
                        </div>
                        <div class="col-md-4">
                            <div style="width: 300px" class="center-block">
                                <div class="g-recaptcha" data-sitekey="<?php echo GOOGLE_RECAPTCHA_V2_SITE_KEY; ?>"></div>
                                <script src="https://www.google.com/recaptcha/api.js" async defer></script>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <input type='submit' name='submit_send_voucher_to' class="btn btn-primary btn-block" value="Send Voucher Documents" />
                        </div>
                    </form>
                </div>

                <div class="col-xs-12">



                    <table class="table text-small table-hover">
                        <thead>
                            <tr>
                                <th>Golf Course</th>
                                <th>Tee Time</th>
                                <th>Golfers</th>
                                <th>Carts</th>
                                <th>Shuttle</th>
                                <th>Range Balls</th>
                                <th>Confirmation Number</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            foreach( $objPackage->arrCourseVouchers As $arrCourse){
                                ?>
                                <tr>
                                    <td>
                                        <a href="/golf-courses/<?php echo $arrCourse["slug"]; ?>/" target="_blank">
                                            <?php
                                            echo $arrCourse['course_name'];
                                            if (!empty($arrCourse['title']) && !empty($arrCourse['short_name'])) {
                                                echo ' ('.$arrCourse['title'].' '.$arrCourse['short_name'].')';
                                            }
                                            ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php

                                        if(strtotime($arrCourse["tee_date"]. ' ' . $arrCourse["tee_time"] . " " . $arrCourse["tee_ap"])){
                                            echo Util::formatDate($arrCourse["tee_date"]. ' ' . $arrCourse["tee_time"] . " " . $arrCourse["tee_ap"], true);
                                        } else {
                                            echo 'Not Set';
                                        }


                                        ?>
                                    </td>
                                    <td><?php echo ucfirst($arrCourse['golfer_num']);?></td>
                                    <td><?php echo ucfirst($arrCourse['carts']);?></td>
                                    <td><?php echo ucfirst($arrCourse['shuttle']);?></td>
                                    <td><?php echo ucfirst($arrCourse['range_ball']);?></td>
                                    <td><?php echo $arrCourse["confirm_num"]; ?></td>
                                </tr>
                                <?
                            }
                            ?>
                        </tbody>
                    </table>
                </div>

                <div class="col-xs-12">
                    <?php
                    // Courses
                    if (!empty($objPackage->arrCourseVouchers)) {
                        foreach ($objPackage->arrCourseVouchers as $arrCourse) {
                            $strTitle = $arrCourse['course_name'];
                            $strImage = Util::createImageSrc($arrCourse['course_image'], 555, 300, 1);
                            ?>
                            <br />
                                <figure class="location-preview">
                                    <?php if (Util::isFile($arrCourse['course_image'])) { ?>
                                    <img class="img-responsive" src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>">
                                    <?php } ?>
                                    <figcaption class="caption"><?php echo $strTitle; ?></figcaption>
                                </figure>

                            <?php
                        }
                    }

                    ?>

                </div>



            <?php } ?>
            </div>





            <div class="tab-pane" id="hotel">
                <?php if(!empty($objPackage->arrHotelVouchers)) { ?>

                    <h3>Hotel Info</h3>


                    <div class="col-xs-12">

                        <table class="table text-small table-hover" >
                            <thead>
                                <tr>
                                    <th>Hotel</th>
                                    <th>Check In</th>
                                    <th>Check Out</th>
                                    <th>Nights</th>
                                    <th>Rooms</th>
                                    <th>Golfers</th>
                                    <th>Non Golfers</th>
                                    <th>Room Style</th>
                                    <th>Confirmation Number</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            foreach($objPackage->arrHotelVouchers As $arrHotel) {
                                ?>
                                <tr>
                                    <td>
                                        <a href="/golf-accommodations/<?php echo $arrHotel["slug"]; ?>/" target="_blank">
                                            <?php
                                            echo $arrHotel['hotel_name'];
                                            if (!empty($arrHotel['title']) && !empty($arrHotel['short_name'])) {
                                                echo ' ('.$arrHotel['title'].' '.$arrHotel['short_name'].')';
                                            }
                                            ?>
                                        </a>
                                    </td>
                                    <td><?php echo Util::formatDate($arrHotel["check_in_date"], false); ?></td>
                                    <td><?php echo Util::formatDate($arrHotel["check_out_date"], false); ?></td>
                                    <td><?php echo $arrHotel["nights"]; ?></td>
                                    <td><?php echo $arrHotel["rooms"]; ?></td>
                                    <td><?php echo $arrHotel["golfers"]; ?></td>
                                    <td><?php echo $arrHotel["non_golfers"]; ?></td>
                                    <td><?php echo $arrHotel["guests_name"]; ?></td>
                                    <td><?php echo $arrHotel["confirm_num"]; ?></td>
                                </tr>
                                <?php
                            }
                            ?>
                            </tbody>
                        </table>

                    </div>
                    <div class="col-xs-12">

                        <?php

                        // Hotels
                        if (!empty($objPackage->arrHotelVouchers)) {
                            foreach ($objPackage->arrHotelVouchers as $arrHotel) {
                                $strTitle = $arrHotel['hotel_name'];
                                $strImage = Util::createImageSrc($arrHotel['hotel_image'], 555, 300, 1);
                                ?>
                                <br />
                                    <figure class="location-preview">
                                        <?php if (Util::isFile($arrHotel['hotel_image'])) { ?>
                                        <img class="img-responsive" src="<?php echo $strImage; ?>" alt="<?php echo $strTitle; ?>">
                                        <?php } ?>
                                        <figcaption class="caption"><?php echo $strTitle; ?></figcaption>
                                    </figure>

                                <?php
                            }
                        }
                        ?>

                    </div>




                <?php } ?>

            </div>

            <?php

            if(!empty($arrDetails['additional_details'])){

            ?>
            <div class="tab-pane" id="additional_details">

                <h3>Trip Itinerary Notes</h3>

                <div class="additional_details">
                    <?php echo $arrDetails['additional_details']; ?>
                </div>

            </div>
            <?php

            } // end of additional details tab

            ?>

            <div class="tab-pane" id="tb_map_directions">
                <h3>Map Directions</h3>

                <div id="gmap" class="gmap"></div>
                <br>

                <form method="POST" role="form" class="map-direction-form clearfix">

                    <div class="row">
                        <div class="col-xs-12 col-sm-5">
                            <div class="form-group">
                                <label for="start_address">Start Address:</label>
                                <input type="text" name="start_address" id="start_address" class="form-control" value="">
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-2">
                            <div class="form-group">
                                <label for="method">Method:</label>
                                <select name="method" id="method" class="form-control" onchange="calcRoute(directionsDisplay);">
                                    <option value="DRIVING">Driving</option>
                                    <option value="WALKING">Walking</option>
                                    <option value="BICYCLING">Bicycling</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-5">
                            <div class="form-group">
                                <label for="end_address">Destination:</label>
                                <select name="eaddr" id="eaddr" class="form-control">
                                    <?php
                                    if (!empty($objPackage->arrCourseVouchers)) {
                                        foreach ($objPackage->arrCourseVouchers as $arrCourse) {
                                            echo '<option value="' . $arrCourse['latitude'] . ' ' . $arrCourse['longitude'] . '">' . $arrCourse['course_name'] . '</option>';
                                        }
                                    }
                                    if (!empty($objPackage->arrHotelVouchers)) {
                                        foreach ($objPackage->arrHotelVouchers as $arrHotel) {
                                            echo '<option value="' . $arrHotel['latitude'] . ' ' . $arrHotel['longitude'] . '">' . $arrHotel['hotel_name'] . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <button type="button" class="btn btn-primary btn-icon-after pull-right" onclick="calcRoute(directionsDisplay);">Get Directions</button>

                </form>

                <hr>

                <div id="directions_panel"></div>

            </div>

            <div class="tab-pane" id="message">


                <?php if (!empty($objPackage->strComments)) { ?>
                <h3>Additional Details</h3>
                <p><?php echo Util::nl2br($objPackage->strComments); ?></p>
                <hr>
                <?php } ?>

                <h3>Message History</h3>
                <?php if (!empty($arrNotes)) { ?>

                <!-- START TITLES for DB Items -->
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th width="60%">Message Threads</th>
                            <th width="20%">From</th>
                            <th width="20%">Time Stamp</th>
                        </tr>
                    </thead>

                    <tbody>
                    <?php
                    foreach($arrNotes As $mrow) {
                        ?>
                        <tr>
                            <td width="60%" align="left" cellspacing="2">
                                <?php echo Util::shortenStringWithExtention(Util::nl2br($mrow['comment']), 100); ?>
                            </td>
                            <td>
                                <?php
                                if ($mrow['direction'] == '1') {
                                    if ($mrow['sales_id'] == '1') {
                                        echo 'Ross Marrington';
                                    }
                                    if ($mrow['sales_id'] == '2') {
                                        echo 'Danny Leitch';
                                    }
                                } else {
                                    echo $mrow['user_name'];
                                }
                                ?>
                            </td>
                            <td><?php echo Util::formatDate($mrow['timestamp'], true); ?></td>
                        </tr>

                    <?php } ?>
                    </tbody>
                </table>

                <?php } else {

                    echo 'No history is recorded.';

                } ?>

                <div class="row">
                    <div class="col-xs-12">

                        <form name="form1" method="post" role="form">
                            <input type="hidden" name="session" id="id" value="<?php echo $session_id; ?>">
                            <input type="hidden" name="package_id" id="package_id" value="<?php echo $objPackage->intId; ?>">

                            <h3>Type New Messages Below</h3>
                            <div class="form-group">
                                <textarea rows="7" name="comment" id="comment" class="form-control"></textarea>
                            </div>
                            <div class="form-group">

                                <input type="submit" value="Send Message" name="Submit" class="btn btn-primary">&nbsp;&nbsp;

                            </div>
                        </form>
                    </div>
                </div>



            </div>

        </div>

        <?php } //end incomplete package check ?>

    </div>

    <?php
    // Generate the javascript for the map
    echo Location::getMapData2(array(
        'hotels' => $objPackage->arrHotelVouchers,
        'courses' => $objPackage->arrCourseVouchers,
        'show_directions' => true,
        'show_directions_id' => 'directions_panel',
        'tab_id' => 'maps_tab',
        'map_id' => 'gmap',
        'latitude' => $objPackage->strLatitude,
        'longitude' => $objPackage->strLongitude,
        'zoom' => $objPackage->strZlevel
    ));
    ?>

    <?php echo $objSettings->getFooterScripts(); ?>

</body>
</html>
