<?php
include('../config.php');

/*
if (isset($_POST['session_package'])) {
    //var_dump($_SESSION['package']);
    //var_dump($_POST['session_package']);
    //var_dump(json_decode($_POST['session_package']));
    //$_SESSION[]
}
*/

$objPartner = $objController->objModel;
$arrDetails =  $objPartner->arrDetails;

// Nav variables
$arrNavSteps = array(
    1 => '1. Choose Your Courses',
    2 => '2. Choose Your Hotels',
    3 => '3. Additional Details',
    4 => '4. Overview',
);
$blnNavPrev  = $objPartner->intStep > 1 ? true : false;
$blnNavNext  = $objPartner->intStep < 5 ? true : false;
$blnReadonly = $objPartner->intStep > 3 ? true : false;

$strNavPrev = 'Prev Step';
$strNavNext = $objPartner->intStep == 4 ? 'Submit Package Request' : 'Next Step';

// Form submission URLs
$strForm = '/' . $objPartner->strBaseUrl . '/' . $objPartner->strIdentUrl . '/';
//$strFormNext = $strForm . ($objPartner->intStep + 1) . '/';
//$strFormPrev = $strForm . ($objPartner->intStep - 1) . '/';

$strSelectedCourses = '';
$arrSelectedCourses = array();
$strSelectedHotels = '';
$arrSelectedHotels = array();

//var_dump($_SESSION['package']);

/*
if (isset($_POST['selected_courses'])) {
    $arrSelectedCourses = $_POST['selected_courses'];
    $strSelectedCourses = json_encode($_POST['selected_courses']);
}
if (isset($_POST['selected_hotels'])) {
    $arrSelectedHotels = $_POST['selected_hotels'];
    $strSelectedHotels = json_encode($_POST['selected_hotels']);
}
*/

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex,nofollow">

    <title>Build your package</title>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="/application/css/style.css">

    <!-- SCRIPTS -->
    <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="/application/js/payment_funcs.js"></script>
    <script src="/application/js/scripts.js?v=685"></script>
    <script src="/application/js/admin/admin.js"></script>

	<?php echo $objSettings->getHeaderScripts(); // Custom analytics or tracking scripts from the settings ?>
</head>
<body>

	<?php include(ROOT_DIR.'/application/includes/header_whitelabel.php'); ?>

    <div class="container-content" style="padding-top: 0;">
		<main class="container">

            <?php if ($objPartner->intStep < 5) { ?>

            <form method="post" id="partner_form" action="<?php echo $strForm; ?>">
                <input type="hidden" id="step" value="<?php echo $objPartner->intStep; ?>">
                <input type="hidden" id="goto_step" value="">
<!--
                <input type="hidden" id="selected_courses" name="selected_courses" value='<?php echo $strSelectedCourses; ?>'>
                <input type="hidden" id="selected_hotels" name="selected_hotels" value="">
            -->

                <input type="hidden" id="session_package" name="session_package" value='<?php echo json_encode($_SESSION['package']);?>' />


                <ul class="list-inline pull-right">
                    <?php if ($blnNavPrev) { ?>
                    <li><button type="submit" class="next_step btn btn-primary partner_step_submit" js-step="<?php echo $objPartner->intStep - 1;?>"><?php echo $strNavPrev; ?></button></li>
                    <?php } ?>
                    <?php if ($blnNavNext) { ?>
                    <li><button type="submit" class="prev_step btn btn-primary partner_step_submit" js-step="<?php echo $objPartner->intStep + 1;?>"><?php echo $strNavNext; ?></button></li>
                    <?php } ?>
                </ul>

                <div class="clearfix"></div>

                <div class="package-builder">
                    <div class="col-sm-3 padding-none">

                        <div class="package-controls">
                            <h2 class="package-controls-title">Package Overview</h2>
                            <div class="form-group">
                                <label>Region</label>
                                <input type="text" class="form-control" readonly value="<?php echo $objPartner->arrRegion['region_name']; ?>">
                            </div>
                            <div class="form-group">
                                <label for="arrival_date">Arrival Date</label>
                                <input type="text" name="arrival_date" id="arrival_date" class="form-control <?php if (!$blnReadonly) echo 'datepicker-future'; ?>" data-min-date="0" autocomplete="off" <?php if ($blnReadonly) echo 'readonly'; ?> value="<?php echo $_SESSION['package']['arrival_date']; ?>">
                            </div>
                            <div class="form-group">
                                <label for="departure_date">Departure Date</label>
                                <input type="text" name="departure_date" id="departure_date" class="form-control <?php if (!$blnReadonly) echo 'datepicker-future'; ?>" data-min-date="0" autocomplete="off" <?php if ($blnReadonly) echo 'readonly'; ?> value="<?php echo $_SESSION['package']['depart_date']; ?>">
                            </div>
                            <div class="form-group">
                                <strong>Selected Courses</strong>
                                <ul id="selected-courses" class="list-unstyled">
                                    <?php

                                    if (!empty($_SESSION['package']['selected_courses'])) {
                                        $objPartner->getCoursesForBuilder($_SESSION['package']['selected_courses']);
                                    }

/*
                                    if (!empty($arrSelectedCourses)) {
                                        $objPartner->getCoursesForBuilder($arrSelectedCourses);
                                    }
                                */
                                    ?>
                                </ul>
                            </div>
                            <div class="form-group">
                                <strong>Selected Hotels</strong>
                                <ul id="selected-hotels" class="list-unstyled">
                                    <?php
                                    if (!empty($_SESSION['package']['selected_hotels'])) {
                                        $objPartner->getHotelsForBuilder($_SESSION['package']['selected_hotels']);
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>

                    </div>
                    <div class="col-sm-9 padding-none">

                        <nav class="package-steps">
                            <?php
                            foreach ($arrNavSteps as $i => $strStep) {
                                // Set the step text
                                $strText = 'Step ' . $i;
                                $strClass = 'partner_step_submit';

                                // Set the step class
                                if ($i == $objPartner->intStep) {
                                    $strClass .= ' active';
                                } else if ($i < $objPartner->intStep) {
                                    $strClass .= ' prev';
                                } else {
                                    $strClass .= '';
                                }

                                if ($objPartner->intStep >= $i) {
                                    $strLink = $strForm . $i . '/';
                                    //echo '<a href="' . $strLink . '" class="' . $strClass . '">' . $strText . '</a>';
                                } else {
                                    //echo '<button type="submit" class="' . $strClass . '">' . $strText . '</button>';
                                }

                                echo '<button type="submit" class="' . $strClass . '" js-step="'.$i.'">' . $strText . '</button>';
                            }
                            ?>
                        </nav>

                        <?php include(ROOT_DIR.'/application/views/_partner_step_'.$objPartner->intStep.'.php'); ?>

                    </div>
                </div>
            </form>

            <?php } else { ?>

            <div class="well">
                <?php echo Util::nl2br(str_replace("[client_name]", $objPartner->strUserName, $objPartner->strInquiryText)); ?>
            </div>

            <?php } ?>

        </main>
    </div>

    <?php echo $objSettings->getFooterScripts(); ?>

</body>
</html>
