<?php


include('../config.php');
include(ROOT_DIR.'/application/models/admin/package.php');
include(ROOT_DIR.'/application/models/admin/brand.php');
include(ROOT_DIR.'/application/models/admin/package_hotel.php');
include(ROOT_DIR.'/application/models/admin/package_golf.php');
include(ROOT_DIR.'/application/models/admin/member.php');

$objPackage = new Package;
$objMember = new Member;
$objPackageHotel = new Packagehotels;
$objPackageCourse = new Packagecourses;
$objBrand = new Brand;

$session_id = isset($_REQUEST['session']) ? $_REQUEST['session'] : '';
$hotel_detail_id = isset($_REQUEST['user']) ? $_REQUEST['user'] : '';

//$arrDetails = $objPackage->getDetail('',$session_id);
//$url = ROOT_URL.'/package/'.$session_id.'/';
//$intTotal = isset($_POST['make_payment_total_hidden']) ? $_REQUEST['make_payment_total_hidden'] : '0';

$strErrorMessage = '';
$strSuccessMessage = '';

$arrPackageDetails = $objPackage->getDetail('',$session_id);
$arrBrandDetails = $objBrand->getByID($arrPackageDetails['brandID']);
$arrHotelDetails = $objPackageHotel->getHotelsByPackage($arrPackageDetails['id']);
$arrHotelLineDetail = $objPackageHotel->getHotelDetailLine($hotel_detail_id);
$arrCourseDetails = $objPackageCourse->getCoursesByPackage($arrPackageDetails['id']);


//var_dump($arrPackageDetails);
//var_dump($arrHotelDetails);
//var_dump($arrCourseDetails);
//var_dump($arrHotelLineDetail);
//var_dump($arrBrandDetails);

$strCurrency = $arrPackageDetails['currency'];
$strTitle = 'Confirmed Itinerary For ' . $arrHotelLineDetail['people_name'] . ' ' . $arrHotelLineDetail['people_lname'];

//die();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex,nofollow">

    <title><?php echo $strTitle; ?></title>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="/application/css/style.css">

    <!-- SCRIPTS -->
    <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="//maps.googleapis.com/maps/api/js?key=AIzaSyCAEI0_8xMbaP_3Z7MBgAisGPqPZA2MeZ4"></script>
    <script src="//www.google.com/jsapi"></script>
    <script src="/application/js/map_funcs.js"></script>
    <script src="/application/js/payment_funcs.js"></script>
    <script src="/application/js/scripts.js"></script>
    <script src="/application/js/admin/admin.js"></script>

    <?php echo $objSettings->getHeaderScripts(); // Custom analytics or tracking scripts from the settings ?>
</head>
<body>

    <?php //include(ROOT_DIR.'/application/includes/header_whitelabel.php'); ?>

    <div class="container">

        <div class="row">
            <div class="pull-left">
                <img src="<?php echo $arrBrandDetails['display_image']; ?>" />
            </div>
            <div class="pull-right">
                <p>
                <?php

                    echo $arrBrandDetails['business_name'] . "<br />";
                    echo $arrBrandDetails['tollfree'] . "<br />";
                    echo "<a href='mailto:".$arrBrandDetails['contact_email']."' target='_blank'>" . $arrBrandDetails['contact_email'] . "</a><br />";
                    echo "<a href='http://".$arrBrandDetails['web_url']."' target='_blank'>" . $arrBrandDetails['web_url'] . "</a><br />";

                ?>
                </p>
            </div>
        </div>

        <h1><?php echo $strTitle; ?></h1>

        <div class="well">

            <?php

            echo '<b>Group Name: </b>' . $arrPackageDetails['group_name'] . '<br />';
            echo '<b>Primary Contact Name: </b>' . $arrPackageDetails['user_name'] . '<br />';
            echo '<b>Contact Name: </b>' . $arrHotelLineDetail['people_name'] . ' ' . $arrHotelLineDetail['people_lname'] . '<br />';
            echo '<b>Amount Paid:</b> $' . $arrHotelLineDetail['package_price'] . ' ' . $strCurrency . '<br />';
            echo '<b>Date Paid:</b> ' . $arrHotelLineDetail['last_payment_date'];

            ?>

        </div>

        <?php if (count($arrHotelDetails) > 0) { ?>

            <!-- <h3>Hotel Itinerary</h3> -->
            <table class="table text-small">
                <thead>
                    <tr>
                        <th>Hotel Name</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                    </tr>
                </thead>
                <tbody>

                    <?php

                    foreach ($arrHotelDetails as $arrHotelDetail) {
                        echo "<tr>
                                <td>" . $arrHotelDetail['hotel_name'] . "</td>
                                <td>" . $arrHotelDetail['check_in_date'] . "</td>
                                <td>" . $arrHotelDetail['check_out_date'] . "</td>
                              </tr>";
                    }

                    ?>

                </tbody>
            </table>

        <?php } ?>

        <?php if (count($arrCourseDetails) > 0) { ?>

            <!-- <h3>Golf Itinerary</h3> -->
            <table class="table text-small">
                <thead>
                    <tr>
                        <th>Course Name</th>
                        <th>Date</th>
                        <th>Tee Time</th>
                    </tr>
                </thead>
                <tbody>

                    <?php

                    foreach ($arrCourseDetails as $arrCourseDetail) {
                        echo "<tr>
                                <td>" . $arrCourseDetail['course_name'] . "</td>
                                <td>" . $arrCourseDetail['tee_date'] . "</td>
                                <td>" . $arrCourseDetail['tee_time'] . ' ' . $arrCourseDetail['tee_ap'] . "</td>
                              </tr>";
                    }

                    ?>

                </tbody>
            </table>

        <?php } ?>

    </div>

    <?php echo $objSettings->getFooterScripts(); ?>

</body>
</html>
