<?php 
header('Content-Type: application/json');

$arrReturn = array(
	'error' => false,
	'message' => null,
	'count' => null,
	'packages' => array()
);

if(!isset($_REQUEST['call']) || empty($_REQUEST['call'])){
	// no call is passed in
	$arrReturn['error'] = true;
	$arrReturn['message'] = 'No call specified.';

	echo json_encode($arrReturn);
	die();
}


switch(strtolower($_REQUEST['call'])){
	case 'featured-packages':
		getFeaturedPackages();
		break;

	default:
		// no call not found
		$arrReturn['error'] = true;
		$arrReturn['message'] = 'Call not found.';

		echo json_encode($arrReturn);
		die();
		break;
}


function getFeaturedPackages(){
	$arrReturn = array(
		'error' => false,
		'message' => null,
		'count' => null,
		'packages' => array()
	);

	include('../config.php');

	$intLimit = 10;
	if(isset($_REQUEST['limit']) && !empty($_REQUEST['limit'])){
		// override default
		$intLimit = (int)$_REQUEST['limit'];
	}

	$intRegion = 2;
	if(isset($_REQUEST['region']) && !empty($_REQUEST['region'])){
		// override default
		$intRegion = $_REQUEST['region'];
	}

	$intCountry = null;

	// get featured packages from selected region
	$objPage = new Page('api');

	$arrFeaturedPackages = $objPage->getPackageList($intLimit, 1, 'start_date','DESC','', 'Active', $intRegion, '', false);

	$arrReturn['count'] = count($arrFeaturedPackages);
	$arrReturn['packages'] = $arrFeaturedPackages;
	$arrReturn['message'] = 'Packages retrieved successfully.';

	echo json_encode($arrReturn);
	die();

}