<?php


class Transaction extends Database  {

	public $strQuery;
	public $intID;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $records;


	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'paypal';
		$this->intPageCount = 0;

	} 

	

	public function insertTransaction($txid, $member_id, $amount, $fee, $receiptId,
		$transaction_date, $package_id, $group_name, $user_name, $user_email, $currency = "CAD") {


		$gross = $amount - $fee;

		$keys = array('transaction_id','member_id','amount','transaction_date','package_id','group_name','user_name','user_email','fee','receipt_id','gross','currency');
		$vals = array( $txid, $member_id, $amount, $transaction_date, $package_id, $group_name, $user_name, $user_email,$fee,$receiptId,$gross, $currency);

		//echo "vals:";

		//var_dump($vals);

		//echo "val=". implode(',',$vals) . " <br />";
		//echo "keys=". implode(',',$keys) . " <br />";
		//echo "<br />-------------------------------<br /><br /><br /><br />";

		$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
		$this->intID = $this->insert_id;
		return 'Record Added:'.$this->intID;

	}


	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false, $arrCondition = null) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    
	    //if($status != 'all') {
	   	 	//$this->strQuery1 .= "AND status='$status' ";
	    //}

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.group_name like '%$searchWord%' OR package_id='$searchWord')";
	    }

	    if(!empty($arrCondition)){
			// conditions where passed in
			if(!is_array($arrCondition)){
				$arrCondition = array($arrCondition);
			}

			foreach($arrCondition as $strCondition){
				$this->strQuery1 .= ' AND ' . $strCondition;
			}

	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.`first_name`, m.`last_name`  
	     FROM $this->strTableName t 
	     LEFT JOIN members m on m.`id`=t.`member_id` 
	     WHERE t.id>0 ";

	    // if($status != 'all') {
	   	 	//$this->strQuery .= "AND t.status='$status' ";
	     //}

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.group_name like '%$searchWord%' OR package_id='$searchWord' )";
		 }

		if(!empty($arrCondition)){
			// conditions where passed in
			if(!is_array($arrCondition)){
				$arrCondition = array($arrCondition);
			}

			foreach($arrCondition as $strCondition){
				$this->strQuery .= ' AND ' . $strCondition;
			}

	    }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}
}
?>