<?php


class Review extends Database  {

	public $strQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strContent;
	public $strMetaKeywords;
	public $strMetaTitle;
	public $strMetaDescription;
	public $strMetaRobots;
	public $strSearchWord;

	public $strView;
	public $strLastName;
	public $strFirstName;
	public $strEmail;
	public $strReview;
	public $intCourseId;
	public $strPlayedDate;
	public $strCountry;
	public $strState;
	public $strCity;
	public $strFacebookTitle;
	public $strOGImage;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'course_reviews';
		$this->strTableSlug = 'course_reviews';

		$this->strView = 'add_review';

	}



	public function processForm($debug = false) { 

		$this->strLastName = isset($_POST['last_name']) ? $_POST['last_name'] : '';
		$this->strFirstName = isset($_POST['first_name']) ? $_POST['first_name'] : '';
		$this->strEmail = isset($_POST['user_email']) ? $_POST['user_email'] : '';
		$this->strReview = isset($_POST['review']) ? $_POST['review'] : '';
		$this->strPlayedDate = isset($_POST['played_date']) ? $_POST['played_date'] : '';
		$this->strCountry = isset($_POST['country']) ? $_POST['country'] : '';
		$this->strState = isset($_POST['state']) ? $_POST['state'] : '';
		$this->strCity = isset($_POST['city']) ? $_POST['city'] : '';

		$this->intCourseId = $this->arrResult[0]['id'];

		if($this->strLastName == '') { $this->strErrorMessage .= "Please enter a last name.<br />"; }
		if($this->strFirstName == '') { $this->strErrorMessage .= "Please enter a first name.<br />"; }
		if($this->strEmail == '') { $this->strErrorMessage .= "Please enter a email.<br />"; }
		if($this->strReview == '') { $this->strErrorMessage .= "Please enter a review.<br />"; }
		if($this->strPlayedDate == '') { $this->strErrorMessage .= "Please enter a played date.<br />"; }


		if($this->strErrorMessage == '') {

			$keys = array('first_name','last_name','user_email','detail',
				'course_id','approved','post_date','played_date','country','state','city');
			$vals = array( $this->strFirstName,$this->strLastName,$this->strEmail,$this->strReview,
				$this->intCourseId,'0',Date('Y-m-d'),$this->strPlayedDate,$this->strCountry,$this->strState,$this->strCity);
			//$types = array('ss');

			//if($this->intID == '') {

				//no ability to add categories is required.
            //REVIEWS DISABLED
				//$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				//$this->intID = $this->insert_id;
				//$this->strSuccessMessage = 'Record Added:'.$this->intID;

			//} else {

				//$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				//$this->strSuccessMessage = 'Record Saved';

			//}



			$this->strSuccessMessage = "Thank you, your review has been submitted for approval.";
		}



		

	}


	public function getDetails($slug, $debug = false) {

		$this->strQuery = "SELECT id, course_name, display_image FROM course WHERE `slug` = '".$slug."' LIMIT 0,1";

		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		$this->arrResult = $this->getMysqliResults($this->strQuery, true);
		if (!empty($this->arrResult)) {
			return $this->arrResult[0];
		} else {
			return false;
		}
	}



	public function getAds($debug = false) {
		$this->strQuery = "SELECT * FROM ads WHERE `status` = 'Active' ORDER BY rand() LIMIT 0,2";


		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		$result = $this->getMysqliResults($this->strQuery, true);
		if (!empty($result)) {
			return $result;
		} else {
			return false;
		}
	}


}



?>