<?php


class Region extends Database  {

	public $strQuery;
	public $strVideoQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;


	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'region';
		$this->intPageCount = 0;

	}

	public function getRegionId($slug) {

		$this->strQuery = "SELECT r.id FROM $this->strTableName r WHERE slug='$slug'";

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
	     	return $result[0]['id'];
	    } else {
	     	return null;
	    }

	}


	public function getRegionDetail($slug = '',$id = '',$debug = false) {

		$this->strQuery = "SELECT r.* , c.id As country_id, s.id As state_id,
		s.state_name, c.country_name, r.latitude As rlat, r.longitude As rlong, r.zlevel AS rzlevel
		From $this->strTableName r
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id ";

		if($slug != ''){
			$this->strQuery .= "WHERE r.slug='".$slug."'";
		} else {
			$this->strQuery .= "WHERE r.id=".$id;
		}



		$this->strQuery .= " LIMIT 0,1";

		if($debug) {
			Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			if($result = $this->getMysqliResults($this->strQuery,true)) {
				$result = $result[0];

				//set the SEO details at the same time
				$this->strMetaTitle = $result['meta_title'] != '' ? $result['meta_title'] : $result['region_name'] . ' ' . $result['state_name'];
		        $this->strTitle = $this->strMetaTitle;
		        $this->strMetaKeywords = $result['meta_keywords'];
		        $this->strMetaDescription = $result['meta_description'] != '' ? $result['meta_description'] : Util::shortenString($result['text1'], 30);
		        $this->strMetaRobots = $result['meta_robots'];
		        $this->strOGImage = '';
		        $this->strFacebookTitle = $result['facebook_title'];
		        $this->strFacebookDescription = $result['facebook_description'];
		        $this->strFacebookImage = $result['facebook_image'];
		        $this->strTwitterTitle = $result['twitter_title'];
		        $this->strTwitterDescription = $result['twitter_description'];
		        $this->strTwitterImage = $result['twitter_image'];
		        $this->strGoogleDescription = $result['google_description'];
		        return $result;
		    } else {

		    	return null;

		    }



	    } else {
	     	return null;
	    }
	}

	public function getRegionImageList($region_id) {


		$strQuery = "SELECT *
		FROM region_img where region_id=$region_id AND status = 'Active' ORDER BY blnPrimary DESC, display_order ASC";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

}
?>