<?php


class Quotegroups extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;

	public $strGroupName;
	public $intGroupId;
	public $intQuoteId;


	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'quote_group';
		$this->strTableSlug = 'quote_group';
		$this->strAdminSlug = '/admin/quote/';

		$this->strTitle = 'Quote Groups';


	}

	public function getGroupName($debug = false){
		$this->strQuery = 'SELECT group_name FROM `groups` WHERE id = '. $this->group_id;

		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$strGroupName = $res[0]['group_name'];
	     	if(file_exists(ROOT_DIR.$strGroupName)) {
	     		unlink(ROOT_DIR.$strGroupName);
	     		Util::debugDisplay('delete='.ROOT_DIR.$strGroupName);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$strGroupName='.ROOT_DIR.$strGroupName);
		}

		return $strGroupName;
	}

	public static function insertQuoteGroup($intQuoteId, $intGroupId = null){
		if(empty($intQuoteId)){
			return false;
		}

		if(empty($intGroupId)){
			// create a new group
			$intGroupId = Group::createGroup();
		}

		// create new instance of this model to do operations too
		$objModel = new static;

		// insert new db record
		$arrKeys = array('group_id', 'quote_id');
		$arrValues = array($intGroupId, $intQuoteId);

		$objModel->strQuery = 'INSERT INTO ' . $objModel->strTableName . ' (' . implode(',', $arrKeys) . ') VALUES (' . implode(',', $arrValues) . ') ';

		if($objModel->short_query($objModel->strQuery)) {
			$objModel->strSuccessMessage = 'Record Created';
		} else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		// return group id that was just created
		return true;

	}

	public static function getLastQuoteByGroup($intGroupId, $blnDebug = false){
		if(empty($intGroupId)){
			return false;
		}

		// create new instance of this model to do operations too
		$objModel = new static;

		$objModel->strQuery = 'SELECT quote_id FROM ' . $objModel->strTableName . ' WHERE group_id = '. $intGroupId . ' ORDER BY quote_id DESC';

		$intQueryId = null;
		if($objModel->query($objModel->strQuery)) {
	     	$arrResults = $objModel->getMysqliResults($objModel->strQuery,true);
	     	$intQueryId = $arrResults[0]['quote_id'];
	    }

	    if($blnDebug) {
	    	Util::debugDisplay($objModel->strQuery);
		}

		return $intQueryId;
	}

	public static function getQuotesByGroup($intGroupId, $blnDebug = false){
		if(empty($intGroupId)){
			return false;
		}

		// create new instance of this model to do operations too
		$objModel = new static;

		$objModel->strQuery = 'SELECT q.*
								 FROM quotes q
								 JOIN quote_group qg
								   ON q.id = qg.quote_id
								WHERE qg.group_id = ' . $intGroupId . '
								ORDER BY q.date_created DESC, q.id DESC';

		$intQueryId = null;
		if($objModel->query($objModel->strQuery)) {
	     	$arrResults = $objModel->getMysqliResults($objModel->strQuery,true);
	    }

	    if($blnDebug) {
	    	Util::debugDisplay($objModel->strQuery);
		}

		return $arrResults;
	}

	public static function getGroupNameById($intGroupId, $blnDebug = false){
		$objQuoteGroup = new static;
		$objQuoteGroup->group_id = $intGroupId;

		return $objQuoteGroup->getGroupName($blnDebug);
	}
}



?>