<?php

class Quote extends Database {

	public $intId;
	public $intBrandId;
	public $intRegionId;
	public $intSessionId;
	public $intFeaturedId;
	public $intGroupID;
	public $strTitle;
	public $strContent;
	public $intStep;
	public $strUserName;
	public $strUserEmail;
	public $strUserPhone;
	public $intCountryId = 261;
	public $intStateId = 2;
	public $intCityId = 6345;
	public $strCountryName = "CA";
	public $strStateName = "BC";
	public $strCityName = "Kelowna";
	public $strAddress;
	public $strPostalCode ;
	public $strCell;
	public $strFax;
	public $blnDateFlex = "no";
	public $intPlayersNum = 2;
	public $intRoundsNum = 1;
	public $intCouplesNum  = 0;
	public $intNgNum  = 0;
	public $strDatesArrival;
	public $strDatesDepart;
	public $blnSmoking = 0;
	public $blnBedshare1  = 'no';
	public $blnBedshare2  = 'no';
	public $blnShuttle  = 0;
	public $strOrigin;
	public $strDomain;
	public $strTeeTimes = 'anytime';
	public $arrSelectedCourses;
	public $arrSelectedHotels;
	public $csvSelectedCourses;
	public $csvSelectedHotels;
	public $strBaseUrl;
	public $strIdentUrl;
	public $strDisplayImage;

	public $arrSelectedBookingPeople;
	public $arrSelectedBookingPeoplePrimary;
	public $arrSelectedBookingPeopleBcc;

	public $arrBookingAgent;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strSuccessMessage  = "";
		$this->strTableName = 'quotes';
		$this->strTableSlug = 'quotes';
		$this->intPageCount = 0;
		$this->strView = 'quote_engine';

		$this->strbrandSlug = isset($_GET['brandID']) ? $_GET['brandID'] : '';
		$this->intFeaturedId = isset($_GET['featuredID']) ? $_GET['featuredID'] : '';
		$this->arrDetails = $this->getDetail($this->strbrandSlug);
		$this->intStep = isset($_GET['step']) ? $_GET['step'] : 1;

	}

	public function getAgentDetail($id = '', $session = '') {

		$arrBookingAgent = array();

		if ($session != '') {
			$strSql = "SELECT id FROM quotes WHERE session_id = '$session'";

			$arrResults = $this->getMysqliResults($strSql,true);

			if (count($arrResults) == 1) {
				$id = $arrResults[0]['id'];
			}

		}

		if($id != '') {

			$strSql = "SELECT booking_people_id FROM quote_booking_people WHERE primary_contact = 1 and quote_id = $id";

			$arrResults = $this->getMysqliResults($strSql,true);

			if (count($arrResults) == 1) {

				$intPrimaryBookingPersonId = $arrResults[0]['booking_people_id'];
				$strSql = "SELECT * FROM booking_people WHERE id = $intPrimaryBookingPersonId";

				$arrResults = $this->getMysqliResults($strSql,true);

				if (count($arrResults) == 1) {
					$arrBookingAgent = $arrResults[0];
				}
			}
		}

		return $arrBookingAgent;

	}

	public function getDetail($id = '', $session = '') {
		if($id != '' || $session != ''){
			//page specific SEO settings. These may override the default settings.
			$this->strQuery = "SELECT  r.latitude, r.longitude, r.zlevel, p.*, b2.booking_email,
			(SELECT check_in_date FROM quote_hotel WHERE quote_id=p.`id` AND `default`=1) As check_in_date,
			b.address As business_address,
			b.phone As business_phone,
			b.business_name,
			b.tollfree As business_tollfree,
			b.zip As business_zip,
			b.fax As business_fax,
			b.display_image As business_logo,
			c.title As business_city,
			b.contact_email As business_email,
			b.terms As business_terms,
			b.mini_quote_page_text As business_text,
			s.state_name As business_state,
			b.background_color,
			b.text_color,
			s2.status_name,
			s2.color AS status_color,
			m.id AS userID,
			g.group_name AS group_name,
			g.id AS groupID
			From $this->strTableName p
			LEFT JOIN quote_group qg ON qg.quote_id = p.id
	     	LEFT JOIN `groups` g ON g.id = qg.group_id
			Left Join region r on r.id=p.region_id
			LEFT join members m on m.email=p.user_email
			LEFT join order_status s2 on s2.id=p.completed
			LEFT join brands b on b.id=p.brandID
			LEFT join booking_people b2 on b2.id=p.bookingID
			LEFT join city c on c.id=b.city_id
			LEFT join state s on s.id=c.state_id ";

			if($id != ''){
				$this->strQuery .= "WHERE p.id=$id ";
			}

			if($session != ''){
				$this->strQuery .= "WHERE p.session_id='$session' ";
			}




			$this->strQuery .= "LIMIT 0,1 ";

			// echo Util::debugDisplay($this->strQuery);


			if($this->query($this->strQuery)) {

		     	if($result = $this->getMysqliResults($this->strQuery,true)) {
			     	$result = $result[0];

			     	$this->strGroupName = isset($result['group_name']) ? $result['group_name'] : '';
			     	$this->strUserName = isset($result['user_name']) ? $result['user_name'] : '';
			     	$this->strUserEmail = isset($result['user_email']) ? $result['user_email'] : '';
			     	$this->intBrandId = isset($result['brandID']) ? $result['brandID'] : '';
					$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
					$this->strFax = isset($result['fax']) ? $result['fax'] : '';
					$this->strCellPhone = isset($result['cell_phone']) ? $result['cell_phone'] : '';
					$this->strEmergency = isset($result['emergency']) ? $result['emergency'] : '';
					$this->strAdminNote = isset($result['admin_note']) ? $result['admin_note'] : '';
					$this->strAddress = isset($result['address']) ? $result['address'] : '';
					$this->intCityId = isset($result['city']) ? $result['city'] : '';
					$this->intCountryId = isset($result['country']) ? $result['country'] : '';
					$this->intStateId = isset($result['state']) ? $result['state'] : '';
					$this->strZip = isset($result['zip']) ? $result['zip'] : '';
					$this->strDatesArrival = isset($result['dates_arrival']) ? $result['dates_arrival'] : '';
					$this->strDatesDepart = isset($result['dates_depart']) ? $result['dates_depart'] : '';
					$this->strComments = isset($result['comments']) ? $result['comments'] : '';
					$this->strCompleted = isset($result['completed']) ? $result['completed'] : '';
					$this->strSmoking = isset($result['smoking']) ? $result['smoking'] : '';
					$this->strBedshare1 = isset($result['bedshare1']) ? $result['bedshare1'] : '';
					$this->strBedshare2 = isset($result['bedshare1']) ? $result['bedshare2'] : '';
					$this->strCarts = isset($result['carts']) ? $result['carts'] : '';
					$this->strShuttle = isset($result['shuttle']) ? $result['shuttle'] : '';
					$this->intCouplesNum = isset($result['couples_num']) ? $result['couples_num'] : '';
					$this->intPlayersNum = isset($result['players_num']) ? $result['players_num'] : '';
					$this->intNgNum = isset($result['ng_num']) ? $result['ng_num'] : '';
					$this->arrGolfCourses = isset($result['golfcourses']) ? $result['golfcourses'] : '';
					$this->arrAccommodations = isset($result['accommodations']) ? $result['accommodations'] : '';
					$this->intRepeat = isset($result['blnRepeat']) ? $result['blnRepeat'] : '';
					$this->strNote = isset($result['note']) ? $result['note'] : '';
					$this->strMiniContent = isset($result['mini_content']) ? $result['mini_content'] : '';
					$this->md5Session = isset($result['session_id']) ? $result['session_id'] : '';
					$this->strVoucherText1 = isset($result['voucher_text_1']) ? $result['voucher_text_1'] : '';
					$this->strVoucherText2 = isset($result['voucher_text_2']) ? $result['voucher_text_2'] : '';
					$this->strVoucherText3 = isset($result['voucher_text_3']) ? $result['voucher_text_3'] : '';
					$this->strVoucherText4 = isset($result['voucher_text_4']) ? $result['voucher_text_4'] : '';
					$this->strVoucherText5 = isset($result['voucher_text_5']) ? $result['voucher_text_5'] : '';
					$this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
					$this->strBrandLogo = isset($result['business_logo']) ? $result['business_logo'] : '';
					$this->strBusinessTollFree = isset($result['business_tollfree']) ? $result['business_tollfree'] : '';
					$this->strBusinessCity = isset($result['business_city']) ? $result['business_city'] : '';
					$this->strBusinessPhone = isset($result['business_phone']) ? $result['business_phone'] : '';
					$this->strBusinessAddress = isset($result['business_address']) ? $result['business_address'] : '';
					$this->strBusinessProv  = isset($result['business_state']) ? $result['business_state'] : '';
					$this->strBusinessFax    = isset($result['business_fax']) ? $result['business_fax'] : '';
					$this->strBusinessZip    = isset($result['business_zip']) ? $result['business_zip'] : '';
					$this->strBusinessEmail    = isset($result['business_email']) ? $result['business_email'] : '';
					$this->strTerms = isset($result['business_terms']) ? $result['business_terms'] : '';
					$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
					$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
					$this->strZlevel = isset($result['zlevel']) ? $result['zlevel'] : '';
					$this->intBookingId = isset($result['bookingID']) ? $result['bookingID'] : '';
					$this->strBookingEmail = isset($result['booking_email']) ? $result['booking_email'] : '';
					$this->blnNotify = isset($result['blnNotify']) ? $result['blnNotify'] : 0;
					$this->blnProcessed = isset($result['blnProcessed']) ? $result['blnProcessed'] : 0;
					$this->strDatesBooking = isset($result['dates_booking']) ? $result['dates_booking'] : '';
					$this->intPrice = isset($result['price']) ? $result['price'] : '';
					$this->intTotalPeople = isset($result['total_people']) ? $result['total_people'] : 0;
					$this->intTotalRooms = isset($result['total_rooms']) ? $result['total_rooms'] : 0;
					$this->intTotalRounds = isset($result['total_rounds']) ? $result['total_rounds'] : 0;
			     	$this->intId = $result['id'];
			     	$this->intGroupID = $result['groupID'];
			     	$this->strCurrency = isset($result['currency']) ? $result['currency'] : 'CAD';

			     	$this->arrBookingAgent = $this->getAgentDetail($id, $session);

					$this->strQuery = "SELECT
											pg.id AS pgid,
											pg.course_id,
											grp.group_name,
											p.user_name,
											g.*,
											c.title,
											s.short_name,
											pg.course_id,
											pg.tee_date,
											pg.tee_time,
											pg.tee_day,
											pg.tee_ap,
											pg.carts,
											pg.range_ball,
											pg.shuttle,
											pg.rental_club,
											pg.confirm_num,
											pg.golfer_num,
											pg.notes,
											pg.public_notes,
											coalesce((SELECT file_name FROM course_img WHERE course_id=pg.course_id AND blnPrimary=1),display_image) As course_image
										FROM
											quote_golf pg
											LEFT JOIN quotes p On pg.quote_id=p.id
											LEFT JOIN course g On  pg.course_id=g.id
											LEFT JOIN  city c On g.city_id=c.id
											LEFT JOIN  state s On c.state_id=s.id
											LEFT JOIN quote_group qg ON pg.id = qg.quote_id
											LEFT JOIN `groups` grp ON qg.group_id = grp.id
										WHERE
											pg.quote_id=".$this->intId."
											order by pg.tee_date asc";

					// echo Util::debugDisplay($this->strQuery);

					$this->arrCourseVouchers = Null;

					if($this->query($this->strQuery)) {
			     		$result2 = $this->getMysqliResults($this->strQuery,true);
			     		if(count($result2) > 0) {

			     			// Add another value called id since we renamed the original id
			     			foreach ($result2 as &$arrValue) {
			     				$arrValue['id'] = $arrValue['pgid'];
			     			}

			     			$this->arrCourseVouchers = $result2;
			     		}
			     	}

			     	$this->strQuery = "SELECT
			     							ph.id As phid,
			     							ph.hotel_id,
			     							grp.group_name,
			     							p.user_name,
			     							h.*,
			     							c.title,
			     							s.short_name,
			     							ph.hotel_id,
			     							ph.check_in_date,
			     							ph.check_out_date,
			     							ph.confirm_num,
			     							ph.nights,
			     							ph.notes,
			     							ph.public_notes,
			     							coalesce((SELECT file_name FROM hotel_img WHERE hotel_id=ph.hotel_id AND blnPrimary=1),file_name) As hotel_image,
			     							ph.golfers,
			     							ph.non_golfers,
			     							ph.rooms,
			     							ph.guests_name,
			     							ph.`default`
			     						FROM
			     							quote_hotel ph
									     	LEFT JOIN quotes p ON ph.quote_id=p.id
											LEFT JOIN hotel h ON  ph.hotel_id=h.id
											LEFT JOIN city c ON h.city_id=c.id
											LEFT JOIN state s ON c.state_id=s.id
											LEFT JOIN quote_group qg ON p.id = qg.quote_id
											LEFT JOIN `groups` grp ON qg.group_id = grp.id
			     						WHERE
			     							ph.quote_id='".$this->intId."'
			     						ORDER BY ph.check_in_date asc";

			     	// echo Util::debugDisplay($this->strQuery);

			     	$this->arrHotelVouchers = Null;

					if($this->query($this->strQuery)) {
			     		$result2 = $this->getMysqliResults($this->strQuery,true);
			     		if(count($result2) > 0) {
			     			$this->arrHotelVouchers = $result2;
			     		}
			     	}

			     	$result['booking_agent'] = $this->arrBookingAgent;

			     	return $result;

		    	}

		    }

			return null;


		}

	}

	public function getEmailsForQuoteHotel($rel_id) {

		$this->strQuery = "SELECT b.contact_email, b.business_name, b.contact_email2,
		h2.frontdesk_email As hotel_email, b.mini_hotel_text, p.phone, p.cell_phone,
		p.user_name, h.check_in_date, h.check_out_date, h.nights, h.rooms, h.confirm_num, h.quote_id
		From quote_hotel h
		LEFT JOIN quotes p on p.id=h.quote_id
		LEFT join brands b on b.id=p.brandID
		LEFT JOIN hotel h2 on h2.id=h.hotel_id
		WHERE h.id=$rel_id
		LIMIT 0,1";

		//echo '<br />'.$this->strQuery;

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);

	     	//var_dump($result);
	     	//$result = $result[0];
	     	return $result[0];

	    } else {
	     	return null;
	    }
	}

	public function getQuoteHotelDetail($quote_hotel_id, $debug = false) {


		$this->strQuery ="SELECT *
			FROM quote_hotel_detail
			where quote_hotel_id='$quote_hotel_id'
			order by CHAR_LENGTH(room_num) ASC, room_num asc, people_num ASC";

		if($debug){

			Util::debugDisplay($this->strQuery);
		}


		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result;

		}

	}

	public static function getGroupName($intQuoteId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT g.group_name FROM `groups` g JOIN quote_group qg ON g.id = qg.group_id WHERE qg.quote_id = ' . $intQuoteId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults[0]['group_name'];
	}

	public static function getGroupId($intQuoteId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT g.id FROM `groups` g JOIN quote_group qg ON g.id = qg.group_id WHERE qg.quote_id = ' . $intQuoteId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults[0]['id'];
	}

	public static function getGroupById($intQuoteId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT g.* FROM `groups` g JOIN quote_group qg ON g.id = qg.group_id WHERE qg.quote_id = ' . $intQuoteId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrResults)){
			return null;
		}

		return $arrResults[0];
	}


	public function getNotesForQuote($quote_id) {
		// look up group id by quote
		$group_id = static::getGroupById($quote_id);

		return $this->getNotesForQuoteGroup($group_id['id']);
	}

	public function getNotesForQuoteGroup($group_id) {
		$this->strQuery = "
			SELECT qmn.*, sb.contact_person, sb.user_name
			FROM quote_mini_notes qmn
			LEFT JOIN (
				SELECT b.contact_person, q.user_name, qg.group_id
				FROM quote_group qg
				LEFT JOIN quotes q
					ON q.id = qg.quote_id
				LEFT JOIN brands b
					ON b.id = q.brandid
				WHERE qg.group_id = " . $group_id . "
				ORDER BY qg.quote_id DESC
				LIMIT 1
			) sb
				ON 1=1
			WHERE qmn.group_id = sb.group_id";

		// $this->strQuery = "SELECT p.*, b.contact_person, pk.user_name
		// From quote_mini_notes p
		// LEFT join quotes pk on pk.id=p.group_id
		// LEFT join brands b on b.id=pk.brandID
		// WHERE p.quote_id=$quote_id";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

	     	if($result = $this->getMysqliResults($this->strQuery,true)) {
				//$result = $result[0];


	     		return $result;
	     	}

	    }

	    return null;
	}

	public function setQuoteNote($groupID,$note,$direction = 1){
		$this->strQuery = "INSERT INTO quote_mini_notes
		(group_id, comment, timestamp, direction)
		VALUES (" . $groupID . ",'" . $this->mysqli->real_escape_string($note) . "', '" . Date('Y-m-d G:i:s') . "'," . $direction . " ) ";

		$this->short_query($this->strQuery);
    }

    public function sendQuoteNoteAlert($quoteID, $strNote, $intDirection = 1) {
        // Get the contact details
        //var_dump($die);
        //$arrContactInfo = $this->getEmailsForQuote($groupID);

        // Set the contact details
        //$strAdminEmail =  $arrContactInfo['contact_email'];
        //$strAdminEmail2 =  $arrContactInfo['contact_email2'];
        //$strUserEmail =  $arrContactInfo['user_email'];

        $strAdminEmail = 'ross@bcgolfguide.com';
        $intBrandId = 18;
        $strUserEmail = '';
        $arrCC = array();
        $arrBCC = array();

        $arrAgents =  $this->getEmailsForQuote($quoteID);

		// Determine Primary Contact
		foreach ($arrAgents as $arrAgent) {

			$strUserEmail = $arrAgent['user_email'];
			$intBrandId = $arrAgent['brandID'];

			if ($arrAgent['primary_contact'] == '1') {
				$strAdminEmail = $arrAgent['booking_email'];
			}
		}

        $sentUser = false;

		// Send Emails
		foreach ($arrAgents as $arrAgent) {

        	//Outgoing to user
        	if ($intDirection == 1) {
        		//$strTo = $strUserEmail;

        		$strHeaders = 'From: ' . $strAdminEmail . "\r\n"
                    . 'Reply-To: ' . $strAdminEmail . "\r\n"
                    . 'X-Mailer: PHP/' . phpversion();

		        $strSubject = 'New BCgolfguide.com Message';
		        $strMessage = 'New BCgolfguide.com Message';

		        $strMessage .= ':' . "\r\n\r\n" . $strNote;

		        // Only send to user once
		        if (!$sentUser) {
		        	Util::sendMailCore($strUserEmail, $strSubject, $strMessage, $strHeaders);
		        	$sentUser = true;
		        }

		        Util::sendMailCore($arrAgent['booking_email'], $strSubject, $strMessage, $strHeaders);

		    }

		    //Incoming to Selected Contacts
	        if ($intDirection == 0) {

	        	$strHeaders = 'From: ' . $strUserEmail . "\r\n"
                    . 'Reply-To: ' . $strUserEmail . "\r\n"
                    . 'X-Mailer: PHP/' . phpversion();

	            // Add the group name for admin emails
	            $strSubject = ' from quote "' . static::getGroupName($quoteID) . '"';
	            $strMessage = ' from quote "' . static::getGroupName($quoteID) . '":' . "\r\n\r\n" . $strNote;

	            Util::sendMailCore($arrAgent['booking_email'], $strSubject, $strMessage, $strHeaders);

	        }
		}
    }

	public function getEmailsForQuote($quote_id) {

		/*
		$this->strQuery = "SELECT b.contact_email, p.user_email, p.user_name, b.contact_email2, b.id AS 'brand_id'
		From $this->strTableName p
		LEFT join brands b on b.id=p.brandID
		WHERE p.id=$quote_id
		LIMIT 0,1";
		*/
		$this->strQuery = "SELECT
								booking_people.booking_name,
							    booking_people.booking_email,
							    quotes.user_email,
							    quotes.brandID,
							    quote_booking_people.primary_contact,
							    quote_booking_people.contact,
							    quote_booking_people.bcc
							 FROM booking_people
								JOIN quote_booking_people ON (booking_people.id = quote_booking_people.booking_people_id)
							    JOIN quotes ON (quote_booking_people.quote_id = quotes.id)
							    WHERE quote_booking_people.quote_id = $quote_id";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

	     	$arrResult = $this->getMysqliResults($this->strQuery,true);
	     	//$result = $result[0];
	     	return $arrResult;

	    } else {
	     	return null;
	    }
	}

	public function getClientNameForQuote($quote_id) {

		$this->strQuery = "SELECT user_name
		From $this->strTableName
		WHERE id=$quote_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0]['user_name'];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getSessionForQuote($quote_id) {

		$this->strQuery = "SELECT session_id
		From $this->strTableName
		WHERE id=$quote_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0]['session_id'];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getCoursesForQuote($quoteID) {

		$strQuery = "SELECT p.*, c.*, c.comments AS description, ct.title AS city, s.short_name
		FROM quote_golf p
		LEFT JOIN course c on c.id=p.course_id
        LEFT JOIN city ct on ct.id=c.city_id
        LEFT JOIN state s on ct.state_id=s.id
		WHERE quote_id=".$quoteID." ORDER BY tee_date ASC";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function getQuoteCourseImages($course_id) {


		$this->strQuery ="SELECT *
			FROM course_img
			where course_id='$course_id'
			AND status='Active'
			order by blnPrimary DESC, display_order asc
			LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);

	     	if(empty($result)){
	     		return null;
	     	}

			return $result[0];

		}

	}

	public function getHotelsForQuote($quoteID) {

		$strQuery = "SELECT p.*, h.*, ct.title AS city, s.short_name
		FROM quote_hotel p
		LEFT JOIN hotel h on h.id=p.hotel_id
        LEFT JOIN city ct on ct.id=h.city_id
        LEFT JOIN state s on ct.state_id=s.id
		WHERE quote_id=".$quoteID." ORDER BY check_in_date ASC";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function getQuoteHotelImages($hotel_id) {


		$this->strQuery ="SELECT *
			FROM hotel_img
			where hotel_id='$hotel_id'
			AND status='Active'
			order by blnPrimary DESC, display_order asc
			LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);

	     	if(empty($result)){
	     		return null;
	     	}

			return $result[0];

		}

	}

	public static function setBookNow($arrPost){
		$arrReturn = array(
			'blnError' => false,
			'strMessage' => ''
		);

		$objQuote = new static;
		$objBrand = new Brand;

		// get quote details
		$arrQuote = $objQuote->getDetail($arrPost['quote_id']);
		$strComment = $arrPost['comment'];

		// mark quote as ready
		$objQuote->markAsBookNowById($arrQuote['id']);

		// make emails
		$arrContactEmails = $objQuote->getEmailsForQuote($arrQuote['id']);

		if (empty($arrContactEmails)) {
			$arrContactEmails = array(array('booking_name'=> 'Ross Marrington', 'booking_email' => 'ross@bcgolfguide.com', 'primary_contact' => '1'));
		}

		$strPrimaryContact = 'Ross Marrington';
		$strPrimaryContactEmail = 'ross@bcgolfguide.com';

		foreach ($arrContactEmails AS $arrContactEmail) {
			if ($arrContactEmail['primary_contact'] == '1') {
				$strPrimaryContact = $arrContactEmail['booking_name'];
				$strPrimaryContactEmail = $arrContactEmail['booking_email'];
			}
		}

		$arrGroup = $objQuote->getGroupById($arrQuote['id']);
		$arrBrand = $objBrand->getDetail($arrQuote['brandID']);
		$arrBookingPerson = $objQuote->getBookingPersonsById($arrQuote['bookingID']);

		$strPreviewLink = ROOT_URL . '/quote-preview/' . $arrQuote['session_id'];
		$strAdminLink = ROOT_URL . '/admin/quote/' . $arrGroup['id'] . '/edit/' . $arrQuote['id'] . '/';

		ob_start();
			include(ROOT_DIR . '/application/views/emails/book_now.php');
		$strContent = ob_get_clean();

		$strQuoteName = $arrQuote['quote_name'];
		if(empty($strQuoteName)){
			$strQuoteName = $arrGroup['group_name'];
		}

		$strContent = str_replace('[group_name]', $arrGroup['group_name'], $strContent);
		$strContent = str_replace('[quote_name]', $strQuoteName, $strContent);
		$strContent = str_replace('[date_created]', $arrQuote['date_created'], $strContent);
		$strContent = str_replace('[user_name]', $arrQuote['user_name'], $strContent);
		$strContent = str_replace('[user_email]', $arrQuote['user_email'], $strContent);
		$strContent = str_replace('[user_phone]', $arrQuote['phone'], $strContent);
		$strContent = str_replace('[agent_name]', $strPrimaryContact, $strContent);
		$strContent = str_replace('[brand_name]', $arrBrand['business_name'], $strContent);
		$strContent = str_replace('[preview_link]', $strPreviewLink, $strContent);
		$strContent = str_replace('[admin_link]', $strAdminLink, $strContent);
		$strContent = str_replace('[comment]', $strComment, $strContent);

		$strSubject = $arrBrand['business_name'] . ' quote ready to book. (' . $strQuoteName . ')';
		$strHeaders = 'MIME-Version: 1.0' . "\r\n"
					. 'Content-type: text/html; charset=iso-8859-1' . "\r\n"
	//				. 'From: ' . $arrQuote['user_email'] . "\r\n"
                    . 'From: system@bcgolfguide.com' . "\r\n"
					. 'Reply-To: ' . $arrQuote['user_email'] . "\r\n";
//g
		// send emails
		foreach ($arrContactEmails AS $arrContactEmail) {
			Util::sendMailCore($arrContactEmail['booking_email'], $strSubject, $strContent, $strHeaders);
		}
/*
		if(!empty($arrBrandEmails['contact_email'])){
			Util::sendMailCore($arrBrandEmails['contact_email'], $strSubject, $strContent, $strHeaders);
		}

		if(!empty($arrBrandEmails['contact_email2'])){
			Util::sendMailCore($arrBrandEmails['contact_email2'], $strSubject, $strContent, $strHeaders);
		}
		*/

		// return success message
		$arrReturn['strMessage'] = '<strong>Thank you.</strong> Booking Request Sent.';
		return $arrReturn;

	}

	public function markAsBookNowById($intQuoteId, $blnReadyToBook = true, $blnDebug = false){
		if(empty($intQuoteId)){
			// no quote to mark
			return false;
		};

		$intReadyToBook = 1;
		if(!$blnReadyToBook){
			$intReadyToBook = 0;
		}

		$this->strQuery = " UPDATE quotes "
						. " SET ready_to_book = " . $intReadyToBook
						. " WHERE id = " . $intQuoteId;

		$this->short_query($this->strQuery);

		return true;
	}

	public function getBookingPersonsById($intBoookingId, $blnDebug = false){
		if(empty($intBoookingId)){
			// no person to find
			return null;
		}

		$this->strQuery = 'SELECT * FROM booking_people WHERE id = '. $intBoookingId;

		$intQueryId = null;
		if($this->query($this->strQuery)) {
	     	$arrResults = $this->getMysqliResults($this->strQuery,true);
	     	$arrResult = $arrResults[0];
	    }

	    if($blnDebug) {
	    	Util::debugDisplay($this->strQuery);
		}

		return $arrResult;
	}



	public static function updateEditDateById($intQuoteId){
		$objQuote = new static;

		$objQuote->strQuery = "UPDATE quotes SET edit_date = '" . date('Y-m-d G:i:s') . "' WHERE id = " . $intQuoteId;

		if($objQuote->short_query($objQuote->strQuery)) {
			return true;
		} else {
			return false;
		}
	}

    public static function updateQuoteEmailStatus($intQuoteId, $blnRead = true) {
        $objQuote = new static;

        // Set the value
        $intValue = $blnRead ? 1 : 0;

        // Set the query
        $objQuote->strQuery = "UPDATE quotes SET `email_read` = " . $intValue . ", `email_read_datetime` = " . time() . " WHERE `id` = " . $intQuoteId;

        if ($objQuote->short_query($objQuote->strQuery)) {
            return true;
        } else {
            return false;
        }
    }
}

?>