<?php

class Partner extends Database {

    public $intId;
    public $intBrandId;
    public $intRegionId;
    public $intSessionId;
    public $intFeaturedId;
    public $strDomain;

    public $strTitle;
    public $strContent;

    public $intStep;
    public $strUserName;
    public $strUserEmail;
    public $strUserPhone;
    public $strUserCell;
    public $strUserFax;
    public $intCountryId = 261;
    public $intStateId = 2;
    public $intCityId = 6345;
    public $strCountryName = 'CA';
    public $strStateName = 'BC';
    public $strCityName = 'Kelowna';
    public $strAddress;
    public $strPostalCode;
    public $blnDateFlex = 'no';
    public $intPlayersNum = 2;
    public $intRoundsNum = 1;
    public $intCouplesNum = 0;
    public $intNgNum = 0;
    public $strDatesArrival;
    public $strDatesDepart;
    public $blnSmoking = 'no';
    public $blnBedshare1 = 'no';
    public $blnBedshare2 = 'no';
    public $blnShuttle = 'no';
    public $strOrigin;
    public $strComments;
    public $strRecaptcha;

    public $strTeeTimes = 'anytime';
    public $arrSelectedCourses;
    public $arrSelectedHotels;
    public $csvSelectedCourses;
    public $csvSelectedHotels;
    public $strBaseUrl;
    public $strIdentUrl;

    public $strDisplayImage;
    public $strFocusKeyword;
    public $strMetaTitle;
    public $strMetaKeywords;
    public $strMetaDescription;
    public $strMetaRobots;
    public $strSearchWord;
    public $blnShowFeatured = true;
    public $arrColumns;
    public $strFacebookTitle;
    public $strOGImage;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;

    public $intAdwordsLead;

    public $arrAgents;

    public function __construct() {

        parent::__construct();
        $this->strErrorMessage = "";
        $this->strSuccessMessage  = "";
        $this->strTableName = 'brands';
        $this->strTableSlug = 'brands';
        $this->intPageCount = 0;
        $this->strView = 'partner';

        $this->intStep = !empty($_GET['step']) ? $_GET['step'] : 1;
        $this->strbrandSlug = !empty($_GET['brandID']) ? $_GET['brandID'] : '';
    }

    public function init() {
		//gets all the background info for the brand
        $this->arrDetails = $this->getDetail($this->strbrandSlug);
        $this->intBrandId = $this->arrDetails['id'];
        $objPage = New Page('golf-vacation-builder');

        $this->strMetaTitle = $objPage->strMetaTitle;
        $this->strTitle = $objPage->strTitle;
        $this->strMetaTitle = $objPage->strMetaTitle;
        $this->strMetaKeywords = $objPage->strMetaKeywords;
        $this->strMetaDescription = $objPage->strMetaDescription;
        $this->strMetaRobots = $objPage->strMetaRobots;
        $this->strOGImage = $objPage->strOGImage;

        $this->strFacebookTitle = $objPage->strFacebookTitle;
        $this->strFacebookDescription = $objPage->strFacebookDescription;
        $this->strFacebookImage = $objPage->strFacebookImage;
        $this->strTwitterTitle = $objPage->strTwitterTitle;
        $this->strTwitterDescription = $objPage->strTwitterDescription;
        $this->strTwitterImage = $objPage->strTwitterImage;
        $this->strGoogleDescription = $objPage->strGoogleDescription;

        // Set the region ID
        $this->intFeaturedId = !empty($_GET['featuredID']) ? $_GET['featuredID'] : '';
        $this->strDomain = $_SERVER['HTTP_HOST'];
        $this->intSessionId = session_id();

        // Restore Session from Post Data -- Workaround for iframes
        if (isset($_REQUEST['session_package'])) {
            $_SESSION['package'] = json_decode($_REQUEST['session_package'], true);
        }

        $this->intAdwordsLead  = (isset($_SESSION['adwords_lead']) && $_SESSION['adwords_lead']) ? 1 : 0;

        // New request
        if (!empty($_GET['r']) && isset($_GET['arrival_date'])) {
            $this->intRegionId     = !empty($_REQUEST['r']) ? $_REQUEST['r'] : 0;
            $this->strDatesArrival = !empty($_REQUEST['arrival_date']) ? $_REQUEST['arrival_date'] : date('Y-m-d');
            $this->strDatesDepart  = !empty($_REQUEST['departure_date']) ? $_REQUEST['departure_date'] : date('Y-m-d', strtotime('+1 day'));
            $this->intNights       = !empty($_REQUEST['nights']) ? $_REQUEST['nights'] : 1;

            if (!empty($this->intNights)) {
                $this->strDatesDepart = date('Y-m-d', strtotime($this->strDatesArrival . ' +' . $this->intNights . ' days'));
            }

            // Reset the session values
            unset($_SESSION['package']);
        } else {

            $this->intRegionId     = !empty($_SESSION['package']['region_id']) ? $_SESSION['package']['region_id'] : 0;
            $this->strDatesArrival = !empty($_SESSION['package']['arrival_date']) ? $_SESSION['package']['arrival_date'] : date('Y-m-d', strtotime('+3 days'));
            $this->strDatesDepart  = !empty($_SESSION['package']['departure_date']) ? $_SESSION['package']['departure_date'] : date('Y-m-d', strtotime('+4 days'));
        }

        // Set the defaulted values for featured packages
        if (!empty($this->intFeaturedId)) {
            $this->getFeaturedPackage();
        } else {
            // This never returns results?
            // $this->getPackageForSession(session_id());
        }

        // Set the default session values
        if (empty($_SESSION['package'])) {
            $this->setSession();
        }

        // Set the region, course, and hotel list
        $objRegion = new Region;
        if (!empty($this->intRegionId)) {
            $this->arrRegion  = $objRegion->getRegionDetail('', $this->intRegionId);
            $this->arrCourses = $this->getCourseListForRegion($this->intRegionId);
            $this->arrHotels  = $this->getHotelListForRegion($this->intRegionId);
        } else {
            $this->arrRegion  = $objRegion->getRegionDetail('', $this->arrDetails['region_id']);
            $this->arrCourses = $this->getCourseListForBrand($this->arrDetails['id']);
            $this->arrHotels  = $this->getHotelListForBrand($this->arrDetails['id']);
        }

        // Form post back logic
        if (!empty($_POST)) {
            // Set the values + session values
            $this->setValues($_POST)->setSession($_POST);

            // Insert the records
            if ($this->intStep == 5) {
                $this->processForm();
            }
        }
    }



    public function getFeaturedPackage() {

        $this->strQuery = "SELECT * FROM feature_packages WHERE id='$this->intFeaturedId'";
        if ($this->query($this->strQuery)) {
            if ($result = $this->getMysqliResults($this->strQuery,true)) {

                $result = $result[0];

                $id = $result['id'];

                $strQuery = "SELECT *
                From feature_packages_hotel
                WHERE packageID=$id";
                if ($this->query($strQuery)) {
                    $result2 = $this->getMysqliResults($strQuery,true);
                    $this->arrHotels = $result2;
                    foreach( $this->arrHotels as $h ) {
                        $arrHotels[] = $h['hotelID'];
                    }
                    $result['hotel'] = $arrHotels;
                }


                $strQuery = "SELECT *
                From feature_packages_course
                WHERE packageID=$id";
                if ($this->query($strQuery)) {
                    $result2 = $this->getMysqliResults($strQuery,true);
                    $this->arrCourse = $result2;
                    foreach( $this->arrCourse as $c ) {
                        $arrCourses[] = $c['courseID'];
                    }
                    $result['golf_course'] = $arrCourses;
                }




                //$this->intId = $result['id'];
                $this->arrSelectedCourses = array_filter($result['golf_course']);
                $this->csvSelectedCourses = implode(",",$this->arrSelectedCourses);

                $this->arrSelectedHotels = array_filter($result['hotel']);
                $this->csvSelectedHotels = implode(",",$this->arrSelectedHotels);

                $_SESSION['package']['selected_courses'] = $this->arrSelectedCourses;
                $_SESSION['package']['selected_hotels'] = $this->arrSelectedHotels;

                return $result;

            }
        }
    }





    public function setDisplayImage($img) {

        $this->strDisplayImage = $img;

    }

    public function setBaseUrl($url) {

        $this->strBaseUrl = $url;

    }

    public function setIdentUrl($url) {

        $this->strIdentUrl = $url;

    }



    public function setSlug($slug) {

        $this->strbrandSlug = $slug;

    }


    public function getCoursesForBuilder($arrCourses) {
        $objCourse = new Course();
        foreach ($arrCourses as $c) {
            $arrDetails = $objCourse->getCourseDetailById($c);
            echo '<li><span href="#" class="fa fa-minus-circle"></span> ' . $arrDetails['course_name'] . '</li>';
        }
    }

    public function getHotelsForBuilder($arrHotels) {
        $objHotel = new Hotel();
        foreach ($arrHotels as $h) {
            $arrDetails = $objHotel->getHotelDetailById($h);
            echo '<li><span href="#" class="fa fa-minus-circle"></span> ' . $arrDetails['hotel_name'] . '</li>';
        }
    }

    public function getPackageForSession($session_id) {

        $this->strQuery = "SELECT * FROM packages WHERE session_id='$session_id' ORDER BY id DESC LIMIT 0,1";
        if ($this->query($this->strQuery)) {
            if ($result = $this->getMysqliResults($this->strQuery,true)) {

                $result = $result[0];
                $this->intId = $result['id'];
                $this->strUserName = isset($result['user_name']) ? $result['user_name'] : '';
                $this->strUserEmail = isset($result['user_email']) ? $result['user_email'] : '';
                $this->strUserPhone = isset($result['phone']) ? $result['phone'] : '';
                $this->strUserCell = isset($result['cell']) ? $result['cell'] : '';
                $this->strUserFax = isset($result['fax']) ? $result['fax'] : '';
                $this->strAddress = isset($result['address']) ? $result['address'] : '';
                $this->strPostalCode = isset($result['postal_code']) ? $result['postal_code'] : '';
                $this->intCityId = isset($result['city']) ? $result['city'] : '';
                $this->intCountryId = isset($result['country']) ? $result['country'] : '';
                $this->intStateId = isset($result['state']) ? $result['state'] : '';
                $this->blnDateFlex = isset($result['date_flex']) ? $result['date_flex'] : '';
                $this->intPlayersNum = isset($result['players_num']) ? $result['players_num'] : '';
                $this->intRoundsNum = isset($result['rounds_num']) ? $result['rounds_num'] : '';
                $this->intCouplesNum = isset($result['couples_num']) ? $result['couples_num'] : '';
                $this->intNgNum = isset($result['ng_num']) ? $result['ng_num'] : '';
                $this->strDatesArrival = isset($result['dates_arrival']) ? $result['dates_arrival'] : '';
                $this->strDatesDepart = isset($result['dates_depart']) ? $result['dates_depart'] : '';
                $this->blnSmoking = isset($result['smoking']) ? $result['smoking'] : '';
                $this->blnBedshare1 = isset($result['bedshare1']) ? $result['bedshare1'] : '';
                $this->blnBedshare2 = isset($result['bedshare2']) ? $result['bedshare2'] : '';
                $this->blnShuttle = isset($result['shuttle']) ? $result['shuttle'] : '';
                $this->strOrigin = isset($result['theorigin']) ? $result['theorigin'] : '';
                $this->strComments = isset($result['comments']) ? $result['comments'] : '';
                $this->strTeeTimes = isset($result['tee_times']) ? $result['tee_times'] : '';

                $this->arrSelectedCourses = isset($result['golfcourses']) ? $result['golfcourses'] : '|';
                $this->arrSelectedCourses = explode("|",$this->arrSelectedCourses);
                $this->csvSelectedCourses = implode(",",$this->arrSelectedCourses);

                $this->arrSelectedHotels = isset($result['accommodations']) ? $result['accommodations'] : '|';
                $this->arrSelectedHotels = explode("|",$this->arrSelectedHotels);
                $this->csvSelectedHotels = implode(",",$this->arrSelectedHotels);
            }

        }


    }

    /**
     * Sets the class parameters, before the post is submitted
     *
     */
    public function setValues($post = array()) {
        // Set the values
        if (isset($post['arrival_date'])) $this->strDatesArrival = $post['arrival_date'];
        if (isset($post['departure_date'])) $this->strDatesDepart = $post['departure_date'];
        if (isset($post['selected_courses'])) $this->arrSelectedCourses = $post['selected_courses'];
        if (isset($post['selected_hotels'])) $this->arrSelectedHotels = $post['selected_hotels'];

        if (isset($post['user_name'])) $this->strUserName = $post['user_name'];
        if (isset($post['user_email'])) $this->strUserEmail = $post['user_email'];
        if (isset($post['user_phone'])) $this->strUserPhone = $post['user_phone'];
        if (isset($post['cell'])) $this->strUserCell = $post['cell'];
        if (isset($post['fax'])) $this->strUserFax = $post['fax'];
        if (isset($post['address'])) $this->strAddress = $post['address'];
        if (isset($post['postal_code'])) $this->strPostalCode = $post['postal_code'];
        if (isset($post['city'])) $this->intCityId = $post['city'];
        if (isset($post['country'])) $this->intCountryId = $post['country'];
        if (isset($post['state'])) $this->intStateId = $post['state'];

        if (isset($post['date_flex'])) $this->blnDateFlex = $post['date_flex'];
        if (isset($post['players_num'])) $this->intPlayersNum = $post['players_num'];
        if (isset($post['rounds_num'])) $this->intRoundsNum = $post['rounds_num'];
        if (isset($post['couples_num'])) $this->intCouplesNum = $post['couples_num'];
        if (isset($post['ng_num'])) $this->intNgNum = $post['ng_num'];
        if (isset($post['smoking'])) $this->blnSmoking = $post['smoking'];
        if (isset($post['bedshare1'])) $this->blnBedshare1 = $post['bedshare1'];
        if (isset($post['bedshare2'])) $this->blnBedshare2 = $post['bedshare2'];
        if (isset($post['shuttle'])) $this->blnShuttle = $post['shuttle'];
        if (isset($post['tee_times'])) $this->strTeeTimes = $post['tee_times'];
        if (isset($post['theorigin'])) $this->strOrigin = $post['theorigin'];
        if (isset($post['comments'])) $this->strComments = $post['comments'];

        // Set captcha
        if (isset($post['g-recaptcha-response'])) $this->strRecaptcha = $post['g-recaptcha-response'];

        // Return the object for method chaining
        return $this;
    }

    /**
     * Set the session values
     *
     */
    public function setSession($post = array()) {
        // Set the session values
        if (!isset($_SESSION['package'])) {
            $_SESSION['package'] = array(
                'region_id'        => $this->intRegionId,
                'arrival_date'     => $this->strDatesArrival,
                'depart_date'      => $this->strDatesDepart,
                'selected_courses' => $this->arrSelectedCourses,
                'selected_hotels'  => $this->arrSelectedHotels,
                'user_name'        => '',
                'user_email'       => '',
                'user_phone'       => '',
                'cell'             => '',
                'fax'              => '',
                'address'          => '',
                'postal_code'      => '',
                'city'             => '',
                'country'          => '',
                'state'            => '',
                'date_flex'        => $this->blnDateFlex,
                'players_num'      => $this->intPlayersNum,
                'rounds_num'       => $this->intRoundsNum,
                'couples_num'      => $this->intCouplesNum,
                'ng_num'           => $this->intNgNum,
                'smoking'          => $this->blnSmoking,
                'bedshare1'        => $this->blnBedshare1,
                'bedshare2'        => $this->blnBedshare2,
                'shuttle'          => $this->blnShuttle,
                'tee_times'        => $this->strTeeTimes,
                'theorigin'        => '',
                'comments'         => '',
            );
        }

        if (isset($post['arrival_date'])) $_SESSION['package']['arrival_date'] = $post['arrival_date'];
        if (isset($post['departure_date'])) $_SESSION['package']['depart_date'] = $post['departure_date'];
        if (isset($post['selected_courses'])) $_SESSION['package']['selected_courses'] = $post['selected_courses'];
        if (isset($post['selected_hotels'])) $_SESSION['package']['selected_hotels'] = $post['selected_hotels'];

        if (isset($post['user_name'])) $_SESSION['package']['user_name'] = $post['user_name'];
        if (isset($post['user_email'])) $_SESSION['package']['user_email'] = $post['user_email'];
        if (isset($post['user_phone'])) $_SESSION['package']['user_phone'] = $post['user_phone'];
        if (isset($post['cell'])) $_SESSION['package']['cell'] = $post['cell'];
        if (isset($post['fax'])) $_SESSION['package']['fax'] = $post['fax'];
        if (isset($post['address'])) $_SESSION['package']['address'] = $post['address'];
        if (isset($post['postal_code'])) $_SESSION['package']['postal_code'] = $post['postal_code'];
        if (isset($post['city'])) $_SESSION['package']['city'] = $post['city'];
        if (isset($post['country'])) $_SESSION['package']['country'] = $post['country'];
        if (isset($post['state'])) $_SESSION['package']['state'] = $post['state'];

        if (isset($post['date_flex'])) $_SESSION['package']['date_flex'] = $post['date_flex'];
        if (isset($post['players_num'])) $_SESSION['package']['players_num'] = $post['players_num'];
        if (isset($post['rounds_num'])) $_SESSION['package']['rounds_num'] = $post['rounds_num'];
        if (isset($post['couples_num'])) $_SESSION['package']['couples_num'] = $post['couples_num'];
        if (isset($post['ng_num'])) $_SESSION['package']['ng_num'] = $post['ng_num'];
        if (isset($post['smoking'])) $_SESSION['package']['smoking'] = $post['smoking'];
        if (isset($post['bedshare1'])) $_SESSION['package']['bedshare1'] = $post['bedshare1'];
        if (isset($post['bedshare2'])) $_SESSION['package']['bedshare2'] = $post['bedshare2'];
        if (isset($post['shuttle'])) $_SESSION['package']['shuttle'] = $post['shuttle'];
        if (isset($post['tee_times'])) $_SESSION['package']['tee_times'] = $post['tee_times'];
        if (isset($post['theorigin'])) $_SESSION['package']['theorigin'] = $post['theorigin'];
        if (isset($post['comments'])) $_SESSION['package']['comments'] = $post['comments'];

        // Return the object for method chaining
        return $this;
    }

    public function processForm() {
        // include required extra models
        include(ROOT_DIR . '/application/models/admin/quote_golf.php');
        include(ROOT_DIR . '/application/models/admin/quote_hotel.php');

        // Set the step to 3 (post back errors). If the insert succeeds it will update to 5
        $this->intStep = 3;

        // Verify the recaptcha
        if (!Util::recaptcha($this->strRecaptcha)) {
            $this->strErrorMessage .= 'Please validate that you are not a robot<br />';
            return;
        }

        if (empty($this->arrSelectedCourses)) {
            $this->strErrorMessage .= 'Please select at least one course<br />';
        }
        if (empty($this->arrSelectedHotels)) {
            $this->strErrorMessage .= 'Please select at least one hotel<br />';
        }
        if ($this->strDatesArrival == '') {
            $this->strErrorMessage .= 'Please enter an approximate Arrival Date<br />';
        }
        if ($this->strDatesDepart == '') {
            $this->strErrorMessage .= 'Please enter an approximate Departure Date<br />';
        }
        if ($this->strDatesArrival > $this->strDatesDepart) {
            $this->strErrorMessage .= 'Please enter valid arrival / departure dates<br />';
        }
        if ($this->strUserName == '')  {
            $this->strErrorMessage .= 'Please enter your name<br />';
        }
        if (!filter_var($this->strUserEmail, FILTER_VALIDATE_EMAIL)) {
            $this->strErrorMessage .= 'Please enter a valid email address<br />';
        }
        if ($this->strUserPhone == '') {
            $this->strErrorMessage .= 'Please enter your phone number<br />';
        }
        if ($this->intPlayersNum < 2) {
            $this->strErrorMessage .= 'A minimum of 2 golfers is required<br />';
        }
        if ($this->intRoundsNum < 1) {
            $this->strErrorMessage .= 'A minimum of 1 round is required<br />';
        }
        if (empty($this->blnDateFlex)) {
            $this->strErrorMessage .= 'Please select if your dates are flexible<br />';
        }

        if ($this->strComments == '') {
            $this->strErrorMessage .= 'Please enter the group composition<br />';
        }

        if ($this->strErrorMessage == "") {

            //remnant from the old system. Pipe delimited values for courses and hotels
            $this->pdSelectedCourses = implode("|",$this->arrSelectedCourses);
            $this->pdSelectedHotels = implode("|",$this->arrSelectedHotels);

            $keys = array(
                'user_name',
                'user_email',
                'phone',
                'cell_phone',
                'fax',
                // 'address',
                // 'zip',
                // 'city',
                // 'country',
                // 'state',
                'date_flex',
                'players_num',
                'rounds_num',
                'couples_num',
                'ng_num',
                'dates_arrival',
                'dates_depart',
                'smoking',
                'bedshare1',
                'bedshare2',
                'shuttle',
                'theorigin',
                'comments',
                'tee_times',
                'session_id',
                'region_id',
                'golfcourses',
                'accommodations',
                'order_date',
                'edit_date',
                'domain',
                'brandID',
                'adwords_lead'
            );

            $vals = array(
                $this->strUserName,
                $this->strUserEmail,
                $this->strUserPhone,
                $this->strUserCell,
                $this->strUserFax,
                // $this->strAddress,
                // $this->strPostalCode,
                // $this->intCityId,
                // $this->intCountryId,
                // $this->intStateId,
                $this->blnDateFlex,
                $this->intPlayersNum,
                $this->intRoundsNum,
                $this->intCouplesNum,
                $this->intNgNum,
                $this->strDatesArrival,
                $this->strDatesDepart,
                $this->blnSmoking,
                $this->blnBedshare1,
                $this->blnBedshare2,
                $this->blnShuttle,
                $this->strOrigin,
                $this->strComments,
                $this->strTeeTimes,
                $this->intSessionId,
                $this->intRegionId,
                $this->pdSelectedCourses,
                $this->pdSelectedHotels,
                date('Y-m-d'),
                date('Y-m-d'),
                $this->strDomain,
                $this->intBrandId,
                $this->intAdwordsLead
            );

            if ($this->intId == '') {
                $this->strErrorMessage = $this->mysqliinsert('quotes',$keys,$vals,'');
                $this->intId = $this->insert_id;
                $this->strSuccessMessage = 'Record Added';
            } else {
                $this->strErrorMessage = $this->mysqliupdate('quotes',$keys,$vals,'',$this->intId);
                $this->strSuccessMessage = 'Record Saved';
            }

            // make child golf records
            $intNumberGolfers = (int) $this->intPlayersNum - (int) $this->intNgNum;
            if ($intNumberGolfers < 0) {
                $intNumberGolfers = 0;
            }

            foreach($this->arrSelectedCourses as $intCourseId) {
                $objQuoteGolf = new Quotecourses();
                $intQuoteGolfId = $objQuoteGolf->handlePost(array(
                    'course_id' => $intCourseId,
                    'golfer_num' => $intNumberGolfers,
                    'shuttle' => $this->blnShuttle
                ), $this->intId);
            }

            $blnDefaultHotelSet = false;
            foreach($this->arrSelectedHotels as $intHotelId) {
                $objQuoteHotel = new Quotehotels();
                $intQuoteGolfId = $objQuoteHotel->handlePost(array(
                    'hotel_id' => $intHotelId,
                    'rooms' => $this->intCouplesNum,
                    'golfers' => (int)$this->intPlayersNum,
                    'people_num' => (int)$this->intPlayersNum,
                    'default' => ($blnDefaultHotelSet) ? 0 : 1,
                    'validate' => false
                ), $this->intId);

                $blnDefaultHotelSet = true;
            }

            $this->intHotelId = isset($post['hotel_id']) && $post['hotel_id'] != '' ? $post['hotel_id'] : 'Null';
            $this->strCheckInDate = isset($post['check_in_date']) ? $post['check_in_date'] : '';
            $this->strCheckOutDate = isset($post['check_out_date']) ? $post['check_out_date'] : '';
            $this->strNights = isset($post['nights']) ? $post['nights'] : 0;
            $this->strRooms = isset($post['rooms']) ? $post['rooms'] : 0;
            $this->strGolfers = isset($post['golfers']) ? $post['golfers'] : 1;
            $this->strConfirmNum = isset($post['confirm_num']) ? $post['confirm_num'] : '';
            $this->strGuestsName = isset($post['guests_name']) ? $post['guests_name'] : '';
            $this->strRoomNotes = isset($post['room_notes']) ? $post['room_notes'] : '';
            $this->strPublicNotes = isset($post['public_notes']) ? $post['public_notes'] : '';
            $this->strMiniContent = isset($post['email_content']) ? $post['email_content'] : '';
            $this->blnDefault = isset($post['default']) ? $post['default'] : 0;

            $pc =   isset($_POST['people_num']) ? count($_POST['people_num']) : 0;

            // generate new group for this quote to go into
            $intGroupId = Quotegroups::insertQuoteGroup($this->intId);

            if ($this->strErrorMessage == "") {
                $this->intStep = 5;
                $this->sendInquiryEmail();

                // Clear the session values
                unset($_SESSION['package']);
            }
        }
    }



    public function getCourseListForRegion($regionID,$debug = false) {


        $strQuery = "SELECT c.*, c2.title,c2.title As city, s.short_name, c.`display_image` As logo ,
        (SELECT detail FROM course_detail WHERE course_id=c.id LIMIT 0,1) As description,
        (SELECT file_name FROM course_img WHERE course_id=c.id order by blnPrimary DESC, display_order ASC LIMIT 0,1) AS primary_image
        FROM course c
        Left Join city c2 on c2.id = c.city_id
        Left Join state s on s.id = c2.state_id
        where c.status = 'Active' AND c.id in (SELECT course_id FROM course_region WHERE region_id=$regionID) ORDER BY type_id, rand()";

        //echo $strQuery;
        if ($debug) {
            Util::debugDisplay($strQuery);
        }

        if ($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return 0;
        }

    }

    public function getCourseListForBrand($brandID,$debug = false) {


        $strQuery = "SELECT c.*, c2.title,c2.title As city, s.short_name, c.`display_image` As logo ,
        (SELECT detail FROM course_detail WHERE course_id=c.id LIMIT 0,1) As description,
        (SELECT file_name FROM course_img WHERE course_id=c.id order by blnPrimary DESC, display_order ASC LIMIT 0,1) AS primary_image
        FROM course c
        Left Join city c2 on c2.id = c.city_id
        Left Join state s on s.id = c2.state_id
        where c.status = 'Active'
        AND c.id in (SELECT course_id FROM brand_courses WHERE brand_id=$brandID)
        AND c.type_id in (3,7)
        ORDER BY type_id, rand()";

        //echo $strQuery;
        if ($debug) {
            Util::debugDisplay($strQuery);
        }

        if ($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return 0;
        }

    }

    public function getSelectedCourseList($courses,$debug = false) {


        $strQuery = "SELECT c.*, c2.title,c2.title As city, s.short_name, c.`display_image` As logo ,
        (SELECT detail FROM course_detail WHERE course_id=c.id LIMIT 0,1) As description,
        (SELECT file_name FROM course_img WHERE course_id=c.id order by blnPrimary DESC, display_order ASC LIMIT 0,1) AS primary_image
        FROM course c
        Left Join city c2 on c2.id = c.city_id
        Left Join state s on s.id = c2.state_id
        where c.status = 'Active' AND c.id in ($courses)";

        //echo $strQuery;
        if ($debug) {
            Util::debugDisplay($strQuery);
        }
        if ($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return 0;
        }

    }

    public function getHotelListForRegion($regionID,$debug = false) {


        $strQuery = "SELECT h.*, c2.title,c2.title As city, s.short_name, h.`file_name` As logo,
        (SELECT file_name FROM hotel_img WHERE hotel_id=h.id order by blnPrimary DESC, display_order ASC LIMIT 0,1) AS primary_image
        FROM hotel h
        Left Join city c2 on c2.id = h.city_id
        Left Join state s on s.id = c2.state_id
        where h.status = 'Active' AND h.id in (SELECT hotel_id FROM  hotel_region WHERE region_id=$regionID) ORDER BY rand()";

        //echo $strQuery;
        if ($debug) {
            Util::debugDisplay($strQuery);
        }
        if ($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return 0;
        }

    }

    public function getHotelListForBrand($brandID,$debug = false) {


        $strQuery = "SELECT h.*,c2.title As city, s.short_name, h.`file_name` As logo,
        (SELECT file_name FROM hotel_img WHERE hotel_id=h.id order by blnPrimary DESC, display_order ASC LIMIT 0,1) AS primary_image
        FROM hotel h
        Left Join city c2 on c2.id = h.city_id
        Left Join state s on s.id = c2.state_id
        where h.status = 'Active' AND h.id in (SELECT hotel_id FROM  brand_hotels WHERE brand_id=$brandID) ORDER BY rand()";

        //echo $strQuery;
        if ($debug) {
            Util::debugDisplay($strQuery);
        }
        if ($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return 0;
        }

    }

    public function getSelectedHotelList($hotels,$debug = false) {


        $strQuery = "SELECT h.*, c2.title, s.short_name, h.`file_name` As logo,
        (SELECT file_name FROM hotel_img WHERE hotel_id=h.id order by blnPrimary DESC, display_order ASC LIMIT 0,1) AS primary_image
        FROM hotel h
        Left Join city c2 on c2.id = h.city_id
        Left Join state s on s.id = c2.state_id
        where h.status = 'Active' AND h.id in ($hotels)";

        //echo $strQuery;
        if ($debug) {
            Util::debugDisplay($strQuery);
        }
        if ($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return 0;
        }

    }


    public function getDetail($slug) {
        //page specific SEO settings. These may override the default settings.
        $this->strQuery = "SELECT b.*,
        c.id As country_id,
        s.id As state_id,
        b.address As business_address,
        b.phone As business_phone,
        b.business_name,
        b.tollfree As business_tollfree,
        b.zip As business_zip,
        b.fax As business_fax,
        c2.title As business_city,
        b.display_image As business_logo,
        b.contact_email As business_email,
        b.terms As business_terms,
        s.state_name As business_state,
        b.background_color,
        b.text_color
        From $this->strTableName b
        Left Join region r on r.id=b.region_id
        Left Join state s on s.id=r.state_id
        Left Join country c on c.id=s.country_id
        Left Join city c2 on c2.id=b.city_id
        WHERE b.slug='$slug'
        LIMIT 0,1";

        //echo $this->strQuery;

        if ($this->query($this->strQuery)) {

            $result = $this->getMysqliResults($this->strQuery,true);

            $result = $result[0];

            $this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
            $this->strSlug = isset($result['slug']) ? $result['slug'] : '';
            $this->blnLinks = isset($result['blnLinks']) ? $result['blnLinks'] : '';
            $this->blnLogo = isset($result['blnLogo']) ? $result['blnLogo'] : '';
            $this->strAddress = isset($result['address']) ? $result['address'] : '';
            $this->strPhone = isset($result['phone']) ? $result['phone'] : '';
            $this->strFax = isset($result['fax']) ? $result['fax'] : '';
            $this->strTollFree = isset($result['tollfree']) ? $result['tollfree'] : '';

            $strSqlAgents = "SELECT * from booking_people WHERE id in (SELECT booking_people_id FROM brand_booking_people WHERE brand_id = ".$result['id'].")";
            $this->arrAgents = $this->getMysqliResults($strSqlAgents, true);

            $this->strWebUrl = isset($result['web_url']) ? $result['web_url'] : '';
            $this->strEmailText = isset($result['email_text']) ? $result['email_text'] : '';
            $this->strInquiryText = isset($result['inquiry_text']) ? $result['inquiry_text'] : '';
            $this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
            $this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
            $this->strMiniPageText = isset($result['mini_email_text']) ? $result['mini_email_text'] : '';
            $this->strTerms = isset($result['terms']) ? $result['terms'] : '';
            $this->strTextColor = isset($result['text_color']) ? $result['text_color'] : '';
            $this->strBackgroundColor = isset($result['background_color']) ? $result['background_color'] : '';
            $this->strTVoucherText1 = isset($result['voucher_text_1']) ? $result['voucher_text_1'] : '';
            $this->strTVoucherText2 = isset($result['voucher_text_2']) ? $result['voucher_text_2'] : '';
            $this->strTVoucherText3 = isset($result['voucher_text_3']) ? $result['voucher_text_3'] : '';
            $this->strTVoucherText4 = isset($result['voucher_text_4']) ? $result['voucher_text_4'] : '';
            $this->strTVoucherText5 = isset($result['voucher_text_5']) ? $result['voucher_text_5'] : '';
            $this->intRegionId = isset($result['region_id']) ? $result['region_id'] : '';
            $this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
            $this->strBrandLogo = isset($result['business_logo']) ? $result['business_logo'] : '';
            $this->strBusinessTollFree = isset($result['business_tollfree']) ? $result['business_tollfree'] : '';
            $this->strBusinessCity = isset($result['business_city']) ? $result['business_city'] : '';
            $this->strBusinessPhone = isset($result['business_phone']) ? $result['business_phone'] : '';
            $this->strBusinessAddress = isset($result['business_address']) ? $result['business_address'] : '';
            $this->strBusinessProv  = isset($result['business_state']) ? $result['business_state'] : '';
            $this->strBusinessFax    = isset($result['business_fax']) ? $result['business_fax'] : '';
            $this->strBusinessZip    = isset($result['business_zip']) ? $result['business_zip'] : '';
            $this->strBusinessEmail    = isset($result['business_email']) ? $result['business_email'] : '';
            $this->strTerms = isset($result['business_terms']) ? $result['business_terms'] : '';

            $this->strSlug = '/partner/'.$this->strSlug;
            return $result;
        } else {
            return null;
        }
    }

    /**
     * Sends a HTML email to the customer
     *
     */
    function sendInquiryEmail() {
        // Set the subject and message
        $strMailSubject = 'Golf Package inquiry from ' . $this->strUserName . ' ( ' . $this->arrDetails['business_name'] . ' )';
        $strMailMessage = str_replace('[client_name]', $this->strUserName, nl2br($this->arrDetails['inquiry_text']));

        // Create the list of hotels + courses
        $arrSelectedCourses = $this->getSelectedCourseList(implode(',', $this->arrSelectedCourses));
        $strSelectedCourses = '';
        foreach($arrSelectedCourses as $course) {
            $strSelectedCourses .= '<span style="text-transform: capitalize;">' . $course['course_name'] . '</span> (' . $course['title'] . ', ' . $course['short_name'] . ')<br />';
        }
        $arrSelectedHotels = $this->getSelectedHotelList(implode(',', $this->arrSelectedHotels));
        $strSelectedHotels = '';
        foreach($arrSelectedHotels as $hotel) {
            $strSelectedHotels .= '<span style="text-transform: capitalize;">' . $hotel['hotel_name'] . '</span> (' . $hotel['title'] . ', ' . $hotel['short_name'] . ')<br />';
        }

        // Start the content
        $strMailContent  = $strMailMessage .'<br /><br />';
        $strMailContent .=
        '<table border="1" style="width:620px;" cellpadding="0" cellspacing="4" align="center" style="border-collapse: collapse" bordercolor="#517A2B">
            <tr><td>
                <table style="width:600px;background-color:#E9F3DE;" align="center">
                    <tr><td colspan="2"><b><i>Main Info</i></b></td></tr>
                    <tr>
                        <td width="28%">Your Name :</td>
                        <td>' . $this->strUserName . '</td>
                    </tr>
                    <tr>
                        <td>Email :</td>
                        <td>' . $this->strUserEmail . '</td>
                    </tr>
                    <tr>
                        <td>Preferred # to call back on:</td>
                        <td>' . $this->strUserPhone . '</td>
                    </tr>
                    <tr>
                        <td>Cel#:</td>
                        <td>' . $this->strUserCell . '</td>
                    </tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center">
                    <tr><td><b>Requested Travel Dates</b></td><td></td></tr>
                    <tr>
                        <td width="35%">Arrival :</td>
                        <td>' . $this->strDatesArrival . '</td>
                    </tr>
                    <tr>
                        <td>Departure :</td>
                        <td>' . $this->strDatesDepart . '</td>
                    </tr>
                    <tr>
                        <td>Flexible Dates :</td>
                        <td>' . $this->blnDateFlex . '</td>
                    </tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center">
                    <tr>
                        <td width="35%">Number of Golfers :</td>
                        <td>' . $this->intPlayersNum . '</td>
                    </tr>
                    <tr>
                        <td>Total rounds interested in playing (per person):</td>
                        <td>' . $this->intRoundsNum . '</td>
                    </tr>
                    <tr><td colspan="2">&nbsp;</td></tr>
                    <tr><td colspan="2"><b><i>Please indicate your preference of golf courses</i></b></td></tr>
                    <tr><td colspan="2">' . $strSelectedCourses . '</td></tr>
                    <tr><td colspan="2">&nbsp;</td></tr>
                    <tr><td colspan="2"><b><i>Please indicate your preference of hotels</i></b></td></tr>
                    <tr><td colspan="2">' . $strSelectedHotels . '</td></tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center">
                    <tr>
                        <td>Is your party interested in upgraded rooms?</td>
                        <td>' . $this->blnSmoking . '</td>
                    </tr>
                    <tr>
                        <td>Are you interested in single occupancy pricing?</td>
                        <td>' . $this->blnBedshare1 . '</td>
                    </tr>
                    <tr>
                        <td>Number of Couples :</td>
                        <td>' . $this->intCouplesNum . '</td>
                    </tr>
                    <tr>
                        <td>Number of non golfers:</td>
                        <td>' . $this->intNgNum . '</td>
                    </tr>
                    <tr>
                        <td>Have you been to this region before?</td>
                        <td>' . $this->blnBedshare2 . '</td>
                    </tr>
                    <tr>
                        <td>Are you planning to golf on the day of arrival?</td>
                        <td>' . $this->blnShuttle . '</td>
                    </tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center" cellspacing="8" cellpadding="0">
                    <tr><td><b><i>How did you discover our website?</i></b></td></tr>
                    <tr><td>' . $this->strOrigin . '</td></tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center" cellspacing="8" cellpadding="0">
                    <tr><td><b><i>What is your group composition and your budget per person?</i></b></td></tr>
                    <tr><td>' . $this->strComments . '</td></tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center" cellspacing="8" cellpadding="0">
                    <tr><td><b><i>Preferred Tee-Times (am, noon, pm, anytime)</i></b></td></tr>
                    <tr><td>' . $this->strTeeTimes . '</td></tr>
                </table>
                <br />

                <table style="width:600px;background-color:#E9F3DE;" align="center" cellspacing="8" cellpadding="0">
                    <tr><td><b><i>Google Adwords Lead</i></b></td></tr>
                    <tr><td>' . (($this->intAdwordsLead=="1") ? 'yes' : 'no') . '</td></tr>
                </table>
                <br />

            </td></tr>
        </table>
        <br /><br />';

        // setup emails
        $strMailHeaders  = "MIME-Version: 1.0\r\n";
        $strMailHeaders .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

        // email user
        $strMailHeaders1 = "From: " . strip_tags($this->arrDetails['contact_email']) . "\r\n"
                         . "Reply-To: ". strip_tags($this->arrDetails['contact_email']) . "\r\n"
                         . $strMailHeaders;
        Util::sendMailCore($this->strUserEmail, $strMailSubject, $strMailContent, $strMailHeaders1);
        
        

        // email brand contacts
        $adminemail = 'requests@bcgolfguide.com';
        $strMailHeaders2 = "From: " . $adminemail . "\r\n"
                         . "Reply-To: ". $this->strUserEmail . "\r\n"
                         . $strMailHeaders;
        if (count($this->arrAgents) > 0) {
            foreach ($this->arrAgents as $arrAgent) {
                Util::sendMailCore($arrAgent['booking_email'], $strMailSubject, $strMailContent, $strMailHeaders2);
            }
        } else { // No Agents, Send to Ross
            Util::sendMailCore('ross@bcgolfguide.com', $strMailSubject, $strMailContent, $strMailHeaders2);
        }
    }

}