<?php


class Page extends Database  {

	public $strQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strContent;
	public $strFocusKeyword;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $strSearchWord;
	public $strDisplayImage;
	public $blnShowFeatured = true;
	public $arrColumns;
	public $strFacebookTitle;
	public $strOGImage;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;

    public $strVideoEmbed;
    public $strVideoSmallHeading;
    public $strVideoLargeHeading;
    public $strVideoText;
    public $strVideoBtnText;
    public $strVideoLink;

	public function __construct($strPageId) {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'pages';
		$this->strTableSlug = $strPageId;

		$this->arrResult=$this->getPageData(false);

		/*
		$this->arrColumns = array(
			'title' => 'title',
			'content' => 'content',
			'meta_title' => 'meta_title',
			'meta_keywords' => 'meta_keywords',
			'meta_description' => 'meta_description',
			'meta_robots' => 'meta_robots',
			'image' => 'display_image',
			'facebook_title' => 'facebook_title',
	        'facebook_description' => 'facebook_description',
	        'facebook_image' => 'facebook_image',
	        'twitter_title' => 'twitter_title',
	        'twitter_description' => 'twitter_description',
	        'twitter_image' => 'twitter_image',
	        'google_description' => 'google_description'
		);
		*/

		if(count($this->arrResult) > 0) {
			//found it, populate the data
			$this->intID = $this->arrResult[0]['id'];
	     	$this->strTitle = $this->arrResult[0]['title'];
	     	//$this->strTitle = 'test';
			$this->strContent =  $this->arrResult[0]['content'];
			$this->blnShowFeatured =  $this->arrResult[0]['bln_show_featured'];
			$this->strFocusKeyword = $this->arrResult[0]['focus_keyword'];
			$this->strMetaTitle =  $this->arrResult[0]['meta_title'] != '' ? $this->arrResult[0]['meta_title'] : $this->strTitle;
			$this->strMetaKeywords =  $this->arrResult[0]['meta_keywords'];
			$this->strMetaDescription =  $this->arrResult[0]['meta_description'];
			$this->strMetaRobots =   $this->arrResult[0]['meta_robots'];
			$this->strView =   $this->arrResult[0]['template'];

			// Social media
			$this->strFacebookTitle =  $this->arrResult[0]['facebook_title'];
			$this->strFacebookDescription =  $this->arrResult[0]['facebook_description'];
			$this->strFacebookImage =  $this->arrResult[0]['facebook_image'];
			$this->strTwitterTitle =  $this->arrResult[0]['twitter_title'];
			$this->strTwitterDescription =  $this->arrResult[0]['twitter_description'];
			$this->strTwitterImage =  $this->arrResult[0]['twitter_image'];
			$this->strGoogleDescription = $this->arrResult[0]['google_description'];

            $this->strVideoEmbed = $this->arrResult[0]['video_embed'];
            $this->strVideoSmallHeading = $this->arrResult[0]['video_smallheading'];
            $this->strVideoLargeHeading = $this->arrResult[0]['video_largeheading'];
            $this->strVideoText = $this->arrResult[0]['video_text'];
            $this->strVideoBtnText = $this->arrResult[0]['video_buttontext'];
            $this->strVideoLink = $this->arrResult[0]['video_link'];

		} else {
			//page not found
			$this->intID = null;
			$this->strTitle = 'Page not found';
			$this->strContent =  "Sorry, but the page you were trying to view does not exist.";
			$this->strFocusKeyword =  '';
			$this->blnShowFeatured = false;
			$this->strMetaTitle =  '404 not found';
			$this->strMetaKeywords =  '';
			$this->strMetaDescription = '';
			$this->strMetaRobots = 'noindex,nofollow';
			$this->strView =   'page';
		}

	}



	public function getPageData($debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		FROM $this->strTableName
		WHERE slug
		LIKE '$this->strTableSlug'
		LIMIT 0,1";


		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


		if($this->query($this->strQuery)) {
			$result = $this->getMysqliResults($this->strQuery,true);

			if (!empty($result)) {
				// Set our display image
				$displayImage = $result[0]['display_image'];
				if (!empty($displayImage) && is_file(ROOT_DIR.$displayImage)) {
					$this->strDisplayImage = ROOT_URL.$displayImage;
				}
			}

			if($debug) {
			 	Util::debugDisplay($result);
			}


	     	return $result;
	    } else {
	     	return null;
	    }
	}


	public function setMetaData($title, $desc, $keywords, $robots, $debug = false) {

		$this->strTitle = $title;
		$this->strMetaTitle = $title;
		$this->strMetaKeywords =  $keywords;
		$this->strMetaDescription =  $desc;
		$this->strMetaRobots =   $robots;

	}


	public function getSlideImages($intID) {
		$this->strQuery = "SELECT * FROM page_img WHERE `page_id` = '$intID' ORDER BY blnPrimary DESC, display_order";
		$result = $this->getMysqliResults($this->strQuery, true);
		if (!empty($result)) {
			return $result;
		} else {
			return false;
		}
	}

	public function getAds($debug = false) {
		$this->strQuery = "SELECT * FROM ads WHERE `status` = 'Active' ORDER BY rand() LIMIT 0,2";


		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		$result = $this->getMysqliResults($this->strQuery, true);
		if (!empty($result)) {
			return $result;
		} else {
			return false;
		}
	}


	public function getPackageList($pgSize, $pg, $sortBy,$sortOrder,$searchWord, $status, $state, $country, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM feature_packages t
	    Left join region r on r.`id`=t.`region_id`
	    Left join state s on s.`id`=r.`state_id`
	    WHERE t.id in (
			SELECT packageID FROM feature_packages_course WHERE courseID in (
				SELECT course_id
				FROM brand_courses c
				LEFT JOIN course c2 ON c2.id=c.course_id
				WHERE c.brand_id=18
				AND c2.status='Active'
			)
		)
		AND t.id in (
			SELECT packageID FROM feature_packages_hotel WHERE hotelID in (
				SELECT hotel_id
				FROM brand_hotels h
				LEFT JOIN hotel h2 ON h2.id=h.hotel_id
				WHERE brand_id=18
				AND h2.status='Active'
			)
		)
		AND t.start_date < '".date('Y-m-d')."'
		AND t.end_date >= '".date('Y-m-d')."' ";

	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.title like '%$searchWord%' )";
	    }

	    if($state != ''){
	    	$this->strQuery1 .= "AND (r.state_id=$state)";
	    }

	    if($country != ''){
	    	$this->strQuery1 .= "AND (s.country_id != $country)";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*
	     FROM feature_packages t
	     Left join region r on r.`id`=t.`region_id`
	     Left join state s on s.`id`=r.`state_id`
	     WHERE region_id is not null ";



	    $this->strQuery = "SELECT t.*, r.`region_name`, COALESCE(short_description,description) As excerpt
	    FROM feature_packages t
	    LEFT JOIN region r on r.`id`=t.`region_id`
	    Left join state s on s.`id`=r.`state_id`
	    WHERE t.id in (
			SELECT packageID FROM feature_packages_course WHERE courseID in (
				SELECT course_id
				FROM brand_courses c
				LEFT JOIN course c2 ON c2.id=c.course_id
				WHERE c.brand_id=18
				AND c2.status='Active'
			)
		)
		AND t.id in (
			SELECT packageID FROM feature_packages_hotel WHERE hotelID in (
				SELECT hotel_id
				FROM brand_hotels h
				LEFT JOIN hotel h2 ON h2.id=h.hotel_id
				WHERE brand_id=18
				AND h2.status='Active'
			)
		)
		AND t.start_date < '".date('Y-m-d')."'
		AND t.end_date >= '".date('Y-m-d')."' ";



		//echo $this->strQuery."<br /><br />";




	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.title like '%$searchWord%' )";
		 }

	     if($state != ''){
	    	$this->strQuery .= "AND (r.state_id=$state)";
	     }

	     if($country != ''){
	    	$this->strQuery .= "AND (s.country_id != $country)";
	     }

		 $this->strQuery .= " ORDER BY priority DESC, RAND() ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}


	public function getPackageListForCourse($courseID, $limit, $country, $debug = false) {


		$this->strQuery = "SELECT t.*
	     FROM feature_packages t
	     Left join region r on r.`id`=t.`region_id`
	     Left join state s on s.`id`=r.`state_id`
	    WHERE t.id in (SELECT packageID FROM feature_packages_course WHERE courseID=$courseID)
	    AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."'  ";


	    if($country != ''){
	    	$this->strQuery .= "AND (s.country_id != $country)";
	    }

	    $this->strQuery .= " LIMIT 0,$limit ";

		if($debug) {
			Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {
			return $this->getMysqliResults($this->strQuery,true);
		} else {
			return null;
		}


	}


	public function getPackageListForHotel($hotelID, $limit,  $debug = false) {


		$this->strQuery = "SELECT t.*
	     FROM feature_packages t
	    WHERE t.id in (SELECT packageID FROM feature_packages_hotel WHERE hotelID=$hotelID)
	    AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."'  ";


	   // if($country != ''){
	    	//$this->strQuery .= "AND (s.country_id != $country)";
	    //}

	    $this->strQuery .= " LIMIT 0,$limit ";

		if($debug) {
			Util::debugDisplay($this->strQuery);
			//die();
		}

		if($this->query($this->strQuery)) {
			return $this->getMysqliResults($this->strQuery,true);
		} else {
			return null;
		}


	}



	public function getPackageListForRegion($regionID, $limit, $country, $debug = false) {


		$this->strQuery = "SELECT t.*
	     FROM feature_packages t
	     Left join region r on r.`id`=t.`region_id`
	     Left join state s on s.`id`=r.`state_id`
	    WHERE (t.id in
	    	(SELECT packageID
	    		FROM feature_packages_course
	    		WHERE courseID in
	    		(SELECT course_id FROM course_region WHERE region_id=$regionID)
	    	)
		or  t.id in
	    	(SELECT packageID
	    		FROM feature_packages_hotel
	    		WHERE hotelID in
	    		(SELECT hotel_id FROM hotel_region WHERE region_id=$regionID)
	    	))
		AND t.start_date < '".date('Y-m-d')."'
		AND t.end_date >= '".date('Y-m-d')."'
		ORDER BY RAND()
		";


	    if($country != ''){
	    	$this->strQuery .= "AND (s.country_id != $country)";
	    }

	    $this->strQuery .= " LIMIT 0,$limit ";

		if($debug) {
			Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {
			return $this->getMysqliResults($this->strQuery,true);
		} else {
			return null;
		}


	}
}