<?php


class Hotel extends Database  {

	public $strQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strFocusKeyword;
	public $strTitle;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $strSearchWord;
	public $strDisplayImage;
	public $strFacebookTitle;
	public $strOGImage;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'hotel';

	}


	public function updateHits($id, $debug = false) {

		$this->strQuery = "UPDATE $this->strTableName SET hit_counter=hit_counter+1 WHERE id=$id";
		if($debug) {
			Util::debugDisplay($this->strQuery);
		}

		$this->short_query($this->strQuery);
	}


	public function getHotelDetailById($id) {

		$this->strQuery = "SELECT t.* , c.id As country_id, s.id As state_id,
		ci.title As city, s.state_name, c.country_name, r.latitude As rlat, r.longitude As rlong, r.zlevel AS rzlevel,
			(SELECT file_name FROM hotel_img WHERE hotel_id=t.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As main_image
		From $this->strTableName t
		Left Join city ci on ci.id=t.city_id
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.id='".$id."'
		LIMIT 0,1";

		// echo $this->strQuery;

		if($this->query($this->strQuery)) {
			$result = $this->getMysqliResults($this->strQuery,true);
	     	return $result[0];
	    } else {
	     	return null;
	    }
	}


	public function getHotelDetail($slug) {

		//page specific SEO settings. These may override the default settings.
		/*
		$this->strQuery = "SELECT
			t.* ,
			c.id As country_id,
			s.id As state_id,
			t.`file_name` As logo,
			ci.title As city,
			s.state_name,
			c.country_name,
			r.latitude As rlat,
			r.longitude As rlong,
			r.zlevel AS rzlevel,
			r.id AS region_id,
			r.slug AS region_slug,
			description As comments,
			(SELECT file_name FROM hotel_img WHERE hotel_id=t.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As display_image
		From $this->strTableName t
		Left Join city ci on ci.id=t.city_id
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.slug='".$slug."'
		LIMIT 0,1";
		*/


		$this->strQuery = "SELECT
			t.* ,
			c.id As country_id,
			s.id As state_id,
			t.`file_name` As logo,
			ci.title As city,
			s.state_name,
			c.country_name,
			description As comments,
			(SELECT file_name FROM hotel_img WHERE hotel_id=t.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As display_image
		From $this->strTableName t
		Left Join city ci on ci.id=t.city_id
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.slug='".$slug."'
		LIMIT 0,1";





		// echo $this->strQuery;

		if($this->query($this->strQuery)) {
			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];

			//set the SEO details at the same time
			$this->strMetaTitle = $result['meta_title'] != '' ? $result['meta_title'] : $result['hotel_name'] . ' ' . $result['state_name'];
	        $this->strTitle = $this->strMetaTitle;
	        $this->strMetaKeywords = $result['meta_keywords'];
	        $this->strMetaDescription = $result['meta_description'] != '' ? $result['meta_description'] : Util::shortenString($result['comments'], 30);
	        $this->strMetaRobots = $result['meta_robots'];
	        $this->strOGImage = $result['file_name'];
	        $this->strFacebookTitle = $result['facebook_title'];
	        $this->strFacebookDescription = $result['facebook_title'];
	        $this->strTwitterTitle = $result['twitter_title'];
	        $this->strTwitterDescription = $result['twitter_description'];
	        $this->strGoogleDescription = $result['google_description'];

	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getHotelList($pgSize, $pg, $sortBy,$sortOrder,$searchWord, $status, $country, $state, $city, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE region_id is not null ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    if($city != ''){
	    	$this->strQuery1 .= "AND (t.city_id = $city )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name , r.region_name, t.`file_name` As logo,
			coalesce((SELECT file_name FROM hotel_img WHERE hotel_id=t.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1),file_name) As primary_image
	     From $this->strTableName t
	     Left Join members m on m.id=t.member_id
	     Left Join course_type c on c.id=t.type_id
	     Left Join region r on r.id=t.region_id
	     WHERE region_id is not null ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($city != ''){
	    	$this->strQuery .= "AND (t.city_id = $city )";
	     }



		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}


	public function getHotelListByRegion($pgSize, $pg, $sortBy,$sortOrder,$searchWord, $status, $region, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE region_id is not null ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    if($region != ''){
	    	$this->strQuery1 .= "AND t.id in (select hotel_id FROM hotel_region WHERE region_id=$region)";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name , r.region_name, t.`file_name` As logo
	     From $this->strTableName t
	     Left Join members m on m.id=t.member_id
	     Left Join course_type c on c.id=t.type_id
	     Left Join region r on r.id=t.region_id
	     WHERE region_id is not null ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

	    if($region != ''){
	    	$this->strQuery .= "AND t.id in (select hotel_id FROM hotel_region WHERE region_id=$region)";
	    }



		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}




	public function getHotelPhotos($id, $debug = false) {

		$this->strQuery = "SELECT p.*
		FROM hotel_img p
		WHERE hotel_id=".$id." AND status='Active' ORDER BY display_order";

		//echo $this->strQuery;
		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }
		if($this->query($this->strQuery)) {
			if($result = $this->getMysqliResults($this->strQuery,true)) {
	     		return $result;
	     	}
	    }
	    return null;
	}

	public function getHotelVideos($id, $debug = false) {

		$this->strVideoQuery = "SELECT v.*
		FROM hotel_videos v
		WHERE hotel_id=".$id." ORDER BY display_order";

		//echo $this->strQuery;
		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }
		if($this->query($this->strVideoQuery)) {
			if($result = $this->getMysqliResults($this->strVideoQuery,true)) {

	     		return $result;
	     	}
	    }
	    return null;
	}

	public function getHotelFiles($id, $debug = false) {

		$this->strVideoQuery = "SELECT f.*, coalesce(description,file_name) As name
		FROM hotel_files f
		WHERE hotel_id=".$id;

		//echo $this->strQuery;
		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }
		if($this->query($this->strVideoQuery)) {
			if($result = $this->getMysqliResults($this->strVideoQuery,true)) {

	     		return $result;
	     	}
	    }
	    return null;
	}


	public static function getRating($intRating) {
		$intRating = intval($intRating);

        // Exit if empty
        if (empty($intRating)) {
            return '';
        }

        // Reduce the scaling
        $fltReduced = ($intRating / 10) * 5; // Reduce to */5
        $fltRating = round($fltReduced * 2, 0) / 2; // round to closest .5

        // Build the ratings
        $strRatings = '';
        for ($i=0; $i<5; $i++) {
            $strActive = '';

            // Set the icon
            if ($fltRating <= $i) {
                $strIcon = 'fa-star-o';
            } else if($fltRating > $i && $fltRating < ($i+1)) {
                $strIcon = 'fa-star-half-o';
                $strActive = 'active';
            } else {
                $strIcon = 'fa-star';
                $strActive = 'active';
            }

            $strRatings .= '<li><span class="fa ' . $strIcon . ' ' . $strActive . '"></span></li>';
        }

        $strReturn = '<ul class="rating rating-hotel list-inline">'
                   . '<li class="rating-title">Rating:</li>'
                   . $strRatings
                   . '<li><a href="/hotel-ratings-guide/" target="_blank" class="fa fa-info-circle rating-info"></a></li>'
                   . '</ul>';

        return $strReturn;
	}

}
?>