<?php


class Group extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strGroupName;
	public $strSlug;
	public $strStatus;
	public $intID;
	public $strAction;

	public $intLevel;


	public function __construct($strPageId = null,$strAction = null) {

		parent::__construct();

		$this->strErrorMessage = "";
		$this->strTableName = 'groups';

		if(empty($strPageId) && empty($strAction)){
			// called from another page, we don't need all the page setup
			return;
		}

		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/quote/';

		$this->strTitle = 'Quote Groups';
	}

	public static function createGroup($strGroupName = null){
		// create a new quote group you can add quotes too

		// create new instance of this model to do operations too
		$objModel = new static;

		// insert new db record
		$arrKeys = array('status');
		$arrValues = array("'Active'");

		if(!empty($strGroupName)){
			$arrKeys[] = 'group_name';
			$arrValues[] = "'" . str_replace("'", "\'", $strGroupName) . "'";
		}

		$objModel->strQuery = 'INSERT INTO `' . $objModel->strTableName . '` (' . implode(',', $arrKeys) . ') VALUES (' . implode(',', $arrValues) . ') ';

		if($objModel->short_query($objModel->strQuery)) {
			$objModel->strSuccessMessage = 'Record Created';
		} else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		// return group id that was just created
		return $objModel->mysqli->insert_id;
	}


}



?>