<?php


class Featured extends Database  {

	public $strQuery;
	public $strVideoQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTitle;
	public $strContent;
	public $strView ;
	public $strTableSlug ;
	public $arrDetails ;
	public $arrPackages ;
	public $arrPackage ;
	public $intStep ;
	public $strBaseUrl  ;
	public $strIdentUrl   ;
	public $strDisplayImage;
	public $intCityId;
	public $intCountryId;
	public $intStateId;
	public $blnDateFlex = 'no';
	public $strDatesArrival;
	public $strDatesDepart;
	public $intNumberGolfers;
	public $strPg = 1;
	public $strSortBy;
	public $strSortOrder ;
	public $arrCourse;
	public $arrHotel;
	public $strUserName ;
	public $strUserEmail ;
	public $strUserPhone ;
	public $strCell ;
	public $arrBrandDetails;
	public $strMetaKeywords;
	public $strMetaTitle;
	public $strMetaDescription;
	public $strMetaRobots;
	public $strSearchWord;
	public $strFocusKeyword;
	public $strFacebookTitle;
	public $strOGImage;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;
    public $intAdwordsLead;
    public $strRecaptcha;
    public $strTellUs;

    public $strVideoEmbed;
    public $strVideoSmallHeading;
    public $strVideoLargeHeading;
    public $strVideoText;
    public $strVideoBtnText;
    public $strVideoLink;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'feature_packages';
		$this->intPageCount = 0;
		//$this->strSortBy = 'priority';
		//$this->strSortOrder = 'DESC';
		$this->intStep = isset($_GET['step']) ? $_GET['step'] : 1;
		$this->strbrandSlug = isset($_GET['brandID']) ? $_GET['brandID'] : '';
		$this->strPgSize = isset($_REQUEST['pgSize']) ? $_REQUEST['pgSize'] : 50;
		$this->intRegionId = isset($_REQUEST['region']) ? $_REQUEST['region'] : 0;
		$this->intPackageId = isset($_GET['packageID']) ? $_GET['packageID'] : '';

		$this->intAdwordsLead  = (isset($_SESSION['adwords_lead']) && $_SESSION['adwords_lead']) ? 1 : 0;

	}


	public function init() {
		//gets all the background info for the brand
		$this->arrDetails = $this->getBrandDetail($this->strbrandSlug,false);









		if($this->intStep == 1){

			//$this->arrPackages = $this->getPackages();
			$this->arrPackages = $this->getPackageListByBrand($this->strPgSize, $this->strPg,
				'', 'Active', $this->arrDetails['id'], $this->strDatesArrival, $this->strDatesDepart, false);

		} else if($this->intStep == 2) {

			$this->arrPackage = $this->getPackageDetail('',$this->intPackageId ,false);


			//echo 'here';
		} else if($this->intStep == 3) {

			$this->arrPackage = $this->getPackageDetail('',$this->intPackageId ,false);


			if(isset($_POST['Submit']) && $_POST['Submit'] != '')
				$this->handlePost($_POST,$this->arrPackage);

		}
	}





	public function getBrandDetail($slug,$debug=false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT b.*,
		c.id As country_id,
		s.id As state_id,
		b.address As business_address,
		b.phone As business_phone,
		b.business_name,
		b.tollfree As business_tollfree,
		b.zip As business_zip,
		b.fax As business_fax,
		c2.title As business_city,
		b.display_image As business_logo,
		b.contact_email As business_email,
		b.terms As business_terms,
		s.state_name As business_state,
		b.background_color,
		b.text_color
		From brands b
		Left Join region r on r.id=b.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		Left Join city c2 on c2.id=b.city_id
		WHERE b.slug='$slug'
		LIMIT 0,1";

		//echo $this->strQuery;

		if($debug) {
			Util::debugDisplay($this->strQuery);
		}


		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);

			$result = $result[0];

			$this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
			$this->blnLinks = isset($result['blnLinks']) ? $result['blnLinks'] : '';
			$this->blnLogo = isset($result['blnLogo']) ? $result['blnLogo'] : '';
			$this->strAddress = isset($result['address']) ? $result['address'] : '';
			$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
			$this->strFax = isset($result['fax']) ? $result['fax'] : '';
			$this->strTollFree = isset($result['tollfree']) ? $result['tollfree'] : '';
			$this->strContactEmail = isset($result['contact_email']) ? $result['contact_email'] : '';
			$this->strContactPerson = isset($result['contact_person']) ? $result['contact_person'] : '';
			$this->strContactEmail2 = isset($result['contact_email2']) ? $result['contact_email2'] : '';
			$this->strContactPerson2 = isset($result['contact_person2']) ? $result['contact_person2'] : '';
			$this->strWebUrl = isset($result['web_url']) ? $result['web_url'] : '';
			$this->strEmailText = isset($result['email_text']) ? $result['email_text'] : '';
			$this->strInquiryText = isset($result['inquiry_text']) ? $result['inquiry_text'] : '';
			$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
			$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
			$this->strMiniPageText = isset($result['mini_email_text']) ? $result['mini_email_text'] : '';
			$this->strTerms = isset($result['terms']) ? $result['terms'] : '';
			$this->strTextColor = isset($result['text_color']) ? $result['text_color'] : '';
			$this->strBackgroundColor = isset($result['background_color']) ? $result['background_color'] : '';
			$this->strTVoucherText1 = isset($result['voucher_text_1']) ? $result['voucher_text_1'] : '';
			$this->strTVoucherText2 = isset($result['voucher_text_2']) ? $result['voucher_text_2'] : '';
			$this->strTVoucherText3 = isset($result['voucher_text_3']) ? $result['voucher_text_3'] : '';
			$this->strTVoucherText4 = isset($result['voucher_text_4']) ? $result['voucher_text_4'] : '';
			$this->strTVoucherText5 = isset($result['voucher_text_5']) ? $result['voucher_text_5'] : '';
			$this->intRegionId = isset($result['region_id']) ? $result['region_id'] : '';
			$this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
			$this->strBrandLogo = isset($result['business_logo']) ? $result['business_logo'] : '';
			$this->strBusinessTollFree = isset($result['business_tollfree']) ? $result['business_tollfree'] : '';
			$this->strBusinessCity = isset($result['business_city']) ? $result['business_city'] : '';
			$this->strBusinessPhone = isset($result['business_phone']) ? $result['business_phone'] : '';
			$this->strBusinessAddress = isset($result['business_address']) ? $result['business_address'] : '';
			$this->strBusinessProv  = isset($result['business_state']) ? $result['business_state'] : '';
			$this->strBusinessFax    = isset($result['business_fax']) ? $result['business_fax'] : '';
			$this->strBusinessZip    = isset($result['business_zip']) ? $result['business_zip'] : '';
			$this->strBusinessEmail    = isset($result['business_email']) ? $result['business_email'] : '';
			$this->strTerms = isset($result['business_terms']) ? $result['business_terms'] : '';

			$this->strSlug = '/partner/'.$this->strSlug;
	     	return $result;
	    } else {
	     	return null;
	    }
	}








	public function handlePost($post, $arrPackage){
        $this->strUserName      = isset($post['user_name']) ? $post['user_name'] : '';
        $this->strUserEmail     = isset($post['user_email']) ? $post['user_email'] : '';
        $this->strUserPhone     = isset($post['phone']) ? $post['phone'] : '';
        $this->strCell          = isset($post['cell']) ? $post['cell'] : '';
        $this->strDatesArrival  = isset($post['dates_arrival']) ? $post['dates_arrival'] : '';
        $this->strDatesDepart   = isset($post['dates_depart']) ? $post['dates_depart'] : '';
        $this->blnDateFlex      = isset($post['date_flex']) ? $post['date_flex'] : '';
        $this->intNumberGolfers = isset($post['number_golfers']) ? $post['number_golfers'] : '';
        $this->strRecaptcha     = isset($post['g-recaptcha-response']) ? $post['g-recaptcha-response'] : '';
        $this->strTellUs        = isset($post['tell_us']) ? $post['tell_us'] : '';
        $this->intSessionId     = session_id();

        $this->intAdwordsLead   = isset($_SESSION['adwords_lead']) && $_SESSION['adwords_lead'] ? 1 : 0;

        // Verify the recaptcha
        if (!Util::recaptcha($this->strRecaptcha)) {
            $this->strErrorMessage .= 'Please validate that you are not a robot<br />';
            return;
        }

		if(strpos($this->strUserEmail,".") == 0 || strpos($this->strUserEmail,"@") == 0) { $this->strErrorMessage .= "Please enter a valid email.<br />"; }
		if($this->strUserName == '') { $this->strErrorMessage .= "Please enter your name.<br />"; }
        if($this->strUserPhone == '') { $this->strErrorMessage .= "Please enter your phone number.<br />"; }
		if($this->strDatesArrival == '') { $this->strErrorMessage .= "Please enter an arrival date.<br />"; }
		if($this->strDatesDepart == '') { $this->strErrorMessage .= "Please enter an departure date.<br />"; }
        if($this->intNumberGolfers == '') { $this->strErrorMessage .= "Please enter the number of golfers.<br />"; }

		if($this->strDatesArrival < $arrPackage['start_date']) {
			$this->strErrorMessage .= "The date you have selected is not available for this package.
			Please select another date between " .$arrPackage['start_date']. " and " .$arrPackage['end_date']. "<br />";

		}

		if($this->strDatesArrival > $arrPackage['end_date']) {
			$this->strErrorMessage .= "The date you have selected is not available for this package.
			Please select another date between " .$arrPackage['start_date']. " and " .$arrPackage['end_date']. "<br />";
		}

        if ($this->strTellUs == '') {
            $this->strErrorMessage .= "Please tell us about your group.<br />";
        }

		if($this->strErrorMessage == '') {
			$this->arrBrandDetails = $this->getBrandDetail($this->strbrandSlug);

			$this->saveAsQuote($arrPackage);

			// $this->saveAsPackage($arrPackage);
			$this->sendInquiryEmail($arrPackage);
		}


	}

	public function saveAsQuote($arrPackage){
		// include required extra models
		include(ROOT_DIR . '/application/models/admin/quote_golf.php');
		include(ROOT_DIR . '/application/models/admin/quote_hotel.php');

		// save package
		$objPartner = new Partner;

		//remnant from the old system. Pipe delimited values for courses and hotels
		$objPartner->pdSelectedCourses = '';

		foreach($arrPackage['golf_course'] as $arrGolfCourse){
			$objPartner->pdSelectedCourses .= $arrGolfCourse['courseID'] . '|';
		}

		$objPartner->pdSelectedCourses = rtrim($objPartner->pdSelectedCourses, '|');

		$objPartner->pdSelectedHotels = '';

		foreach($arrPackage['hotel'] as $arrHotel){
			$objPartner->pdSelectedHotels .= $arrHotel['hotelID'] . '|';
		}

		$objPartner->pdSelectedHotels = rtrim($objPartner->pdSelectedHotels, '|');


		$keys = array(
			'user_name',
			'user_email',
			'phone',
			'cell_phone',
			'date_flex',
			'players_num',
			'dates_arrival',
			'dates_depart',
			'region_id',
			'golfcourses',
			'accommodations',
			'order_date',
			'edit_date',
			'domain',
			'brandID',
			'session_id',
			'adwords_lead'
		);

		$vals = array(
			$this->strUserName,
			$this->strUserEmail,
			$this->strUserPhone,
			$this->strCell,
			$this->blnDateFlex,
			(int)$this->intNumberGolfers,
			$this->strDatesArrival,
			$this->strDatesDepart,
			$this->intRegionId,
			$objPartner->pdSelectedCourses,
			$objPartner->pdSelectedHotels,
			date('Y-m-d'),
			date('Y-m-d'),
			$_SERVER['HTTP_HOST'],
			$this->arrBrandDetails['id'],
			$this->intSessionId,
			$this->intAdwordsLead
		);

		$objPartner->intBrandId = $this->arrBrandDetails['id'];

		$objPartner->strErrorMessage = $objPartner->mysqliinsert('quotes', $keys, $vals, '');
		$objPartner->intId = $objPartner->insert_id;
		$objPartner->strSuccessMessage = 'Record Added';

		// make child golf records
		foreach($arrPackage['golf_course'] as $arrCourse){
			$objQuoteGolf = new Quotecourses();
			$intQuoteGolfId = $objQuoteGolf->handlePost(array(
				'course_id' => $arrCourse['courseID'],
				'golfer_num' => (int)$this->intNumberGolfers
			), $objPartner->intId);
		}

		$blnDefaultHotelSet = false;
		foreach($arrPackage['hotel'] as $arrHotel){
			$objQuoteHotel = new Quotehotels();
			$intQuoteGolfId = $objQuoteHotel->handlePost(array(
				'hotel_id' => $arrHotel['hotelID'],
				'golfers' => (int)$this->intNumberGolfers,
				'people_num' => (int)$this->intNumberGolfers,
				'default' => ($blnDefaultHotelSet) ? 0 : 1,
				'validate' => false
			), $objPartner->intId);

			$blnDefaultHotelSet = true;
		}

		// generate new group for this quote to go into
		$intGroupId = Quotegroups::insertQuoteGroup($objPartner->intId);

		return $objPartner->intId;
	}


	public function setDisplayImage($img) {
		$this->strDisplayImage = $img;
	}

	public function setBaseUrl($url) {
		$this->strBaseUrl = $url;
	}

	public function setIdentUrl($url) {
		$this->strIdentUrl = $url;
	}

	public function setSlug($slug) {
		$this->strbrandSlug = $slug;
	}

	public function getPackageId($slug) {

		$this->strQuery = "SELECT r.id FROM $this->strTableName r WHERE slug='$slug'";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);

			//echo '$result='.$result[0]['id'];

	     	return $result[0]['id'];
	    } else {
	     	return null;
	    }

	}

	public function updateHits($id) {

		$this->strQuery = "UPDATE feature_packages SET hits=hits+1 WHERE id=".$id;
		//echo $this->strQuery;
		$this->short_query($this->strQuery);
	}





	public function getPackageListByBrand($pgSize, $pg, $searchWord, $status, $brand, $arrival, $departure, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);

/*
		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t
	    LEFT JOIN region r on r.`id`=t.`region_id`
	    WHERE t.id in (
			SELECT packageID FROM feature_packages_course WHERE courseID in (
				SELECT course_id
				FROM brand_courses c
				LEFT JOIN course c2 ON c2.id=c.course_id
				WHERE c.brand_id=$brand
				AND c2.status='Active'
			) AND courseID not in (
				SELECT course_id
				FROM brand_courses c
				LEFT JOIN course c2 ON c2.id=c.course_id
				WHERE c.brand_id <>$brand
				AND c2.status='Active' )

		)
		AND t.id in (
			SELECT packageID
				FROM feature_packages_hotel
				WHERE hotelID in (
					SELECT hotel_id
					FROM brand_hotels h
					LEFT JOIN hotel h2 ON h2.id=h.hotel_id
					WHERE brand_id=$brand
					AND h2.status='Active'
				) AND hotelID not in (
					SELECT hotel_id
					FROM brand_hotels h
					LEFT JOIN hotel h2 ON h2.id=h.hotel_id
					WHERE brand_id<>$brand
					AND h2.status='Active'
				)
		)
		AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."'
		";
*/


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t
	    WHERE t.id in (
			SELECT package_id FROM package_brand WHERE brand_id = $brand
		)
		AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."'
		";




	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.title like '%$searchWord%' )";
	    }

	    //if($region != ''){
	    	//$this->strQuery1 .= "AND (t.region_id=$region)";
	    //}


	    if($arrival != ''){
	    	$this->strQuery1 .= "AND (t.start_date>='$arrival')";
	    }

	    if($departure != ''){
	    	$this->strQuery1 .= "AND (t.end_date<='$departure')";
	    }


	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


		$this->strQuery = "SELECT t.*, r.`region_name`, COALESCE(short_description,description) As excerpt
	    FROM $this->strTableName t
	    LEFT JOIN region r on r.`id`=t.`region_id`
	    WHERE t.id in (
			SELECT package_id FROM package_brand WHERE brand_id = $brand
		)
		AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."'
		";


	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.title like '%$searchWord%' )";
		 }

		 //if($region != ''){
	    	//$this->strQuery .= "AND (t.region_id=$region)";
	     //}

	    if($arrival != ''){
	    	$this->strQuery .= "AND (t.start_date>='$arrival')";
	    }

	    if($departure != ''){
	    	$this->strQuery .= "AND (t.end_date<='$departure')";
	    }


		$this->strQuery .= " ORDER BY priority DESC, RAND() ";



		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}







	public function getPackageListByRegion($pgSize, $pg, $searchWord = '', $status = 'all', $region, $arrival = '', $departure = '', $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t
	    LEFT JOIN region r on r.`id`=t.`region_id`
	    WHERE t.region_id=$region
		AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."'
		";

	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.title like '%$searchWord%' )";
	    }

	    //if($region != ''){
	    	//$this->strQuery1 .= "AND (t.region_id=$region)";
	    //}


	    if($arrival != ''){
	    	$this->strQuery1 .= "AND (t.start_date<='$arrival')";
	    }

	    if($departure != ''){
	    	$this->strQuery1 .= "AND (t.end_date>='$departure')";
	    }


	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	    $this->strQuery = "SELECT t.*, r.`region_name`, COALESCE(short_description,description) As excerpt
	    FROM $this->strTableName t
	    LEFT JOIN region r on r.`id`=t.`region_id`
	    WHERE t.region_id=$region
		AND start_date < '".date('Y-m-d')."'
		AND end_date >= '".date('Y-m-d')."' ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.title like '%$searchWord%' )";
		 }

		 //if($region != ''){
	    	//$this->strQuery .= "AND (t.region_id=$region)";
	     //}

	    if($arrival != ''){
	    	$this->strQuery .= "AND (t.start_date<='$arrival')";
	    }

	    if($departure != ''){
	    	$this->strQuery .= "AND (t.end_date>='$departure')";
	    }


		$this->strQuery .= " ORDER BY priority DESC, RAND() ";



		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}













	public function getPackages($debug = false) {


		$this->strQuery = "SELECT t.id, golf_course, hotel
			FROM $this->strTableName t ";

	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


		if($this->query($this->strQuery)) {
	    	return $this->getMysqliResults($this->strQuery,true);
	    } else {
	    	return null;
	    }

	}

	public function getPackageDetail($slug = '',$id = '',$debug = false) {
		//$debug = true;

		$this->strQuery = "SELECT p.*, r.latitude As rlat, r.longitude As rlong, r.zlevel AS rzlevel, r.region_name
		From $this->strTableName p
		Left Join region r on r.id=p.region_id ";

		if($slug != ''){
			$this->strQuery .= "WHERE p.slug='".$slug."'";
		} else {
			$this->strQuery .= "WHERE p.id=".$id;
		}

		$this->strQuery .= " LIMIT 0,1";

		if($debug) {
			Util::debugDisplay($this->strQuery);
		}



		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$id = $result['id'];
			$result['golf_course'] = array();
			$result['hotel'] = array();

			$strQuery = "SELECT h.id AS hotelID, h.hotel_name As item_name, latitude, longitude, description,  level, h.slug,
			file_name As logo, address, c2.title As city, s.short_name,
			(SELECT file_name FROM hotel_img WHERE hotel_id=p.hotelID ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As display_image
			From feature_packages_hotel p
			Left Join hotel h on h.id=p.hotelID
			Left Join city c2 on c2.id=h.city_id
			Left Join state s on s.id=c2.state_id
			WHERE p.packageID=$id";




			if($this->query($strQuery)) {
	     		$result2 = $this->getMysqliResults($strQuery,true);
	     		//$this->arrHotels = $result2;
	     		$result['hotel'] = $result2;


	     		//var_dump($result2);
	     	//} else {


	     		//Util::debugDisplay($strQuery);

	     	}




	     	$strQuery = "SELECT c.id AS courseID, c.course_name As item_name, type_id, latitude, longitude, comments As description, c.slug, level,
	     	display_image As logo, address, c2.title As city,  s.short_name,
	     	(SELECT file_name FROM course_img WHERE course_id=p.courseID ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As display_image
			From feature_packages_course p
			Left Join course c on c.id = p.courseID
			Left Join city c2 on c2.id=c.city_id
			Left Join state s on s.id=c2.state_id
			WHERE p.packageID=$id";
			if($this->query($strQuery)) {
	     		$result2 = $this->getMysqliResults($strQuery,true);
	     		$this->arrCourse = $result2;
	     		$result['golf_course'] = $result2;
	     		//var_dump($result2);
	     	} else {


	     		// Util::debugDisplay($strQuery);

	     	}

	     	//Util::debugDisplay($strQuery);

	     	//set the SEO details at the same time
			$this->strMetaTitle = $result['meta_title'] != '' ? $result['meta_title'] : $result['title'];
	        $this->strTitle = $this->strMetaTitle;
	        $this->strMetaKeywords = $result['meta_keywords'];
	        $this->strMetaDescription = $result['meta_description'] != '' ? $result['meta_description'] : $result['short_description'];
	        $this->strMetaRobots = $result['meta_robots'];
	        $this->strOGImage = $result['file_name'];
	        $this->strFacebookTitle = $result['facebook_title'];
	        $this->strFacebookDescription = $result['facebook_title'];
	        $this->strTwitterTitle = $result['twitter_title'];
	        $this->strTwitterDescription = $result['twitter_description'];
	        $this->strGoogleDescription = $result['google_description'];

            $this->strVideoEmbed = $result['video_embed'];
            $this->strVideoSmallHeading = $result['video_smallheading'];
            $this->strVideoLargeHeading = $result['video_largeheading'];
            $this->strVideoText = $result['video_text'];
            $this->strVideoBtnText = $result['video_buttontext'];
            $this->strVideoLink = $result['video_link'];



	     	return $result;
	    } else {
	     	return null;
	    }
	}


	public function getCoursesForPackages($arrData,$debug = false) {

		$arrCourses = array();

		foreach($arrData As $data) {

			$id = $data['id'];
			$region_id = $data['region_id'];

			$strQuery = "SELECT c.id AS courseID, c.course_name, c.level, c.slug, c.type_id, c.teetimes_phone, latitude, longitude, comments,
	     	display_image As logo, address, c2.title As city,  s.short_name,
	     	(SELECT file_name FROM course_img WHERE course_id=p.courseID ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As primary_image
			From feature_packages_course p
			Left Join course c on c.id = p.courseID
			Left Join city c2 on c2.id=c.city_id
			Left Join state s on s.id=c2.state_id
			WHERE p.packageID=$id";

			if($debug) {
			 	Util::debugDisplay($strQuery);
			}

			if($this->query($strQuery)) {
	     		if($result2 = $this->getMysqliResults($strQuery,true)){
		     		//$this->arrCourse = $result2;

		     		foreach($result2 AS $r){
		     			$r['region_id'] = $region_id;
		     			$arrCourses[] = $r;
		     		}


		     		//var_dump($result2);
		     	}
	     	} else {


	     		//Util::debugDisplay($strQuery);

	     	}

	     }

	     return $arrCourses;

	}

	public function getHotelsForPackages($arrData,$debug = false) {

		$arrHotels = array();

		foreach($arrData As $data) {

			$id = $data['id'];
			$region_id = $data['region_id'];

			$strQuery = "SELECT h.id AS hotelID, h.hotel_name, h.level, h.slug, latitude, longitude, description,
	     	file_name As logo, address, c2.title As city,  s.short_name,
	     	(SELECT file_name FROM hotel_img WHERE hotel_id=p.hotelID ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As primary_image
			From feature_packages_hotel p
			Left Join hotel h on h.id = p.hotelID
			Left Join city c2 on c2.id=h.city_id
			Left Join state s on s.id=c2.state_id
			WHERE p.packageID=$id";

			if($debug) {
			 	Util::debugDisplay($strQuery);
			}

			if($this->query($strQuery)) {
	     		if($result2 = $this->getMysqliResults($strQuery,true)){
		     		//$this->arrCourse = $result2;
		     		//$result2[0]['region_id'] = $region_id;
		     		//$result2[0]['packageid'] = $id;
		     		//$arrHotels[] = $result2[0];
		     		foreach($result2 AS $r){
		     			$r['region_id'] = $region_id;
		     			$r['packageid'] = $id;
		     			$arrHotels[] = $r;
		     		}
		     	}
	     	} else {


	     		Util::debugDisplay($strQuery);

	     	}

	     }

	     return $arrHotels;

	}

	/*
	public function getCourses($data) {


		//var_dump($data);
		foreach( $data as $c ) {

		    $arrCourses[] = $c['courseID'];

		}
		//var_dump($arrCourses);



		if(!empty($arrCourses) > 0) {
			$arrCourses = implode(",",$arrCourses);

			$this->strQuery = "SELECT c.* ,
			(SELECT file_name FROM course_img WHERE course_id=c.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As main_image
			FROM course c
			WHERE c.id in ($arrCourses)";


			if($this->query($this->strQuery)) {

				$result = $this->getMysqliResults($this->strQuery,true);
		     	return $result;
		    } else {
		     	return null;
		    }
		}

	}


	public function getHotels($data) {


		foreach( $data as $c ) {

		    $arrHotels[] = $c['hotelID'];

		}
		//var_dump($arrCourses);

		if(!empty($arrHotels) > 0) {

			$arrHotels = implode(",",$arrHotels );

			$this->strQuery = "SELECT h.*,
			(SELECT file_name FROM hotel_img WHERE hotel_id=h.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As main_image
			FROM hotel h
			WHERE h.id in ($arrHotels)";

			if($this->query($this->strQuery)) {
				$result = $this->getMysqliResults($this->strQuery,true);
		     	return $result;
		    } else {
		     	return null;
		    }
		}

	}
	*/










	function sendInquiryEmail($arrPackage) {

		//var_dump($this->arrPackage);
		//die();

     	##############Send E-mails#############################################

	    $mail_subject = "Golf Package inquiry from ".$this->strUserName." - " . $this->arrBrandDetails['business_name'] . " -
	    Feature Package: " . $arrPackage['title'] . " (" . $arrPackage['id'] . ")";


		$inquiry_text = nl2br($this->arrBrandDetails['inquiry_text']);
		$inquiry_text = str_replace("[client_name]",$this->strUserName,$inquiry_text);

		$mail_message =  $inquiry_text .'<br /><br />';


		$mail_message .= '<table border="1" style="width:620px;" cellpadding="0" cellspacing="4" align="center" style="border-collapse: collapse" bordercolor="#517A2B">
		   <tr><td>
			 <table style="width:600px;background-color:#E9F3DE;" align="center">
				<tr><td colspan="2" height="60"><b><i>Main Info</i></b></td></tr>
				<tr>
				   <td width="28%">Your Name :</td>
				   <td>'.$this->strUserName.'</td>
				</tr>
				<tr>
				   <td>Email :</td>
				   <td>'.$this->strUserEmail.'</td>
				</tr>
				<tr>
				   <td>Phone #::</td>
				   <td>'.$this->strUserPhone.'</td>
				</tr>
				<tr>
				   <td>Cel #:</td>
				   <td>'.$this->strCell.'</td>
				</tr>
				<tr>
				   <td>Arrival:</td>
				   <td>'.$this->strDatesArrival.'</td>
				</tr>
				<tr>
				   <td>Departure:</td>
				   <td>'.$this->strDatesDepart.'</td>
				</tr>
				<tr>
				   <td>Date Flexible:</td>
				   <td>'.$this->blnDateFlex.'</td>
				</tr>
				<tr>
					<td>Number of Golfers:</td>
					<td>'.$this->intNumberGolfers.'</td>
				</tr>
                <tr>
                    <td>Tell us about your group:</td>
                    <td>'.$this->strTellUs.'</td>
                </tr>
				<tr>
					<td>Google Adwords Lead:</td>
					<td>'.(($this->intAdwordsLead=="1") ? 'yes' : 'no') .'</td>
				</tr>
				<tr><td colspan="2" height="60"><b><i>Package Info</i></b></td></tr>
				<tr><td colspan="2">';

		// domain/feature/brand-slug/packageid
		$strPackageLinkUrl = ROOT_URL . '/feature/' . $this->arrBrandDetails['slug'] . '/' . $arrPackage['id'];

		$mail_message .= '<h2><a href="' . $strPackageLinkUrl . '" target="_blank">'.$arrPackage['title'].'</a></h2></td></tr>';

		$mail_message .= '<tr><td>';
		if($arrPackage['file_name'] != '') {

			$i = Util::createImageSrc(ROOT_URL.$arrPackage['file_name'], 370, 250);
			$mail_message .= '<img src="'.$i. '" style="width:140px;margin-right:10px;">';

		}
		$mail_message .= '</td>';

		$mail_message .= '<td><p><small>Please be aware that these feature packages vary in price based on season, and # golfers sharing accommodations</small></p>';

		$mail_message .= '</td></tr>
			 </table>
			 <br />';

			 //$this->arrPackage



		 //$mail_message   .= $mail_footer;

		 //$mail_sender     = $admin_email;
		 //$mail_receiver_1 = $your_email;
		 //$mail_receiver_2 = $admin_mail;
		 //$mail_receiver_3 = 'danny@bcgolfguide.com';
		 //die($mail_message);

        // setup emails
		$headers = "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

        // email user
        
        $userHeaders = "From: " . strip_tags($this->arrBrandDetails['contact_email']) . "\r\n"
                     . "Reply-To: ". strip_tags($this->arrBrandDetails['contact_email']) . "\r\n"
                     . $headers;
        Util::sendMailCore($this->strUserEmail, $mail_subject, $mail_message, $userHeaders);

		$this->strSuccessMessage = "Your request has been submitted.";

        // email brand contacts
        
        $adminemail = 'requests@bcgolfguide.com';
        
        // $brandContactHeaders = "From: " . $this->strUserEmail . "\r\n"
        //                      . "Reply-To: ". $this->strUserEmail . "\r\n"
        //                      . $headers;
        $brandContactHeaders = "From: " . $adminemail . "\r\n"
                             . "Reply-To: ". $this->strUserEmail . "\r\n"
                             . $headers;


		if($this->arrBrandDetails['contact_email'] != ''){
			Util::sendMailCore($this->arrBrandDetails['contact_email'], $mail_subject, $mail_message, $brandContactHeaders);
		}

		if($this->arrBrandDetails['contact_email2'] != ''){
			Util::sendMailCore($this->arrBrandDetails['contact_email2'], $mail_subject, $mail_message, $brandContactHeaders);
		}


		 //sendemail99HTML ($mail_receiver_1,$mail_sender,$mail_message,$mail_subject);
		// sendemail99HTML ($mail_receiver_2,$mail_sender,$mail_message,$mail_subject);
		// sendemail99HTML ($mail_receiver_3,$mail_sender,$mail_message,$mail_subject);
		 #######################################################################



	}

	function saveAsPackage($arrPackage){
		// var_dump($arrPackage, $this);
		// die();

		// save package
		$objPartner = new Partner;

		//remnant from the old system. Pipe delimited values for courses and hotels
		$objPartner->pdSelectedCourses = '';

		foreach($arrPackage['golf_course'] as $arrGolfCourse){
			$objPartner->pdSelectedCourses .= $arrGolfCourse['courseID'] . '|';
		}

		$objPartner->pdSelectedCourses = rtrim($objPartner->pdSelectedCourses, '|');

		$objPartner->pdSelectedHotels = '';

		foreach($arrPackage['hotel'] as $arrHotel){
			$objPartner->pdSelectedHotels .= $arrHotel['hotelID'] . '|';
		}

		$objPartner->pdSelectedHotels = rtrim($objPartner->pdSelectedHotels, '|');

		$keys = array(
			'user_name',
			'user_email',
			'phone',
			'cell_phone',
			'date_flex',
			'players_num',
			'dates_arrival',
			'dates_depart',
			'region_id',
			'golfcourses',
			'accommodations',
			'order_date',
			'edit_date',
			'domain',
			'brandID'
		);

		$vals = array(
			$this->strUserName,
			$this->strUserEmail,
			$this->strUserPhone,
			$this->strCell,
			$this->blnDateFlex,
			$this->intNumberGolfers,
			$this->strDatesArrival,
			$this->strDatesDepart,
			$this->intRegionId,
			$objPartner->pdSelectedCourses,
			$objPartner->pdSelectedHotels,
			date('Y-m-d'),
			date('Y-m-d'),
			$_SERVER['HTTP_HOST'],
			$this->arrBrandDetails['id']
		);

		$objPartner->intBrandId = $this->arrBrandDetails['id'];

		$objPartner->strErrorMessage = $objPartner->mysqliinsert('packages', $keys, $vals, '');
		$objPartner->intId = $objPartner->insert_id;
		$objPartner->strSuccessMessage = 'Record Added';

		// save hotels


		// save courses

		return $objPartner->intId;
	}



}
?>