<?php


class Cron extends Database  {

    public $strQuery;
    public $strQuery1;
    public $arrResult;
    public $arrPages;
    public $records = 1;
    public $intPageCount;
    public $intAffectedRows;
    public $strErrorMessage;
    public $strSuccessMessage;
    public $strTableName;
    public $strTableSlug;

    public function __construct($strPageId = '',$strAction = '') {
        parent::__construct();
        $this->strErrorMessage = '';
        $this->strTableName = '';
        $this->strTableSlug = $strPageId;
    }

    public static function getEmailList($strCron) {
        $objCron = new static;
        $objCron->strQuery = "SELECT booking_email FROM booking_people WHERE status = 'Active' AND $strCron = 1";

        $arrReturn = array();

        $arrEmails = $objCron->getMysqliResults($objCron->strQuery, true);

        foreach ($arrEmails AS $arrEmail) {
            $arrReturn[] = $arrEmail['booking_email'];
        }

        return $arrReturn;
    }

    public static function getPackagesUpcoming($arrArgs = array()) {
        // Set default arguments
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'date_range' => 45
        ));

        // Set variables
        $objCron = new static;
        $intDateRange = $arrArgs['date_range'];

        // Array that is returned;
        $arrPackages = array();
       
        // Start the query
        $objCron->strQuery = 'SELECT `q`.* FROM'
                            .   ' (SELECT'
                            .   ' `p`.`id`,'
                            .   ' `p`.`group_name`,'
                            .   ' `ph`.`check_in_date`,'
                            .   ' SUM(`phd`.`package_price`) AS `package_total`,'
                            .   ' SUM(`phd`.`deposit_price`) AS `package_paid`,'
                            .   ' (SELECT booking_name FROM booking_people h WHERE h.id = (SELECT booking_people_id FROM package_booking_people WHERE package_id=p.id AND primary_contact=1 )) AS booking_agent, '
                            .   ' `p`.`phone` AS `group_contact_phone`,'
                            .   ' `s`.`status_name` AS `package_status`'
                            .   ' FROM `packages` `p`'
                            .   ' LEFT JOIN `package_hotel` `ph`'
                            .   ' ON `p`.`id` = `ph`.`package_id`'
                            .   ' LEFT JOIN `package_hotel_detail` `phd`'
                            .   ' ON `ph`.`id` = `phd`.`package_hotel_id`'
                            .   ' LEFT JOIN `order_status` `s` ON `s`.`id`=`p`.`completed`'
                            .   ' WHERE 1=1'
                            .   ' AND `p`.`blnNotify` = 1'
                            .   ' AND `ph`.`default` = 1'
                            .   ' AND `ph`.`check_in_date` BETWEEN NOW() AND DATE_SUB(NOW(), INTERVAL -' . $intDateRange . ' day)'
                            .   ' GROUP BY `ph`.`package_id`'
                            .   ' ) `q`'
                            //. ' WHERE (`q`.`package_total` - `q`.`package_paid`) > 0'
                            . ' ORDER BY `q`.`check_in_date` DESC;';

        // Get the packages
        $arrPackages = $objCron->getMysqliResults($objCron->strQuery, true);

        return $arrPackages;
    }

    public static function getPackagesOverdue($arrArgs = array()) {
        // Set default arguments
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'date_range' => 45,
        ));

        // New DB object
        $objCron = new static;
        $intDateRange = $arrArgs['date_range'];

        // Array that is returned;
        $arrPackages = array();
       
        // Start the query
        // Similar to the upcoming query except the interval isn't negative
        // and the ordering of the results is ascending
        $objCron->strQuery  = 'SELECT `q`.* FROM'
                            .   ' (SELECT'
                            .   ' `p`.`id`,'
                            .   ' `p`.`group_name`,'
                            .   ' `ph`.`check_in_date`,'
                            .   ' SUM(`phd`.`package_price`) AS `package_total`,'
                            .   ' SUM(`phd`.`deposit_price`) AS `package_paid`,'
                            .   ' (SELECT booking_name FROM booking_people h WHERE h.id = (SELECT booking_people_id FROM package_booking_people WHERE package_id=p.id AND primary_contact=1 )) AS booking_agent, '
                            .   ' `p`.`phone` AS `group_contact_phone`,'
                            .   ' `s`.`status_name` AS `package_status`'
                            .   ' FROM `packages` `p`'
                            .   ' LEFT JOIN `package_hotel` `ph`'
                            .   ' ON `p`.`id` = `ph`.`package_id`'
                            .   ' LEFT JOIN `package_hotel_detail` `phd`'
                            .   ' ON `ph`.`id` = `phd`.`package_hotel_id`'
                            .   ' LEFT JOIN `order_status` `s` ON `s`.`id`=`p`.`completed`'
                            .   ' WHERE 1=1'
                            .   ' AND `p`.`blnNotify` = 1'
                            .   ' AND `ph`.`default` = 1'
                            .   ' AND `ph`.`check_in_date` BETWEEN DATE_SUB(NOW(), INTERVAL ' . $intDateRange . ' day) AND NOW() '
                            .   ' GROUP BY `ph`.`package_id`'
                            .   ' ) `q`'
                            . ' WHERE (`q`.`package_total` - `q`.`package_paid`) > 0'
                            . ' ORDER BY `q`.`check_in_date` ASC;';

        // Get the packages
        $arrPackages = $objCron->getMysqliResults($objCron->strQuery, true);

        return $arrPackages;
    }

}