<?php


class Course extends Database  {

	public $strQuery;
	public $strVideoQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strFocusKeyword;
	public $strTitle;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $strSearchWord;
	public $strDisplayImage;
	public $strFacebookTitle;
	public $strOGImage;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'course';
		$this->intPageCount = 0;

	}


	public function updateHits($id, $debug = false) {

		$this->strQuery = "UPDATE $this->strTableName SET hit_counter=hit_counter+1 WHERE id=$id";
		if($debug) {
			Util::debugDisplay($this->strQuery);
		}

		$this->short_query($this->strQuery);
	}

	public function getCourseDetailById($id) {

		$this->strQuery = "SELECT t.* , c.id As country_id, s.id As state_id,
		ci.title As city, s.state_name, c.country_name, r.latitude As rlat, r.longitude As rlong, r.zlevel AS rzlevel,
			(SELECT file_name FROM course_img WHERE course_id=t.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1) As main_image
		From $this->strTableName t
		Left Join city ci on ci.id=t.city_id
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.id='".$id."'
		LIMIT 0,1";


		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
	     	return $result[0];
	    } else {
	     	return null;
	    }
	}


	public function getCourseDetail($slug, $debug = false) {
/*
		$this->strQuery = "SELECT
			t.* ,
			c.id As country_id,
			s.id As state_id,
			ci.title As city,
			s.state_name,
			c.country_name,
			r.latitude As rlat,
			r.longitude As rlong,
			r.zlevel AS rzlevel,
			r.slug AS region_slug,
			r.id AS region_id
		From $this->strTableName t
		Left Join city ci on ci.id=t.city_id
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.slug='".$slug."'
		LIMIT 0,1";
*/

		$this->strQuery = "SELECT
			t.* ,
			c.id As country_id,
			s.id As state_id,
			ci.title As city,
			s.state_name,
			c.country_name
		From $this->strTableName t
		Left Join city ci on ci.id=t.city_id
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.slug='".$slug."'
		LIMIT 0,1";




		//echo $this->strQuery;
		if($debug) {
			Util::debugDisplay($this->strQuery);
		}
		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];

			//set the SEO details at the same time
			$this->strMetaTitle = $result['meta_title'] != '' ? $result['meta_title'] : $result['course_name'] . ' ' . $result['state_name'];
	        $this->strTitle = $this->strMetaTitle;
	        $this->strMetaKeywords = $result['meta_keywords'];
	        $this->strMetaDescription = $result['meta_description'] != '' ? $result['meta_description'] : Util::shortenString($result['comments'], 30);
	        $this->strMetaRobots = $result['meta_robots'];
	        $this->strOGImage = $result['display_image'];
	        $this->strFacebookTitle = $result['facebook_title'];
	        $this->strFacebookDescription = $result['facebook_title'];
	        $this->strTwitterTitle = $result['twitter_title'];
	        $this->strTwitterDescription = $result['twitter_description'];
	        $this->strGoogleDescription = $result['google_description'];

	     	return $result;
	    } else {
	     	return null;
	    }
	}

	public function getCoursePhotos($id) {

		$this->strQuery = "SELECT p.*
		FROM course_img p
		WHERE course_id=".$id." AND status='Active' ORDER BY display_order";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {
			if($result = $this->getMysqliResults($this->strQuery,true)) {
	     		return $result;
	     	}
	    }
	    return null;
	}

	public function getCourseVideos($id) {

		$this->strVideoQuery = "SELECT v.*
		FROM course_videos v
		WHERE course_id=".$id." ORDER BY display_order";

		//echo $this->strQuery;

		if($this->query($this->strVideoQuery)) {
			if($result = $this->getMysqliResults($this->strVideoQuery,true)) {

	     		return $result;
	     	}
	    }
	    return null;
	}

	public function getCourseTestimonials($id) {

		$this->strQuery = "SELECT t.*
		FROM testimonial t
		WHERE course_id=".$id." ORDER BY timestamp_post DESC";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {
			if($result = $this->getMysqliResults($this->strQuery,true)) {

	     		return $result;
	     	}
	    }
	    return null;
	}



	public function getCourseReviews($id) {

		$this->strQuery = "SELECT r.*
		FROM course_reviews r
		WHERE course_id=".$id." AND approved=1 ORDER BY post_date DESC";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {
			if($result = $this->getMysqliResults($this->strQuery,true)) {

	     		return $result;
	     	}
	    }
	    return null;
	}

	public function getCourseHoleInOne($id) {

		$this->strQuery = "SELECT h.*
		FROM hole_in_ones h
		WHERE course_id=".$id." AND approved=1 ORDER BY post_date DESC";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {
			if($result = $this->getMysqliResults($this->strQuery,true)) {

	     		return $result;
	     	}
	    }
	    return null;
	}


	public function getCourseList($pgSize, $pg, $sortBy,$sortOrder,$searchWord, $status, $country, $state, $city, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE region_id is not null ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.course_name like '%$searchWord%' )";
	    }

	    if($city != ''){
	    	$this->strQuery1 .= "AND (t.city_id = $city )";
	    }



	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name , r.region_name,
			coalesce((SELECT file_name FROM course_img WHERE course_id=t.id ORDER BY blnPrimary DESC, display_order LIMIT 0,1),display_image) As primary_image
	     From $this->strTableName t
	     Left Join members m on m.id=t.member_id
	     Left Join course_type c on c.id=t.type_id
	     Left Join region r on r.id=t.region_id
	     WHERE region_id is not null ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.course_name like '%$searchWord%' )";
		 }

		 if($city != ''){
	    	$this->strQuery .= "AND (t.city_id = $city )";
	     }


		 //if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";
	     //don't overide this
	     $this->strQuery .= " ORDER BY c.display_order ASC, course_name ASC ";



	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}

	public function getCourseListbyRegion($arrArgs = array()) {
        // Set default args
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'region' => 0,
            'city' => 0,
            'state' => 0,
            'country' => 0,
            'search' => '',
            'status' => 'Active',
            'page_size' => 36,
            'page' => 1,
            'order' => 'ASC',
            'order_by' => 'course_name',
        ));

        // Set defaults
        if (empty($arrArgs['page']) || $arrArgs['page'] < 0) {
            $arrArgs['page'] = 1;
        }
        if (empty($arrArgs['page_size'])) {
            $arrArgs['page_size'] = 36;
        }

        $this->strQuery =
            "SELECT
                t.*,
                c.`type_name`,
                c.`public_note`,
                r.`region_name`,
                r.`state_id`,
                r.`country_id`
            FROM
                $this->strTableName t
                LEFT JOIN `course_type` c ON c.`id` = t.`type_id`
                LEFT JOIN `region` r ON r.`id` = t.`region_id`
            WHERE
                1=1
                AND `region_id` IS NOT NULL ";

        if ($arrArgs['status'] != 'all') {
            $this->strQuery .= ' AND t.`status` = "' . $arrArgs['status'] . '" ';
        }

        if (!empty($arrArgs['search'])) {
            $this->strQuery .= ' AND t.`course_name` LIKE "%' . $arrArgs['search'] . '%" ';
        }

        if (!empty($arrArgs['region'])) {
            $this->strQuery .= ' AND t.`region_id` = ' . $arrArgs['region'] . ' ';
        }

        if (!empty($arrArgs['city'])) {
            $this->strQuery .= ' AND t.`city_id` = ' . $arrArgs['city'] . ' ';
        }

        if (!empty($arrArgs['state'])) {
            $this->strQuery .= ' AND r.`state_id` = ' . $arrArgs['state'] . ' ';
        }

        if (!empty($arrArgs['country'])) {
            $this->strQuery .= ' AND r.`country_id` = ' . $arrArgs['country'] . ' ';
        }

        if (!empty($arrArgs['order_by'])) {
            $this->strQuery .= ' ORDER BY `' . $arrArgs['order_by'] . '` ' . $arrArgs['order'] . ' ';
        }

        // Get the count to set the pagination
        $count = count($this->getMysqliResults($this->strQuery, true));
        $this->pg = $arrArgs['page'];
        $this->intPageCount = ceil($count / $arrArgs['page_size']);

        // Restrict the results
        if ($count > $arrArgs['page_size']) {
            $start = $arrArgs['page'] > 1 ? ($arrArgs['page'] * $arrArgs['page_size']) : 0;
            $this->strQuery .= ' LIMIT ' . ($start) . ', ' . $arrArgs['page_size'];
        }

        // Valid query
        if ($this->query($this->strQuery)) {
            return $this->getMysqliResults($this->strQuery,true);
        }

        return null;
	}

	public function getFullCourseList() {


		$strQuery = "SELECT c.*, (SELECT detail FROM course_detail WHERE course_id=c.id)
		FROM $this->strTableName c where c.status = 'Active' LIMIT 0,1";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

    /**
     * Gets courses for the BC map page
     *
     */
    public function getCourseListForBC($intPackages = 0, $intOther = 0) {
        // Exit if no filters
        if (empty($intPackages) && empty($intOther)) {
            return array();
        }

        // Set the filters
        $strFilters = '';
        if ($intPackages || $intOther) {
            $strFilters .= 'AND (1=1';
            if ($intPackages) {
                $strFilters .= ' AND ct.id IN (3,7) ';
            }
            if ($intOther) {
                $strOp = $intPackages ? 'OR' : 'AND';
                $strFilters .= ' ' . $strOp . ' ct.id NOT IN (3,7) ';
            }
            $strFilters .= ')';
        }

        $strQuery =
            "SELECT
                c.*,
                ct.public_note,
                coalesce((SELECT file_name FROM course_img WHERE course_id = c.id ORDER BY blnPrimary DESC, display_order LIMIT 0, 1), display_image) AS primary_image
            FROM
                course c
                LEFT JOIN course_type ct ON c.type_id = ct.id
            WHERE
                c.status = 'Active'
                AND city_id IN (SELECT id FROM city WHERE state_id = 2)
                $strFilters
            ORDER BY course_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return array();
        }
    }

    /**
     * Checks if a course is partnered
     *
     */
    public static function isPartnered($arrCourse) {
        return in_array($arrCourse['type_id'], array(3, 7));
    }

    /**
     * Gets the rating output
     *
     */
    public static function getRating($intRating) {
        $intRating = intval($intRating);
        $fltRating = $intRating;

        // Exit if empty
        if (empty($intRating)) {
            return '';
        }

        // Build the ratings
        $strRatings = '';
        for ($i=0; $i<10; $i++) {
            $strActive = '';

            // Set the icon
            if ($fltRating <= $i) {
                $strIcon = 'fa-circle-o';
            } else if($fltRating > $i && $fltRating < ($i+1)) {
                $strIcon = 'fa-circle-dot';
                $strActive = 'active';
            } else {
                $strIcon = 'fa-circle';
                $strActive = 'active';
            }

            $strRatings .= '<span class="fa ' . $strIcon . ' ' . $strActive . '"></span>';
        }

        // Add the wrapper HTML
        $strReturn = '<ul class="rating rating-course list-inline">'
                   . '<li class="rating-title">Price:</li>'
                   . $strRatings
                   . '<li><a href="/golf-course-ratings-guide/" target="_blank" class="fa fa-info-circle rating-info"></a></li>'
                   . '</ul>';

        return $strReturn;
    }

}
?>