<?php


class User extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $arrroles = [];
	public $arrUsers;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strSlug;
	public $strContent;
	public $is_admin;
	public $permissions;
	public $getModules;


	public $strSearchWord;
	public $strDateCreated;
	public $strDateModified;
	public $strStatus;
	
	public $intID;
	public $strAction;
	public $strPubStatus;

	public function __construct($strPageId,$strAction) {

		parent::__construct();

		$this->strErrorMessage = "";
		$this->strTableName = 'admins';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/user/';

		$this->strTitle = 'Users CMS';

		$this->strDateCreated = date('Y-m-d H:i:s');
		$this->strDateModified = date('Y-m-d H:i:s');

        $this->arrroles = $this->getCategories();

	}


	public function handlePost($post,$id) {
	    
        $this->user_name = isset($post['user_name']) ? $post['user_name'] : '';
		$this->intID = isset($id) ? $id : '';
		$this->user_alias = isset($post['user_alias']) ? $post['user_alias'] : '';
		$this->user_email = isset($post['user_email']) ? $post['user_email'] : '';
		$this->user_password = isset($post['user_password']) ? $post['user_password'] : '';
		$this->repeat_password = isset($post['repassword']) ? $post['repassword'] : '';
		
		$this->strStatus = isset($post['status']) ? $post['status'] : '';
		$this->strAction = isset($post['action']) ? $post['action'] : '';
		
		$this->permissions = isset($post['permissions']) ? $post['permissions'] : [];
		
		// Required Fields
		if ($this->user_name == '') { $this->strErrorMessage .= "Please enter a username for this user.<br />"; }
		
		if($this->strAction == 'edit'){
		    $this->is_admin = $post['is_admin'];
		    
		    if ($this->user_name != '') {
    		    $this->strQuery = "SELECT * FROM admins WHERE user_name = '".$this->user_name."' And userID != ".$this->intID;
                if($this->query($this->strQuery)) {
                    $result = $this->getMysqliResults($this->strQuery,true);
                    $result = $result[0];
                    if ($result) {
                        $this->strErrorMessage .= "Username already exists.<br />";
                    }
                }
                
            }
            if ($this->user_email != '') {
                $this->strQuery = "SELECT * FROM admins WHERE user_email = '".$this->user_email."' And userID != ".$this->intID;
                if($this->query($this->strQuery)) {
                    $result = $this->getMysqliResults($this->strQuery,true);
                    $result = $result[0];
                    if ($result) {
                        $this->strErrorMessage .= "Email already exists.<br />";
                    }
                }
            }else{
                $this->strErrorMessage .= "Please enter email for this user.<br />";
            }
		    
		    if($this->user_password != ''){
	            if ($this->user_password != '' || $this->repeat_password != '') {
                    if (!preg_match('/^(?=.*[A-Z])(?=.*\d)(?=.*[a-z]).{8,}$/', $this->user_password)) {
                        $this->strErrorMessage .= "Password must be at least 8 characters long, contain at least one uppercase letter, one lowercase letter, and one number.<br />";
                    }
                }else{
                    $this->strErrorMessage .= "Please enter a Password for this user.<br />";
                }
                
                if ($this->user_password != '' && $this->repeat_password != '') {
                    if ($this->user_password !== $this->repeat_password) {
                        $this->strErrorMessage .= "Passwords do not match.<br />";
                    }
                }
                
                $thePassword = Util::bcryptString($this->user_password);
                
                $this->strQuery = "UPDATE `admins` SET user_alias='".$this->user_alias."' , user_password='".$thePassword."' ,user_email='".$this->user_email."' ,status= '".$this->strStatus."' ,is_admin= '".$this->is_admin."' ,date_modified=".Date('Y-m-d')." WHERE userID=".$id;
		    }else{
                
                $this->strQuery = "UPDATE `admins` SET user_alias='".$this->user_alias."' ,user_email='".$this->user_email."' ,status= '".$this->strStatus."' ,is_admin= '".$this->is_admin."' ,date_modified=".Date('Y-m-d')." WHERE userID=".$id;
		    }
		    
		    if($this->query($this->strQuery)) {
		        
		        $this->strQuery = "UPDATE `permissions` SET `can_add` = 0, `can_view` = 0, `can_edit` = 0, `can_delete` = 0 WHERE `userID` = ".$id;
		        if($this->query($this->strQuery)){
		               foreach ($this->permissions as $moduleID => $actions) {
        		            $can_add = isset($actions['can_add']) ? 1 : 0;
                            $can_edit = isset($actions['can_edit']) ? 1 : 0;
                            $can_delete = isset($actions['can_delete']) ? 1 : 0;
                            $can_view = isset($actions['can_view']) ? 1 : 0;
                            
                            $this->strQuery = "SELECT * FROM permissions WHERE userID=".$id." And moduleID=".$moduleID;
                            if($this->query($this->strQuery)) {
                                $result = $this->getMysqliResults($this->strQuery,true);
                                $result = $result[0];
                                if ($result) {
                                    $this->strQuery2 = "UPDATE `permissions` SET can_add='".$can_add."' ,can_edit='".$can_edit."' ,can_delete= '".$can_delete."' ,can_view= '".$can_view."' WHERE userID=".$id." And moduleID=".$moduleID;
                                    $this->query($this->strQuery2);
                                }else{
                                    $this->strQuery2 = "
                                        INSERT INTO `permissions` 
                                        (`userID`, `moduleID`, `can_add`, `can_view`, `can_edit`, `can_delete`) 
                                        VALUES 
                                        ('$id', '$moduleID', '$can_add', '$can_view', '$can_edit', '$can_delete')
                                    ";
                                    $this->query($this->strQuery2);
        
                                }
                            }
                            
        		        }
        		        
        		        $this->strQuery = "
                            SELECT 
                                m.moduleID,
                                m.module_name,
                                m.module_description,
                                m.only_view,
                                COALESCE(p.can_add, 0) AS can_add,
                                COALESCE(p.can_view, 0) AS can_view,
                                COALESCE(p.can_edit, 0) AS can_edit,
                                COALESCE(p.can_delete, 0) AS can_delete
                            FROM 
                                modules m
                            LEFT JOIN 
                                permissions p 
                            ON 
                                m.moduleID = p.moduleID AND p.userID = ".$id."
                            WHERE 
                                m.status = 1
                        ";
                        
                        if ($this->query($this->strQuery)) {
                            $result2 = $this->getMysqliResults($this->strQuery, true);
                            $this->getModules = $result2;
                        }
        		        
        		        $this->strSuccessMessage = 'Record Saved';
        		        
        		        return $this->intID;
		        }
		    }
            
		    
		}else{
		    $this->is_admin = $post['is_admin'];
		    
		    if ($this->user_name != '') {
    		    $this->strQuery = "SELECT * FROM admins WHERE user_name = '".$this->user_name."'";
                if($this->query($this->strQuery)) {
                    $result = $this->getMysqliResults($this->strQuery,true);
                    $result = $result[0];
                    if ($result) {
                        $this->strErrorMessage .= "Username already exists.<br />";
                    }
                }
                
            }
            if ($this->user_email != '') {
                $this->strQuery = "SELECT * FROM admins WHERE user_email = '".$this->user_email."'";
                if($this->query($this->strQuery)) {
                    $result = $this->getMysqliResults($this->strQuery,true);
                    $result = $result[0];
                    if ($result) {
                        $this->strErrorMessage .= "Email already exists.<br />";
                    }
                }
            }else{
                $this->strErrorMessage .= "Please enter email for this user.<br />";
            }
		    
		    if($this->strErrorMessage == '') {
            
                $thePassword = Util::bcryptString($this->user_password);
                
    			$keys = array(
                    'user_name',
                    'user_alias',
                    'user_password',
                    'user_email',
                    'user_access',
                    'status',
                    'is_admin',
                    'date_created',
                    'date_modified',
                );
                $vals = array(
                    $this->user_name,
                    $this->user_alias,
                    $thePassword,
                    $this->user_email,
                    0,
                    $this->strStatus,
                    $this->is_admin,
                    Date('Y-m-d'),
                    Date('Y-m-d'),
                );
                
                if ($this->user_password != '' || $this->repeat_password != '') {
                    if (!preg_match('/^(?=.*[A-Z])(?=.*\d)(?=.*[a-z]).{8,}$/', $this->user_password)) {
                        $this->strErrorMessage .= "Password must be at least 8 characters long, contain at least one uppercase letter, one lowercase letter, and one number.<br />";
                    }
                }else{
                    $this->strErrorMessage .= "Please enter a Password for this user.<br />";
                }
                
                if ($this->user_password != '' && $this->repeat_password != '') {
                    if ($this->user_password !== $this->repeat_password) {
                        $this->strErrorMessage .= "Passwords do not match.<br />";
                    }
                }
                
                if($this->intID == '') {
                    // Insert
                    $this->strErrorMessage = $this->mysqliinsert($this->strTableName, $keys, $vals, '');
                    $id = $this->insert_id;
                    
                    $next = false;
                    $i = 1;
                    foreach ($this->permissions as $moduleID => $actions) {
        	            $can_add = isset($actions['can_add']) ? 1 : 0;
                        $can_edit = isset($actions['can_edit']) ? 1 : 0;
                        $can_delete = isset($actions['can_delete']) ? 1 : 0;
                        $can_view = isset($actions['can_view']) ? 1 : 0;
                        
                        $this->strQuery = "SELECT * FROM permissions WHERE userID=".$id." And moduleID=".$moduleID;
                        if($this->query($this->strQuery)) {
                            $result = $this->getMysqliResults($this->strQuery,true);
                            if ($result) {
                                $result = $result[0];
                                $this->strQuery2 = "UPDATE `permissions` SET can_add='".$can_add."' ,can_edit='".$can_edit."' ,can_delete= '".$can_delete."' ,can_view= '".$can_view."' WHERE userID=".$id." And moduleID=".$moduleID;
                                $this->query($this->strQuery2);
                            }else{
                                $this->strQuery2 = "INSERT INTO `permissions` 
                                    (`userID`, `moduleID`, `can_add`, `can_view`, `can_edit`, `can_delete`) 
                                    VALUES 
                                    ('$id', '$moduleID', '$can_add', '$can_view', '$can_edit', '$can_delete')
                                ";
                                $this->query($this->strQuery2);
        
                            }
                        }
                        
                        if ($i == count($this->permissions)) {
                            $next = true;
                        }
                        
                        $i++;
                        
        	        }
        	        
        	        if($next){
        	            $this->strQuery = "
                            SELECT 
                                m.moduleID,
                                m.module_name,
                                m.module_description,
                                m.only_view,
                                COALESCE(p.can_add, 0) AS can_add,
                                COALESCE(p.can_view, 0) AS can_view,
                                COALESCE(p.can_edit, 0) AS can_edit,
                                COALESCE(p.can_delete, 0) AS can_delete
                            FROM 
                                modules m
                            LEFT JOIN 
                                permissions p 
                            ON 
                                m.moduleID = p.moduleID AND p.userID = ".$id."
                            WHERE 
                                m.status = 1
                        ";
                        
                        if ($this->query($this->strQuery)) {
                            $result2 = $this->getMysqliResults($this->strQuery, true);
                            $this->getModules = $result2;
                        }
                        $this->strSuccessMessage = 'Record Added: ' . $this->intID;
                        
                        return $id;
        	        }
        	        
        	        
                }
                
		    }
		    
		}
		

	}
	
	public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}


	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		From $this->strTableName
		WHERE userID=$id
		LIMIT 0,1";


		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
            $result = $result[0];

			$this->user_name = isset($result['user_name']) ? $result['user_name'] : '';
			$this->intID = isset($id) ? $id : '';
			$this->user_alias = isset($result['user_alias']) ? $result['user_alias'] : '';
			$this->user_email = isset($result['user_email']) ? $result['user_email'] : '';
			$this->is_admin = isset($result['is_admin']) ? $result['is_admin'] : '';
			$this->strStatus = isset($result['status']) ? $result['status'] : '';
			$this->strDateCreated = isset($result['date_created']) ? $result['date_created'] : '';
			$this->strDateModified = isset($result['date_modified']) ? $result['date_modified'] : '';
			$this->strAction = 'edit';

            $this->strQuery = "
                SELECT 
                    m.moduleID,
                    m.module_name,
                    m.module_description,
                    m.only_view,
                    COALESCE(p.can_add, 0) AS can_add,
                    COALESCE(p.can_view, 0) AS can_view,
                    COALESCE(p.can_edit, 0) AS can_edit,
                    COALESCE(p.can_delete, 0) AS can_delete
                FROM 
                    modules m
                LEFT JOIN 
                    permissions p 
                ON 
                    m.moduleID = p.moduleID AND p.userID = ".$this->intID."
                WHERE 
                    m.status = 1
            ";
            
            if ($this->query($this->strQuery)) {
                $result2 = $this->getMysqliResults($this->strQuery, true);
                return $this->getModules = $result2;
            }

// 			return $result;

	    } else {
	        
	        $this->strQuery2 = "SELECT 
                    m.moduleID,
                    m.module_name,
                    m.module_description,
                    m.only_view
                FROM 
                    modules m
                WHERE 
                    m.status = 1 ";
            
            if ($this->query($this->strQuery2)) {
                $result2 = $this->getMysqliResults($this->strQuery2, true);
                $this->getModules = $result2;
            }
            
	     	return null;
	    }
	}


	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {

        $this->pgSize = $pgSize;
        $this->pg = ($pg > 0 ? $pg : 1);
        
        // Query to count the total records with role_id = 1
        $this->strQuery1 = "SELECT COUNT(t.userID) AS records 
            FROM $this->strTableName t 
            WHERE t.userID != ".$_SESSION['userID']; // Filter users with role_id = 1
            
        if ($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
            $this->strQuery1 .= " AND t.status = '$status'"; // Filter by status if not 'all'
        }
        
        if ($searchWord != '') {
            $this->strQuery1 .= " AND (t.user_name LIKE '%$searchWord%' OR t.user_email LIKE '%$searchWord%')"; // Search by name or email
        }
        
        $result = $this->getMysqliResults($this->strQuery1, true);
        $this->records = $result[0]['records'];
        $this->intPageCount = ceil($result[0]['records'] / $this->pgSize);
        
        $this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
        $start = (($this->pg * $this->pgSize) - $this->pgSize);
        if ($start < 0) $start = 0;
    
        $this->strQuery = "SELECT * 
            FROM $this->strTableName t 
            WHERE userID != ".$_SESSION['userID']; // Filter users with role_id = 1
            
        if ($status != 'all') {
            $this->strQuery .= " AND t.status='$status' ";
        }
        
        if ($searchWord != '') {
            $this->strQuery .= " AND (t.user_name LIKE '%$searchWord%' OR t.user_email LIKE '%$searchWord%')";
        }
        
        if ($sortBy != '') {
            $this->strQuery .= " ORDER BY $sortBy $sortOrder";
        }
        
        $this->strQuery .= " LIMIT $start, $pgSize";
        
        if ($debug) {
            Util::debugDisplay($this->strQuery);
        }
        
        $this->strQuery;
        
        if ($this->query($this->strQuery)) {
            return $this->getMysqliResults($this->strQuery, true);
        } else {
            return null;
        }

	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getCategories() {

		$strQuery = "SELECT *
		FROM role t
		WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}



	public function getPageImageList($page_id,$debug = false) {


		$strQuery = "SELECT *
		FROM page_img where page_id=$page_id AND status = 'Active'";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		 }

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}



	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\', date_modified=\'' . Date('Y-m-d H:i:s') . '\' WHERE userID in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {
        $this->strQuery = 'SELECT facebook_image, twitter_image, display_image FROM '.$this->strTableName.' WHERE id=' . $id;

		// Delete images
        if($this->query($this->strQuery)) {
            $results = $this->getMysqliResults($this->strQuery,true);
            if (!empty($results)) {
                $results = $results[0];
                foreach($results AS $fileName) {
                    Util::deleteFile($fileName);
                }
            }
        }

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}
	}

}



?>