<?php


class Report extends Database  {


	public $strErrorMessage;
	public $strSuccessMessage;
	public $intPageCount;
	public $strFilterType;
	public $strStartDate;
	public $strEndDate;
	public $records;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";

		//$this->strTableName = 'city';
		//$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/report/';



	}


	public function setFilterType($type) {
		$this->strFilterType = $type;
	}

	public function setStartDate($date) {
		$this->strStartDate = $date;
	}

	public function setEndDate($date) {
		$this->strEndDate = $date;
	}
	public function setRecords($int) {
		$this->records = $int;
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}


	public function makeGolfPayment($objCourse,$intBrandId,$intCourseId,$strContent,$strSendDate){

		if($intCourseId =='') { $this->strErrorMessage = "Please choose a course."; }
		if($strSendDate =='') { $this->strErrorMessage = "Please choose a date."; }
		if($strContent =='') { $this->strErrorMessage = "Please enter some content."; }
		if($intBrandId =='') { $this->strErrorMessage = "Please choose a brand."; }


		if($this->strErrorMessage != "") {
			return false;
		}

		//get the course admin email
		$arrDetails = $objCourse->getDetail($intCourseId);
		$strCourseContact = $arrDetails['account_name'];
		$strCourseContactEmail = $arrDetails['account_email'];

		$strMailSubject = "Payment from BCgolfguide.com to ".$arrDetails['course_name'];

		// get user's email to send duplicate copy too
		$arrBrandContacts = Brand::getBrandContacts($intBrandId);

		$strAdminName = 'Ross Marrington';
		$strAdminEmail = 'ross@bcgolfguide.com';

		if (count($arrBrandContacts) > 0) {
			$strAdminName = $arrBrandContacts[0]['booking_name'];
			$strAdminEmail = $arrBrandContacts[0]['booking_email'];
		}

		$filePath = ROOT_DIR.'/application/pdfs/payment_c.pdf';

		$id = $this->updatePrintRecord($strContent, $intCourseId, 'course');
		$filename = ROOT_URL."/application/services/pdf_nt.php?cid=".$id."&r=".rand();

		$option = "-f $filePath --strict --footer ./. --size a4 --left 0.5in --right 0.5in --bodyfont times --browserwidth 720px --fontsize 9.0 --top margin 1.0in --bottom margin 0.5in  ";

		putenv("HTMLDOC_NOCGI=1");
		passthru("/usr/bin/htmldoc -t pdf --quiet --jpeg=100 --webpage $option $filename");


		$mail_message = "<p>Hello <b>".$strCourseContact."</b>,</p>

		<p>Please find the attached pdf file with payment instructions detailing amounts and invoice numbers.</p>

		<p>Regards,</p>

		<p>Ross Marrington</p>

		<p><a taget='_blank' href='www.bcgolfguide.com'>BCgolfguide.com Inc.</a><br />
		Tel 250-764-0700 - fax 250-800-0912 Toll - 1-877-223-7226</p>
		 ";

		$headers = "From: " . strip_tags($strAdminEmail) . "\r\n";
		$headers .= "Reply-To: ". strip_tags($strAdminEmail) . "\r\n";
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

		//Util::sendMailCore($strAdminEmail, $strMailSubject, $mail_message, $headers);
		$attachment = "";

		if(file_exists($filePath)){
	    	$attachment .= "$filePath;";
		}

		/*
		$strFromAddress = $strAdminEmail;
		if(!empty($arrBrandContacts)){
			$strFromAddress = $arrBrandContacts[0]['email'];
		}
		*/

		// send email to course
		Util::mail_attachment($strAdminEmail, $strCourseContactEmail, '', $strMailSubject, $mail_message, $attachment);

		// send email to brand contacts
		foreach($arrBrandContacts as $arrBrandContact){
			Util::mail_attachment($strAdminEmail, $arrBrandContact['booking_email'], '', $strMailSubject, $mail_message, $attachment);
		}

		//unlink("content.html");

		unlink(ROOT_DIR.'/application/pdfs/payment_c.pdf');


		$this->strSuccessMessage = "Success. Email has been sent to $strCourseContact at $strCourseContactEmail";

	}

	public function makeHotelPayment($objHotel,$intBrandId,$intHotelId,$strContent,$strSendDate){


		if($intHotelId =='') { $this->strErrorMessage = "Please choose a hotel."; }
		if($strSendDate =='') { $this->strErrorMessage = "Please choose a date."; }
		if($strContent =='') { $this->strErrorMessage = "Please enter some content."; }
		if($intBrandId =='') { $this->strErrorMessage = "Please choose a brand."; }


		if($this->strErrorMessage == "") {

			//get the course admin email

			//$arrDetails = $objHotel->getDetail($intHotelId);
			//$strAdminEmail = ($arrDetails['account_email'] != "" ? $arrDetails['account_email'] : $arrDetails['contact_email']);
			//$strAdminName = ($arrDetails['account_name'] != "" ? $arrDetails['account_name'] : $arrDetails['contact_person']);


			//$strMailSubject = "Payment from BCgolfguide.com to ".$arrDetails['hotel_name'];
			//Util::debugDisplay($arrDetails);

			// get user's email to send duplicate copy too
			//$arrBrandContacts = Brand::getBrandContacts($intBrandId);

			// get user's email to send duplicate copy too
			/*
			$strUserEmail = null;

			if(isset($_SESSION['userID'])){
				$objProfile = new Profile($_SESSION['userID']);
				$arrProfile = $objProfile->getDetail();

				$strUserEmail = $objProfile->strUserEmail;
			}
			*/

			//get the hotel admin email
			$arrDetails = $objHotel->getDetail($intHotelId);
			$strHotelContact = $arrDetails['account_name'];
			$strHotelContactEmail = $arrDetails['account_email'];

			$strMailSubject = "Payment from BCgolfguide.com to ".$arrDetails['hotel_name'];

			// get user's email to send duplicate copy too
			$arrBrandContacts = Brand::getBrandContacts($intBrandId);

			$strAdminName = 'Ross Marrington';
			$strAdminEmail = 'ross@bcgolfguide.com';

			if (count($arrBrandContacts) > 0) {
				$strAdminName = $arrBrandContacts[0]['booking_name'];
				$strAdminEmail = $arrBrandContacts[0]['booking_email'];
			}

			$headers = "From: " . strip_tags($strAdminEmail) . "\r\n";
			$headers .= "Reply-To: ". strip_tags($strAdminEmail) . "\r\n";
			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";



			$id = $this->updatePrintRecord($strContent, $intHotelId, 'hotel');


			//$public_directory = str_replace('admin/golf_package','',realpath(dirname(__FILE__)));
			$filePath = ROOT_DIR.'/application/pdfs/payment_h.pdf';

			$filename = ROOT_URL."/application/services/pdf_nt.php?hid=".$id."&r=".rand();


			//die($filename);

			$option = "-f $filePath --strict --footer ./. --size a4 --left 0.5in --right 0.5in --bodyfont times --browserwidth 720px --fontsize 9.0 --top margin 1.0in --bottom margin 0.5in  ";

			putenv("HTMLDOC_NOCGI=1");
			passthru("/usr/bin/htmldoc -t pdf --quiet --jpeg=100 --webpage $option $filename");

			//Util::debugDisplay("filePath=$filePath");
			//Util::debugDisplay("filename=$filename");
			//Util::debugDisplay("option=$option");

			$mail_message = "<p>Hello <b>".$strHotelContact."</b>,</p>

			<p>Please find the attached pdf file with payment instructions detailing amounts and invoice numbers.</p>

			<p>Regards,</p>

			<p>Ross Marrington</p>

			<p><a taget='_blank' href='http://www.bcgolfguide.com'>BCgolfguide.com Inc.</a><br />
			Tel 250-764-0700 - fax 250-800-0912 Toll - 1-877-223-7226</p>
			 ";


			$attachment = "";

			if(file_exists($filePath)){
		    	$attachment .= "$filePath;";
			}

			/*
			$strFromAddress = $strAdminEmail;
			if(!empty($arrBrandContacts)){
				$strFromAddress = $arrBrandContacts[0]['email'];
			}
			*/

			Util::mail_attachment($strAdminEmail, $strHotelContactEmail, '', $strMailSubject, $mail_message, $attachment);

			// send email to brand contacts
			foreach($arrBrandContacts as $arrBrandContact){
				Util::mail_attachment($strAdminEmail, $arrBrandContact['booking_email'], '', $strMailSubject, $mail_message, $attachment);
			}
			//unlink("content.html");

			unlink(ROOT_DIR.'/application/pdfs/payment_h.pdf');

			//mysql_query("delete from payment_print_info where id='".$scourse."' and section_name='golf course'");

			//Util::sendMailCore($strAdminEmail, $strMailSubject, $mail_message, $headers);

			$this->strSuccessMessage .= "<br />Success. Email has been sent to $strHotelContact at $strAdminEmail.";
			//$this->strSuccessMessage .= "<br />Path to pdf=$filename.";

		}



	}

	public function updatePrintRecord($description, $id, $section_name) {


		$this->strQuery = "INSERT INTO payment_print_info (description,id,section_name) VALUES ('$description','$id','$section_name') ON DUPLICATE KEY UPDATE description='$description'";

		//Util::debugDisplay("this->strQuery=$this->strQuery");

		if($this->short_query($this->strQuery)) {
	    	if($this->insert_id > 0) {
	    		$id = $this->insert_id;
	    	}

	    	//$this->strSuccessMessage .= 'Print Record Inserted:'.$id;
	    	return $id;
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return null;
		}

	}



	public function getPrintRecord($id, $section_name,$debug = false) {


		$strQuery = "SELECT * FROM payment_print_info WHERE section_name='$section_name' AND id=$id";

		if($debug) {
	  		Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);

	     	if(empty($res)){
	     		return null;
	     	}

	     	return $res[0];
	    } else {
	    	return null;
	    }




	}

	public function getPaypalReportDetails($paypal_id, $debug = false) {


		$strQuery ="SELECT p.*, m.`first_name`, m.`last_name`, m.email
		 FROM paypal p
		 LEFT JOIN members m on m.`id`=p.`member_id`
		 WHERE p.id=$paypal_id";

	  	if($debug) {
	  		Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	$this->records = count($res);
	     	return $res[0];
	    } else {
	    	return null;
	    }

	}

	public function updatePaypal($paypal_id, $notes, $fee ,$gross, $rec, $rec_date, $debug = false) {


		$strQuery ="UPDATE paypal SET
		notes='$notes',
		fee='$fee',
		gross='$gross',
		reconciled='$rec',
		rec_date='$rec_date'
		WHERE id=$paypal_id";
		if($debug) {
	  		Util::debugDisplay($strQuery);
	  	}

		if($this->short_query($strQuery)) {
	    	$this->strSuccessMessage .= 'Record Updated';
	    	//return $id;
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			//return null;
		}

	}



	public function getCourseReportDetails($course_id,$year,$debug = false) {

		$strQuery ="select
            p.phone as phone,
            p.cell_phone,
            p.state,
            p.city,
            p.country,
            pg.id,
            p.group_name,
            pg.golfer_num,
            pg.tee_date,
    	  	pg.tee_time,
            pg.tee_ap,
            pg.carts,
            pg.range_ball,
    	  	pg.shuttle,
            pg.rental_club,
            pg.track_code,
            pg.paidout,
    	  	pg.net_rate,
            pg.confirm_num,
            pg.id As golfID,
            p.id as package_id,
            pg.notes as private_notes,

            p.order_date,
            p.dates_booking,
            p.blnRepeat as `repeat`,
            (SELECT business_name FROM brands WHERE id= p.brandID) As business_name,
            (SELECT booking_name FROM booking_people WHERE id= p.bookingID) As booking_name
        from
            package_golf pg,
            packages p
	  	where
            pg.package_id=p.id
	  	    and pg.course_id='".$course_id."'
	  	    and pg.tee_date>='".$year."-01-01'
	  	    and pg.tee_date<='".$year."-12-31'
	  	group by pg.id
	  	order by pg.tee_date asc";

	  	if($debug) {
            Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	$this->records = count($res);

	     	foreach ($res as &$record) {
	     		$record = $this->getCoursePackageTotalsReport($record);
	     	}

	     	return $res;

	    } else {
	    	return null;
	    }

	}

	public function getCoursePackageTotalsReport($record) {
		$intPackagecourseId = $record['id'];

		$record['public_course_base_cost'] = 0;
		$record['private_course_base_cost'] = 0;

		$record['public_course_fee_cost'] = 0;
		$record['private_course_fee_cost'] = 0;

		$record['public_course_grand_total'] = 0;
		$record['private_course_grand_total'] = 0;

		$record['public_summary'] = '';
		$record['private_summary'] = '';

		// Get Rate
		$sql = "select * from package_golf
					JOIN course_rates ON (package_golf.rate = course_rates.id)
					WHERE package_golf.id = " . $intPackagecourseId;

		$arrRates = $this->getMysqliResults($sql,true);

		if (count($arrRates) > 0) {
			$record['public_summary']	 .= "Rates\n\n";
			$record['private_summary']	 .= "Rates\n\n";
		}

		foreach ($arrRates As $arrRate) {

			$dblPublicBaseCost = $arrRate['price'] * $arrRate['golfer_num'];
			$dblPrivateBaseCost = $arrRate['private_price'] * $arrRate['golfer_num'];

			$record['public_course_base_cost'] += $dblPublicBaseCost;
			$record['public_course_grand_total'] += $dblPublicBaseCost;
			$record['public_summary'] .= $arrRate['name'] . " Public Rate: $" . number_format($arrRate['price'], 2) . " Golfers: " . $arrRate['golfer_num'] . " Total: $" . number_format($dblPublicBaseCost, 2) .  "\n";

			$record['private_course_base_cost'] += $dblPrivateBaseCost;
			$record['private_course_grand_total'] += $dblPrivateBaseCost;
			$record['private_summary'] .= $arrRate['name'] . " Private Rate: $" . number_format($arrRate['private_price'], 2) . " Golfers: " . $arrRate['golfer_num'] . " Total: $" . number_format($dblPrivateBaseCost, 2) . "\n";

		}

		// Get Rate Fees
		$sql = "select 	course_rates.price,
						course_rates.private_price,
						course_rates.name as rate_name,
						package_golf.golfer_num,
						fees.name as fee_name,
						fees.public,
						fees.private,
						fees.calculation_type,
						fees.amount,
						fees.per_person
				FROM package_golf
				JOIN course_rates ON (package_golf.rate = course_rates.id)
				JOIN fees ON (course_rates.id = fees.course_rate_id)
				WHERE package_golf.id = ".$intPackagecourseId."
				ORDER BY rate_name;";

		$arrFees = $this->getMysqliResults($sql,true);

		if (count($arrFees) > 0) {
			$record['public_summary']	 .= "\nFees\n\n";
			$record['private_summary']	 .= "\nFees\n\n";
		}

		foreach ($arrFees As $arrFee) {

			$dblPublicBaseCost = $arrFee['price'] * $arrFee['golfer_num'];
			$dblPrivateBaseCost = $arrFee['private_price'] * $arrFee['golfer_num'];
			$dblPublicFeeCost = 0;
			$dblPrivateFeeCost = 0;


			if ($arrFee['calculation_type'] == 'flat') {
				$dblPublicFeeCost = $arrFee['amount'];
				$dblPrivateFeeCost = $arrFee['amount'];

				if ($arrFee['per_person'] == 1) {
					$dblPublicFeeCost *= $arrFee['golfer_num'];
					$dblPrivateFeeCost *= $arrFee['golfer_num'];
				}
			}

			if ($arrFee['calculation_type'] == 'percentage') {
				$dblPublicFeeCost = ($arrFee['amount'] / 100) * $dblPublicBaseCost;
				$dblPrivateFeeCost = ($arrFee['amount'] / 100) * $dblPrivateBaseCost;
			}

			if ($arrFee['public'] == '1') {
				$record['public_course_fee_cost'] += $dblPublicFeeCost;
				$record['public_course_grand_total'] += $dblPublicFeeCost;
				$record['public_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPublicFeeCost, 2) . "\n";
			}

			if ($arrFee['private'] == '1') {
				$record['private_course_fee_cost'] += $dblPrivateFeeCost;
				$record['private_course_grand_total'] += $dblPrivateFeeCost;
				$record['private_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPrivateFeeCost, 2) . "\n";
			}
		}

		// Get Season Fees
		$sql = "select 	course_rates.price,
						course_rates.private_price,
						course_rates.name as rate_name,
						package_golf.golfer_num,
						fees.name as fee_name,
						fees.public,
						fees.private,
						fees.calculation_type,
						fees.amount,
						fees.per_person
				FROM package_golf
				JOIN course_rates ON (package_golf.rate = course_rates.id)
				JOIN fees ON (course_rates.parent_id = fees.course_rate_id)
				WHERE package_golf.id = ".$intPackagecourseId."
				ORDER BY rate_name;";

		$arrFees = $this->getMysqliResults($sql,true);

		if (count($arrFees) > 0) {
			$record['public_summary']	 .= "\nSeason Fees\n\n";
			$record['private_summary']	 .= "\nSeason Fees\n\n";
		}

		$dblPrivateSubTotal = $record['private_course_grand_total'];
		$dblPublicSubTotal = $record['public_course_grand_total'];

		foreach ($arrFees As $arrFee) {

			if ($arrFee['calculation_type'] == 'flat') {
				$dblPublicFeeCost = $arrFee['amount'];
				$dblPrivateFeeCost = $arrFee['amount'];
			}

			if ($arrFee['calculation_type'] == 'percentage') {
				$dblPublicFeeCost = ($arrFee['amount'] / 100) * $dblPublicSubTotal;
				$dblPrivateFeeCost = ($arrFee['amount'] / 100) * $dblPrivateSubTotal;
			}

			if ($arrFee['public'] == '1') {
				$record['public_course_fee_cost'] += $dblPublicFeeCost;
				$record['public_course_grand_total'] += $dblPublicFeeCost;
				$record['public_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPublicFeeCost, 2) . "\n";
			}

			if ($arrFee['private'] == '1') {
				$record['private_course_fee_cost'] += $dblPrivateFeeCost;
				$record['private_course_grand_total'] += $dblPrivateFeeCost;
				$record['private_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPrivateFeeCost, 2) . "\n";
			}
		}

		if (($record['public_course_grand_total'] != 0) || ($record['private_course_grand_total'] != 0)) {
			$record['private_summary'] .= "\nGrand Total: $" . number_format($record['private_course_grand_total'], 2);
			$record['public_summary'] .= "\nGrand Total: $" . number_format($record['public_course_grand_total'], 2);
		}

		return $record;
	}


	public function getCourseDetailRangeChildren($course_id, $startDate, $endDate, $package_id = '', $bypassCount=false, $debug = false) {

        if (isset($_GET['grid_agency']) && ($_GET['grid_agency'] != '')) {
            $strAgencyWhere = ' AND p.brandID = ' . (int)$_GET['grid_agency'];
        } else {
            $strAgencyWhere = '';
        }

        if (isset($_GET['grid_agent']) && ($_GET['grid_agent'] != '')) {
            $strAgentWhere = ' AND p.bookingID = ' . (int)$_GET['grid_agent'];
        } else {
            $strAgentWhere = '';
        }

		if ($package_id == '')  {
            $strQuery ="select pg.id, c.course_name, p.group_name, pg.golfer_num, pg.tee_date,
    	  	pg.tee_time, pg.tee_ap, pg.carts, pg.range_ball,
    	  	pg.shuttle, pg.rental_club, pg.track_code, pg.paidout,
    	  	pg.net_rate, pg.confirm_num, pg.id As golfID, p.id as package_id
    	  	from package_golf pg, packages p, course c
    	  	where pg.package_id = p.id
            and pg.course_id = c.id
    	  	and pg.course_id = '" . $course_id . "'
    	  	and pg.tee_date >= '" . $startDate . "'
    	  	and pg.tee_date <= '" . $endDate . "'
            ".$strAgencyWhere."
            ".$strAgentWhere."
    	  	group by pg.id
    	  	order by pg.tee_date asc";
        } else {
            $strQuery ="select pg.id, c.course_name, p.group_name, pg.golfer_num, pg.tee_date,
            pg.tee_time, pg.tee_ap, pg.carts, pg.range_ball,
            pg.shuttle, pg.rental_club, pg.track_code, pg.paidout,
            pg.net_rate, pg.confirm_num, pg.id As golfID, p.id as package_id
            from package_golf pg, packages p, course c
            where pg.package_id = p.id
            and p.id = ".$package_id."
            and pg.course_id = c.id
            group by pg.id
            order by pg.tee_date asc";
        }


	  	if($debug) {
	  		Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	if (!$bypassCount) {
                $this->records = count($res);
            }
	     	return $res;
	    } else {
	    	return null;
	    }

	}




	public function getHotelReportDetails($hotel_id,$year,$debug = false) {

		$strQuery = "select
            ph.id,
            ph.package_id,
            p.group_name,
            p.phone,
            ph.hotel_id As hotelID,
            ph.check_in_date,
            ph.check_out_date,
            ph.confirm_num,
            ph.nights,
            ph.rooms,
            ph.golfers,
            ph.non_golfers,
            ph.paidout,
            ph.room_notes as private_notes,
            p.cell_phone,
            p.state,
            p.country,

            p.order_date,
            p.dates_booking,
            (SELECT sum(package_price) FROM package_hotel_detail WHERE package_hotel_id= ph.id) As sell_value,
            p.blnRepeat as `repeat`,
            (SELECT business_name FROM brands WHERE id= p.brandID) As business_name,
            (SELECT booking_name FROM booking_people WHERE id= p.bookingID) As booking_name
	  	from
            package_hotel ph,
            packages p,
            hotel h
	  	where
            ph.package_id=p.id
	  	    and ph.hotel_id='".$hotel_id."'
	  	    and ((ph.check_in_date>='".$year."-01-01'
	  		       and ph.check_in_date<='".$year."-12-31') or (ph.check_out_date>='".$year."-01-01'
	  		       and ph.check_out_date<='".$year."-12-31'))
	  	group by ph.id
	  	order by ph.check_in_date asc";

	  	if($debug) {
            Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	$this->records = count($res);

	     	foreach ($res as &$record) {
	     		$record = $this->getHotelPackageTotalsReport($record);
	     	}

	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getHotelPackageTotalsReport($record) {
		$intPackageHotelId = $record['id'];

		$record['public_hotel_base_cost'] = 0;
		$record['private_hotel_base_cost'] = 0;

		$record['public_hotel_fee_cost'] = 0;
		$record['private_hotel_fee_cost'] = 0;

		$record['public_hotel_grand_total'] = 0;
		$record['private_hotel_grand_total'] = 0;

		$record['public_summary'] = '';
		$record['private_summary'] = '';

		// Get Rates
		$sql = "select * from package_hotel_rates
					JOIN hotel_rates ON (package_hotel_rates.rate_id = hotel_rates.id)
					WHERE package_hotel_id = " . $intPackageHotelId;

		$arrRates = $this->getMysqliResults($sql,true);

		if (count($arrRates) > 0) {
			$record['public_summary']	 .= "Rates\n\n";
			$record['private_summary']	 .= "Rates\n\n";
		}

		foreach ($arrRates As $arrRate) {

			$dblPublicBaseCost = $arrRate['price'] * $arrRate['nights'] * $arrRate['rooms'];
			$dblPrivateBaseCost = $arrRate['private_price'] * $arrRate['nights'] * $arrRate['rooms'];

			$record['public_hotel_base_cost'] += $dblPublicBaseCost;
			$record['public_hotel_grand_total'] += $dblPublicBaseCost;
			$record['public_summary'] .= $arrRate['name'] . " Public Rate: $" . number_format($arrRate['price'], 2) . " Rooms: " . $arrRate['rooms'] . " Nights: " . $arrRate['nights'] . " Total: $" . number_format($dblPublicBaseCost, 2) .  "\n";

			$record['private_hotel_base_cost'] += $dblPrivateBaseCost;
			$record['private_hotel_grand_total'] += $dblPrivateBaseCost;
			$record['private_summary'] .= $arrRate['name'] . " Private Rate: $" . number_format($arrRate['private_price'], 2) . " Rooms: " . $arrRate['rooms'] . " Nights: " . $arrRate['nights'] . " Total: $" . number_format($dblPrivateBaseCost, 2) . "\n";

		}

		// Get Fees
		$sql = "SELECT 	hotel_rates.price,
						hotel_rates.private_price,
						hotel_rates.name as rate_name,
						package_hotel_rates.rooms,
						package_hotel_rates.nights,
						fees.name as fee_name,
						fees.public,
						fees.private,
						fees.calculation_type,
						fees.amount,
						fees.per_room,
						fees.per_night
				FROM package_hotel_rates
				JOIN hotel_rates ON (package_hotel_rates.rate_id = hotel_rates.id)
				JOIN fees ON (hotel_rates.id = fees.hotel_rate_id)
				WHERE package_hotel_id = " . $intPackageHotelId . "
				ORDER BY rate_name";

		$arrFees = $this->getMysqliResults($sql,true);

		if (count($arrFees) > 0) {
			$record['public_summary']	 .= "\nFees\n\n";
			$record['private_summary']	 .= "\nFees\n\n";
		}

		foreach ($arrFees As $arrFee) {

			$dblPublicBaseCost = $arrFee['price'] * $arrFee['nights'] * $arrFee['rooms'];
			$dblPrivateBaseCost = $arrFee['private_price'] * $arrFee['nights'] * $arrFee['rooms'];
			$dblPublicFeeCost = 0;
			$dblPrivateFeeCost = 0;


			if ($arrFee['calculation_type'] == 'flat') {
				$dblPublicFeeCost = $arrFee['amount'];
				$dblPrivateFeeCost = $arrFee['amount'];

				if ($arrFee['per_room'] == 1) {
					$dblPublicFeeCost *= $arrFee['rooms'];
					$dblPrivateFeeCost *= $arrFee['rooms'];
				}

				if ($arrFee['per_night'] == 1) {
					$dblPublicFeeCost *= $arrFee['nights'];
					$dblPrivateFeeCost *= $arrFee['nights'];
				}
			}

			if ($arrFee['calculation_type'] == 'percentage') {
				$dblPublicFeeCost = ($arrFee['amount'] / 100) * $dblPublicBaseCost;
				$dblPrivateFeeCost = ($arrFee['amount'] / 100) * $dblPrivateBaseCost;
			}

			if ($arrFee['public'] == '1') {
				$record['public_hotel_fee_cost'] += $dblPublicFeeCost;
				$record['public_hotel_grand_total'] += $dblPublicFeeCost;
				$record['public_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPublicFeeCost, 2) . "\n";
			}

			if ($arrFee['private'] == '1') {
				$record['private_hotel_fee_cost'] += $dblPrivateFeeCost;
				$record['private_hotel_grand_total'] += $dblPrivateFeeCost;
				$record['private_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPrivateFeeCost, 2) . "\n";
			}
		}

		// Get Season Fees
		$sql = "SELECT 	hotel_rates.price,
						hotel_rates.private_price,
						hotel_rates.name as rate_name,
						package_hotel_rates.rooms,
						package_hotel_rates.nights,
						fees.name as fee_name,
						fees.public,
						fees.private,
						fees.calculation_type,
						fees.amount,
						fees.per_room,
						fees.per_night
				FROM package_hotel_rates
				JOIN hotel_rates ON (package_hotel_rates.rate_id = hotel_rates.id)
				JOIN fees ON (hotel_rates.parent_id = fees.hotel_rate_id)
				WHERE package_hotel_id = " . $intPackageHotelId . "
				ORDER BY rate_name";

		$arrFees = $this->getMysqliResults($sql,true);

		if (count($arrFees) > 0) {
			$record['public_summary']	 .= "\nSeason Fees\n\n";
			$record['private_summary']	 .= "\nSeason Fees\n\n";
		}

		//$dblPrivateSubTotal = $record['private_hotel_grand_total'];
		//var_dump($dblPrivateSubTotal);
		//$dblPublicSubTotal = $record['public_hotel_grand_total'];

		//$dblPublicBaseCost = $arrFee['price'] * $arrFee['nights'] * $arrFee['rooms'];
		//$dblPrivateBaseCost = $arrFee['private_price'] * $arrFee['nights'] * $arrFee['rooms'];

		foreach ($arrFees As $arrFee) {

			$dblPublicSubTotal = $arrFee['price'] * $arrFee['nights'] * $arrFee['rooms'];
			$dblPrivateSubTotal = $arrFee['private_price'] * $arrFee['nights'] * $arrFee['rooms'];

			if ($arrFee['calculation_type'] == 'flat') {
				$dblPublicFeeCost = $arrFee['amount'];
				$dblPrivateFeeCost = $arrFee['amount'];
			}

			if ($arrFee['calculation_type'] == 'percentage') {
				$dblPublicFeeCost = ($arrFee['amount'] / 100) * $dblPublicSubTotal;
				$dblPrivateFeeCost = ($arrFee['amount'] / 100) * $dblPrivateSubTotal;
			}

			if ($arrFee['public'] == '1') {
				$record['public_hotel_fee_cost'] += $dblPublicFeeCost;
				$record['public_hotel_grand_total'] += $dblPublicFeeCost;
				$record['public_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPublicFeeCost, 2) . "\n";
			}

			if ($arrFee['private'] == '1') {
				$record['private_hotel_fee_cost'] += $dblPrivateFeeCost;
				$record['private_hotel_grand_total'] += $dblPrivateFeeCost;
				$record['private_summary'] .= $arrFee['rate_name'] . " Fee: " . $arrFee['fee_name'] . " Amount: $" . number_format($dblPrivateFeeCost, 2) . "\n";
			}

		}

		if (($record['public_hotel_grand_total'] != 0) || ($record['private_hotel_grand_total'] != 0)) {
			$record['private_summary'] .= "\nGrand Total: $" . number_format($record['private_hotel_grand_total'], 2);
			$record['public_summary'] .= "\nGrand Total: $" . number_format($record['public_hotel_grand_total'], 2);
		}

		return $record;
	}

	public function getHotelDetailRangeChildren($hotel_id, $startDate, $endDate, $package_id='', $bypassCount=false, $debug = false) {

        if (isset($_GET['grid_agency']) && ($_GET['grid_agency'] != '')) {
            $strAgencyWhere = ' AND p.brandID = ' . (int)$_GET['grid_agency'];
        } else {
            $strAgencyWhere = '';
        }

        if (isset($_GET['grid_agent']) && ($_GET['grid_agent'] != '')) {
            $strAgentWhere = ' AND p.bookingID = ' . (int)$_GET['grid_agent'];
        } else {
            $strAgentWhere = '';
        }

        if ($package_id == '') {
    		$strQuery = "select ph.id, h.hotel_name, ph.package_id, p.group_name, ph.hotel_id As hotelID, ph.check_in_date, ph.check_out_date, ph.confirm_num,
    		ph.nights, ph.rooms, ph.golfers, ph.non_golfers, ph.confirm_num , ph.paidout
    	  	from package_hotel ph, packages p, hotel h
    	  	where ph.package_id=p.id
            and p.status != 'Trash'
    	  	and ph.hotel_id='" . $hotel_id . "'
    	  	and ((ph.check_in_date >= '" . $startDate . "'
    	  		and ph.check_in_date <= '" . $endDate . "') or (ph.check_out_date >= '" . $startDate . "'
    	  		and ph.check_out_date <= '" . $endDate . "'))
            ". $strAgentWhere . "
            ". $strAgencyWhere . "
    	  	group by ph.id
    	  	order by ph.check_in_date asc";
        } else {
            $strQuery = "select ph.id, h.hotel_name, ph.package_id, p.group_name, ph.hotel_id As hotelID, ph.check_in_date, ph.check_out_date, ph.confirm_num,
            ph.nights, ph.rooms, ph.golfers, ph.non_golfers, ph.confirm_num , ph.paidout
            from package_hotel ph, packages p, hotel h
            where ph.package_id=p.id
            and p.id=".$package_id."
            and p.status != 'Trash'
            group by ph.id
            order by ph.check_in_date asc";
        }

	  	if($debug) {
	  		Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	if (!$bypassCount) {
                $this->records = count($res);
            }
	     	return $res;
	    } else {
	    	return null;
	    }

	}


	public function getHotelList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $year, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM hotel t WHERE id>0 ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name,
	     	(SELECT count(ph.id)
	     	FROM package_hotel ph
	     	WHERE ph.hotel_id=t.id
	     	and ((ph.check_in_date>='".$year."-01-01'
	  		and ph.check_in_date<='".$year."-12-31') or (ph.check_out_date>='".$year."-01-01'
	  		and ph.check_out_date<='".$year."-12-31'))
		 ) As detail_count
	     From hotel t
	     Left Join members m on m.id=t.member_id
	     Left Join hotel_type c on c.id=t.type_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return 'no results';
	     }
	}

	public function getHotelDetailRangeList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $startDate, $endDate, $status = 'Active', $dates, $cats, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM hotel t WHERE id>0 ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

        if (isset($_GET['grid_agency']) && ($_GET['grid_agency'] != '')) {
            $strAgencyWhere = ' AND p.brandID = ' . (int)$_GET['grid_agency'];
        } else {
            $strAgencyWhere = '';
        }

        if (isset($_GET['grid_agent']) && ($_GET['grid_agent'] != '')) {
            $strAgentWhere = ' AND p.bookingID = ' . (int)$_GET['grid_agent'];
        } else {
            $strAgentWhere = '';
        }


	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;

	    $this->strQuery = "SELECT t.*, m.email, c.type_name
		     From hotel t
		     Left Join members m on m.id=t.member_id
		     Left Join hotel_type c on c.id=t.type_id
		     WHERE t.`id` > 0
			 AND (SELECT count(ph.id)
		     	FROM package_hotel ph
                JOIN packages p ON (ph.package_id = p.id)
		     	WHERE ph.hotel_id=t.id
                ".$strAgencyWhere."
                ".$strAgentWhere."
		     	and ((ph.check_in_date >= '" . $startDate . "'
		  		and ph.check_in_date <= '" . $endDate . "') or (ph.check_out_date>='" . $startDate . "'
		  		and ph.check_out_date <= '" . $endDate . "'))
			 ) > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return 'no results';
	     }
	}




	public function getCourseList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $year,  $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM course t WHERE id>0 ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND t.status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.course_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, contact_email, c.type_name , s.state_name,
	     	(SELECT count(pg.id)
	     	FROM package_golf pg
	     	WHERE pg.course_id=t.id
	     	and (pg.tee_date>='".$year."-01-01'
	  		and pg.tee_date<='".$year."-12-31')
		 ) As detail_count
	     From course t
	     Left Join course_type c on c.id=t.type_id
	     Left Join city c2 on c2.id=t.city_id
	     Left Join state s on s.id=c2.state_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.course_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery1);
		 	echo '<br />';
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }


	     //We marked most courses as Trash at Ross's request with this statement. The records are left in case any back pages are need.

	     /*


		Select c.id,c.course_name,type_name,region_id,r.region_name FROM course c
		Left Join region r on r.id=c.region_id
		left join course_type t on t.id=c.type_id
		WHERE r.state_id=2
		OR type_id in (3,7)

		UPDATE course SET status='Trash'

		UPDATE course c
		Left Join region r on r.id=c.region_id
		SET status='Active'
		WHERE r.state_id=2
		OR type_id in (3,7)
		AND deleted=0

	     */






	}

	public function getCourseDetailRangeList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $startDate, $endDate,  $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM course t WHERE id>0 ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND t.status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.course_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;

        if (isset($_GET['grid_agency']) && ($_GET['grid_agency'] != '')) {
            $strAgencyWhere = ' AND p.brandID = ' . (int)$_GET['grid_agency'];
        } else {
            $strAgencyWhere = '';
        }

        if (isset($_GET['grid_agent']) && ($_GET['grid_agent'] != '')) {
            $strAgentWhere = ' AND p.bookingID = ' . (int)$_GET['grid_agent'];
        } else {
            $strAgentWhere = '';
        }

	    $this->strQuery = "SELECT t.*, c.type_name , s.state_name
			 From course t
			 Left Join course_type c on c.id=t.type_id
			 Left Join city c2 on c2.id=t.city_id
			 Left Join state s on s.id=c2.state_id
			 WHERE t.`id` > 0
			 AND (SELECT count(pg.id)
					FROM package_golf pg
                    JOIN packages p ON (pg.package_id = p.id)
					WHERE pg.course_id = t.id
                    ".$strAgencyWhere."
                    ".$strAgentWhere."
					and (pg.tee_date >= '" . $startDate . "'
					and pg.tee_date <= '" . $endDate . "')
				 ) > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.course_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery1);
		 	echo '<br />';
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }

	}





	public function decryptCC($encrypted, $key) {

		$val = null;
		error_reporting(0);
		if($encrypted != '' && $key != ''){
		    include ROOT_DIR.'/application/vendor/tiilib/crypt.func.php';
		    include ROOT_DIR.'/application/vendor/tiilib/format.func.php';
		    $val = tii_formatCreditCard(tii_GetDecrypted($encrypted,$key));
		}



		return "Decrypted Card Number: $val";
	}


    public function adminpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            
            return false;
            
        }
        
	}
	
	
	public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
        $columns = $this->getMysqliResults( $sql, true );
        
        $_SESSION['is_admin'] = $columns[0]['is_admin'];
            
        if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}


	public function getPaymentReport($strPgSize,$strPg,$strSortBy,$strSortOrder,$strSearchWord,$type,$month,$year,$debug = false) {

		/*$strQuery1 = 'SELECT count(*) As records
            FROM packages AS pp
            Left Join package_hotel AS ph ON ph.package_id = pp.id
            Left Join package_golf AS pg ON pg.package_id = pp.id
            Where pp.id > 0 ';

        if (isset($month) && $month != "") {
            $strQuery1 .= " and (pp.dates_arrival>='" . $year . "-" . $month . "-01' and pp.dates_arrival<='" . $year . "-" . $month . "-31')";
        } else {
            $strQuery1 .= " and (pp.dates_arrival>='" . $year . "-01-01' and pp.dates_arrival<='" . $year . "-12-31')";
        }

		//if(strtotime($start) && strtotime($end)){
	    	//$strQuery1 .= "AND (pp.dates_arrival BETWEEN '$start' AND '$end' )";
	    //}


        $result = $this->getMysqliResults($strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$strPgSize);

		$strPg = ($strPg <= $this->intPageCount ? $strPg : $this->intPageCount);
		$start = (($strPg*$strPgSize)-$strPgSize);
		if($start<0) $start = 0;
		//Util::debugDisplay($strQuery1);
		//Util::debugDisplay('$this->intPageCount='.$this->intPageCount);*/

		/*$strQuery = 'SELECT * from ( SELECT
            pp.group_name,
            pp.user_name,
            pp.order_date,
            pp.edit_date,
            pp.completed,
            pp.deleted,
            pp.dates_arrival,
            pp.id,
            pp.players_num,
            if(Min(ph.check_in_date) is null, min(pg.tee_date), min(ph.check_in_date)) cid
            FROM
            packages AS pp
            Left Join package_hotel AS ph ON ph.package_id = pp.id
            Left Join package_golf AS pg ON pg.package_id = pp.id
            Where pp.id>0 group by pp.id) np WHERE  np.cid > 0 ';

        if (isset($month) && $month != "") {
            $strQuery .= " and (np.dates_arrival>='" . $year . "-" . $month . "-01' and np.dates_arrival<='" . $year . "-" . $month . "-31')";
        } else {
            $strQuery .= " and (np.dates_arrival>='" . $year . "-01-01' and np.dates_arrival<='" . $year . "-12-31')";
        }

		/*if(strtotime($start) && strtotime($end)){
	    	$strQuery .= "AND (np.dates_arrival BETWEEN '$start' AND '$end' )";
	    }*/

	    $strDateFilter = '';

        if (isset($month) && $month != "") {
            //$strDateFilter = " and (np.dates_arrival>='" . $year . "-" . $month . "-01' and np.dates_arrival<='" . $year . "-" . $month . "-31')";
            $strDateFilter = " AND ((ph.check_in_date >='" . $year . "-" . $month . "-01' AND ph.check_in_date <= '" . $year . "-" . $month . "-31')
            					OR (pg.tee_date >='" . $year . "-" . $month . "-01' AND pg.tee_date <= '" . $year . "-" . $month . "-31'))";
        } else {
            //$strDateFilter = " and (np.dates_arrival>='" . $year . "-01-01' and np.dates_arrival<='" . $year . "-12-31')";
            $strDateFilter = " AND ((ph.check_in_date >='" . $year . "-01-01' AND ph.check_in_date <= '" . $year . "-12-31')
            					OR (pg.tee_date >='" . $year . "-01-01' AND pg.tee_date <= '" . $year . "-12-31'))";
        }

        $strQuery = 'SELECT * from
					( SELECT pp.group_name, pp.user_name, pp.order_date, pp.edit_date, pp.completed, pp.deleted, pp.dates_arrival, pp.id, pp.players_num,
						if(Min(ph.check_in_date) is null, min(pg.tee_date), min(ph.check_in_date)) cid
						FROM packages AS pp
					Left Join package_hotel AS ph ON ph.package_id = pp.id
					Left Join package_golf AS pg ON pg.package_id = pp.id
					Where pp.id>0
					 '.$strDateFilter.'
					group by pp.id) np
					WHERE np.cid > 0';


        $strQuery.= " order by np.cid ";

        $result = $this->getMysqliResults($strQuery,true);

	    $this->records = count($result);
	    $this->intPageCount = ceil($this->records/$strPgSize);

		$strPg = ($strPg <= $this->intPageCount ? $strPg : $this->intPageCount);
		$start = (($strPg*$strPgSize)-$strPgSize);

        $strQuery .= " LIMIT $start,$strPgSize ";

        //$strPgSize,$strPg,$strSortBy,$strSortOrder,$strSearchWord


        if($debug) {
	  		Util::debugDisplay($strQuery);
	  	}

	  	if($this->query($strQuery)) {


	     	$res = $this->getMysqliResults($strQuery,true);


	     	//$arrResult = $res;
	     	$i = 0;
	     	foreach($res as $r) {

	     		$id = $r['id'];
	     		$res[$i]['details'] = array();


				$this->strQuery = "(SELECT
				    cp.id,
				    cp.course_name as name,
				    pg.note_id as note_id,
				    pg.golfer_num,
				    pg.golfer_num as nights,
				    pg.golfer_num as rooms,
				    pg.paidout,
				    pg.id As indexID,
				    'course' as type,
					paid,
				    n.invoice,
				    pg.notes
				    FROM
				    course AS cp
				    Left Join package_golf AS pg ON pg.course_id = cp.id
				    Left Join notes n on n.id=pg.course_id AND n.package_id=pg.package_id AND n.note_id=pg.note_id
				    where
				    pg.package_id={$id}
				)UNION ALL(
				    SELECT
				    h.id,
				    h.hotel_name as name,
				    ph.note_id as note_id,
				    ph.golfers as golfer_num,
				    ph.nights as nights,
				    ph.rooms as rooms,
				    ph.paidout,
				    ph.id As indexID,
				    'hotel' as type,
					paid,
				    n.invoice,
				    ph.room_notes
				    FROM
				    hotel AS h
				    Left Join package_hotel AS ph ON ph.hotel_id = h.id
				    Left Join notes n on n.id=ph.hotel_id AND n.package_id=ph.package_id AND n.note_id=ph.note_id
				    where
				    ph.package_id={$id}
				)";
				//Util::debugDisplay($this->strQuery."<br /><br />");
				if($this->query($this->strQuery)) {
		     		$result2 = $this->getMysqliResults($this->strQuery,true);
		     		if(count($result2) > 0) {
		     			$res[$i]['details'] = $result2;
		     		}
		     	} else {

		     		Util::debugDisplay($this->strQuery."<br /><br />");
		     	}

		     	$i++;
	     	}


	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getPackageHotelTotalCost($intPackageId) {

		$strSql = "SELECT id FROM package_hotel WHERE package_id = " . $intPackageId;
		$arrPackageHotels = $this->getMysqliResults($strSql,true);

		$dblPrivateTotal = 0;

		foreach ($arrPackageHotels AS $arrPackageHotel) {
			$arrPackageHotel = $this->getHotelPackageTotalsReport($arrPackageHotel);

			$dblPrivateTotal += $arrPackageHotel['private_hotel_grand_total'];
		}

		return $dblPrivateTotal;
	}

	public function getPackageCourseTotalCost($intPackageId) {

		$strSql = "SELECT id FROM package_golf WHERE package_id = " . $intPackageId;
		$arrPackageCourses = $this->getMysqliResults($strSql,true);

		$dblPrivateTotal = 0;

		foreach ($arrPackageCourses AS $arrPackageCourse) {
			$arrPackageCourse = $this->getCoursePackageTotalsReport($arrPackageCourse);

			$dblPrivateTotal += $arrPackageCourse['private_course_grand_total'];
		}

		return $dblPrivateTotal;
	}

    public function getSellValueByPackage($package_id) {

        $strSql = "SELECT
                (SELECT sum(package_price) FROM package_hotel_detail where package_hotel_id= ph.id) As sell_value
            FROM packages t
            LEFT JOIN package_hotel ph on ph.package_id=t.id
            LEFT JOIN hotel h on h.id=ph.hotel_id
            WHERE t.id = $package_id AND ph.default=1
        ";

        $arrResults = $this->getMysqliResults($strSql,true);

        if (!empty($arrResults)) {
            return $arrResults[0]['sell_value'];
        }

    }

	public function getPackageList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $year='', $month='', $range=array(), $agent=array(), $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM packages t
	    LEFT JOIN package_hotel ph on ph.package_id=t.id
	    WHERE ph.default=1 ";

	    if (isset($month) && $month != "") {
            $this->strQuery1 .= " and (ph.check_in_date>='" . $year . "-" . $month . "-01' and ph.check_in_date<='" . $year . "-" . $month . "-31')";
        } else {
            $this->strQuery1 .= " and (ph.check_in_date>='" . $year . "-01-01' and ph.check_in_date<='" . ($year+1) . "-01-01')";
        }

	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.type_name like '%$searchWord%' )";
	    }


	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
        /*
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;
        */


	     $this->strQuery = "SELECT t.*, b.business_name, p.booking_name, ph.hotel_id as ph_id, ph.check_in_date, ph.rooms,
	     case when t.blnRepeat = 1 THEN (SELECT 'Yes') Else (SELECT 'No') END as blnRepeat,
	     r.region_name, h.hotel_name,
	     (SELECT sum(package_price) FROM package_hotel_detail where package_hotel_id= ph.id) As sell_value,
	     (SELECT count(id) FROM package_hotel_detail WHERE package_hotel_id= ph.id) as golfer_count
	     FROM packages t
	     LEFT JOIN brands b on b.id = t.brandID
	     LEFT JOIN booking_people p on p.id = t.bookingID
	     LEFT JOIN package_hotel ph on ph.package_id=t.id
	     LEFT JOIN region r on r.id=t.region_id
	     LEFT JOIN hotel h on h.id=ph.hotel_id
	     WHERE ph.default=1 ";

        if ($agent['agency']) {
            $this->strQuery .= " and t.brandID = " . $agent['agency'];
        }

        if ($agent['agent']) {
            $this->strQuery .= " and t.bookingID = " . $agent['agent'];
        }

        if (empty($range)) {
            if (isset($month) && $month != "") {
                $this->strQuery .= " and (ph.check_in_date>='" . $year . "-" . $month . "-01' and ph.check_in_date<='" . $year . "-" . $month . "-31') ";
            } else {
                $this->strQuery .= " and (ph.check_in_date>='" . $year . "-01-01' and ph.check_in_date<='" . ($year+1) . "-01-01') ";
            }
        } else {
            if ($range['grid_date'] == '') {
                $range['grid_date'] = 'dates_arrival';
            }

            if ($range['grid_date'] == 'dates_arrival') {
                if ($range['start_date'] == '') {
                    $this->strQuery .= " and (ph.check_in_date>='" . $year . "-01-01' and ph.check_in_date<='" . ($year+1) . "-01-01') ";
                } else if ($range['start_date'] != '') {
                    $this->strQuery .= " AND (ph.check_in_date>= '".$range['start_date']."') ";
                }

                if ($range['end_date'] != '') {
                    $this->strQuery .= " AND (ph.check_in_date<= '".$range['end_date']."') ";
                }
            }

            if ($range['grid_date'] == 'dates_depart') {
                if ($range['start_date'] == '') {
                    $this->strQuery .= " and (ph.check_out_date>='" . $year . "-01-01' and ph.check_in_date<='" . ($year + 1) . "-01-01') ";
                } else if ($range['start_date'] != '') {
                    $this->strQuery .= " AND (ph.check_out_date>= '".$range['start_date']."') ";
                }

                if ($range['end_date'] != '') {
                    $this->strQuery .= " AND (ph.check_out_date<= '".$range['end_date']."') ";
                }
            }

            if ($range['grid_date'] == 'order_date') {
                if ($range['start_date'] == '') {
                    $this->strQuery .= " and (t.order_date >='" . $year . "-01-01' and t.order_date <='" . ($year+1) . "-01-01') ";
                } else if ($range['start_date'] != '') {
                    $this->strQuery .= " AND (t.order_date >= '".$range['start_date']."') ";
                }

                if ($range['end_date'] != '') {
                    $this->strQuery .= " AND (t.order_date <= '".$range['end_date']."') ";
                }
            }

            if ($range['grid_date'] == 'edit_date') {

            }

            if ($range['grid_date'] == 'dates_booking') {
                if ($range['start_date'] == '') {
                    $this->strQuery .= " and (t.dates_booking >='" . $year . "-01-01' and t.dates_booking <='" . ($year+1) . "-01-01') ";
                } else if ($range['start_date'] != '') {
                    $this->strQuery .= " AND (t.dates_booking >= '".$range['start_date']."') ";
                }

                if ($range['end_date'] != '') {
                    $this->strQuery .= " AND (t.dates_booking <= '".$range['end_date']."') ";
                }
            }
        }


	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.group_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

        $result = $this->getMysqliResults($this->strQuery,true);
        $this->records = count($result);

        //Pagination Broken with Filters
        //$this->intPageCount = ceil($this->records/$this->pgSize);
        //$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
        //$start = (($this->pg*$this->pgSize)-$this->pgSize);
        $pgSize = 0;
        $this->pgSize = 0;
        $this->intPageCount = 1;
        $this->pg = 1;
        $start=0;
        if($start<0) $start = 0;

		 if ($pgSize > 0) {
	     	$this->strQuery .= " LIMIT $start,$pgSize ";
	     }

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     $arrResults = $this->getMysqliResults($this->strQuery,true);

	     foreach ($arrResults as &$arrResult) {
	     	$arrResult['hotel_private_cost'] = $this->getPackageHotelTotalCost($arrResult['id']);
	     	$arrResult['course_private_cost'] = $this->getPackageCourseTotalCost($arrResult['id']);
	     	$arrResult['package_total_cost'] = $arrResult['hotel_private_cost'] + $arrResult['course_private_cost'];
	     	$arrResult['profit'] = $arrResult['sell_value'] - ($arrResult['hotel_private_cost'] + $arrResult['course_private_cost']);

			if ($arrResult['package_total_cost'] != 0) {
	     		$arrResult['profit_margin'] = $arrResult['sell_value'] / $arrResult['package_total_cost'];
	     	} else {
	     		$arrResult['profit_margin'] = 0;
	     	}
	     }

         foreach ($arrResults as $i => $arrResultRow) {
            // GET HOTEL DETAILS

            $arrHotelDetails = $this->getHotelDetailRangeChildren('', '','', $arrResultRow['id'], true);

            foreach ($arrHotelDetails as $arrHotelDetail) {

                if (isset($arrResults[$i]['hotel_details'])) {
                    $arrResults[$i]['hotel_details'] .= ' || '; // Delmiter
                } else {
                    $arrResults[$i]['hotel_details'] = '';
                }
                $arrResults[$i]['hotel_details'] .= "Hotel Name: " . $arrHotelDetail['hotel_name'];
                $arrResults[$i]['hotel_details'] .= ", Check In Date: " . $arrHotelDetail['check_in_date'];
                $arrResults[$i]['hotel_details'] .= ", Check Out Date: " . $arrHotelDetail['check_out_date'];
                $arrResults[$i]['hotel_details'] .= ", Confirmation#: " . $arrHotelDetail['confirm_num'];
                $arrResults[$i]['hotel_details'] .= ", Nights: " . $arrHotelDetail['nights'];
                $arrResults[$i]['hotel_details'] .= ", Rooms: " . $arrHotelDetail['rooms'];
                $arrResults[$i]['hotel_details'] .= ", Golfers: " . $arrHotelDetail['golfers'];
                $arrResults[$i]['hotel_details'] .= ", Non Golfers: " . $arrHotelDetail['non_golfers'];
            }

            $arrCourseDetails = $this->getCourseDetailRangeChildren('', '','', $arrResultRow['id'], true);
            foreach ($arrCourseDetails as $arrCourseDetail) {

                if (isset($arrResults[$i]['course_details'])) {
                    $arrResults[$i]['course_details'] .= ' || '; // Delmiter
                } else {
                    $arrResults[$i]['course_details'] = '';
                }
                $arrResults[$i]['course_details'] .= "Course Name: " . $arrCourseDetail['course_name'];
                $arrResults[$i]['course_details'] .= ", Confirmation #: " . $arrCourseDetail['confirm_num'];
                $arrResults[$i]['course_details'] .= ", Tee Date / Time: " . $arrCourseDetail['tee_date'] . ' ' . $arrCourseDetail['tee_time'] . ' ' . $arrCourseDetail['tee_ap'];
                $arrResults[$i]['course_details'] .= ", Carts: " . $arrCourseDetail['carts'];
                $arrResults[$i]['course_details'] .= ", Golfer #: " . $arrCourseDetail['golfer_num'];
                $arrResults[$i]['course_details'] .= ", Range Ball: " . $arrCourseDetail['range_ball'];
                $arrResults[$i]['course_details'] .= ", Shuttle: " . $arrCourseDetail['shuttle'];
                $arrResults[$i]['course_details'] .= ", Rental Clubs: " . $arrCourseDetail['rental_club'];
            }

         }
	     //var_dump($arrResults[0]['hotel_details']);

	     return $arrResults;

	     //if($this->query($this->strQuery)) {
	     	//return $this->getMysqliResults($this->strQuery,true);
	     //} else {
	     //	return null;
	     //}
	}
}



?>