<?php


class Region extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strRegionName;
	public $strSlug;
	public $strSearchWord;
	public $intCountryId;
	public $strZlevel;
	public $strLatitude;
	public $strLongitude;

	public $strFocusKeyword;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $intScoreSEO;

	public $strFacebookTitle;
	public $strFacebookDescription;
	public $strTwitterTitle;
	public $strTwitterDescription;
	public $strGoogleDescription;

	public $strUploadsDir;
    public $strUploadsUrl;
    public $arrFilesToDelete;

	public $strRegionSubText;
	public $strRegionSubText2;
	public $strText1;
	public $strText2;
	public $strText3;
	public $intID;
	public $intCatID;
	public $intDisplayOrder;
	public $strAction;
	public $strPubStatus;
	public $arrSelectedCourses;
	public $arrSelectedHotels;

    public $strVideoEmbed;
    public $strVideoSmallHeading;
    public $strVideoLargeHeading;
    public $strVideoText;
    public $strVideoBtnText;
    public $strVideoLink;

	public function __construct($strPageId = '',$strAction = '') {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'region';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/region/';

		$this->strTitle = 'Region';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/regions/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/regions/'.date('Y').'/';
        $this->strSlug = '/regions/'.$this->strSlug;

	}


	public function handlePost($post,$id,$debug=false) {

		$this->intID = $id;
		$this->strRegionName = isset($post['region_name']) ? $post['region_name'] : '';
		$this->intCountryId = isset($post['country_id']) ? $post['country_id'] : '';
		$this->intStateId = isset($post['state_id']) ? $post['state_id'] : '';
		$this->intDisplayOrder = isset($post['display_order']) ? $post['display_order'] : '';
		$this->strSlug = isset($post['slug']) ? $post['slug'] : '';
		$this->strSlug = str_replace('/regions/','',$this->strSlug);

		$this->strFocusKeyword = isset($post['focus_keyword']) ? $post['focus_keyword'] : '';
		$this->strMetaTitle = isset($post['meta_title']) ? $post['meta_title'] : '';
		$this->strMetaKeywords = isset($post['meta_keywords']) ? $post['meta_keywords'] : '';
		$this->strMetaDescription = isset($post['meta_description']) ? $post['meta_description'] : '';
		$this->strMetaRobots = isset($post['meta_robots']) ? $post['meta_robots'] : "index,follow";
		$this->intScoreSEO = isset($post['score_seo']) ? $post['score_seo'] : 0;

		$this->strFacebookTitle = isset($post['facebook_title']) ? $post['facebook_title'] : '';
		$this->strFacebookDescription = isset($post['facebook_description']) ? $post['facebook_description'] : '';
		$this->strTwitterTitle = isset($post['twitter_title']) ? $post['twitter_title'] : '';
		$this->strTwitterDescription = isset($post['twitter_description']) ? $post['twitter_description'] : '';
		$this->strGoogleDescription = isset($post['google_description']) ? $post['google_description'] : '';
		$this->strRegionSubText = isset($post['region_subtext']) ? $post['region_subtext'] : '';
		$this->strRegionSubText2 = isset($post['region_subtext2']) ? $post['region_subtext2'] : '';
		$this->strZlevel  = isset($post['zlevel']) ? $post['zlevel'] : '';
		$this->strLatitude = isset($post['latitude']) ? $post['latitude'] : '';
		$this->strLongitude = isset($post['longitude']) ? $post['longitude'] : '';

		$this->arrSelectedCourses = isset($post['course_id']) ? $post['course_id'] : array();
		$this->arrSelectedHotels = isset($post['hotel_id']) ? $post['hotel_id'] : array();

		$this->strText1 = isset($post['text1']) ? $post['text1'] : '';
		$this->strText2 = isset($post['text2']) ? $post['text2'] : '';
		$this->strText3 = isset($post['text3']) ? $post['text3'] : '';

        $this->arrFilesToDelete = isset($post['files_to_delete']) ? $post['files_to_delete'] : '';

		if($this->strRegionName == '') { $this->strErrorMessage .= "Please enter a name for this region.<br />"; }
		if($this->strSlug == '' && $this->strRegionName != '') { $this->strSlug = $this->strRegionName; }
		$this->strSlug = Util::cleanForUrl($this->strSlug);

		$slug_exists = $this->validSlug($this->strTableName, $this->strSlug, $id);
		if(!empty($slug_exists)){
			$this->strErrorMessage .= "Region with this slug already exists.<br />";
		}

        $this->strVideoEmbed = isset($post['video_embed']) ? $post['video_embed'] : '';
        $this->strVideoSmallHeading = isset($post['video_smallheading']) ? $post['video_smallheading'] : '';
        $this->strVideoLargeHeading= isset($post['video_largeheading']) ? $post['video_largeheading'] : '';
        $this->strVideoText = isset($post['video_text']) ? $post['video_text'] : '';
        $this->strVideoBtnText = isset($post['video_buttontext']) ? $post['video_buttontext'] : '';
        $this->strVideoLink = isset($post['video_link']) ? $post['video_link'] : '';

		if($this->strErrorMessage == '') {

			$keys = array(
				'region_name',
				'country_id',
				'state_id',
				'slug',
				'focus_keyword',
				'meta_title',
				'meta_keywords',
				'meta_description',
				'meta_robots',
				'score_seo',
				'facebook_title',
				'facebook_description',
				'twitter_title',
				'twitter_description',
				'google_description',
				'region_subtext',
				'region_subtext2',
				'text1',
				'text2',
				'text3',
				'zlevel',
				'latitude',
				'longitude',
				'display_order',
                'video_embed',
                'video_smallheading',
                'video_largeheading',
                'video_text',
                'video_buttontext',
                'video_link'
			);
			$vals = array(
				$this->strRegionName,
				$this->intCountryId,
				$this->intStateId,
				$this->strSlug,
				$this->strFocusKeyword,
				$this->strMetaTitle,
				$this->strMetaKeywords,
				$this->strMetaDescription,
				$this->strMetaRobots,
				$this->intScoreSEO,
                $this->strFacebookTitle,
                $this->strFacebookDescription,
                $this->strTwitterTitle,
                $this->strTwitterDescription,
                $this->strGoogleDescription,
                $this->strRegionSubText,
                $this->strRegionSubText2,
                $this->strText1,
                $this->strText2,
                $this->strText3,
                $this->strZlevel,
                $this->strLatitude,
                $this->strLongitude,
                $this->intDisplayOrder,
                $this->strVideoEmbed,
                $this->strVideoSmallHeading,
                $this->strVideoLargeHeading,
                $this->strVideoText,
                $this->strVideoBtnText,
                $this->strVideoLink
            );

			//$types = array('sissssssssss');

			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;

			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}


			if(count($this->arrSelectedCourses) == 0) {
				$delSql = "DELETE FROM course_region WHERE region_id=$this->intID";
			} else {
				$csvSelectedCourses = implode(",",$this->arrSelectedCourses);
				$delSql = "DELETE FROM course_region WHERE region_id=$this->intID AND course_id not in ($csvSelectedCourses)";
			}

			$this->short_query($delSql);
			foreach($this->arrSelectedCourses As $k=>$c) {
				$sql = "INSERT INTO course_region (region_id, course_id)
				VALUES ($this->intID, ".$c.")
				ON DUPLICATE KEY UPDATE region_id=$this->intID";

				$this->short_query($sql);
			}


			if(count($this->arrSelectedHotels) == 0) {
				$delSql = "DELETE FROM hotel_region WHERE region_id=$this->intID";
			} else {
				$csvSelectedHotels = implode(",",$this->arrSelectedHotels);
				$delSql = "DELETE FROM hotel_region WHERE region_id=$this->intID AND hotel_id not in ($csvSelectedHotels)";
			}


			$this->short_query($delSql);
			foreach($this->arrSelectedHotels As $k=>$h) {
				$sql = "INSERT INTO hotel_region (region_id, hotel_id)
				VALUES ($this->intID, ".$h.")
				ON DUPLICATE KEY UPDATE region_id=$this->intID";

				$this->short_query($sql);
			}

			// Delete any files that were checked for deletion
            if (!empty($this->arrFilesToDelete)) {
                foreach ($this->arrFilesToDelete as $strFieldName => $strFilePath) {
                    if (Util::deleteFile($strFilePath)) {
                        $this->strQuery = "UPDATE $this->strTableName SET `$strFieldName` = NULL WHERE `id` = $this->intID";
                        $this->short_query($this->strQuery);
                    }
                }
            }


			if($_FILES['facebook_image']['error'] != 4) {
	            // Upload our Facebook image
				$arrUploaded = Util::uploadFile(
	                $_FILES['facebook_image'],
	                $this->strUploadsDir,
	                $this->intID.'_facebook',
	                array('image/*'),
	                true,
	                true
	            );
	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET `facebook_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br />Facebook Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


	        if($_FILES['twitter_image']['error'] != 4) {
	            $arrUploaded = Util::uploadFile(
	                $_FILES['twitter_image'],
	                $this->strUploadsDir,
	                $this->intID.'_twitter',
	                array('image/*'),
	                true,
	                true
	            );
	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET twitter_image = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br />Twitter Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


        } //error message check

        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		From $this->strTableName
		WHERE id=$id
		LIMIT 0,1";


		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$this->arrSelectedCourses = array();
			$this->arrSelectedHotels = array();
			$this->strRegionName = isset($result['region_name']) ? $result['region_name'] : '';
			$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
			$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
			$this->intDisplayOrder = isset($result['display_order']) ? $result['display_order'] : '';
			$this->strFocusKeyword = isset($result['focus_keyword']) ? $result['focus_keyword'] : '';
			$this->strMetaTitle = isset($result['meta_title']) ? $result['meta_title'] : '';
			$this->strMetaKeywords = isset($result['meta_keywords']) ? $result['meta_keywords'] : '';
			$this->strMetaDescription = isset($result['meta_description']) ? $result['meta_description'] : '';
			$this->strMetaRobots = isset($result['meta_robots']) ? $result['meta_robots'] : "index,follow";
			$this->strFacebookTitle = isset($result['facebook_title']) ? $result['facebook_title'] : '';
			$this->strFacebookDescription = isset($result['facebook_description']) ? $result['facebook_description'] : '';
			$this->strFacebookImage = isset($result['facebook_image']) ? $result['facebook_image'] : '';
			$this->strTwitterTitle = isset($result['twitter_title']) ? $result['twitter_title'] : '';
			$this->strTwitterDescription = isset($result['twitter_description']) ? $result['twitter_description'] : '';
			$this->strTwitterImage = isset($result['twitter_image']) ? $result['twitter_image'] : '';
			$this->strGoogleDescription = isset($result['google_description']) ? $result['google_description'] : '';
			$this->strRegionSubText = isset($result['region_subtext']) ? $result['region_subtext'] : '';
			$this->strRegionSubText2 = isset($result['region_subtext2']) ? $result['region_subtext2'] : '';
			$this->strZlevel  = isset($result['zlevel']) ? $result['zlevel'] : '';
			$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
			$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
			$this->strText1 = isset($result['text1']) ? $result['text1'] : '';
			$this->strText2 = isset($result['text2']) ? $result['text2'] : '';
			$this->strText3 = isset($result['text3']) ? $result['text3'] : '';
			$this->strSlug = '/regions/'.$this->strSlug;

            $this->strVideoEmbed = isset($result['video_embed']) ? $result['video_embed'] : '';
            $this->strVideoSmallHeading = isset($result['video_smallheading']) ? $result['video_smallheading'] : '';
            $this->strVideoLargeHeading= isset($result['video_largeheading']) ? $result['video_largeheading'] : '';
            $this->strVideoText = isset($result['video_text']) ? $result['video_text'] : '';
            $this->strVideoBtnText = isset($result['video_buttontext']) ? $result['video_buttontext'] : '';
            $this->strVideoLink = isset($result['video_link']) ? $result['video_link'] : '';

			$strQuery = "SELECT course_id FROM course_region WHERE region_id=$id";
			if($this->query($strQuery)) {
		     	if($res = $this->getMysqliResults($strQuery,true)){
		     		foreach($res As $r) {
		     			$this->arrSelectedCourses[] = $r['course_id'];
		     		}
		     	}
		     }

		    $strQuery = "SELECT hotel_id FROM hotel_region WHERE region_id=$id";
			if($this->query($strQuery)) {
		     	if($res = $this->getMysqliResults($strQuery,true)){
		     		foreach($res As $r) {
		     			$this->arrSelectedHotels[] = $r['hotel_id'];
		     		}
		     	}
		    }


		    // Score the SEO content of the page
            if (class_exists('SEO_Scorer')) {
                $objScore = new SEO_Scorer(array(
                    'keyword' => $this->strFocusKeyword,
                    'meta_title' => $this->strMetaTitle,
                    'meta_description' => $this->strMetaDescription,
                    'meta_robots' => $this->strMetaRobots,
                    'content' => $this->strText1.' '.$this->strText2,
                    'url' => $this->strSlug
                ));
                $this->arrScore = $objScore->getScore();
            }


			return $result;


	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }


	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.region_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, s.state_name, c.country_name
	     From $this->strTableName t
	     Left Join state s on s.`id`=t.`state_id`
	     Left Join country c on c.`id`=s.`country_id`
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.region_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}

	public function getCountrys() {

		$strQuery = "SELECT *
		from country t ";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);

	     	$res[] = array(
	     		'id' => -1,
	     		'country_name' => 'N/A',
	     		'code' => 'XX',
	     		'status' => 'Active'
	     	);

	     	return $res;
	    } else {
	    	return null;
	    }

	}


	public function getStates() {

		$strQuery = "SELECT *
		from state t ";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}


	public function getRegions($debug = false) {

		$strQuery = "SELECT id, region_name
		             FROM region r
                     WHERE status = 'Active'
                     ORDER BY region_name
                     ASC";

		if($debug){
			Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}


	public function getCourses($id) {

		$strQuery = "SELECT id, course_name ,
		(SELECT count(course_id) FROM course_region WHERE region_id=$id AND course_id=id) As blnActive
		from course c
		WHERE status='Active'
		ORDER BY course_name";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}





	public function getCoursesForRegion($id) {

		$strQuery = "SELECT id, course_name ,
		(SELECT count(course_id) FROM course_region WHERE region_id=$id AND course_id=id) As blnActive
		from course c
		WHERE status='Active'
		AND region_id=$id
		ORDER BY course_name";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}



	public function getHotels($id) {

		$strQuery = "SELECT id, hotel_name,
		(SELECT count(hotel_id) FROM hotel_region WHERE region_id=$id AND hotel_id=id) As blnActive
		from hotel h
		WHERE status='Active'
		ORDER BY hotel_name";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}


	public function getHotelsForRegion($id,$debug = false) {

		$strQuery = "SELECT id, hotel_name,
		(SELECT count(hotel_id) FROM hotel_region WHERE region_id=$id AND hotel_id=id) As blnActive
		from hotel h
		WHERE status='Active'
		AND region_id=$id
		ORDER BY hotel_name";

		//if($type != '') $strQuery .= "WHERE status='$type'";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		 }



		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}



	public function updateCourseRegion($region_id,$course_id,$val) {


		if($val == 'false') {
			$strQuery = "DELETE FROM course_region WHERE course_id=$course_id AND region_id=$region_id";
		}else {
			$strQuery = "INSERT INTO course_region SET course_id=$course_id, region_id=$region_id ON DUPLICATE KEY UPDATE course_id=$course_id";
		}

		//$result = array('Region'=>$region_id , 'course_id'=>$course_id, 'Val'=>$val, 'strQuery'=>$strQuery);
		$result = array('Region'=>$region_id);

		//return $result;

		//echo $strQuery;

		if($this->short_query($strQuery)) {
	     	//$res = $this->getMysqliResults($strQuery,true);
	     	return $result;
	    } else {
	    	return null;
	    }
	}

	public function updateHotelRegion($region_id,$hotel_id,$val) {


		if($val == 'false') {
			$strQuery = "DELETE FROM hotel_region WHERE hotel_id=$hotel_id AND region_id=$region_id";
		}else {
			$strQuery = "INSERT INTO hotel_region SET hotel_id=$hotel_id, region_id=$region_id ON DUPLICATE KEY UPDATE hotel_id=$hotel_id";
		}

		//$result = array('Region'=>$region_id , 'course_id'=>$course_id, 'Val'=>$val, 'strQuery'=>$strQuery);
		$result = array('Region'=>$region_id);

		//return $result;

		//echo $strQuery;

		if($this->short_query($strQuery)) {
	     	//$res = $this->getMysqliResults($strQuery,true);
	     	return $result;
	    } else {
	    	return null;
	    }
	}


	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}



	public function getRegionImageList($region_id) {


		$strQuery = "SELECT *
		FROM region_img where region_id=$region_id AND status = 'Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}






}



?>