<?php


class Rate extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $records = 1;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;

	public function __construct($strPageId = '',$strAction = '') {
		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'rates';
		$this->strTableSlug = $strPageId;
	}

	/*** Hotels ***/

	public static function getHotelsNoRatesInRange($arrOptionsIn = array()){
		if(!isset($arrOptionsIn['min_start_date']) || empty($arrOptionsIn['min_start_date']) ||
			!isset($arrOptionsIn['max_start_date']) || empty($arrOptionsIn['max_start_date']) ||
			!isset($arrOptionsIn['min_end_date']) || empty($arrOptionsIn['min_end_date']) ||
			!isset($arrOptionsIn['max_end_date']) || empty($arrOptionsIn['max_end_date'])){
				// required informatino not provided
				return array();
		}

		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'hotel_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'hotel_name',
			'sort_order' => 'ASC'
		);

        if (isset($_GET['sort']) && ($_GET['sort'] != 'hotel_name')) {
            if ($_GET['sort'] == 'last_rate_change') {
                $arrOptions['order_by'] = 'last_rate_change';
            }
        }

        if (isset($_GET['dir']) && ($_GET['dir'] != 'ASC')) {
            if ($_GET['dir'] == 'DESC') {
                $arrOptions['sort_order'] = 'DESC';
            }
        }

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrHotels = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `h` . *, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `h`.`region_id`) AS region_name "
							.   " FROM `hotel` `h` "
        					.   " LEFT JOIN ( "
        					.           " SELECT * "
						    .             " FROM `hotel_rates` `hr` "
							.            " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		$objRate->strQuery .= " AND ((`hr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		$objRate->strQuery .= " AND `hr`.`start_date` <= '" . $arrOptions['max_start_date'] . "') ";
		$objRate->strQuery .= " OR (`hr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		$objRate->strQuery .= " AND `hr`.`end_date` <= '" . $arrOptions['max_end_date'] . "')) ";

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		$objRate->strQuery .=   " ) `hr2` "
							.    " ON `hr2`.`hotel_id` = `h`.`id` "
							. " WHERE `hr2`.`hotel_id` IS NULL ";

	    if(!empty($arrOptions['hotel_name'])){
	    	$objRate->strQuery .= " AND `h`.`hotel_name` LIKE '%" . $arrOptions['hotel_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `h`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrHotels;
	}
	
	public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
        $columns = $this->getMysqliResults( $sql, true );
        
        $_SESSION['is_admin'] = $columns[0]['is_admin'];
            
        if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public static function getHotelsWithRatesInRange($arrOptionsIn = array()){
		if(!isset($arrOptionsIn['min_start_date']) || empty($arrOptionsIn['min_start_date']) ||
			!isset($arrOptionsIn['max_start_date']) || empty($arrOptionsIn['max_start_date']) ||
			!isset($arrOptionsIn['min_end_date']) || empty($arrOptionsIn['min_end_date']) ||
			!isset($arrOptionsIn['max_end_date']) || empty($arrOptionsIn['max_end_date'])){
				// required informatino not provided
				return array();
		}

		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'hotel_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'hotel_name',
			'sort_order' => 'ASC',
			'group_by' => '`h`.`id`'
		);

		if(!empty($arrOptionsIn['start_date']) || !empty($arrOptionsIn['end_date'])){
			// remove default active date so the default doesn't restrict the passed in data
			$arrOptions['active_date'] = null;
		}

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrHotels = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `h`.*, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `h`.`region_id`) AS region_name "
						    .   " FROM `hotel` `h` "
							.   " JOIN `hotel_rates` `hr` "
							.        " ON `hr`.`hotel_id` = `h`.`id` "
							.  " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		$objRate->strQuery .= " AND ((`hr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		$objRate->strQuery .= " AND `hr`.`start_date` <= '" . $arrOptions['max_start_date'] . "') ";
		$objRate->strQuery .= " OR (`hr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		$objRate->strQuery .= " AND `hr`.`end_date` <= '" . $arrOptions['max_end_date'] . "')) ";

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['hotel_name'])){
	    	$objRate->strQuery .= " AND `h`.`hotel_name` LIKE '%" . $arrOptions['hotel_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `h`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['group_by'])){
			$objRate->strQuery .= " GROUP BY " . $arrOptions['group_by'];
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrHotels;
	}

	public static function getHotelsNoRates($arrOptionsIn = array()){
		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'hotel_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'hotel_name',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrHotels = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `h` . *, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `h`.`region_id`) AS region_name "
							.   " FROM `hotel` `h` "
        					.   " LEFT JOIN ( "
        					.           " SELECT * "
						    .             " FROM `hotel_rates` `hr` "
							.            " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		if(!empty($arrOptions['min_start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		}

		if(!empty($arrOptions['max_start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` <= '" . $arrOptions['max_start_date'] . "' ";
		}

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['min_end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		}

		if(!empty($arrOptions['max_end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` <= '" . $arrOptions['max_end_date'] . "' ";
		}

		$objRate->strQuery .=   " ) `hr2` "
							.    " ON `hr2`.`hotel_id` = `h`.`id` "
							. " WHERE `hr2`.`hotel_id` IS NULL ";

	    if(!empty($arrOptions['hotel_name'])){
	    	$objRate->strQuery .= " AND `h`.`hotel_name` LIKE '%" . $arrOptions['hotel_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `h`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrHotels;
	}

	public static function getHotelsWithRates($arrOptionsIn = array()){
		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'hotel_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'hotel_name',
			'sort_order' => 'ASC',
			'group_by' => '`h`.`id`'
		);

        if (isset($_GET['sort']) && ($_GET['sort'] != 'hotel_name')) {
            if ($_GET['sort'] == 'last_rate_change') {
                $arrOptions['order_by'] = 'last_rate_change';
            }
        }

        if (isset($_GET['dir']) && ($_GET['dir'] != 'ASC')) {
            if ($_GET['dir'] == 'DESC') {
                $arrOptions['sort_order'] = 'DESC';
            }
        }

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrHotels = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `h`.*, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `h`.`region_id`) AS region_name "
						    .   " FROM `hotel` `h` "
							.   " JOIN `hotel_rates` `hr` "
							.        " ON `hr`.`hotel_id` = `h`.`id` "
							.  " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		if(!empty($arrOptions['min_start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		}

		if(!empty($arrOptions['max_start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` <= '" . $arrOptions['max_start_date'] . "' ";
		}

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['min_end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		}

		if(!empty($arrOptions['max_end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` <= '" . $arrOptions['max_end_date'] . "' ";
		}

		if(!empty($arrOptions['hotel_name'])){
	    	$objRate->strQuery .= " AND `h`.`hotel_name` LIKE '%" . $arrOptions['hotel_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `h`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['group_by'])){
			$objRate->strQuery .= " GROUP BY " . $arrOptions['group_by'];
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrHotels;
	}

	public static function getHotelPackageRates($arrOptions) {

		$intPackageId = $arrOptions['package_id'];
		$intHotelId = $arrOptions['hotel_id'];
		$strStartDate = $arrOptions['check_in'];
		$strEndDate = $arrOptions['check_out'];
		$objRate = new static;

		$strSql = "SELECT * FROM hotel_rates
						WHERE (hotel_id = $intHotelId
							AND (
									(start_date >= '$strStartDate' AND end_date <= '$strEndDate')
									OR
									(start_date <= '$strEndDate' AND end_date >= '$strStartDate')
								)
							AND deleted != 1)
							OR (hotel_id = $intHotelId
							 AND id IN (SELECT rate_id FROM package_hotel_rates WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = $intPackageId)))";

		$arrHotels = $objRate->getMysqliResults($strSql, true);

		foreach ($arrHotels as &$arrHotel) {
			$arrHotel['fees'] = $objRate->getMysqliResults("SELECT * FROM fees WHERE hotel_rate_id = " . $arrHotel['id'], true);
		}

		return $arrHotels;

	}

	public static function getHotelRates($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'hotel_id' => null,
			'name' => null, // contains search
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'length' => null,
			'parent_id' => null,
			'price' => null,
			'min_price' => null,
			'max_price' => null,
			'rack_rate' => null,
			'min_rack_rate' => null,
			'max_rack_rate' => null,
			'room_type' => null,
			'room_type_rating' => null,
			'min_room_type_rating' => null,
			'max_room_type_rating' => null,
			'occupancy' => null,
			'minimum_stay' => null, // always search greather then
			'deposit' => null, // contains search
			'notes' => null, // contains search
			'limit' => null,
			'offset' => null,
			'order_by' => 'start_date',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT `hr`.*, "
						   . " `rdt`.`name` AS `detail_type_name`, "
						   . " `rdt`.`description` AS `detail_type_description`, "
						   . " `rdt`.`rating` AS `detail_type_rating`, "
						   . " `h`.`hotel_name`, "
						   . " (SELECT IF(count('x') > 0, 1, 0) FROM `hotel_rates` `hr2` WHERE `hr2`.`parent_id` = `hr`.`id`) AS `has_children` "
						   . " FROM `hotel_rates` `hr` "
						   . " LEFT JOIN `rate_detail_types` `rdt` "
						   . " ON `rdt`.`id` = `hr`.`room_type` "
   						   . " LEFT JOIN `hotel` `h` "
						   . " ON `h`.`id` = `hr`.`hotel_id` "
						   . " WHERE 1 = 1 "
						   . " AND `hr`.`deleted` != 1 "
						   . " AND (`rdt`.`type` = 'hotel' "
						   . " OR `rdt`.`type` IS NULL ) ";

		if(!empty($arrOptions['hotel_id'])){
			$objRate->strQuery .= " AND `hr`.`hotel_id` = " . $arrOptions['hotel_id'] . " ";
		}

		if(!empty($arrOptions['parent_id'])){
			if(strtolower($arrOptions['parent_id']) == 'empty'){
				$objRate->strQuery .= " AND `hr`.`parent_id` IS NULL ";
			}else{
				$objRate->strQuery .= " AND `hr`.`parent_id` = " . $arrOptions['parent_id'] . " ";
			}
		}

		if(!empty($arrOptions['name'])){
			$objRate->strQuery .= " AND LOWER(`hr`.`name`) LIKE LOWER('%" . $arrOptions['name'] . "%') ";
		}
/*
		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		if(!empty($arrOptions['min_start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		}

		if(!empty($arrOptions['max_start_date'])){
			$objRate->strQuery .= " AND `hr`.`start_date` <= '" . $arrOptions['max_start_date'] . "' ";
		}

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['min_end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		}

		if(!empty($arrOptions['max_end_date'])){
			$objRate->strQuery .= " AND `hr`.`end_date` <= '" . $arrOptions['max_end_date'] . "' ";
		}
*/

		if ((!empty($arrOptions['min_start_date'])) && (!empty($arrOptions['max_end_date']))) {
			$objRate->strQuery .= " AND (
		                                    (start_date >= '".$arrOptions['min_start_date']."' AND end_date <= '".$arrOptions['max_end_date']."')
		                                    OR
		                                    (start_date <= '".$arrOptions['max_end_date']."' AND end_date >= '".$arrOptions['min_start_date']."')
                                		)";
		}

		if(!empty($arrOptions['length'])){
			$objRate->strQuery .= " AND `hr`.`length` = " . $arrOptions['length'] . " ";
		}

		if(!empty($arrOptions['price'])){
			$objRate->strQuery .= " AND `hr`.`price` = " . $arrOptions['price'] . " ";
		}

		if(!empty($arrOptions['min_price'])){
			$objRate->strQuery .= " AND `hr`.`price` >= " . $arrOptions['min_price'] . " ";
		}

		if(!empty($arrOptions['max_price'])){
			$objRate->strQuery .= " AND `hr`.`price` <= " . $arrOptions['max_price'] . " ";
		}

		if(!empty($arrOptions['rack_rate'])){
			$objRate->strQuery .= " AND `hr`.`rack_rate` = " . $arrOptions['rack_rate'] . " ";
		}

		if(!empty($arrOptions['min_rack_rate'])){
			$objRate->strQuery .= " AND `hr`.`rack_rate` >= " . $arrOptions['min_rack_rate'] . " ";
		}

		if(!empty($arrOptions['max_rack_rate'])){
			$objRate->strQuery .= " AND `hr`.`rack_rate` <= " . $arrOptions['max_rack_rate'] . " ";
		}

		if(!empty($arrOptions['room_type'])){
			$objRate->strQuery .= " AND `hr`.`room_type` = " . $arrOptions['room_type'] . " ";
		}

		if(!empty($arrOptions['room_type_rating'])){
			$objRate->strQuery .= " AND `hr`.`room_type_rating` = " . $arrOptions['room_type_rating'] . " ";
		}

		if(!empty($arrOptions['min_room_type_rating'])){
			$objRate->strQuery .= " AND `hr`.`room_type_rating` >= " . $arrOptions['min_room_type_rating'] . " ";
		}

		if(!empty($arrOptions['max_room_type_rating'])){
			$objRate->strQuery .= " AND `hr`.`room_type_rating` <= " . $arrOptions['max_room_type_rating'] . " ";
		}

		if(!empty($arrOptions['occupancy'])){
			$objRate->strQuery .= " AND `hr`.`occupancy` = " . $arrOptions['occupancy'] . " ";
		}

		if(!empty($arrOptions['minimum_stay'])){
			$objRate->strQuery .= " AND `hr`.`minimum_stay` >= " . $arrOptions['minimum_stay'] . " ";
		}

		if(!empty($arrOptions['deposit'])){
			$objRate->strQuery .= " AND LOWER(`hr`.`deposit`) LIKE LOWER('%" . $arrOptions['deposit'] . "%') ";
		}

		if(!empty($arrOptions['notes'])){
			$objRate->strQuery .= " AND LOWER(`hr`.`notes`) LIKE LOWER('%" . $arrOptions['notes'] . "%') ";
		}

		if(!empty($arrOptions['order_by'])){

			if (($arrOptions['order_by'] == 'start_date') && ($arrOptions['sort_order'] == "ASC")) {

				$objRate->strQuery .= " ORDER BY `hr`.`start_date` ASC, `hr`.`private_price` ASC";

			} else {

				$objRate->strQuery .= " ORDER BY `hr`.`" . $arrOptions['order_by'] . "` ";

				if(!empty($arrOptions['sort_order'])){
					$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
				}
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

		foreach ($arrHotels as &$arrHotel) {
			$arrHotel['fees'] = $objRate->getMysqliResults("SELECT * FROM fees WHERE hotel_rate_id = " . $arrHotel['id'], true);
		}

		return $arrHotels;
	}

	public static function getHotelRateById($intRateId){
		if(empty($intRateId)){
			// no rate to find
			return array();
		}

		$objRate = new static;

		$objRate->strQuery = " SELECT `hr`.*, "
						   .        " `rdt`.`name` AS `room_type_name`, "
						   .        " `rdt`.`description` AS `room_type_description`, "
						   .        " `rdt`.`rating` AS `room_type_rating` "
						   .   " FROM `hotel_rates` `hr` "
						   .   " LEFT JOIN `rate_detail_types` `rdt` "
						   .        " ON `rdt`.`id` = `hr`.`room_type` "
						   .  " WHERE `hr`.`id` = " . $intRateId
						   .    " AND (`rdt`.`type` = 'hotel' "
						   .        " OR `rdt`.`type` IS NULL ) ";

		$arrRates = $objRate->getMysqliResults($objRate->strQuery, true);

		if(empty($arrRates) || empty($arrRates[0])){
			// rate not found
			return array();
		}

		$arrRates = $arrRates[0];

		$arrRates['fees'] = $objRate->getMysqliResults("SELECT * FROM fees WHERE hotel_rate_id = " . $arrRates['id'], true);

		return $arrRates;
	}

	public static function getHotelRoomTypes($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'type' => 'hotel',
			'name' => null, // contains search
			'description' => null, // contains search
			'rating' => null, // exact match
			'min_rating' => null, // > rating
			'max_rating' => null, // < rating
			'limit' => null,
			'offset' => null,
			'order_by' => 'name',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT `rdt`.* "
						   . " FROM `rate_detail_types` `rdt` "
						   . " WHERE 1 = 1 ";

		if(!empty($arrOptions['id'])){
			$objRate->strQuery .= " AND `rdt`.`id` = " . $arrOptions['id'] . " ";
		}

		if(!empty($arrOptions['type'])){
			$objRate->strQuery .= " AND `rdt`.`type` = '" . $arrOptions['type'] . "' ";
		}

		if(!empty($arrOptions['name'])){
			$objRate->strQuery .= " AND `rdt`.`name` LIKE '%" . $arrOptions['name'] . "%' ";
		}

		if(!empty($arrOptions['description'])){
			$objRate->strQuery .= " AND `rdt`.`description` LIKE '%" . $arrOptions['description'] . "%' ";
		}

		if(!empty($arrOptions['rating'])){
			$objRate->strQuery .= " AND `rdt`.`rating` = " . $arrOptions['rating'] . " ";
		}

		if(!empty($arrOptions['min_rating'])){
			$objRate->strQuery .= " AND `rdt`.`min_rating` >= " . $arrOptions['min_rating'] . " ";
		}

		if(!empty($arrOptions['max_rating'])){
			$objRate->strQuery .= " AND `rdt`.`max_rating` <= " . $arrOptions['max_rating'] . " ";
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY `rdt`.`" . $arrOptions['order_by'] . "` ";

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrRoomTypes = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrRoomTypes;
	}

	public static function updateHotelRate($arrData){
		if(empty($arrData) || !isset($arrData['id']) || empty($arrData['id'])){
			// nothing to save/save to
			return false;
		}

		$intOldId = $arrData['id'];
		$arrDateColumns = array(
			'start_date',
			'end_date'
		);

		unset($arrData['id']);

		// calculate rate length
		$objStartDate = date_create($arrData['start_date']);
		$objEndDate = date_create($arrData['end_date']);
		$objDateInterval = date_diff($objStartDate, $objEndDate);

		$arrData['length'] = $objDateInterval->days;

		$objRate = new static;

		$objRate->strQuery = " UPDATE `hotel_rates`  ";

		$blnFirst = true;
		foreach($arrData as $strColumn => $strValue){
			if($blnFirst){
				$objRate->strQuery .= " SET ";
				$blnFirst = false;
			}

			$objRate->strQuery .= " `" . $strColumn . "` = ";

			if($strValue == ''){
				$objRate->strQuery .= " NULL, ";
			}else{
				if(in_array(strtolower($strColumn), $arrDateColumns)){
					$strValue = date('Y-m-d', strtotime($strValue));
				}

				$objRate->strQuery .= " '" . $strValue . "', ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " WHERE `id` = " . $intOldId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
	    }

	    // success
	    $objRate->strSuccessMessage = 'Record Updated';
    	return $intOldId;
	}

	public static function insertHotelRate($arrData){
		if(empty($arrData) || (isset($arrData['id']) && !empty($arrData['id']))){
			// record already exsists
			return false;
		}

		$arrDateColumns = array(
			'start_date',
			'end_date'
		);

		$objRate = new static;

		$objRate->strQuery = " INSERT INTO `hotel_rates` ( ";

		foreach($arrData as $strColumn => $strValue) {
			if (!is_array($strValue)) {
				$objRate->strQuery .= " `" . $strColumn . "`, ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) VALUES ( ";

		foreach($arrData as $strColumn => $strValue){

			if (!is_array($strValue)) {
				if($strValue == ''){
					$objRate->strQuery .= " NULL, ";
				}else{
					if(in_array(strtolower($strColumn), $arrDateColumns)){
						$strValue = date('Y-m-d', strtotime($strValue));
					}

					$objRate->strQuery .= " '" . $strValue . "', ";
				}
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) ";

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// success
		$objRate->strSuccessMessage = 'Record Created';
		$intNewId = $objRate->mysqli->insert_id;

		return $intNewId;
	}

	public static function getHotelById($intHotelId){
		if(empty($intHotelId)){
			// nothing to show
			return array();
		}

		$objRate = new static;

		$objRate->strQuery = " SELECT * "
						   . " FROM `hotel` "
						   . " WHERE `id` = " . $intHotelId;

	   	$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

	   	if(empty($arrHotels) || empty($arrHotels[0])){
	   		// no hotels found
	   		return array();
	   	}

		return $arrHotels[0];
	}

	public static function getHotels($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'hotel_name' => null, // contains search
            'regions' => array(),
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'hotel_name',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT * "
						   . " FROM `hotel` "
						   . " WHERE 1 = 1 ";

		if(!empty($arrOptions['id'])){
			$objRate->strQuery .= " AND `id` = " . $arrOptions['id'] . " ";
		}

		if(!empty($arrOptions['hotel_name'])){
			$objRate->strQuery .= " AND LOWER(`hotel_name`) LIKE LOWER('%" . $arrOptions['hotel_name'] . "%') ";
		}

        if (!empty($arrOptions['regions']) && is_array($arrOptions['regions'])) {
            $objRate->strQuery .= " AND id in (SELECT `hotel_id` FROM `hotel_region` WHERE `region_id` IN (" . implode(',', $arrOptions['regions']) . ")) ";
        }

		if(!empty($arrOptions['status'])){
			$objRate->strQuery .= " AND `status` = '" . $arrOptions['status'] . "' ";
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY `" . $arrOptions['order_by'] . "` ";

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

	   	$arrHotels = $objRate->getMysqliResults($objRate->strQuery, true);

	   	if(empty($arrHotels)){
	   		// no hotels found
	   		return array();
	   	}

		return $arrHotels;
	}
/*
	public static function deleteHotelRateById($intRateId){
		if(empty($intRateId)){
			return false;
		}

		// delete any child rates (recursivly)
		$arrChildRates = static::getHotelRates(array(
			'parent_id' => $intRateId
		));

		if(!empty($arrChildRates)){
			foreach($arrChildRates as $arrChildRate){
				static::deleteHotelRateById($arrChildRate['id']);
			}
		}

		// delete this rate
		$objRate = new static;

		$objRate->strQuery = " DELETE FROM `hotel_rates` "
						   . " WHERE `id` = " . $intRateId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// success
		return true;
	}
*/

	public static function duplicateHotelRateSingle($arrOptions){
		if(!isset($arrOptions['rate_id']) || empty($arrOptions['rate_id']) ||
			!isset($arrOptions['hotel_id']) || empty($arrOptions['hotel_id'])){
			// missing required information
			return false;
		}

		// get old rate to copy from
		$arrOldRate = static::getHotelRateById($arrOptions['rate_id']);

		// setup new rate to insert
		$arrNewRate = $arrOldRate;

		unset($arrNewRate['id']);
		unset($arrNewRate['room_type_name']);
		unset($arrNewRate['room_type_description']);
		unset($arrNewRate['room_type_rating']);

		if(isset($arrOptions['parent_id']) && !empty($arrOptions['parent_id'])){
			$arrNewRate['parent_id'] = (int)$arrOptions['parent_id'];
		}else{
			// no parent
			$arrNewRate['parent_id'] = null;
		}

		if(isset($arrOptions['hotel_id']) && !empty($arrOptions['hotel_id'])){
			$arrNewRate['hotel_id'] = (int)$arrOptions['hotel_id'];
		}else{
			// no course id
			$arrNewRate['hotel_id'] = null;
		}

		// insert and return insert id
		return static::insertHotelRate($arrNewRate);
	}

	public static function getHotelDetailTypes($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'name' => null, // contains search
			'description' => null, // contains search
			'rating' => null,
			'max_rating' => null,
			'min_rating' => null,
			'type' => null,
			'limit' => null,
			'offset' => null,
			'order_by' => 'name',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT `rdt`.* "
						   . " FROM `rate_detail_types` `rdt` "
						   . " WHERE 1 = 1 ";

		if(!empty($arrOptions['id'])){
			$objRate->strQuery .= " AND `rdt`.`id` = " . $arrOptions['id'] . " ";
		}

		if(!empty($arrOptions['name'])){
			$objRate->strQuery .= " AND `rdt`.`name` LIKE '%" . $arrOptions['name'] . "%' ";
		}

		if(!empty($arrOptions['type'])){
			$objRate->strQuery .= " AND `rdt`.`type` = '" . $arrOptions['type'] . "' ";
		}

		if(!empty($arrOptions['rating'])){
			$objRate->strQuery .= " AND `rdt`.`rating` = " . $arrOptions['rating'] . " ";
		}

		if(!empty($arrOptions['min_rating'])){
			$objRate->strQuery .= " AND `rdt`.`rating` >= " . $arrOptions['min_rating'] . " ";
		}

		if(!empty($arrOptions['max_rating'])){
			$objRate->strQuery .= " AND `rdt`.`rating` <= " . $arrOptions['max_rating'] . " ";
		}

		if(!empty($arrOptions['description'])){
			$objRate->strQuery .= " AND `rdt`.`description` LIKE '%" . $arrOptions['description'] . "%' ";
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY `rdt`.`" . $arrOptions['order_by'] . "` ";

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrDetailTypes = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrDetailTypes;
	}

	/*** Detail Type ***/
	public static function getDetailTypeById($intDetailTypeId){
		if(empty($intDetailTypeId)){
			// nothing to show
			return array();
		}

		$objRate = new static;

		$objRate->strQuery = " SELECT * "
						   . " FROM `rate_detail_types` "
						   . " WHERE `id` = " . $intDetailTypeId;

	   	$arrDetailTypes = $objRate->getMysqliResults($objRate->strQuery, true);

	   	if(empty($arrDetailTypes) || empty($arrDetailTypes[0])){
	   		// no hotels found
	   		return array();
	   	}

		return $arrDetailTypes[0];
	}

	public static function updateDetailType($arrData){
		if(empty($arrData) || !isset($arrData['id']) || empty($arrData['id'])){
			// nothing to save/save to
			return false;
		}

		$intOldId = $arrData['id'];

		unset($arrData['id']);

		$objRate = new static;

		$objRate->strQuery = " UPDATE `rate_detail_types`  ";

		$blnFirst = true;
		foreach($arrData as $strColumn => $strValue){
			if($blnFirst){
				$objRate->strQuery .= " SET ";
				$blnFirst = false;
			}

			$objRate->strQuery .= " `" . $strColumn . "` = ";

			if($strValue == ''){
				$objRate->strQuery .= " NULL, ";
			}else{
				$objRate->strQuery .= " '" . $strValue . "', ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " WHERE `id` = " . $intOldId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
	    }

	    // success
	    $objRate->strSuccessMessage = 'Record Updated';
    	return $intOldId;
	}

	public static function insertDetailType($arrData){
		if(empty($arrData) || (isset($arrData['id']) && !empty($arrData['id']))){
			// record already exsists
			return false;
		}

		$objRate = new static;

		$objRate->strQuery = " INSERT INTO `rate_detail_types` ( ";

		foreach($arrData as $strColumn => $strValue){
			$objRate->strQuery .= " `" . $strColumn . "`, ";
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) VALUES ( ";

		foreach($arrData as $strColumn => $strValue){
			if($strValue == ''){
				$objRate->strQuery .= " NULL, ";
			}else{
				$objRate->strQuery .= " '" . $strValue . "', ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) ";

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// success
		$objRate->strSuccessMessage = 'Record Created';
		$intNewId = $objRate->mysqli->insert_id;

		return $intNewId;
	}

	public static function deleteDetailTypeById($intDetailTypeId){
		if(empty($intDetailTypeId)){
			return false;
		}

		$objRate = new static;

		$objRate->strQuery = " DELETE FROM `rate_detail_types` "
						   . " WHERE `id` = " . $intDetailTypeId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// update all rates with this type to null
		$objRate->strQuery = " UPDATE `hotel_rates` "
						   . " SET `room_type` = NULL "
						   . " WHERE `room_type` = " . $intDetailTypeId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
		}

		$objRate->strQuery = " UPDATE `course_rates` "
						   . " SET `course_type` = NULL "
						   . " WHERE `course_type` = " . $intDetailTypeId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
		}


		// success
		return true;
	}

	/*** Courses ***/
	public static function getCoursesNoRatesInRange($arrOptionsIn = array()){
		if(!isset($arrOptionsIn['min_start_date']) || empty($arrOptionsIn['min_start_date']) ||
			!isset($arrOptionsIn['max_start_date']) || empty($arrOptionsIn['max_start_date']) ||
			!isset($arrOptionsIn['min_end_date']) || empty($arrOptionsIn['min_end_date']) ||
			!isset($arrOptionsIn['max_end_date']) || empty($arrOptionsIn['max_end_date'])){
				// required informatino not provided
				return array();
		}

		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'course_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'course_name',
			'sort_order' => 'ASC'
		);

        if (isset($_GET['sort']) && ($_GET['sort'] != 'course_name')) {
            if ($_GET['sort'] == 'last_rate_change') {
                $arrOptions['order_by'] = 'last_rate_change';
            }
        }

        if (isset($_GET['dir']) && ($_GET['dir'] != 'ASC')) {
            if ($_GET['dir'] == 'DESC') {
                $arrOptions['sort_order'] = 'DESC';
            }
        }

		if(!empty($arrOptionsIn['start_date']) || !empty($arrOptionsIn['end_date'])){
			// remove default active date so the default doesn't restrict the passed in data
			$arrOptions['active_date'] = null;
		}

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrHotels = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `c` . *, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `c`.`region_id`) AS region_name "
							.   " FROM `course` `c` "
        					.   " LEFT JOIN ( "
        					.           " SELECT * "
						    .             " FROM `course_rates` `cr` "
							.            " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		$objRate->strQuery .= " AND ((`cr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		$objRate->strQuery .= " AND `cr`.`start_date` <= '" . $arrOptions['max_start_date'] . "') ";
		$objRate->strQuery .= " OR (`cr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		$objRate->strQuery .= " AND `cr`.`end_date` <= '" . $arrOptions['max_end_date'] . "')) ";

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		$objRate->strQuery .=   " ) `cr2` "
							.    " ON `cr2`.`course_id` = `c`.`id` "
							. " WHERE `cr2`.`course_id` IS NULL ";

	    if(!empty($arrOptions['course_name'])){
	    	$objRate->strQuery .= " AND `c`.`course_name` LIKE '%" . $arrOptions['course_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `c`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrCourses;
	}

	public static function getCoursesWithRatesInRange($arrOptionsIn = array()){
		if(!isset($arrOptionsIn['min_start_date']) || empty($arrOptionsIn['min_start_date']) ||
			!isset($arrOptionsIn['max_start_date']) || empty($arrOptionsIn['max_start_date']) ||
			!isset($arrOptionsIn['min_end_date']) || empty($arrOptionsIn['min_end_date']) ||
			!isset($arrOptionsIn['max_end_date']) || empty($arrOptionsIn['max_end_date'])){
				// required informatino not provided
				return array();
		}

		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'course_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'course_name',
			'sort_order' => 'ASC',
			'group_by' => '`c`.`id`'
		);

		if(!empty($arrOptionsIn['start_date']) || !empty($arrOptionsIn['end_date'])){
			// remove default active date so the default doesn't restrict the passed in data
			$arrOptions['active_date'] = null;
		}

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrCourses = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `c`.*, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `c`.`region_id`) AS region_name "
						    .   " FROM `course` `c` "
							.   " JOIN `course_rates` `cr` "
							.        " ON `cr`.`course_id` = `c`.`id` "
							.  " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		$objRate->strQuery .= " AND ((`cr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		$objRate->strQuery .= " AND `cr`.`start_date` <= '" . $arrOptions['max_start_date'] . "') ";
		$objRate->strQuery .= " OR (`cr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		$objRate->strQuery .= " AND `cr`.`end_date` <= '" . $arrOptions['max_end_date'] . "')) ";

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['course_name'])){
	    	$objRate->strQuery .= " AND `c`.`course_name` LIKE '%" . $arrOptions['course_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `c`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['group_by'])){
			$objRate->strQuery .= " GROUP BY " . $arrOptions['group_by'];
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrCourses;
	}

	public static function getCoursesNoRates($arrOptionsIn = array()){
		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'course_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'course_name',
			'sort_order' => 'ASC'
		);

		if(!empty($arrOptionsIn['start_date']) || !empty($arrOptionsIn['end_date'])){
			// remove default active date so the default doesn't restrict the passed in data
			$arrOptions['active_date'] = null;
		}

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrHotels = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `c` . *, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `c`.`region_id`) AS region_name "
							.   " FROM `course` `c` "
        					.   " LEFT JOIN ( "
        					.           " SELECT * "
						    .             " FROM `course_rates` `cr` "
							.            " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		if(!empty($arrOptions['min_start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		}

		if(!empty($arrOptions['max_start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` <= '" . $arrOptions['max_start_date'] . "' ";
		}

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['min_end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		}

		if(!empty($arrOptions['max_end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` <= '" . $arrOptions['max_end_date'] . "' ";
		}

		$objRate->strQuery .=   " ) `cr2` "
							.    " ON `cr2`.`course_id` = `c`.`id` "
							. " WHERE `cr2`.`course_id` IS NULL ";

	    if(!empty($arrOptions['course_name'])){
	    	$objRate->strQuery .= " AND `c`.`course_name` LIKE '%" . $arrOptions['course_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `c`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrCourses;
	}

	public static function getCoursePackageRates($arrOptions) {

		$intPackageId = $arrOptions['package_id'];
		$intCourseId = $arrOptions['course_id'];
		$strTeeDate = $arrOptions['tee_date'];
		$intRateId = $arrOptions['rate_id'];

		$objRate = new static;

		$strSql = "SELECT * FROM course_rates
						WHERE (course_id = $intCourseId
							AND '$strTeeDate' >= start_date
							AND  '$strTeeDate' <= end_date
							AND deleted != 1)
							AND parent_id IS NOT NULL
							OR (id = $intRateId)";

		$arrCourses = $objRate->getMysqliResults($strSql, true);

		foreach ($arrCourses as &$arrCourse) {
			$arrCourse['fees'] = $objRate->getMysqliResults("SELECT * FROM fees WHERE course_rate_id = " . $arrCourse['id'], true);
		}

		return $arrCourses;

	}

	public static function getCourseRatesByCourse($intCourseId) {

		$arrRates = array();
		$objRate = new static;

		if (is_numeric($intCourseId)) {

			$strQuery = "SELECT * FROM course_rates WHERE course_id = " . $intCourseId . " AND parent_id IS NOT NULL ";
			$arrRates = $objRate->getMysqliResults($strQuery, true);
		}

		return $arrRates;
	}

	public static function getCourseRateFees($intRateId) {
		$arrFees = array();
		$objRate = new static;

		if (is_numeric($intRateId)) {
			$strQuery = "SELECT * FROM fees WHERE course_rate_id = " . $intRateId;
			$arrFees = $objRate->getMysqliResults($strQuery, true);
		}

		return $arrFees;
	}

	public static function getHotelRateFees($intRateId) {
		$arrFees = array();
		$objRate = new static;

		if (is_numeric($intRateId)) {
			$strQuery = "SELECT * FROM fees WHERE hotel_rate_id = " . $intRateId;
			$arrFees = $objRate->getMysqliResults($strQuery, true);
		}

		return $arrFees;
	}

	public static function getCoursesWithRates($arrOptionsIn = array()){
		$arrOptions = array(
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'course_name' => null,
			'status' => 'Active',
			'limit' => null,
			'offset' => null,
			'order_by' => 'course_name',
			'sort_order' => 'ASC',
			'group_by' => '`c`.`id`'
		);

		if(!empty($arrOptionsIn['start_date']) || !empty($arrOptionsIn['end_date'])){
			// remove default active date so the default doesn't restrict the passed in data
			$arrOptions['active_date'] = null;
		}

        if (isset($_GET['sort']) && ($_GET['sort'] != 'course_name')) {
            if ($_GET['sort'] == 'last_rate_change') {
                $arrOptions['order_by'] = 'last_rate_change';
            }
        }

        if (isset($_GET['dir']) && ($_GET['dir'] != 'ASC')) {
            if ($_GET['dir'] == 'DESC') {
                $arrOptions['sort_order'] = 'DESC';
            }
        }

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$arrCourses = array();

		$objRate->strQuery = '';

		$objRate->strQuery .= " SELECT `c`.*, "
							. " (SELECT `r`.`region_name` FROM `region` `r` WHERE `r`.`id` = `c`.`region_id`) AS region_name "
						    .   " FROM `course` `c` "
							.   " JOIN `course_rates` `cr` "
							.        " ON `cr`.`course_id` = `c`.`id` "
							.  " WHERE 1 = 1 ";

		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		if(!empty($arrOptions['min_start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		}

		if(!empty($arrOptions['max_start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` <= '" . $arrOptions['max_start_date'] . "' ";
		}

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['min_end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		}

		if(!empty($arrOptions['max_end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` <= '" . $arrOptions['max_end_date'] . "' ";
		}

		if(!empty($arrOptions['course_name'])){
	    	$objRate->strQuery .= " AND `c`.`course_name` LIKE '%" . $arrOptions['course_name'] . "%' ";
	    }

	    if(!empty($arrOptions['status'])){
	    	$objRate->strQuery .= " AND `c`.`status` = '" . $arrOptions['status'] . "' ";
	    }

		if(!empty($arrOptions['group_by'])){
			$objRate->strQuery .= " GROUP BY " . $arrOptions['group_by'];
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY " . $arrOptions['order_by'];

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrCourses;
	}

	public static function getCourseRates($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'course_id' => null,
			'name' => null, // contains search
			'start_date' => null, // start of year
			'min_start_date' => null, // start of year
			'max_start_date' => null, // start of year
			'end_date' => null, // end of year
			'min_end_date' => null, // end of year
			'max_end_date' => null, // end of year
			'length' => null,
			'parent_id' => null,
			'price' => null,
			'min_price' => null,
			'max_price' => null,
			'rack_rate' => null,
			'min_rack_rate' => null,
			'max_rack_rate' => null,
			'course_type' => null,
			'course_type_rating' => null,
			'min_course_type_rating' => null,
			'max_course_type_rating' => null,
			'rate_based_count' => null,
			'deposit' => null, // contains search
			'notes' => null, // contains search
			'limit' => null,
			'offset' => null,
			'order_by' => 'start_date',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT `cr`.*, "
						   . " `rdt`.`name` AS `detail_type_name`, "
						   . " `rdt`.`description` AS `detail_type_description`, "
						   . " `rdt`.`rating` AS `detail_type_rating`, "
						   . " `c`.`course_name`, "
						   . " (SELECT IF(count('x') > 0, 1, 0) FROM `course_rates` `cr2` WHERE `cr2`.`parent_id` = `cr`.`id`) AS `has_children` "
						   . " FROM `course_rates` `cr` "
						   . " LEFT JOIN `rate_detail_types` `rdt` "
						   . " ON `rdt`.`id` = `cr`.`course_type` "
   						   . " LEFT JOIN `course` `c` "
						   . " ON `c`.`id` = `cr`.`course_id` "
						   . " WHERE 1 = 1 "
						   . " AND `cr`.`deleted` != 1 "
						   . " AND (`rdt`.`type` = 'course' "
						   . " OR `rdt`.`type` IS NULL ) ";

		if(!empty($arrOptions['course_id'])){
			$objRate->strQuery .= " AND `cr`.`course_id` = " . $arrOptions['course_id'] . " ";
		}

		if(!empty($arrOptions['parent_id'])){
			if(strtolower($arrOptions['parent_id']) == 'empty'){
				$objRate->strQuery .= " AND `cr`.`parent_id` IS NULL ";
			}else{
				$objRate->strQuery .= " AND `cr`.`parent_id` = " . $arrOptions['parent_id'] . " ";
			}
		}

		if(!empty($arrOptions['name'])){
			$objRate->strQuery .= " AND LOWER(`cr`.`name`) LIKE LOWER('%" . $arrOptions['name'] . "%') ";
		}
/*
		if(!empty($arrOptions['start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` = '" . $arrOptions['start_date'] . "' ";
		}

		if(!empty($arrOptions['min_start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` >= '" . $arrOptions['min_start_date'] . "' ";
		}

		if(!empty($arrOptions['max_start_date'])){
			$objRate->strQuery .= " AND `cr`.`start_date` <= '" . $arrOptions['max_start_date'] . "' ";
		}

		if(!empty($arrOptions['end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` = '" . $arrOptions['end_date'] . "' ";
		}

		if(!empty($arrOptions['min_end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` >= '" . $arrOptions['min_end_date'] . "' ";
		}

		if(!empty($arrOptions['max_end_date'])){
			$objRate->strQuery .= " AND `cr`.`end_date` <= '" . $arrOptions['max_end_date'] . "' ";
		}
*/

		if ((!empty($arrOptions['min_start_date'])) && (!empty($arrOptions['max_end_date']))) {
			$objRate->strQuery .= " AND (
		                                    (start_date >= '".$arrOptions['min_start_date']."' AND end_date <= '".$arrOptions['max_end_date']."')
		                                    OR
		                                    (start_date <= '".$arrOptions['max_end_date']."' AND end_date >= '".$arrOptions['min_start_date']."')
                                		)";
		}

		if(!empty($arrOptions['length'])){
			$objRate->strQuery .= " AND `cr`.`length` = " . $arrOptions['length'] . " ";
		}

		if(!empty($arrOptions['price'])){
			$objRate->strQuery .= " AND `cr`.`price` = " . $arrOptions['price'] . " ";
		}

		if(!empty($arrOptions['min_price'])){
			$objRate->strQuery .= " AND `cr`.`price` >= " . $arrOptions['min_price'] . " ";
		}

		if(!empty($arrOptions['max_price'])){
			$objRate->strQuery .= " AND `cr`.`price` <= " . $arrOptions['max_price'] . " ";
		}

		if(!empty($arrOptions['rack_rate'])){
			$objRate->strQuery .= " AND `cr`.`rack_rate` = " . $arrOptions['rack_rate'] . " ";
		}

		if(!empty($arrOptions['min_rack_rate'])){
			$objRate->strQuery .= " AND `cr`.`rack_rate` >= " . $arrOptions['min_rack_rate'] . " ";
		}

		if(!empty($arrOptions['max_rack_rate'])){
			$objRate->strQuery .= " AND `cr`.`rack_rate` <= " . $arrOptions['max_rack_rate'] . " ";
		}

		if(!empty($arrOptions['course_type'])){
			$objRate->strQuery .= " AND `cr`.`course_type` = " . $arrOptions['course_type'] . " ";
		}

		if(!empty($arrOptions['course_type_rating'])){
			$objRate->strQuery .= " AND `cr`.`course_type_rating` = " . $arrOptions['course_type_rating'] . " ";
		}

		if(!empty($arrOptions['min_course_type_rating'])){
			$objRate->strQuery .= " AND `cr`.`course_type_rating` >= " . $arrOptions['min_course_type_rating'] . " ";
		}

		if(!empty($arrOptions['max_course_type_rating'])){
			$objRate->strQuery .= " AND `cr`.`course_type_rating` <= " . $arrOptions['max_course_type_rating'] . " ";
		}

		if(!empty($arrOptions['rate_based_count'])){
			$objRate->strQuery .= " AND `cr`.`rate_based_count` = " . $arrOptions['rate_based_count'] . " ";
		}

		if(!empty($arrOptions['deposit'])){
			$objRate->strQuery .= " AND LOWER(`cr`.`deposit`) LIKE LOWER('%" . $arrOptions['deposit'] . "%') ";
		}

		if(!empty($arrOptions['notes'])){
			$objRate->strQuery .= " AND LOWER(`cr`.`notes`) LIKE LOWER('%" . $arrOptions['notes'] . "%') ";
		}
/*
		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY `cr`.`" . $arrOptions['order_by'] . "` ";

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}
*/

		if(!empty($arrOptions['order_by'])){

			if (($arrOptions['order_by'] == 'start_date') && ($arrOptions['sort_order'] == "ASC")) {

				$objRate->strQuery .= " ORDER BY `cr`.`start_date` ASC, `cr`.`private_price` ASC";

			} else {

				$objRate->strQuery .= " ORDER BY `cr`.`" . $arrOptions['order_by'] . "` ";

				if(!empty($arrOptions['sort_order'])){
					$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
				}
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

		foreach ($arrCourses as &$arrCourse) {
			$arrCourse['fees'] = $objRate->getMysqliResults("SELECT * FROM fees WHERE course_rate_id = " . $arrCourse['id'], true);
		}

		return $arrCourses;
	}

	public static function getCourseRateById($intRateId){
		if(empty($intRateId)){
			// no rate to find
			return array();
		}

		$objRate = new static;

		$objRate->strQuery = " SELECT `cr`.*, "
						   .        " `rdt`.`name` AS `course_type_name`, "
						   .        " `rdt`.`description` AS `course_type_description`, "
						   .        " `rdt`.`rating` AS `course_type_rating` "
						   .   " FROM `course_rates` `cr` "
						   .   " LEFT JOIN `rate_detail_types` `rdt` "
						   .        " ON `rdt`.`id` = `cr`.`course_type` "
						   .  " WHERE `cr`.`id` = " . $intRateId
						   .    " AND (`rdt`.`type` = 'course' "
						   .        " OR `rdt`.`type` IS NULL ) ";

		$arrRates = $objRate->getMysqliResults($objRate->strQuery, true);


		if(empty($arrRates) || empty($arrRates[0])){
			// rate not found
			return array();
		}

		$arrRates = $arrRates[0];
		$arrRates['fees'] = $objRate->getMysqliResults("SELECT * FROM fees WHERE course_rate_id = " . $arrRates['id'], true);

		return $arrRates;
	}

	public static function getCourseById($intCourseId){
		if(empty($intCourseId)){
			// nothing to show
			return array();
		}

		$objRate = new static;

		$objRate->strQuery = " SELECT * "
						   . " FROM `course` "
						   . " WHERE `id` = " . $intCourseId;

	   	$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

	   	if(empty($arrCourses) || empty($arrCourses[0])){
	   		// no courses found
	   		return array();
	   	}

		return $arrCourses[0];
	}

	public static function getCourses($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'course_name' => null, // contains search
			'status' => 'Active',
            'regions' => array(),
			'limit' => null,
			'offset' => null,
			'order_by' => 'course_name',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT * "
						   . " FROM `course` "
						   . " WHERE 1 = 1 ";

		if(!empty($arrOptions['id'])){
			$objRate->strQuery .= " AND `id` = " . $arrOptions['id'] . " ";
		}

		if(!empty($arrOptions['course_name'])){
			$objRate->strQuery .= " AND LOWER(`course_name`) LIKE LOWER('%" . $arrOptions['course_name'] . "%') ";
		}

		if(!empty($arrOptions['status'])){
			$objRate->strQuery .= " AND `status` = '" . $arrOptions['status'] . "' ";
		}

        if (!empty($arrOptions['regions']) && is_array($arrOptions['regions'])) {
            $objRate->strQuery .= " AND id in (SELECT `course_id` FROM `course_region` WHERE `region_id` IN (" . implode(',', $arrOptions['regions']) . ")) ";
        }

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY `" . $arrOptions['order_by'] . "` ";

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

	   	$arrCourses = $objRate->getMysqliResults($objRate->strQuery, true);

	   	if(empty($arrCourses)){
	   		// no Courses found
	   		return array();
	   	}

		return $arrCourses;
	}

	public static function getCourseTypes($arrOptionsIn = array()){
		$arrOptions = array(
			'id' => null,
			'type' => 'course',
			'name' => null, // contains search
			'description' => null, // contains search
			'rating' => null, // exact match
			'min_rating' => null, // > rating
			'max_rating' => null, // < rating
			'limit' => null,
			'offset' => null,
			'order_by' => 'name',
			'sort_order' => 'ASC'
		);

		$arrOptions = Util::wp_parse_args($arrOptionsIn, $arrOptions);

		$objRate = new static;

		$objRate->strQuery = " SELECT `rdt`.* "
						   . " FROM `rate_detail_types` `rdt` "
						   . " WHERE 1 = 1 ";

		if(!empty($arrOptions['id'])){
			$objRate->strQuery .= " AND `rdt`.`id` = " . $arrOptions['id'] . " ";
		}

		if(!empty($arrOptions['type'])){
			$objRate->strQuery .= " AND `rdt`.`type` = '" . $arrOptions['type'] . "' ";
		}

		if(!empty($arrOptions['name'])){
			$objRate->strQuery .= " AND `rdt`.`name` LIKE '%" . $arrOptions['name'] . "%' ";
		}

		if(!empty($arrOptions['description'])){
			$objRate->strQuery .= " AND `rdt`.`description` LIKE '%" . $arrOptions['description'] . "%' ";
		}

		if(!empty($arrOptions['rating'])){
			$objRate->strQuery .= " AND `rdt`.`rating` = " . $arrOptions['rating'] . " ";
		}

		if(!empty($arrOptions['min_rating'])){
			$objRate->strQuery .= " AND `rdt`.`min_rating` >= " . $arrOptions['min_rating'] . " ";
		}

		if(!empty($arrOptions['max_rating'])){
			$objRate->strQuery .= " AND `rdt`.`max_rating` <= " . $arrOptions['max_rating'] . " ";
		}

		if(!empty($arrOptions['order_by'])){
			$objRate->strQuery .= " ORDER BY `rdt`.`" . $arrOptions['order_by'] . "` ";

			if(!empty($arrOptions['sort_order'])){
				$objRate->strQuery .= " " . $arrOptions['sort_order'] . " ";
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objRate->strQuery .= " LIMIT " . $arrOptions['limit'] . " ";

			if(isset($arrOptions['offset']) && !empty($arrOptions['offset'])){
				$objRate->strQuery .= " OFFSET " . $arrOptions['offset'] . " ";
			}
		}

		$arrRoomTypes = $objRate->getMysqliResults($objRate->strQuery, true);

		return $arrRoomTypes;
	}

	public static function insertCourseRate($arrData){
		if(empty($arrData) || (isset($arrData['id']) && !empty($arrData['id']))){
			// record already exsists
			return false;
		}

		$arrDateColumns = array(
			'start_date',
			'end_date'
		);

		$objRate = new static;

		$objRate->strQuery = " INSERT INTO `course_rates` ( ";

		foreach($arrData as $strColumn => $strValue){
			if (!is_array($strValue)) {
				$objRate->strQuery .= " `" . $strColumn . "`, ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) VALUES ( ";

		foreach($arrData as $strColumn => $strValue){
			if (!is_array($strValue)) {

				if($strValue == ''){
					$objRate->strQuery .= " NULL, ";
				}else{
					if(in_array(strtolower($strColumn), $arrDateColumns)){
						$strValue = date('Y-m-d', strtotime($strValue));
					}

					$objRate->strQuery .= " '" . $strValue . "', ";
				}
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) ";

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// success
		$objRate->strSuccessMessage = 'Record Created';
		$intNewId = $objRate->mysqli->insert_id;

		return $intNewId;
	}

	public static function updateCourseRate($arrData){
		if(empty($arrData) || !isset($arrData['id']) || empty($arrData['id'])){
			// nothing to save/save to
			return false;
		}

		$intOldId = $arrData['id'];
		$arrDateColumns = array(
			'start_date',
			'end_date'
		);

		unset($arrData['id']);

		// calculate rate length
		$objStartDate = date_create($arrData['start_date']);
		$objEndDate = date_create($arrData['end_date']);
		$objDateInterval = date_diff($objStartDate, $objEndDate);

		$arrData['length'] = $objDateInterval->days;

		$objRate = new static;

		$objRate->strQuery = " UPDATE `course_rates`  ";

		$blnFirst = true;
		foreach($arrData as $strColumn => $strValue){
			if($blnFirst){
				$objRate->strQuery .= " SET ";
				$blnFirst = false;
			}

			$objRate->strQuery .= " `" . $strColumn . "` = ";

			if($strValue == ''){
				$objRate->strQuery .= " NULL, ";
			}else{
				if(in_array(strtolower($strColumn), $arrDateColumns)){
					$strValue = date('Y-m-d', strtotime($strValue));
				}

				$objRate->strQuery .= " '" . $strValue . "', ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " WHERE `id` = " . $intOldId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
	    }

	    // success
	    $objRate->strSuccessMessage = 'Record Updated';
    	return $intOldId;
	}

	public static function insertFee($arrData){
		if(empty($arrData) || (isset($arrData['id']) && !empty($arrData['id']))){
			// record already exsists
			return false;
		}

		$objRate = new static;

		$objRate->strQuery = " INSERT INTO `fees` ( ";

		foreach($arrData as $strColumn => $strValue){
			$objRate->strQuery .= " `" . $strColumn . "`, ";
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) VALUES ( ";

		foreach($arrData as $strColumn => $strValue){
			if($strValue == ''){
				$objRate->strQuery .= " NULL, ";
			}else{
				$objRate->strQuery .= " '" . $strValue . "', ";
			}
		}

		$objRate->strQuery = rtrim($objRate->strQuery, ', ');

		$objRate->strQuery .= " ) ";

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// success
		$objRate->strSuccessMessage = 'Record Created';
		$intNewId = $objRate->mysqli->insert_id;

		return $intNewId;
	}


	public static function updateCourseRates($arrData) {
		if (isset($arrData['rateName'])) {
			foreach ($arrData['rateName'] as $intRateId => $strRateName) {
				$strUpdate = 'UPDATE course_rates SET 	name = "'.$strRateName.'",
														start_date = "'.$arrData['rateDateFrom'][$intRateId].'",
														end_date = "'.$arrData['rateDateTo'][$intRateId].'",
														price = "'.$arrData['ratePublic'][$intRateId].'",
														private_price = "'.$arrData['ratePrivate'][$intRateId].'",
														feature_price = '.(isset($arrData['feature_package'][$intRateId]) ? '1' : '0') . '
												WHERE id = ' . $intRateId;

				$objRate = new static;

				if(!$objRate->short_query($strUpdate)) {
					// error
					$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
					return false;
			    }

			    // success
			    $objRate->strSuccessMessage = 'Record Updated';

			}
		}
	}

		public static function updateHotelRates($arrData) {
		if (isset($arrData['rateName'])) {
			foreach ($arrData['rateName'] as $intRateId => $strRateName) {
				$strUpdate = 'UPDATE hotel_rates SET 	name = "'.$strRateName.'",
														start_date = "'.$arrData['rateDateFrom'][$intRateId].'",
														end_date = "'.$arrData['rateDateTo'][$intRateId].'",
														price = "'.$arrData['ratePublic'][$intRateId].'",
														private_price = "'.$arrData['ratePrivate'][$intRateId].'",
														occupancy = "'.$arrData['rateOccupancy'][$intRateId].'",
														feature_price = '.(isset($arrData['feature_package'][$intRateId]) ? '1' : '0') . '
												WHERE id = ' . $intRateId;

				$objRate = new static;

				if(!$objRate->short_query($strUpdate)) {
					// error
					$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
					return false;
			    }

			    // success
			    $objRate->strSuccessMessage = 'Record Updated';

			}
		}
	}

	public static function updateCourseFees($arrData) {
		if (isset($arrData['feeName'])) {
			foreach ($arrData['feeName'] as $intFeeId => $strFeeName) {
				$strUpdate = 'UPDATE fees SET 	name = "'.$strFeeName.'",
														public = '.(isset($arrData['feePublic'][$intFeeId]) ? '1' : '0') . ',
														private = '.(isset($arrData['feePrivate'][$intFeeId]) ? '1' : '0') . ',
														amount = "'.$arrData['feeAmount'][$intFeeId].'",
														calculation_type = "'.$arrData['feeCalcType'][$intFeeId].'",
														per_person = '.(isset($arrData['feePerPerson'][$intFeeId]) ? '1' : '0') . '
												WHERE id = ' . $intFeeId;

				$objRate = new static;

				if(!$objRate->short_query($strUpdate)) {
					// error
					$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
					return false;
			    }

			    // success
			    $objRate->strSuccessMessage = 'Record Updated';
			}
		}
	}

	public static function updateHotelFees($arrData) {
		if (isset($arrData['feeName'])) {
			foreach ($arrData['feeName'] as $intFeeId => $strFeeName) {
				$strUpdate = 'UPDATE fees SET 	name = "'.$strFeeName.'",
														public = '.(isset($arrData['feePublic'][$intFeeId]) ? '1' : '0') . ',
														private = '.(isset($arrData['feePrivate'][$intFeeId]) ? '1' : '0') . ',
														amount = "'.$arrData['feeAmount'][$intFeeId].'",
														calculation_type = "'.$arrData['feeCalcType'][$intFeeId].'",
														per_night = '.(isset($arrData['feePerNight'][$intFeeId]) ? '1' : '0') . ',
														per_room = '.(isset($arrData['feePerRoom'][$intFeeId]) ? '1' : '0') . '
												WHERE id = ' . $intFeeId;

				$objRate = new static;

				if(!$objRate->short_query($strUpdate)) {
					// error
					$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
					return false;
			    }

			    // success
			    $objRate->strSuccessMessage = 'Record Updated';
			}
		}
	}

	public static function addNewCourseRates($arrData) {
		if (isset($arrData['new_rate_name'])) {
			foreach ($arrData['new_rate_name'] As $intNewRateId => $strNewRateName) {
				$arrNewRate = array('name'			=>	$strNewRateName,
									'course_id' 	=>	$arrData['rate']['course_id'],
									'parent_id' 	=>	$arrData['rate']['id'],
									'start_date'	=>	$arrData['new_rate_datefrom'][$intNewRateId],
									'end_date'		=>	$arrData['new_rate_dateto'][$intNewRateId],
									'price'			=>	$arrData['new_rate_public'][$intNewRateId],
									'private_price'	=>	$arrData['new_rate_private'][$intNewRateId],
									'feature_price'	=>	(isset($arrData['new_rate_feature_package'][$intNewRateId]) ? '1' : '0'),
									);

				$intDbRateId = static::insertCourseRate($arrNewRate);

				// Add new Attached fees
				if (isset($arrData['newRate_newFeeName'])) {
					if (isset($arrData['newRate_newFeeName'][$intNewRateId])) {
						foreach ($arrData['newRate_newFeeName'][$intNewRateId] AS $intNewFeeId => $strNewFeeName) {

							$arrNewFee 	= array('course_rate_id'	=>	$intDbRateId,
										'name' 				=>	$strNewFeeName,
										'public' 			=>	(isset($arrData['newRate_newFeePublic'][$intNewRateId][$intNewFeeId]) ? '1' : '0'),
										'private'			=>	(isset($arrData['newRate_newFeePrivate'][$intNewRateId][$intNewFeeId]) ? '1' : '0'),
										'calculation_type'	=>	$arrData['newRate_newFeeCalcType'][$intNewRateId][$intNewFeeId],
										'amount'			=>	$arrData['newRate_newFeeAmount'][$intNewRateId][$intNewFeeId],
										);

							$intNewFeeId = static::insertFee($arrNewFee);
						}
					}
				}
			}
		}
	}

	public static function addNewHotelRates($arrData) {
		if (isset($arrData['new_rate_name'])) {
			foreach ($arrData['new_rate_name'] As $intNewRateId => $strNewRateName) {
				$arrNewRate = array('name'			=>	$strNewRateName,
									'hotel_id' 		=>	$arrData['rate']['hotel_id'],
									'parent_id' 	=>	$arrData['rate']['id'],
									'start_date'	=>	$arrData['new_rate_datefrom'][$intNewRateId],
									'end_date'		=>	$arrData['new_rate_dateto'][$intNewRateId],
									'price'			=>	$arrData['new_rate_public'][$intNewRateId],
									'private_price'	=>	$arrData['new_rate_private'][$intNewRateId],
									'occupancy'		=>	$arrData['new_rate_occupancy'][$intNewRateId],
									'feature_price'	=>	(isset($arrData['new_rate_feature_package'][$intNewRateId]) ? '1' : '0'),
									);

				$intDbRateId = static::insertHotelRate($arrNewRate);

				// Add new Attached fees
				if (isset($arrData['newRate_newFeeName'])) {
					if (isset($arrData['newRate_newFeeName'][$intNewRateId])) {
						foreach ($arrData['newRate_newFeeName'][$intNewRateId] AS $intNewFeeId => $strNewFeeName) {

							$arrNewFee 	= array('hotel_rate_id'		=>	$intDbRateId,
												'name' 				=>	$strNewFeeName,
												'public' 			=>	(isset($arrData['newRate_newFeePublic'][$intNewRateId][$intNewFeeId]) ? '1' : '0'),
												'private'			=>	(isset($arrData['newRate_newFeePrivate'][$intNewRateId][$intNewFeeId]) ? '1' : '0'),
												'calculation_type'	=>	$arrData['newRate_newFeeCalcType'][$intNewRateId][$intNewFeeId],
												'amount'			=>	$arrData['newRate_newFeeAmount'][$intNewRateId][$intNewFeeId],
												);

							$intNewFeeId = static::insertFee($arrNewFee);
						}
					}
				}
			}
		}
	}

	public static function addNewCourseFees($arrData) {
		if (isset($arrData['newFeeName'])) {
			foreach ($arrData['newFeeName'] As $intRateId => $arrFees) {
				foreach ($arrFees as $intNewFeeId => $strFeeName) {
					$arrNewFee 	= array('course_rate_id'	=>	$intRateId,
										'name' 				=>	$strFeeName,
										'public' 			=>	(isset($arrData['newFeePublic'][$intRateId][$intNewFeeId]) ? '1' : '0'),
										'private'			=>	(isset($arrData['newFeePrivate'][$intRateId][$intNewFeeId]) ? '1' : '0'),
										'calculation_type'	=>	$arrData['newFeeCalcType'][$intRateId][$intNewFeeId],
										'amount'			=>	$arrData['newFeeAmount'][$intRateId][$intNewFeeId],
										);

					$intNewFeeId = static::insertFee($arrNewFee);
				}
			}
		}
	}

	public static function addNewHotelFees($arrData) {
		if (isset($arrData['newFeeName'])) {
			foreach ($arrData['newFeeName'] As $intRateId => $arrFees) {
				foreach ($arrFees as $intNewFeeId => $strFeeName) {
					$arrNewFee 	= array('hotel_rate_id'	=>	$intRateId,
										'name' 				=>	$strFeeName,
										'public' 			=>	(isset($arrData['newFeePublic'][$intRateId][$intNewFeeId]) ? '1' : '0'),
										'private'			=>	(isset($arrData['newFeePrivate'][$intRateId][$intNewFeeId]) ? '1' : '0'),
										'calculation_type'	=>	$arrData['newFeeCalcType'][$intRateId][$intNewFeeId],
										'amount'			=>	$arrData['newFeeAmount'][$intRateId][$intNewFeeId],
										);

					$intNewFeeId = static::insertFee($arrNewFee);
				}
			}
		}
	}

	public static function deleteCourseRateById($intRateId){
		if(empty($intRateId)){
			return false;
		}

		// delete this rate
		$objRate = new static;

		// delete attached fees from rate
		//$objRate->strQuery = " DELETE FROM `fees` WHERE course_rate_id = " . $intRateId;
		//$objRate->short_query($objRate->strQuery);

		// delete attached fees from children rates
		//$objRate->strQuery = " DELETE FROM `fees` WHERE course_rate_id IN (SELECT id FROM course_rates WHERE parent_id = " . $intRateId . ")";
		//$objRate->short_query($objRate->strQuery);

		// delete rate & child rates
		//$objRate->strQuery = " DELETE FROM `course_rates` WHERE `id` = " . $intRateId . " OR parent_id = " . $intRateId;
		$objRate->strQuery = " UPDATE `course_rates` SET deleted = 1 WHERE `id` = " . $intRateId . " OR parent_id = " . $intRateId;
		$objRate->short_query($objRate->strQuery);

		// success
		return true;
	}

	public static function deleteHotelRateById($intRateId){
		if(empty($intRateId)){
			return false;
		}

		$objRate = new static;

		// delete attached fees from rate
		//$objRate->strQuery = " DELETE FROM `fees` WHERE hotel_rate_id = " . $intRateId;
		//$objRate->short_query($objRate->strQuery);

		// delete attached fees from children rates
		//$objRate->strQuery = " DELETE FROM `fees` WHERE hotel_rate_id IN (SELECT id FROM hotel_rates WHERE parent_id = " . $intRateId . ")";
		//$objRate->strQuery = " DELETE FROM `fees` WHERE hotel_rate_id IN (SELECT id FROM hotel_rates WHERE parent_id = " . $intRateId . ")";
		//$objRate->short_query($objRate->strQuery);

		// delete rate & child rates
		//$objRate->strQuery = " DELETE FROM `hotel_rates` WHERE `id` = " . $intRateId . " OR parent_id = " . $intRateId;
		$objRate->strQuery = " UPDATE `hotel_rates` SET deleted = 1 WHERE `id` = " . $intRateId . " OR parent_id = " . $intRateId;
		$objRate->short_query($objRate->strQuery);

		// success
		return true;
	}

	public static function deleteFeeById($intFeeId){
		if(empty($intFeeId)){
			return false;
		}

		// delete this fee
		$objRate = new static;

		$objRate->strQuery = " DELETE FROM `fees` "
						   . " WHERE `id` = " . $intFeeId;

		if(!$objRate->short_query($objRate->strQuery)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

		// success
		return true;
	}

	public static function duplicateHotelRates($arrOptions){
		if(!isset($arrOptions['rate_id']) || empty($arrOptions['rate_id']) ||
			!isset($arrOptions['hotel_id']) || empty($arrOptions['hotel_id'])){
			// missing required information
			return false;
		}

		$arrChildRates = static::getHotelRates(array(
			'parent_id' => $arrOptions['rate_id']
		));

		// duplicate this record
		$intNewRateId = static::duplicateHotelRateSingle($arrOptions);

		// Duplicate Attached Fees
		static::duplicatefees($arrOptions['rate_id'], $intNewRateId, 'hotel');

		if(!filter_var($arrOptions['deep'], FILTER_VALIDATE_BOOLEAN) || empty($arrChildRates)){
			return $intNewRateId;
		}

		// call this function for child records
		foreach($arrChildRates as $arrChildRate){
			$arrChildOptions = $arrOptions;
			$arrChildOptions['rate_id'] = $arrChildRate['id'];
			$arrChildOptions['parent_id'] = $intNewRateId;

			static::duplicateHotelRates($arrChildOptions);
		}

		return $intNewRateId;
	}

	public static function duplicateCourseRates($arrOptions){
		if(!isset($arrOptions['rate_id']) || empty($arrOptions['rate_id']) ||
			!isset($arrOptions['course_id']) || empty($arrOptions['course_id'])){
			// missing required information
			return false;
		}

		$arrChildRates = static::getCourseRates(array(
			'parent_id' => $arrOptions['rate_id']
		));

		// duplicate this record
		$intNewRateId = static::duplicateCourseRateSingle($arrOptions);

		// Duplicate Attached Fees
		static::duplicatefees($arrOptions['rate_id'], $intNewRateId, 'course');

		if(!filter_var($arrOptions['deep'], FILTER_VALIDATE_BOOLEAN) || empty($arrChildRates)){
			return $intNewRateId;
		}

		// call this function for child records
		foreach($arrChildRates as $arrChildRate){
			$arrChildOptions = $arrOptions;
			$arrChildOptions['rate_id'] = $arrChildRate['id'];
			$arrChildOptions['parent_id'] = $intNewRateId;

			static::duplicateCourseRates($arrChildOptions);
		}

		return $intNewRateId;
	}

	public static function duplicateFees($intOldRateId, $intNewRateId, $type) {

		if ($type == 'hotel') {
			$strSql = "INSERT INTO fees (hotel_rate_id, name, public, private, calculation_type, amount) (SELECT " . $intNewRateId . ", name, public, private, calculation_type, amount FROM fees WHERE hotel_rate_id = " . $intOldRateId . ")";
		}

		if ($type == 'course') {
			$strSql = "INSERT INTO fees (course_rate_id, name, public, private, calculation_type, amount) (SELECT " . $intNewRateId . ", name, public, private, calculation_type, amount FROM fees WHERE course_rate_id = " . $intOldRateId . ")";
		}

		$objRate = new static;

		if(!$objRate->short_query($strSql)) {
			// error
			$objRate->strErrorMessage = 'SQL error:'.$objRate->strQuery;
			return false;
		}

	}

	public static function duplicateCourseRateSingle($arrOptions){
		if(!isset($arrOptions['rate_id']) || empty($arrOptions['rate_id']) ||
			!isset($arrOptions['course_id']) || empty($arrOptions['course_id'])){
			// missing required information
			return false;
		}

		// get old rate to copy from
		$arrOldRate = static::getCourseRateById($arrOptions['rate_id']);

		// setup new rate to insert
		$arrNewRate = $arrOldRate;

		unset($arrNewRate['id']);
		unset($arrNewRate['course_type_name']);
		unset($arrNewRate['course_type_description']);
		unset($arrNewRate['course_type_rating']);

		if(isset($arrOptions['parent_id']) && !empty($arrOptions['parent_id'])){
			$arrNewRate['parent_id'] = (int)$arrOptions['parent_id'];
		}else{
			// no parent
			$arrNewRate['parent_id'] = null;
		}

		if(isset($arrOptions['course_id']) && !empty($arrOptions['course_id'])){
			$arrNewRate['course_id'] = (int)$arrOptions['course_id'];
		}else{
			// no course id
			$arrNewRate['course_id'] = null;
		}

		// insert and return insert id
		return static::insertCourseRate($arrNewRate);
	}

}
