<?php


class Quotehotels extends Database  {

	public $strQuery;
	public $strAction;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $intID;
	public $intRelHotelID;
	public $intHotelId;
	public $intMemberId;

	public $strTitle;
	public $strCheckInDate;
	public $strCheckOutDate;
	public $strNights;
	public $strRooms;
	public $strGolfers;

	public $strConfirmNum;
	public $strGuestsName;
	public $strRoomNotes;
	public $strPublicNotes;
	public $strMiniContent;
	public $arrDetails;
	public $blnDefault;

	public function __construct() {

		parent::__construct();
		$this->intRelHotelID = isset($_REQUEST['rel_id']) ? $_REQUEST['rel_id'] : ''; //this is the index of the relationship record between the package and course
		$this->strErrorMessage = "";
		$this->strTableName = 'quote_hotel';
		$this->strTableSlug = 'quote_hotel';
		$this->strAdminSlug = '/admin/quote/';

		$this->strTitle = 'Quote Hotels';
		$this->strAction = isset($_GET['action']) ? $_GET['action'] : '';



	}





	public function handlePost($post,$id, $debug = false) {

		$this->intID = $id;

		$this->intHotelId = isset($post['hotel_id']) && $post['hotel_id'] != '' ? $post['hotel_id'] : 'Null';
		$this->strCheckInDate = isset($post['check_in_date']) ? $post['check_in_date'] : '';
		$this->strCheckOutDate = isset($post['check_out_date']) ? $post['check_out_date'] : '';
		$this->strNights = isset($post['nights']) ? $post['nights'] : 0;
		$this->strRooms = isset($post['rooms']) ? $post['rooms'] : 0;
		$this->strGolfers = isset($post['golfers']) ? $post['golfers'] : 1;
		$this->strConfirmNum = isset($post['confirm_num']) ? $post['confirm_num'] : '';
		$this->strGuestsName = isset($post['guests_name']) ? $post['guests_name'] : '';
		$this->strRoomNotes = isset($post['room_notes']) ? $post['room_notes'] : '';
		$this->strPublicNotes = isset($post['public_notes']) ? $post['public_notes'] : '';
		$this->strMiniContent = isset($post['email_content']) ? $post['email_content'] : '';
		$this->blnDefault = isset($post['default']) ? $post['default'] : 0;

		$pc = 	isset($_POST['people_num']) ? count($_POST['people_num']) : 0;

		
		$blnValidate = true;
		
		if(isset($post['validate']) && !$post['validate']){
			$blnValidate = false;
		}

		if($blnValidate){
			if($this->strGolfers < $pc) {
				$this->strErrorMessage .= "Cannot decrease the number of people. Please remove the player(s) from the list and click save.<br />";
				$this->strGolfers = $pc;
			}

			//if($this->intHotelId == 'Null') { $this->strErrorMessage .= "Please choose a hotel.<br />"; }
			//if(!Util::validateDate($this->strCheckInDate)) { $this->strErrorMessage .= "Please choose a valid check in date.<br />"; }
			//if(!Util::validateDate($this->strCheckOutDate)) { $this->strErrorMessage .= "Please choose a valid check out date.<br />"; }
			//if((int)$this->strNights == 0) { $this->strErrorMessage .= "Please enter the number of nights.<br />"; }
			//if((int)$this->strGolfers == 0) { $this->strErrorMessage .= "Please enter the number of golfers.<br />"; }
			//if((int)$this->strRooms == 0) { $this->strErrorMessage .= "Please enter the number of rooms.<br />"; }
		}

		if($this->strErrorMessage == '') {

			$keys = array(
				'quote_id',
				'hotel_id',
				'check_in_date',
				'check_out_date',
				'nights',
				'rooms',
				'golfers',
				'confirm_num',
				'guests_name',
				'room_notes',
				'public_notes',
				'email_content',
				'`default`'
			);
			$vals = array(
				$this->intID,
				$this->intHotelId,
				$this->strCheckInDate,
				$this->strCheckOutDate,
				$this->strNights,
				$this->strRooms,
				$this->strGolfers,
				$this->strConfirmNum,
				$this->strGuestsName,
				$this->strRoomNotes,
				$this->strPublicNotes,
				$this->strMiniContent,
				$this->blnDefault
			);
			//$types = array('iissssssss');

			if($this->intRelHotelID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intRelHotelID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added';

			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intRelHotelID);
				$this->strSuccessMessage = 'Record Saved';

			}


			//if this is the default hotel, mark all otehrs as not default
			if($this->blnDefault) {
				$sql = "UPDATE quote_hotel SET `default`=0 WHERE quote_id=$this->intID AND id not in ($this->intRelHotelID) ";
				//Util::debugDisplay($sql);
				//die();
				$this->short_query($sql);
			}


			$peopleCount = 	isset($_POST['people_num']) ? count($_POST['people_num']) : $this->strGolfers;
			//Util::debugDisplay('action='.$this->strAction);
			//Util::debugDisplay($_POST['people_num']);
			//Util::debugDisplay('peopleCount='.$peopleCount);

			$rpc = $peopleCount;
			$upc = false; //do we update the people count?
			// need to insert lookup records for each user, but only if this is the default package.
			// /"SELECT * FROM package_hotel_detail WHERE package_hotel_id=".$relID." ORDER BY people_num";
			//if($this->blnDefault) {
				for($x = 1;$x<=$peopleCount;$x++) {


					$people_num = isset($post['people_num'][$x-1]) ? $post['people_num'][$x-1] : $x;
	                $people_name = (isset($post['people_name'][$x-1]) && trim($post['people_name'][$x-1]) != '') ? $this->getCleanVar(trim($post['people_name'][$x-1])) : '';
	                $people_lname = (isset($post['people_lname'][$x-1]) && trim($post['people_lname'][$x-1]) != '') ? $this->getCleanVar(trim($post['people_lname'][$x-1])) : $x;
	                $people_email = isset($post['people_email'][$x-1]) ? $this->getCleanVar(trim($post['people_email'][$x-1])) : '';
	                $people_phone = isset($post['people_phone'][$x-1]) ? $this->getCleanVar(trim($post['people_phone'][$x-1])) : '';
	                $people_city = isset($post['people_city'][$x-1]) ? $this->getCleanVar(trim($post['people_city'][$x-1])) : '';
	                $room_num = isset($post['room_num'][$x-1]) ? $this->getCleanVar(trim($post['room_num'][$x-1])) : '';
	                $nights_num = isset($post['nights_num'][$x-1]) ? $this->getCleanVar(trim($post['nights_num'][$x-1])) : '';
	                $package_price = isset($post['package_price'][$x-1]) ? $this->getCleanVar(trim($post['package_price'][$x-1])) : 0;
	                $deposit_price = isset($post['deposit_price'][$x-1]) ? $this->getCleanVar(trim($post['deposit_price'][$x-1])) : 0;
	                $final_price = $package_price-$deposit_price;
	                $cc_processed = isset($post['cc_processed'][$x-1]) ? $this->getCleanVar(trim($post['cc_processed'][$x-1])) : '';
	                $notes = isset($post['notes'][$x-1]) ? $this->getCleanVar(trim($post['notes'][$x-1])) : '';
	                $member_id = (isset($post['member_id'][$x-1]) && trim($post['member_id'][$x-1]) != '' ) ? trim($post['member_id'][$x-1]) : 'Null';

	                if($people_name != "" || $this->strAction == 'add') {
	                	//$rpc ++; //actual count or records that have the last name filled in
						$sql = "INSERT INTO quote_hotel_detail (
							quote_hotel_id,
							people_num,
							people_name,
							people_lname,
							people_email,
							people_phone,
							people_city,
							room_num,
							nights_num,
							package_price,
							deposit_price,
							final_price,
							cc_processed,
							member_id,
							notes
							) VALUES (
							$this->intRelHotelID,
							$people_num,
							'$people_name',
							'$people_lname',
							'$people_email',
							'$people_phone',
							'$people_city',
							'$room_num',
							'$nights_num',
							'$package_price',
							'$deposit_price',
							'$final_price',
							'$cc_processed',
							$member_id,
							'$notes'
							) ON DUPLICATE KEY UPDATE
							people_num=$x,
							people_name='$people_name',
							people_lname='$people_lname',
							people_email='$people_email',
							people_phone='$people_phone',
							people_city='$people_city',
							room_num='$room_num',
							nights_num='$nights_num',
							package_price='$package_price',
							deposit_price='$deposit_price',
							final_price='$final_price',
							cc_processed='$cc_processed',
							member_id=$member_id,
							notes='$notes'
							";
							//$this->short_query($sql);

					} else {
						$rpc--;
						$sql = "DELETE FROM quote_hotel_detail WHERE quote_hotel_id = $this->intRelHotelID AND people_num=$x";
						//Util::debugDisplay($sql);
						$upc = true;
					}

					//Util::debugDisplay($sql);
					//
					$this->short_query($sql);


				}


				if($upc && $rpc > 0) {

					$sql = "UPDATE quote_hotel SET `golfers`=$rpc WHERE quote_id=$this->intID";
					//Util::debugDisplay($sql);
					//die();

					//Util::debugDisplay('peopleCount='.$peopleCount);
					//Util::debugDisplay('rpc='.$rpc);
					$this->short_query($sql);
				}


			//} else {

				//delete the record out, this will kill off the legacy users.
				//$sql = "DELETE FROM package_hotel_detail WHERE package_hotel_id=$this->intRelHotelID";
				//Util::debugDisplay($sql);
				//$this->short_query($sql);



			//}

			// udpate edit date of quote
			Quote::updateEditDateById($this->intID);


        } //error message check

        return $this->intRelHotelID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*, b.mini_hotel_text, p.phone, p.cell_phone
		From $this->strTableName t
		LEFT Join quotes p on p.id=t.quote_id
		LEFT JOIN brands b on p.brandID=b.id
		WHERE t.id=$this->intRelHotelID
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$this->intID = isset($result['quote_id']) ? $result['quote_id'] : '';
			$this->intRelHotelID = isset($result['id']) ? $result['id'] : '';
			$this->intHotelId = isset($result['hotel_id']) ? $result['hotel_id'] : '';
			$this->strCheckInDate = isset($result['check_in_date']) ? $result['check_in_date'] : '';
			$this->strCheckOutDate = isset($result['check_out_date']) ? $result['check_out_date'] : '';
			$this->strNights = isset($result['nights']) ? $result['nights'] : '';
			$this->strRooms = isset($result['rooms']) ? $result['rooms'] : '';
			$this->strGolfers = isset($result['golfers']) ? $result['golfers'] : '';
			$this->strConfirmNum = isset($result['confirm_num']) ? $result['confirm_num'] : '';
			$this->strGuestsName = isset($result['guests_name']) ? $result['guests_name'] : '';
			$this->strRoomNotes = isset($result['room_notes']) ? $result['room_notes'] : '';
			$this->strPublicNotes = isset($result['public_notes']) ? $result['public_notes'] : '';
			$strPhone = isset($result['phone']) ? $result['phone'] : '';
			$strCellPhone = isset($result['cell_phone']) ? $result['cell_phone'] : '';
			$this->strMiniContent = isset($result['email_content']) && $result['email_content'] != '' ? $result['email_content'] : $result['mini_hotel_text'];
			$this->blnDefault = isset($result['default']) ? $result['default'] : '';

			$strGroupName = Quote::getGroupName($this->intID);


			$this->strMiniContent = str_replace('[arrival]',$this->strCheckInDate,$this->strMiniContent);
			$this->strMiniContent = str_replace('[depart]',$this->strCheckOutDate,$this->strMiniContent);
			$this->strMiniContent = str_replace('[room_num]',$this->strRooms,$this->strMiniContent);
			$this->strMiniContent = str_replace('[confirm_num]',$this->strConfirmNum,$this->strMiniContent);
			$this->strMiniContent = str_replace('[group_name]',$strGroupName,$this->strMiniContent);
			$this->strMiniContent = str_replace('[phone_1]',Util::formatPhone($strPhone),$this->strMiniContent);
			$this->strMiniContent = str_replace('[phone_2]',Util::formatPhone($strCellPhone),$this->strMiniContent);


			$this->arrDetails = $this->getHotelDetails($this->intRelHotelID,false);

			//Util::debugDisplay($this->arrDetails);

			$strRoomList = '';
			$i = 0;
			for($x = 1;$x<=$this->strGolfers;$x++) {

                $people_name = isset($this->arrDetails[$i]['people_name']) && $this->arrDetails[$i]['people_name'] != '' ? $this->arrDetails[$i]['people_name'] : 'Player';
                $people_lname = isset($this->arrDetails[$i]['people_lname'])  && $this->arrDetails[$i]['people_lname'] != '' ? $this->arrDetails[$i]['people_lname'] : $x;
                $people_email = isset($this->arrDetails[$i]['people_email']) ? $this->arrDetails[$i]['people_email'] : '';
                $room_num = isset($this->arrDetails[$i]['room_num']) ? $this->arrDetails[$i]['room_num'] : '';


                $strRoomList .= 'Room '.$room_num.' - '.$people_name.' '.$people_lname.''."\r\n";
                $i++;

            }

           // $strRoomList .= '</ul>';

			$this->strMiniContent = str_replace('[room_detail]',$strRoomList,$this->strMiniContent);
			//$this->strMiniContent .= 'cn='.$this->strConfirmNum;
			//Util::debugDisplay($strRoomList);
	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {

		$debug = true;
		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*
	     From $this->strTableName t
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}

	public function getHotels() {
		$strQuery = "SELECT p.id,  p.type_id, p.hotel_name, p.address,  t.title, s.state_name, s.short_name
			FROM hotel p
			LEFT JOIN hotel_type y ON y.id = p.type_id
			LEFT JOIN city t ON t.id=p.city_id
			LEFT JOIN state s ON s.id=t.state_id
			LEFT JOIN country c ON c.id=s.country_id
			WHERE p.status='Active'
			AND y.status='Active'
			ORDER BY p.hotel_name ASC ";

		//echo '$strQuery='.$strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function getHotelDetails($relID, $debug = false) {
		$strQuery = "SELECT * FROM quote_hotel_detail WHERE quote_hotel_id=".$relID." ORDER BY people_num ASC";
		if($debug) {
		 	Util::debugDisplay($strQuery);
		}
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id, $debug = false) {

	    $this->strQuery = 'SELECT file_name FROM '.$this->strTableName.' WHERE id=' . $id;


		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$file_name = $res[0]['file_name'];
	     	if(file_exists(ROOT_DIR.$file_name)) {
	     		unlink(ROOT_DIR.$file_name);
	     		Util::debugDisplay('delete='.ROOT_DIR.$file_name);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$file_name='.ROOT_DIR.$file_name);
		}


	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}
		
	    if(!$this->short_query($this->strQuery)) {
	    	// error
	    	$this->strErrorMessage = 'SQL error:'.$this->strQuery;
	    	return;
	    }

	    // success
	    $this->strSuccessMessage = 'Record Deleted';

		 // delete child data
	    $this->strQuery = 'DELETE FROM quote_hotel_detail WHERE quote_hotel_id = ' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

	    if(!$this->short_query($this->strQuery)) {
	    	// error
	    	$this->strErrorMessage = 'SQL error (deleting children):'.$this->strQuery;
	    	return;
	    }

	    // udpate edit date of quote
		Quote::updateEditDateById($this->intID);


	}

	public static function deleteByQuote($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		foreach($arrIds as $arrQuoteId){
			// udpate edit date of quote
			Quote::updateEditDateById($arrQuoteId);
		}

		// get list of detail records
		$objModel->strQuery = 'SELECT id FROM ' . $objModel->strTableName . ' WHERE quote_id IN (' . implode(',', $arrIds) . ')';

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrResults)){
			// no records to delete
			return true;
		}

		$arrHotelIds = array();
		foreach($arrResults as $arrRow){
			$arrHotelIds[] = $arrRow['id'];
		}

		// delete detail record
		$objModel->strQuery = 'DELETE FROM quote_hotel_detail WHERE quote_hotel_id IN (' . implode(',', $arrHotelIds) . ')';
		$objModel->short_query($objModel->strQuery);

		// delete main record
		$objModel->strQuery = 'DELETE FROM ' . $objModel->strTableName . ' WHERE id IN (' . implode(',', $arrHotelIds) . ')';
	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    }else{
			$objModel->strErrorMessage = 'SQL error:' . $objModel->strQuery;
			return false;
		}

		return true;
	}

	public static function deleteByQuoteHotel($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		foreach($arrIds as $arrId){
			$arrQuoteHotel = $objModel->getDetail($arrId);

			// udpate edit date of quote
			Quote::updateEditDateById($arrQuoteHotel['quote_id']);
		}

		// delete detail record
		$objModel->strQuery = 'DELETE FROM quote_hotel_detail WHERE quote_hotel_id IN (' . implode(',', $arrIds) . ')';
		$objModel->short_query($objModel->strQuery);

		// delete main record
		$objModel->strQuery = 'DELETE FROM ' . $objModel->strTableName . ' WHERE id IN (' . implode(',', $arrIds) . ')';
	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    }else{
			$objModel->strErrorMessage = 'SQL error:' . $objModel->strQuery;
			return false;
		}

		return true;
	}

	public static function duplicateByQuoteId($intNewId, $intQuoteId, $blnDebug){
		if(empty($intNewId) || empty($intQuoteId)){
			// no records to lookup
			return false;
		}

		$objModel = new static;

		// get list of hotel records for the old quote
		$objModel->strQuery = 'SELECT id FROM ' . $objModel->strTableName . ' WHERE quote_id = ' . $intQuoteId;

		$arrOldHotelIds = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrOldHotelIds)){
			// no records to delete
			return true;
		}

		$arrOldHotelIdsArray = array();
		foreach($arrOldHotelIds as $arrRow){
			$arrOldHotelIdsArray[] = $arrRow['id'];
		}

		foreach($arrOldHotelIdsArray as $intOldHotelId){
			// duplicate hotel record
			$objModel->strQuery = 'INSERT INTO `' . $objModel->strTableName . '`(
					`quote_id`, 
					`hotel_id`, 
					`check_in_date`, 
					`check_out_date`, 
					`nights`, 
					`rooms`, 
					`golfers`, 
					`non_golfers`, 
					`guests_name`, 
					`confirm_num`, 
					`notes`, 
					`public_notes`, 
					`room_notes`, 
					`email_content`, 
					`note_id`, 
					`default`, 
					`paidout`
				) 
				SELECT ' . $intNewId . ', 
					   `hotel_id`, 
					   `check_in_date`, 
					   `check_out_date`, 
					   `nights`, 
					   `rooms`, 
					   `golfers`, 
					   `non_golfers`, 
					   `guests_name`, 
					   `confirm_num`, 
					   `notes`, 
					   `public_notes`, 
					   `room_notes`, 
					   `email_content`, 
					   `note_id`, 
					   `default`, 
					   `paidout`
				FROM `' . $objModel->strTableName . '`
			   WHERE `id` = ' . $intOldHotelId;

		    if($blnDebug) {
			 	Util::debugDisplay($objModel->strQuery);
			}

			if($objModel->short_query($objModel->strQuery)) {
		    	$objModel->strSuccessMessage = 'Hotel Record Duplicated';
		    }else{
				$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			}

			$intNewHotelId = $objModel->mysqli->insert_id;

			// update child records
			// duplicate child records
			$objModel->strQuery = 'INSERT INTO `quote_hotel_detail`(
					`member_id`, 
					`quote_hotel_id`, 
					`people_num`, 
					`people_name`, 
					`people_lname`, 
					`people_email`, 
					`people_phone`, 
					`people_city`, 
					`room_num`, 
					`nights_num`, 
					`package_price`, 
					`deposit_price`, 
					`final_price`, 
					`cc_processed`, 
					`notes`, 
					`last_payment_date`
				) 
				SELECT `member_id`, 
					   ' . $intNewHotelId . ', 
					   `people_num`, 
					   `people_name`, 
					   `people_lname`, 
					   `people_email`, 
					   `people_phone`, 
					   `people_city`, 
					   `room_num`, 
					   `nights_num`, 
					   `package_price`, 
					   `deposit_price`, 
					   `final_price`, 
					   `cc_processed`, 
					   `notes`, 
					   `last_payment_date`
				FROM `quote_hotel_detail`
			   WHERE `quote_hotel_id` = '. $intOldHotelId;

		    if($blnDebug) {
			 	Util::debugDisplay($objModel->strQuery);
			}

			if($objModel->short_query($objModel->strQuery)) {
		    	$objModel->strSuccessMessage = 'Hotel Detail Record Duplicated';
		    }else{
				$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			}
		}

		return true;

	}

	public static function convertToPackageByQuoteId($intNewPackageId, $intQuoteId, $blnDebug){
		if(empty($intNewPackageId) || empty($intQuoteId)){
			// no records to lookup
			return false;
		}

		$objModel = new static;

		// get list of hotel records for the old quote
		$objModel->strQuery = 'SELECT id FROM ' . $objModel->strTableName . ' WHERE quote_id = ' . $intQuoteId;

		$arrOldHotelIds = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrOldHotelIds)){
			// no records to delete
			return true;
		}

		$arrOldHotelIdsArray = array();
		foreach($arrOldHotelIds as $arrRow){
			$arrOldHotelIdsArray[] = $arrRow['id'];
		}

		foreach($arrOldHotelIdsArray as $intOldHotelId){
			// duplicate hotel record
			$objModel->strQuery = 'INSERT INTO `package_hotel`(
					`package_id`, 
					`hotel_id`, 
					`check_in_date`, 
					`check_out_date`, 
					`nights`, 
					`rooms`, 
					`golfers`, 
					`non_golfers`, 
					`guests_name`, 
					`confirm_num`, 
					`notes`, 
					`public_notes`, 
					`room_notes`, 
					`email_content`, 
					`note_id`, 
					`default`, 
					`paidout`
				) 
				SELECT ' . $intNewPackageId . ', 
					   `hotel_id`, 
					   `check_in_date`, 
					   `check_out_date`, 
					   `nights`, 
					   `rooms`, 
					   `golfers`, 
					   `non_golfers`, 
					   `guests_name`, 
					   `confirm_num`, 
					   `notes`, 
					   `public_notes`, 
					   `room_notes`, 
					   `email_content`, 
					   `note_id`, 
					   `default`, 
					   0
				FROM `' . $objModel->strTableName . '`
			   WHERE `id` = ' . $intOldHotelId;

		    if($blnDebug) {
			 	Util::debugDisplay($objModel->strQuery);
			}

			if($objModel->short_query($objModel->strQuery)) {
		    	$objModel->strSuccessMessage = 'Hotel Record Created';
		    }else{
				$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			}

			$intNewPackageHotelId = $objModel->mysqli->insert_id;

			// update child records
			// duplicate child records
			$objModel->strQuery = 'INSERT INTO `package_hotel_detail`(
					`member_id`, 
					`package_hotel_id`, 
					`people_num`, 
					`people_name`, 
					`people_lname`, 
					`people_email`, 
					`people_phone`, 
					`people_city`, 
					`room_num`, 
					`nights_num`, 
					`package_price`, 
					`deposit_price`, 
					`final_price`, 
					`cc_processed`, 
					`notes`, 
					`last_payment_date`
				) 
				SELECT `member_id`, 
					   ' . $intNewPackageHotelId . ', 
					   `people_num`, 
					   `people_name`, 
					   `people_lname`, 
					   `people_email`, 
					   `people_phone`, 
					   `people_city`, 
					   `room_num`, 
					   `nights_num`, 
					   `package_price`, 
					   `deposit_price`, 
					   `final_price`, 
					   `cc_processed`, 
					   `notes`, 
					   `last_payment_date`
				FROM `quote_hotel_detail`
			   WHERE `quote_hotel_id` = '. $intOldHotelId;

		    if($blnDebug) {
			 	Util::debugDisplay($objModel->strQuery);
			}

			if($objModel->short_query($objModel->strQuery)) {
		    	$objModel->strSuccessMessage = 'Hotel Detail Record Created';
		    }else{
				$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			}
		}

		return true;

	}

	public static function convertFromPackageId($intNewId, $intPackageId, $blnDebug){
		if(empty($intNewId) || empty($intPackageId)){
			// no records to lookup
			return false;
		}

		$objModel = new static;

		// get list of hotel records for the old quote
		$objModel->strQuery = 'SELECT id FROM package_hotel WHERE package_id = ' . $intPackageId;

		$arrOldHotelIds = $objModel->getMysqliResults($objModel->strQuery, true);

		// var_dump($objModel->strQuery);
		// die();

		if(empty($arrOldHotelIds)){
			// no records to copy
			return true;
		}

		$arrHotelIds = array();
		foreach($arrOldHotelIds as $arrRow){
			$arrHotelIds[] = $arrRow['id'];
		}

		foreach($arrHotelIds as $intOldHotelId){
			// duplicate hotel record
			$objModel->strQuery = 'INSERT INTO `' . $objModel->strTableName . '`(
					`quote_id`, 
					`hotel_id`, 
					`check_in_date`, 
					`check_out_date`, 
					`nights`, 
					`rooms`, 
					`golfers`, 
					`non_golfers`, 
					`guests_name`, 
					`confirm_num`, 
					`notes`, 
					`public_notes`, 
					`room_notes`, 
					`email_content`, 
					`note_id`, 
					`default`, 
					`paidout`
				) 
				SELECT ' . $intNewId . ', 
					   `hotel_id`, 
					   `check_in_date`, 
					   `check_out_date`, 
					   `nights`, 
					   `rooms`, 
					   `golfers`, 
					   `non_golfers`, 
					   `guests_name`, 
					   `confirm_num`, 
					   `notes`, 
					   `public_notes`, 
					   `room_notes`, 
					   `email_content`, 
					   `note_id`, 
					   `default`, 
					   `paidout`
				FROM `package_hotel`
			   WHERE `id` = ' . $intOldHotelId;

		    if($blnDebug) {
			 	Util::debugDisplay($objModel->strQuery);
			}

			if($objModel->short_query($objModel->strQuery)) {
		    	$objModel->strSuccessMessage = 'Hotel Records Converted';
		    }else{
				$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			}

			$intNewHotelId = $objModel->mysqli->insert_id;

			// update child records
			// duplicate child records
			$objModel->strQuery = 'INSERT INTO `quote_hotel_detail`(
					`member_id`, 
					`quote_hotel_id`, 
					`people_num`, 
					`people_name`, 
					`people_lname`, 
					`people_email`, 
					`people_phone`, 
					`people_city`, 
					`room_num`, 
					`nights_num`, 
					`package_price`, 
					`deposit_price`, 
					`final_price`, 
					`cc_processed`, 
					`notes`, 
					`last_payment_date`
				) 
				SELECT `member_id`, 
					   ' . $intNewHotelId . ', 
					   `people_num`, 
					   `people_name`, 
					   `people_lname`, 
					   `people_email`, 
					   `people_phone`, 
					   `people_city`, 
					   `room_num`, 
					   `nights_num`, 
					   `package_price`, 
					   `deposit_price`, 
					   `final_price`, 
					   `cc_processed`, 
					   `notes`, 
					   `last_payment_date`
				FROM `package_hotel_detail`
			   WHERE `package_hotel_id` = '. $intOldHotelId;

		    if($blnDebug) {
			 	Util::debugDisplay($objModel->strQuery);
			}

			if($objModel->short_query($objModel->strQuery)) {
		    	$objModel->strSuccessMessage = 'Hotel Detail Record Duplicated';
		    }else{
				$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			}
		}

		return true;

	}

}



?>