<?php


class Quotegroups extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;

	public $strGroupName;
	public $intGroupId;
	public $intQuoteId;


	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'quote_group';
		$this->strTableSlug = 'quote_group';
		$this->strAdminSlug = '/admin/quote/';

		$this->strTitle = 'Quote Groups';


	}


	public function handlePost($post,$id, $debug = false) {

		$this->intID = $id;

		$this->intGroupId = isset($post['group_id']) ? $post['group_id'] : '';
		$this->intQuoteId = isset($post['quote_id']) ? $post['quote_id'] : '';
		$this->strGroupName = isset($post['group_name']) ? $post['group_name'] : '';

		if($this->intGroupId == '') { $this->strErrorMessage .= "Please choose a group.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array(
				'quote_id',
				'group_id',
				'group_name'
			);
			$vals = array(
				$this->intQuoteId,
				$this->intGroupId,
				$this->strGroupName
			);
			//$types = array('iissssssssss');

			if($this->intRelGroupID == '') {

				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->strSuccessMessage = 'Record Added:'.$this->intRelGroupID;


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intRelGroupID);
				$this->strSuccessMessage = 'Record Saved';

			}


        } //error message check

        return $this->intRelGroupID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*
		From $this->strTableName t
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];


			$this->intGroupId = isset($result['group_id']) ? $result['group_id'] : '';
			$this->intQuoteId = isset($result['quote_id']) ? $result['quote_id'] : '';

			// get group name
			$this->strGroupName = $this->getGroupName();
			$result['group_name'] = $this->strGroupName;

	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {

		$debug = true;
		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);

		if($start<0){
			$start = 0;
		}


	     $this->strQuery = "SELECT t.*
	     From $this->strTableName t,
	     JOIN `groups` g
	     	ON g.id = t.group_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND g.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (g.group_name like '%$searchWord%' )";
		 }

		 if($sortBy != ''){
		 	$this->strQuery .= " ORDER BY $sortBy $sortOrder ";
		 }

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}

	public function getGroups() {
		$strQuery = "SELECT p.id,  p.type_id, p.group_name, p.address, p.comments, t.title, s.state_name, s.short_name
			FROM group p
			LEFT JOIN group_type y ON y.id = p.type_id
			LEFT JOIN city t ON t.id=p.city_id
			LEFT JOIN state s ON s.id=t.state_id
			LEFT JOIN country c ON c.id=s.country_id
			LEFT JOIN members m ON m.id=p.member_id
			WHERE p.status='Active'
			AND y.status='Active'
			AND (p.type_id='7' OR p.type_id='3')
			ORDER BY p.group_name ASC ";

		//echo '$strQuery='.$strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getTrackCodes() {
		$strQuery = "SELECT * FROM `track_code` WHERE `status`='Active' ORDER BY `name`";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($arrIds, $debug = false) {
		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		// delete quotes in group, this should delete all records in the quote_group table
		Quote::deleteQuoteByGroup($arrIds, $debug);

	    // delete join records, if there are any left over (orphaned records)
	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE group_id IN (' . implode(',', $arrIds) . ')';
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return false;
		}

		return true;
	}

	public static function deleteByQuote($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

	    // delete join records
	    $objModel->strQuery = 'DELETE FROM '.$objModel->strTableName.' WHERE quote_id IN (' . implode(',', $arrIds) . ')';
	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

	    if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    } else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		return true;
	}

	public static function deleteByGroup($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		// delete quotes in group
		Quote::deleteQuoteByGroup($arrIds, $blnDebug);

	    // delete join records
	    $objModel->strQuery = 'DELETE FROM '.$objModel->strTableName.' WHERE group_id IN (' . implode(',', $arrIds) . ')';
	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}


	    if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    } else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		return true;
	}

	public function getGroupName($debug = false){
		$this->strQuery = 'SELECT group_name FROM ' . $this->strTableName . ' WHERE group_id = '. $this->group_id;

		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$strGroupName = $res[0]['group_name'];
	     	if(file_exists(ROOT_DIR.$strGroupName)) {
	     		unlink(ROOT_DIR.$strGroupName);
	     		Util::debugDisplay('delete='.ROOT_DIR.$strGroupName);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$strGroupName='.ROOT_DIR.$strGroupName);
		}

		return $strGroupName;
	}

	public static function insertQuoteGroup($intQuoteId, $intGroupId = null){
		if(empty($intQuoteId)){
			return false;
		}

		if(empty($intGroupId)){
			// create a new group
			$intGroupId = Group::createGroup();
		}

		// create new instance of this model to do operations too
		$objModel = new static;

		// insert new db record
		$arrKeys = array('group_id', 'quote_id');
		$arrValues = array($intGroupId, $intQuoteId);

		$objModel->strQuery = 'INSERT INTO ' . $objModel->strTableName . ' (' . implode(',', $arrKeys) . ') VALUES (' . implode(',', $arrValues) . ') ';

		if($objModel->short_query($objModel->strQuery)) {
			$objModel->strSuccessMessage = 'Record Created';
		} else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		// return group id that was just created
		return true;

	}

	public static function getLastQuoteByGroup($intGroupId, $blnDebug = false){
		if(empty($intGroupId)){
			return false;
		}

		// create new instance of this model to do operations too
		$objModel = new static;

		$objModel->strQuery = 'SELECT quote_id FROM ' . $objModel->strTableName . ' WHERE group_id = '. $intGroupId . ' ORDER BY quote_id DESC';

		$intQueryId = null;
		if($objModel->query($objModel->strQuery)) {
	     	$arrResults = $objModel->getMysqliResults($objModel->strQuery,true);
	     	$intQueryId = $arrResults[0]['quote_id'];
	    }

	    if($blnDebug) {
	    	Util::debugDisplay($objModel->strQuery);
		}

		return $intQueryId;
	}

}



?>