<?php


class Quote extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $records = 1;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strSearchWord;
	public $strGroupName;
	public $strCompleted;
	public $strUserName;
	public $strUserEmail;
	public $strPhone;
	public $strFax;
	public $strCellPhone;
	public $strEmergency;
	public $strAdminNote;
	public $strAddress;
	public $intCityId;
	public $intCountryId;
	public $intStateId;
	public $strZip;
	public $strDatesArrival;
    public $strDatesDepart;
	public $strOrderDate;
	public $strComments;

	public $intId;
	public $intGroupID;
	public $intBrandId;
	public $intBookingId;
	public $arrGroupIds;

	public $strAction;
	public $strPubStatus;
	public $intParentId;
	public $strSmoking;
	public $strBedshare1;
	public $strBedshare2;
	public $strBookingEmail;
	public $strCarts;
	public $strShuttle;
	public $intCouplesNum;
	public $intPlayersNum;
	public $intNgNum;
	public $arrAccommodations;
	public $arrGolfCourses;
	public $intRepeat;
	public $strMiniContent;
	public $strNote;
	public $md5Session;
	public $strVoucherText1;
	public $strVoucherText2;
	public $strVoucherText3;
	public $strVoucherText4;
	public $strBrandName;
	public $intGridCompleted;
	public $strGridDateType;
	public $strStartDate;
	public $strEndDate;
	public $intYear;
	public $intMonth;
	public $strLatitude;
	public $strLongitude;
	public $strZlevel;
	public $blnNotify;
	public $blnProcessed;
	public $strDatesBooking;
	public $intPrice;
	public $intTotalPeople;
	public $intTotalRooms;
	public $intTotalRounds;
	public $strCurrency;
	public $strAdditionalDetails;
	public $strQuoteName;
	public $intPackageId;
	public $blnReadyToBook;
    public $intEmailRead;
    public $intEmailReadDatetime;

    public $arrSelectedBookingPeople;
	public $arrSelectedBookingPeoplePrimary;
	public $arrSelectedBookingPeopleBcc;

	public $arrBookingAgent;

	public function __construct($strPageId = '',$strAction = '') {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'quotes';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/quote/';

		$this->strTitle = 'Quotes';
	}

	public function setStatus($stat) {
		$this->intGridCompleted = $stat;
	}

	public function setDateType($type) {
		$this->strGridDateType = $type;
	}

	public function setStartDate($date) {
		$this->strStartDate = $date;
	}

	public function setEndDate($date) {
		$this->strEndDate = $date;
	}

	public function setYear($date) {
		$this->intYear = $date;
	}

	public function setMonth($date) {
		$this->intMonth = $date;
	}

	public function handlePost($post,$id) {
		$this->intId = $id;
		$this->intGroupId = isset($post['group_id']) ? $post['group_id'] : null;
		$this->strGroupName = isset($post['group_name']) ? $post['group_name'] : '';
		$this->strCompleted = isset($post['completed']) ? $post['completed'] : '';
		$this->intBrandId = isset($post['brandID']) ? $post['brandID'] : '0';
		$this->strUserName = isset($post['user_name']) ? $post['user_name'] : '';
		$this->strUserEmail = isset($post['user_email']) ? $post['user_email'] : '';
		$this->strPhone = isset($post['phone']) ? $post['phone'] : '';
		$this->strFax = isset($post['fax']) ? $post['fax'] : '';
		$this->strCellPhone = isset($post['cell_phone']) ? $post['cell_phone'] : '';
		$this->strEmergency = isset($post['emergency']) ? $post['emergency'] : '';
		$this->strAdminNote = isset($post['admin_note']) ? $post['admin_note'] : '';
		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->intCityId = isset($post['city']) ? $post['city'] : '';
		$this->intCountryId = isset($post['country']) ? $post['country'] : '';
		$this->intStateId = isset($post['state']) ? $post['state'] : '';
		$this->strZip = isset($post['zip']) ? $post['zip'] : '';
		$this->intRepeat = isset($post['repeat']) ? $post['repeat'] : '';
		$this->intBookingId = isset($post['bookingID']) ? $post['bookingID'] : '';
		$this->blnNotify = isset($post['blnNotify']) ? $post['blnNotify'] : '';

		$this->strDatesArrival = isset($post['dates_arrival']) ? $post['dates_arrival'] : '';
		$this->strDatesDepart = isset($post['dates_depart']) ? $post['dates_depart'] : '';
		$this->strComments = isset($post['comments']) ? $post['comments'] : '';
		$this->strCompleted = isset($post['completed']) ? $post['completed'] : '0';
		$this->strSmoking = isset($post['smoking']) ? $post['smoking'] : '0';
		$this->strBedshare1 = isset($post['bedshare1']) ? $post['bedshare1'] : '0';
		$this->strBedshare2 = isset($post['bedshare1']) ? $post['bedshare2'] : '0';
		$this->strCarts = isset($post['carts']) ? $post['carts'] : '0';
		$this->strShuttle = isset($post['shuttle']) ? $post['shuttle'] : '0';
		$this->intCouplesNum = isset($post['couples_num']) ? $post['couples_num'] : '0';
		$this->intPlayersNum = isset($post['players_num']) ? $post['players_num'] : '0';
		$this->intNgNum = isset($post['ng_num']) ? $post['ng_num'] : '0';
		$this->blnProcessed = isset($post['blnProcessed']) ? $post['blnProcessed'] : 0;
        $this->strOrderDate = isset($post['order_date']) ? $post['order_date'] : '';
		$this->strDatesBooking = isset($post['dates_booking']) ? $post['dates_booking'] : '';
		$this->strNote = isset($post['note']) ? $post['note'] : '';
		$this->strMiniContent = isset($post['mini_content']) ? $post['mini_content'] : '';
		$this->strVoucherText1 = isset($post['voucher_text_1']) ? $post['voucher_text_1'] : '';
		$this->strVoucherText2 = isset($post['voucher_text_2']) ? $post['voucher_text_2'] : '';
		$this->strVoucherText3 = isset($post['voucher_text_3']) ? $post['voucher_text_3'] : '';
		$this->strVoucherText4 = isset($post['voucher_text_4']) ? $post['voucher_text_4'] : '';
		$this->strVoucherText5 = isset($post['voucher_text_5']) ? $post['voucher_text_5'] : '';
		$this->intPrice = isset($post['price']) ? $post['price'] : 'Null';
		$this->intTotalPeople = isset($post['total_people']) ? $post['total_people'] : 0;
		$this->intTotalRooms = isset($post['total_rooms']) ? $post['total_rooms'] : 0;
		$this->intTotalRounds = isset($post['total_rounds']) ? $post['total_rounds'] : 0;
		$this->strCurrency = isset($post['currency']) ? $post['currency'] : 'CAD';
		$this->strAdditionalDetails = isset($post['additional_details']) ? $post['additional_details'] : '';
		$this->strQuoteName = isset($post['quote_name']) ? $post['quote_name'] : '';
        $this->intEmailRead = !empty($post['email_read']) ? 1 : 0;
        $this->intEmailReadDatetime = $this->intEmailRead == 1 ? $post['email_read_datetime'] : null;

		$arrVoucherNotes = isset($post['voucher_notes'])? $post['voucher_notes'] : array();

		$this->arrSelectedBookingPeople = isset($post['booking_people_id']) ? $post['booking_people_id'] : array();
		$this->arrSelectedBookingPeopleBcc = isset($post['booking_people_bcc']) ? $post['booking_people_bcc'] : array();
		$this->intSelectedBookingPeoplePrimary = isset($post['booking_people_primary']) ? $post['booking_people_primary'] : 0;

		if($this->strErrorMessage != ''){
			return $this->intId;
		}

		$keys = array(
			'completed',
			'user_name',
			'user_email',
			'phone',
			'fax',
			'cell_phone',
			'emergency',
			'admin_note',
			'address',
			'city',
			'country',
			'state',
			'zip',
			'dates_arrival',
			'dates_depart',
			'comments',
			'smoking',
			'bedshare1',
			'bedshare2',
			'carts',
			'shuttle',
			'couples_num',
			'players_num',
			'ng_num',
			'price',
			'currency',
			'mini_content',
			'notes',
			'voucher_text_1',
			'voucher_text_2',
			'voucher_text_3',
			'voucher_text_4',
			'voucher_text_5',
			'brandID',
			'bookingID',
			'blnRepeat',
			'blnNotify',
			'blnProcessed',
			'total_rounds',
			'total_rooms',
			'total_people',
            'dates_booking',
			'order_date',
			'additional_details',
			'quote_name',
            'email_read',
            'email_read_datetime',
			'edit_date'
		);
		$vals = array(
			$this->strCompleted,
			$this->strUserName,
			$this->strUserEmail,
			$this->strPhone,
			$this->strFax,
			$this->strCellPhone,
			$this->strEmergency,
			$this->strAdminNote,
			$this->strAddress,
			$this->intCityId,
			$this->intCountryId,
			$this->intStateId,
			$this->strZip ,
			$this->strDatesArrival ,
			$this->strDatesDepart,
			$this->strComments,
			$this->strSmoking,
			$this->strBedshare1,
			$this->strBedshare2,
			$this->strCarts,
			$this->strShuttle,
			$this->intCouplesNum,
			$this->intPlayersNum,
			$this->intNgNum,
			$this->intPrice,
			$this->strCurrency,
			$this->strMiniContent,
			$this->strNote,
			$this->strVoucherText1,
			$this->strVoucherText2,
			$this->strVoucherText3,
			$this->strVoucherText4,
			$this->strVoucherText5,
			$this->intBrandId,
			$this->intBookingId,
			$this->intRepeat,
			$this->blnNotify,
			$this->blnProcessed,
			$this->intTotalRounds,
			$this->intTotalRooms,
			$this->intTotalPeople,
			$this->strDatesBooking,
            $this->strOrderDate,
			$this->strAdditionalDetails,
			$this->strQuoteName,
            $this->intEmailRead,
            $this->intEmailReadDatetime,
			date('Y-m-d G:i:s')
		);
		//$types = array('sssssssssssssssssssssssssssssssssssi');

		if($this->intId == '') {

			//no ability to add categories is required.
			$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
			$this->intId = $this->insert_id;
			$this->strSuccessMessage = 'Record Added:'.$this->intId;

			$this->md5Session = md5($this->intId);

			// add relationship record to group
			if(!empty($this->intGroupId)){
				// create records and assign to group passed in
				$this->strQuery = 'INSERT INTO `quote_group`(
										`group_id`,
										`quote_id`
									)VALUES(
										' . $this->intGroupId . ',
										' . $this->intId . '
									)';

				if(!$this->short_query($this->strQuery)) {
					$this->strErrorMessage = 'SQL error:'.$this->strQuery;
					return false;
				}
			}

		} else {

			// Update the voucher notes
			if (!empty($arrVoucherNotes)) {
				foreach ($arrVoucherNotes as $strType => $arrVouchers) {
					// Switch the database
					if ($strType == 'hotel') {
						$strDatabase = 'quote_hotel';
					} else {
						$strDatabase = 'quote_golf';
					}

					// Loop through and update the notes
					if (!empty($arrVouchers)) {
						foreach ($arrVouchers as $intId => $strNote) {
							$this->strErrorMessage = $this->mysqliupdate($strDatabase, array('public_notes'), array($strNote), '', $intId);
						}
					}
				}
			}

			// Update Booking Agents
			$delSql = "DELETE FROM quote_booking_people WHERE quote_id = " . $this->intId;

			$this->short_query($delSql);

			$arrBookingPeople = array();

			foreach ($this->arrSelectedBookingPeople AS $intBookingPersonId) {
				$arrBookingPeople[$intBookingPersonId]['contact'] = true;
			}

			foreach ($this->arrSelectedBookingPeopleBcc AS $intBookingPersonId) {
				$arrBookingPeople[$intBookingPersonId]['bcc'] = true;
			}

			if ($this->intSelectedBookingPeoplePrimary != '') {
				$arrBookingPeople[$this->intSelectedBookingPeoplePrimary]['primary'] = true;
			}

			foreach ($arrBookingPeople As $intBookingPersonId=>$arrBookingPerson) {
				$strSql = "INSERT INTO quote_booking_people (quote_id, booking_people_id, primary_contact, contact, bcc)
							VALUES (".$this->intId.", ".$intBookingPersonId.", " . (isset($arrBookingPerson['primary']) ? 1 : 0) . ", " . (isset($arrBookingPerson['contact']) ? 1 : 0) . ", " . (isset($arrBookingPerson['bcc']) ? 1 : 0) . " )";

				$this->short_query($strSql);
			}

			$this->md5Session = md5($this->intId);
			$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$id);
			$this->strSuccessMessage = 'Record Saved';



		}

		$this->strQuery = "UPDATE $this->strTableName SET session_id='$this->md5Session' WHERE id=$this->intId";
		$this->short_query($this->strQuery);





        return $this->intId;

	}
	
	public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getAgentDetail($id = '', $session = '') {

		$arrBookingAgent = array();

		if ($session != '') {
			$strSql = "SELECT id FROM quotes WHERE session_id = '$session'";

			$arrResults = $this->getMysqliResults($strSql,true);

			if (count($arrResults) == 1) {
				$id = $arrResults[0]['id'];
			}

		}

		if($id != '') {

			$strSql = "SELECT booking_people_id FROM quote_booking_people WHERE primary_contact = 1 and quote_id = $id";

			$arrResults = $this->getMysqliResults($strSql,true);

			if (count($arrResults) == 1) {

				$intPrimaryBookingPersonId = $arrResults[0]['booking_people_id'];
				$strSql = "SELECT * FROM booking_people WHERE id = $intPrimaryBookingPersonId";

				$arrResults = $this->getMysqliResults($strSql,true);

				if (count($arrResults) == 1) {
					$arrBookingAgent = $arrResults[0];
				}
			}
		}

		return $arrBookingAgent;

	}

	public function getDetail($id = '', $session = '') {

		if($id != '' || $session != ''){
			//page specific SEO settings. These may override the default settings.
			$this->strQuery = "SELECT  r.latitude, r.longitude, r.zlevel, p.*, b2.booking_email,
			(SELECT check_in_date FROM quote_hotel WHERE quote_id=p.`id` AND `default`=1) As check_in_date,
			b.address As business_address,
			b.phone As business_phone,
			b.business_name,
			b.tollfree As business_tollfree,
			b.zip As business_zip,
			b.fax As business_fax,
			b.display_image As business_logo,
			c.title As business_city,
			b.contact_email As business_email,
			b.terms As business_terms,
			b.mini_page_text As business_text,
			s.state_name As business_state,
			b.background_color,
			b.text_color,
			s2.status_name,
			s2.color AS status_color,
			m.id AS userID,
			g.group_name AS group_name,
			g.id AS groupID,
			p.dates_arrival AS dates_arrival,
			p.dates_depart AS dates_depart
			From $this->strTableName p
			LEFT JOIN quote_group qg ON qg.quote_id = p.id
	     	LEFT JOIN `groups` g ON g.id = qg.group_id
			Left Join region r on r.id=p.region_id
			LEFT join members m on m.email=p.user_email
			LEFT join order_status s2 on s2.id=p.completed
			LEFT join brands b on b.id=p.brandID
			LEFT join booking_people b2 on b2.id=p.bookingID
			LEFT join city c on c.id=b.city_id
			LEFT join state s on s.id=c.state_id ";

			if($id != ''){
				$this->strQuery .= "WHERE p.id=$id ";
			}

			if($session != ''){
				$this->strQuery .= "WHERE p.session_id='$session' ";
			}




			$this->strQuery .= "LIMIT 0,1 ";

			//echo Util::debugDisplay($this->strQuery);


			if($this->query($this->strQuery)) {

		     	if($result = $this->getMysqliResults($this->strQuery,true)) {
			     	$result = $result[0];

			     	$this->strGroupName = isset($result['group_name']) ? $result['group_name'] : '';
			     	$this->strUserName = isset($result['user_name']) ? $result['user_name'] : '';
			     	$this->strUserEmail = isset($result['user_email']) ? $result['user_email'] : '';
			     	$this->intBrandId = isset($result['brandID']) ? $result['brandID'] : '';
					$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
					$this->strFax = isset($result['fax']) ? $result['fax'] : '';
					$this->strCellPhone = isset($result['cell_phone']) ? $result['cell_phone'] : '';
					$this->strEmergency = isset($result['emergency']) ? $result['emergency'] : '';
					$this->strAdminNote = isset($result['admin_note']) ? $result['admin_note'] : '';
					$this->strAddress = isset($result['address']) ? $result['address'] : '';
					$this->intCityId = isset($result['city']) ? $result['city'] : '';
					$this->intCountryId = isset($result['country']) ? $result['country'] : '';
					$this->intStateId = isset($result['state']) ? $result['state'] : '';
					$this->strZip = isset($result['zip']) ? $result['zip'] : '';
					$this->strDatesArrival = isset($result['dates_arrival']) ? $result['dates_arrival'] : '';
					$this->strDatesDepart = isset($result['dates_depart']) ? $result['dates_depart'] : '';
					$this->strComments = isset($result['comments']) ? $result['comments'] : '';
					$this->strCompleted = isset($result['completed']) ? $result['completed'] : '';
					$this->strSmoking = isset($result['smoking']) ? $result['smoking'] : '';
					$this->strBedshare1 = isset($result['bedshare1']) ? $result['bedshare1'] : '';
					$this->strBedshare2 = isset($result['bedshare1']) ? $result['bedshare2'] : '';
					$this->strCarts = isset($result['carts']) ? $result['carts'] : '';
					$this->strShuttle = isset($result['shuttle']) ? $result['shuttle'] : '';
					$this->intCouplesNum = isset($result['couples_num']) ? $result['couples_num'] : '';
					$this->intPlayersNum = isset($result['players_num']) ? $result['players_num'] : '';
					$this->intNgNum = isset($result['ng_num']) ? $result['ng_num'] : '';
					$this->arrGolfCourses = isset($result['golfcourses']) ? $result['golfcourses'] : '';
					$this->arrAccommodations = isset($result['accommodations']) ? $result['accommodations'] : '';
					$this->intRepeat = isset($result['blnRepeat']) ? $result['blnRepeat'] : '';
					$this->strNote = isset($result['note']) ? $result['note'] : '';
					$this->strMiniContent = isset($result['mini_content']) ? $result['mini_content'] : '';
					$this->md5Session = isset($result['session_id']) ? $result['session_id'] : '';
					$this->strVoucherText1 = isset($result['voucher_text_1']) ? $result['voucher_text_1'] : '';
					$this->strVoucherText2 = isset($result['voucher_text_2']) ? $result['voucher_text_2'] : '';
					$this->strVoucherText3 = isset($result['voucher_text_3']) ? $result['voucher_text_3'] : '';
					$this->strVoucherText4 = isset($result['voucher_text_4']) ? $result['voucher_text_4'] : '';
					$this->strVoucherText5 = isset($result['voucher_text_5']) ? $result['voucher_text_5'] : '';
					$this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
					$this->strBrandLogo = isset($result['business_logo']) ? $result['business_logo'] : '';
					$this->strBusinessTollFree = isset($result['business_tollfree']) ? $result['business_tollfree'] : '';
					$this->strBusinessCity = isset($result['business_city']) ? $result['business_city'] : '';
					$this->strBusinessPhone = isset($result['business_phone']) ? $result['business_phone'] : '';
					$this->strBusinessAddress = isset($result['business_address']) ? $result['business_address'] : '';
					$this->strBusinessProv  = isset($result['business_state']) ? $result['business_state'] : '';
					$this->strBusinessFax    = isset($result['business_fax']) ? $result['business_fax'] : '';
					$this->strBusinessZip    = isset($result['business_zip']) ? $result['business_zip'] : '';
					$this->strBusinessEmail    = isset($result['business_email']) ? $result['business_email'] : '';
					$this->strTerms = isset($result['business_terms']) ? $result['business_terms'] : '';
					$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
					$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
					$this->strZlevel = isset($result['zlevel']) ? $result['zlevel'] : '';
					$this->intBookingId = isset($result['bookingID']) ? $result['bookingID'] : '';
					$this->strBookingEmail = isset($result['booking_email']) ? $result['booking_email'] : '';
					$this->blnNotify = isset($result['blnNotify']) ? $result['blnNotify'] : 0;
					$this->blnProcessed = isset($result['blnProcessed']) ? $result['blnProcessed'] : 0;
                    $this->strDatesBooking = isset($result['dates_booking']) ? $result['dates_booking'] : '';
					$this->strOrderDate = isset($result['order_date']) ? $result['order_date'] : '';
					$this->intPrice = isset($result['price']) ? $result['price'] : '';
					$this->intTotalPeople = isset($result['total_people']) ? $result['total_people'] : 0;
					$this->intTotalRooms = isset($result['total_rooms']) ? $result['total_rooms'] : 0;
					$this->intTotalRounds = isset($result['total_rounds']) ? $result['total_rounds'] : 0;
			     	$this->intId = $result['id'];
			     	$this->intGroupID = $result['groupID'];
			     	$this->strCurrency = isset($result['currency']) ? $result['currency'] : 'CAD';
			     	$this->strAdditionalDetails = isset($result['additional_details']) ? $result['additional_details'] : '';
			     	$this->strQuoteName = isset($result['quote_name']) ? $result['quote_name'] : '';
			     	$this->intPackageId = (int)isset($result['package_id']) ? $result['package_id'] : '';
			     	$this->blnReadyToBook = (boolean)isset($result['ready_to_book']) ? $result['ready_to_book'] : false;
                    $this->intEmailRead = !empty($result['email_read']) ? 1 : 0;
                    $this->intEmailReadDatetime = !empty($result['email_read_datetime']) ? $result['email_read_datetime'] : 0;

                    $this->arrBookingAgent = $this->getAgentDetail($id, $session);

					$this->strQuery = "SELECT
											pg.id AS pgid,
											pg.course_id,
											p.group_name,
											p.user_name,
											g.*,
											c.title,
											s.short_name,
											pg.course_id,
											pg.tee_date,
											pg.tee_time,
											pg.tee_day,
											pg.tee_ap,
											pg.carts,
											pg.range_ball,
											pg.shuttle,
											pg.rental_club,
											pg.confirm_num,
											pg.golfer_num,
											pg.notes,
											pg.public_notes,
											coalesce((SELECT file_name FROM course_img WHERE course_id=pg.course_id AND blnPrimary=1),display_image) As course_image
										FROM
											quote_golf pg
											LEFT JOIN quotes p On pg.quote_id=p.id
											LEFT JOIN course g On  pg.course_id=g.id
											LEFT JOIN  city c On g.city_id=c.id
											LEFT JOIN  state s On c.state_id=s.id
										WHERE
											pg.quote_id=".$this->intId."
											order by pg.tee_date asc";

					// echo Util::debugDisplay($this->strQuery);

					$this->arrCourseVouchers = Null;

					if($this->query($this->strQuery)) {
			     		$result2 = $this->getMysqliResults($this->strQuery,true);
			     		if(count($result2) > 0) {

			     			// Add another value called id since we renamed the original id
			     			foreach ($result2 as &$arrValue) {
			     				$arrValue['id'] = $arrValue['pgid'];
			     			}

			     			$this->arrCourseVouchers = $result2;
			     		}
			     	}

			     	$this->strQuery = "SELECT
			     							ph.id As phid,
			     							ph.hotel_id,
			     							p.group_name,
			     							p.user_name,
			     							h.*,
			     							c.title,
			     							s.short_name,
			     							ph.hotel_id,
			     							ph.check_in_date,
			     							ph.check_out_date,
			     							ph.confirm_num,
			     							ph.nights,
			     							ph.notes,
			     							ph.public_notes,
			     							coalesce((SELECT file_name FROM hotel_img WHERE hotel_id=ph.hotel_id AND blnPrimary=1),file_name) As hotel_image,
			     							ph.golfers,
			     							ph.non_golfers,
			     							ph.rooms,
			     							ph.guests_name,
			     							ph.`default`
			     						FROM
			     							quote_hotel ph
									     	LEFT JOIN quotes p ON ph.quote_id=p.id
											LEFT JOIN hotel h ON  ph.hotel_id=h.id
											LEFT JOIN city c ON h.city_id=c.id
											LEFT JOIN state s ON c.state_id=s.id
			     						WHERE
			     							ph.quote_id='".$this->intId."'
			     						ORDER BY ph.check_in_date asc";

			     	// echo Util::debugDisplay($this->strQuery);

			     	$this->arrHotelVouchers = Null;

					if($this->query($this->strQuery)) {
			     		$result2 = $this->getMysqliResults($this->strQuery,true);
			     		if(count($result2) > 0) {
			     			$this->arrHotelVouchers = $result2;
			     		}
			     	}

			     	$result['booking_agent'] = $this->arrBookingAgent;

			     	return $result;

		    	}

		    }

		    // echo($this->strQuery);
		    // die();

			return null;


		}

	}


	public function getQuoteHotelDetail($quote_hotel_id, $debug = false) {


		$this->strQuery ="SELECT *
			FROM quote_hotel_detail
			where quote_hotel_id='$quote_hotel_id'
			order by CHAR_LENGTH(room_num) ASC, room_num asc, people_num ASC";

		if($debug){

			Util::debugDisplay($this->strQuery);
		}


		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result;

		}

	}

	public function getQuoteHotelImages($hotel_id) {


		$this->strQuery ="SELECT *
			FROM hotel_img
			where hotel_id='$hotel_id'
			AND status='Active'
			order by blnPrimary DESC, display_order asc
			LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result[0];

		}

	}

	public function getQuoteCourseImages($course_id) {


		$this->strQuery ="SELECT *
			FROM course_img
			where course_id='$course_id'
			AND status='Active'
			order by blnPrimary DESC, display_order asc
			LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result[0];

		}

	}

	public function getClientNameForQuote($quote_id) {

		$this->strQuery = "SELECT user_name
		From $this->strTableName
		WHERE id=$quote_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0]['user_name'];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getSessionForQuote($quote_id) {

		$this->strQuery = "SELECT session_id
		From $this->strTableName
		WHERE id=$quote_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0]['session_id'];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getHotelDetailsForQuote($quote_id) {

		$this->strQuery = "SELECT p.`group_name`
		From $this->strTableName p
		WHERE p.`id`=$quote_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getEmailsForQuote($quote_id) {

		$this->strQuery = "SELECT b.contact_email, p.user_email, p.user_name, b.contact_email2, b.id AS 'brand_id'
		From $this->strTableName p
		LEFT join brands b on b.id=p.brandID
		WHERE p.id=$quote_id
		LIMIT 0,1";



		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getEmailsForQuoteHotel($rel_id) {

		$this->strQuery = "SELECT b.contact_email, b.business_name, b.contact_email2,
		h2.frontdesk_email As hotel_email, b.mini_hotel_text, p.phone, p.cell_phone,
		p.user_name, h.check_in_date, h.check_out_date, h.nights, h.rooms, h.confirm_num, h.quote_id
		From quote_hotel h
		LEFT JOIN quotes p on p.id=h.quote_id
		LEFT join brands b on b.id=p.brandID
		LEFT JOIN hotel h2 on h2.id=h.hotel_id
		WHERE h.id=$rel_id
		LIMIT 0,1";



		//echo '<br />'.$this->strQuery;

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);

	     	return $result[0];

	    } else {
	     	return null;
	    }
	}

	public function getNotesForQuote($quote_id) {
		// look up group id by quote
		$group_id = static::getGroupById($quote_id);

		return $this->getNotesForQuoteGroup($group_id['id']);
	}

	public function getNotesForQuoteGroup($group_id) {
		$this->strQuery = "
			SELECT qmn.*, sb.contact_person, sb.user_name
			FROM quote_mini_notes qmn
			LEFT JOIN (
				SELECT b.contact_person, q.user_name, qg.group_id
				FROM quote_group qg
				LEFT JOIN quotes q
					ON q.id = qg.quote_id
				LEFT JOIN brands b
					ON b.id = q.brandid
				WHERE qg.group_id = " . $group_id . "
				ORDER BY qg.quote_id DESC
				LIMIT 1
			) sb
				ON 1=1
			WHERE qmn.group_id = sb.group_id";

		// $this->strQuery = "SELECT p.*, b.contact_person, pk.user_name
		// From quote_mini_notes p
		// LEFT join quotes pk on pk.id=p.group_id
		// LEFT join brands b on b.id=pk.brandID
		// WHERE p.quote_id=$quote_id";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

	     	if($result = $this->getMysqliResults($this->strQuery,true)) {
				//$result = $result[0];


	     		return $result;
	     	}

	    }

	    return null;
	}


	public function setQuoteNote($groupID,$note,$direction = 1){
		$this->strQuery = "INSERT INTO quote_mini_notes
		(group_id, comment, timestamp, direction)
		VALUES (".$groupID.",'".$this->mysqli->real_escape_string ($note)."', '".Date('Y-m-d')."',".$direction." ) ";

		$this->short_query($this->strQuery);
		//echo $this->strQuery1;

	}





	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $intGroupId, $debug = false) {

		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);
		$subquery = "";
		$join = "";
		$extra = "COALESCE((SELECT check_in_date FROM quote_hotel WHERE quote_id=t.id AND `default`=1),'--') As check_in_date ";

		if ($this->strGridDateType != '') {

			if(isset($this->intMonth) && $this->intMonth != "") {
                $searchStart = $this->intYear . "-" . $this->intMonth . "-01";
                $strEnd = '-31';
                if (in_array($this->intMonth, array(4, 6, 9, 11))) {
                    $strEnd = '-30';
                }
                if ($this->intMonth == 2) {
                    $strEnd = '-28';
                }
                $searchEnd = $this->intYear . "-" . $this->intMonth . $strEnd;
            } else {
                $searchStart = $this->intYear . "-01-01";
                $searchEnd = $this->intYear . "-12-31";
            }

	    	switch($this->strGridDateType) {
	    		case 'dates_arrival':
	    			$subquery = " and (h.check_in_date>='$searchStart' and h.check_in_date <='$searchEnd')";
	    			$join = "LEFT JOIN quote_hotel h on h.quote_id=t.id  ";
	    			//$extra = "check_in_date";
	    			break;
	    		case 'dates_depart':
	    			$subquery = " and (h.check_out_date>='$searchStart' and h.check_out_date <='$searchEnd')";
	    			$join = "LEFT JOIN quote_hotel h on h.quote_id=t.id  ";
	    			//$extra = "check_in_date";
	    			break;
	    		case 'dates_booking':
	    			$subquery = " and (dates_booking>='$searchStart' and dates_booking <='$searchEnd')";
	    			//$join = "LEFT JOIN quote_hotel h on h.quote_id=t.id  ";
	    			//$extra = "check_in_date";
	    			break;
	    		default:
	    			$subquery = " and (t.$this->strGridDateType>='$searchStart' and t.$this->strGridDateType <='$searchEnd')";
	    			$extra = "(SELECT check_in_date FROM quote_hotel WHERE quote_id=t.id AND `default`=1) As check_in_date ";
        			break;
	    	}

        }


		$this->strQuery1 = "SELECT count(DISTINCT t.`id`) as records
	    FROM $this->strTableName t
	    $join
	    LEFT join order_status s on s.id=t.completed
	    WHERE 1 ";


	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND lower(t.status)='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (s.status_name like '%" . $this->getCleanVar($searchWord) . "%' OR group_name like '%" . $this->getCleanVar($searchWord) . "%' OR user_name like '%" . $this->getCleanVar($searchWord) . "%' )";
	    }

	    if($this->intGridCompleted != ''){
	    	$this->strQuery1 .= "AND (t.completed = '$this->intGridCompleted' )";
	    }

	    $this->strQuery1 .=$subquery;

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($this->records/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	    $this->strQuery = "SELECT DISTINCT t.*, g.group_name, b.business_name, p.booking_name, s.status_name, s.color AS status_color,
	    COALESCE((SELECT sum(golfers) FROM quote_hotel WHERE quote_id=t.id AND `default`=1 ),'--') As golfer_num,
	    $extra
	     FROM $this->strTableName t
	     LEFT JOIN quote_group qg ON qg.quote_id = t.id
	     LEFT JOIN `groups` g ON g.id = qg.group_id
	     LEFT JOIN brands b on b.id = t.brandID
	     LEFT JOIN booking_people p on p.id = t.bookingID
	     LEFT join order_status s on s.id=t.completed
	     $join
	     WHERE 1 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND lower(t.status)='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (s.status_name like '%" . $this->getCleanVar($searchWord) . "%' OR group_name like '%" . $this->getCleanVar($searchWord) . "%' OR user_name like '%" . $this->getCleanVar($searchWord) . "%' )";
		 }

		 if($this->intGridCompleted != ''){
	    	$this->strQuery .= "AND (t.completed = '$this->intGridCompleted' )";
	     }

	     if(!empty($intGroupId)){
	     	$this->strQuery .= " AND qg.group_id = " . $intGroupId . " ";
	     }

	     $this->strQuery .= $subquery;

		 if($sortBy != '') {
		 		$this->strQuery .= " ORDER BY $sortBy $sortOrder ";
		 }

	     $this->strQuery .= " LIMIT $start,$this->pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($intGroupId, $type = '', $blnDebug = false) {

		$strQuery = "SELECT count('x') As c
		from $this->strTableName t
		LEFT JOIN quote_group qg ON qg.quote_id = t.id
		WHERE 1 = 1 ";

		if($type != '') $strQuery .= " AND status='$type'";

		if(!empty($intGroupId)){
	    	$strQuery .= " AND qg.group_id = " . $intGroupId . " ";
	    }

		if($blnDebug) {
			Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getStatus() {
		$strQuery = "SELECT * FROM order_status ORDER BY status_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function updateCompleted($quoteID,$stat) {
		$this->strQuery = "UPDATE quotes SET completed=$stat WHERE id=$quoteID";

		if($this->short_query($this->strQuery)) {
			echo 'Record Saved ';
		} else {
			echo 'SQL error:'.$this->strQuery;
		}
	}

	public function getBooking() {
		$strQuery = "SELECT * FROM booking_people ORDER BY booking_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getBookingPeople($id, $debug = false) {

		$strQuery = "SELECT id, booking_name,
		(SELECT count(booking_people_id) FROM quote_booking_people WHERE quote_id=$id AND booking_people_id=h.id and contact=1) As blnContact,
		(SELECT count(booking_people_id) FROM quote_booking_people WHERE quote_id=$id AND booking_people_id=h.id and bcc=1) As blnBCC,
		(SELECT count(booking_people_id) FROM quote_booking_people WHERE quote_id=$id AND booking_people_id=h.id and primary_contact=1) As blnPrimary
		from booking_people h
		WHERE status='Active'
		ORDER BY booking_name";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getBrands() {
		$strQuery = "SELECT * FROM brands ORDER BY business_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getHotels() {
		$strQuery = "SELECT * FROM hotel WHERE status='Active' ORDER BY hotel_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getCourses() {
		$strQuery = "SELECT p.id,  p.type_id, p.course_name, p.address, p.comments, t.title, s.state_name, s.short_name
			FROM course p
			LEFT JOIN course_type y ON y.id = p.type_id
			LEFT JOIN city t ON t.id=p.city_id
			LEFT JOIN state s ON s.id=t.state_id
			LEFT JOIN country c ON c.id=s.country_id
			LEFT JOIN members m ON m.id=p.member_id
			WHERE p.status='Active'
			AND y.status='Active'
			AND m.confirmed=1
			AND m.approved=1
			AND (p.type_id='7' OR p.type_id='3')
			ORDER BY p.course_name ASC ";

		//echo '$strQuery='.$strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getCoursesForQuote($quoteID) {

		$strQuery = "SELECT p.*, c.course_name, c.teetimes_phone, c.teetimes_email, c.contact_phone, c.contact_email, c.booking_url, c.booking_password, c.booking_username
		FROM quote_golf p
		LEFT JOIN course c on c.id=p.course_id
		WHERE quote_id=".$quoteID." ORDER BY tee_date ASC";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function getHotelsForQuote($quoteID) {

		$strQuery = "SELECT p.*, h.hotel_name, h.contact_phone, h.frontdesk_email, h.booking_url, h.booking_password, h.booking_username
		FROM quote_hotel p
		LEFT JOIN hotel h on h.id=p.hotel_id
		WHERE quote_id=".$quoteID." ORDER BY check_in_date ASC";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($arrIds, $blnDebug = false) {
		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		$objModel->strQuery = 'DELETE FROM ' . $objModel->strTableName . ' WHERE id IN (' . implode(',', $arrIds) . ')';

	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

	    if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    } else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		return true;


	}

	public function savePaidStatus($newval,$type,$Index) {

		if($type == 'course') {
	   		$this->strQuery = 'Update quote_golf Set paidout='.$newval.' Where id='.$Index;

	   	} elseif ($type == 'hotel') {
	   		$this->strQuery = 'Update quote_hotel Set paidout='.$newval.' Where id='.$Index;

	   	}

		if($this->short_query($this->strQuery)) {
			return 'Record Saved';
		} else {
			return 'SQL error: '.$this->strQuery;
		}

	}



	public function duplicateQuote($intQuoteId, $intGroupId = null, $blnDebug = false){
		// make sure the id is actually a real quote
		$this->strQuery = "SELECT 'x' FROM quotes WHERE id = " . $intQuoteId . " LIMIT 1";

		if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		$arrResults = $this->getMysqliResults($this->strQuery, true);

		if(count($arrResults) == 0){
			// no quote to update
			$this->strErrorMessage = 'No quote with the ID #' . $intQuoteId . ' could be found.';
			return false;
		}

		// make sure there is a group (if needed)
		if(!empty($intGroupId)){
			$this->strQuery = "SELECT 'x' FROM `groups` WHERE id = " . $intGroupId . " LIMIT 1";

			if($blnDebug) {
			 	Util::debugDisplay($this->strQuery);
			}

			$arrResults = $this->getMysqliResults($this->strQuery, true);

			if(count($arrResults) == 0){
				// no quote to update
				$this->strErrorMessage = 'No quote group with the ID #' . $intGroupId . ' could be found.';
				return false;
			}
		}

		// duplicate main quote
		$this->strQuery = 'INSERT INTO `' . $this->strTableName . '`(
				`blnProcessed`,
				`region_id`,
				`user_name`,
				`user_email`,
				`domain`,
				`price`,
				`phone`,
				`fax`,
				`cell_phone`,
				`emergency`,
				`address`,
				`city`,
				`state`,
				`country`,
				`zip`,
				`couples_num`,
				`players_num`,
				`ng_num`,
				`players_notes`,
				`golfcourses`,
				`accommodations`,
				`smoking`,
				`bedshare1`,
				`bedshare2`,
				`carts`,
				`shuttle`,
				`dates_arrival`,
				`dates_depart`,
				`dates_booking`,
				`tee_times`,
				`comments`,
				`theorigin`,
				`origin_comment`,
				`admin_note`,
				`voucher_text_1`,
				`voucher_text_2`,
				`voucher_text_3`,
				`voucher_text_4`,
				`voucher_text_5`,
				`mini_content`,
				`cc_form`,
				`order_date`,
				`edit_date`,
				`deleted`,
				`completed`,
				`paid`,
				`invoice`,
				`notes`,
				`mini_enabled`,
				`rounds_num`,
				`date_flex`,
				`last_payment_date`,
				`exempt_from_report`,
				`blnRepeat`,
				`blnNotify`,
				`brandID`,
				`regionID`,
				`bookingID`,
				`total_people`,
				`total_rounds`,
				`total_rooms`,
				`currency`,
				`status`
			)
			SELECT `blnProcessed`,
				   `region_id`,
				   `user_name`,
				   `user_email`,
				   `domain`,
				   `price`,
				   `phone`,
				   `fax`,
				   `cell_phone`,
				   `emergency`,
				   `address`,
				   `city`,
				   `state`,
				   `country`,
				   `zip`,
				   `couples_num`,
				   `players_num`,
				   `ng_num`,
				   `players_notes`,
				   `golfcourses`,
				   `accommodations`,
				   `smoking`,
				   `bedshare1`,
				   `bedshare2`,
				   `carts`,
				   `shuttle`,
				   `dates_arrival`,
				   `dates_depart`,
				   `dates_booking`,
				   `tee_times`,
				   `comments`,
				   `theorigin`,
				   `origin_comment`,
				   `admin_note`,
				   `voucher_text_1`,
				   `voucher_text_2`,
				   `voucher_text_3`,
				   `voucher_text_4`,
				   `voucher_text_5`,
				   \'\',
				   `cc_form`,
				   `order_date`,
				   \'' . date('Y-m-d G:i:s') . '\',
				   `deleted`,
				   `completed`,
				   `paid`,
				   `invoice`,
				   `notes`,
				   `mini_enabled`,
				   `rounds_num`,
				   `date_flex`,
				   `last_payment_date`,
				   `exempt_from_report`,
				   `blnRepeat`,
				   `blnNotify`,
				   `brandID`,
				   `regionID`,
				   `bookingID`,
				   `total_people`,
				   `total_rounds`,
				   `total_rooms`,
				   `currency`,
				   `status`
			FROM `' . $this->strTableName . '`
		   WHERE `id` = ' . $intQuoteId;

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Duplicated';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return false;
		}

		$intNewId = $this->mysqli->insert_id;

		// update with md5Session
		$this->md5Session = md5($this->intId);
		$this->strQuery = "UPDATE $this->strTableName SET session_id='$this->md5Session' WHERE id=$this->intId";
		$this->short_query($this->strQuery);

		// add relationship record to group
		if(!empty($intGroupId)){
			// create records and assign to group passed in
			$this->strQuery = 'INSERT INTO `quote_group`(
					`group_id`,
					`quote_id`
				)
				SELECT ' . $intGroupId . ',
					   ' . $intNewId . '
				FROM `quote_group`
			   WHERE `quote_id` = ' . $intQuoteId;
		}else{
			// no group was passed in so use the old one
			$this->strQuery = 'INSERT INTO `quote_group`(
					`group_id`,
					`quote_id`
				)
				SELECT `group_id`,
					   ' . $intNewId . '
				FROM `quote_group`
			   WHERE `quote_id` = ' . $intQuoteId;
		}

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Brand Record Duplicated';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return false;
		}

		// duplicate child data
		// quote_brand
		$this->strQuery = 'INSERT INTO `quote_brand`(
				`brand_id`,
				`quote_id`
			)
			SELECT `brand_id`,
				   ' . $intNewId . '
			FROM `quote_brand`
		   WHERE `quote_id` = ' . $intQuoteId;

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Brand Record Duplicated';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

		// don't duplicate quote_mini_notes
		QuoteCourses::duplicateByQuoteId($intNewId, $intQuoteId, $blnDebug);
		Quotehotels::duplicateByQuoteId($intNewId, $intQuoteId, $blnDebug);

		return $intNewId;

	}

	public static function deleteMiniNoteByQuote($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		$objModel->strQuery = 'DELETE FROM quote_mini_notes WHERE quote_id IN (' . implode(',', $arrIds) . ')';
	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    }else{
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		return true;
	}

	public static function deleteBrandByQuote($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			// single id passed in
			$arrIds = array($arrIds);
		}

		$objModel = new static;

		$objModel->strQuery = 'DELETE FROM quote_brand WHERE quote_id IN (' . implode(',', $arrIds) . ')';
	    if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		if($objModel->short_query($objModel->strQuery)) {
	    	$objModel->strSuccessMessage = 'Record Deleted';
	    }else{
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		return true;
	}

	public static function deleteQuote($arrIds, $blnDebug = false){
		// delete sub records
		Quotecourses::deleteByQuote($arrIds, $blnDebug);
		Quotehotels::deleteByQuote($arrIds, $blnDebug);
		static::deleteMiniNoteByQuote($arrIds, $blnDebug);
		static::deleteBrandByQuote($arrIds, $blnDebug);

		// delete quote record
		$objModel = new static;
		$objModel->deleteRecord($arrIds, $blnDebug);

		// delete quote_group record
		Quotegroups::deleteByQuote($arrIds);
	}

	public static function deleteQuoteByGroup($arrIds, $blnDebug = false){
		if(!is_array($arrIds)){
			$arrIds = array($arrIds);
		}

		$objModel = new static;
		// look up quotes with these groups

		// get list of quote records
		$objModel->strQuery = 'SELECT quote_id FROM quote_group WHERE group_id IN (' . implode(',', $arrIds) . ')';

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrResults)){
			// no records to delete
			return true;
		}

		$arrQuoteIds = array();
		foreach($arrResults as $arrRow){
			$arrQuoteIds[] = $arrRow['quote_id'];
		}

		// remove those quotes
		static::deleteQuote($arrQuoteIds, $blnDebug);

		return true;
	}

	public function convertPackage($intQuoteId, $blnDebug = false){
		// make sure the id is actually a real quote
		$this->strQuery = "SELECT 'x' FROM quotes WHERE id = " . $intQuoteId . " LIMIT 1";

		if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		$arrResults = $this->getMysqliResults($this->strQuery, true);

		if(count($arrResults) == 0){
			// no quote to update
			$this->strErrorMessage = 'No quote with the ID #' . $intQuoteId . ' could be found.';
			return false;
		}

			$email_reminder_1 = '';
			$email_reminder_2 = '';
			$email_reminder_3 = '';
			$email_reminder_4 = '';
			$email_reminder_5 = '';
			$email_reminder_6 = '';

            $email_reminder_1_days = 40;
            $email_reminder_2_days = 30;
            $email_reminder_3_days = 0;
            $email_reminder_4_days = 0;
            $email_reminder_5_days = 0;
            $email_reminder_6_days = 0;

		if (is_numeric($intQuoteId)) {

			//Lookup the default email templates for the selected brand and use them to populate the reminder email content
			$brandEmail = $this->getMysqliResults("SELECT * FROM brands WHERE id = (SELECT brandID FROM quotes WHERE id = " . $intQuoteId . ")", true);

			if ((is_array($brandEmail) && (count($brandEmail) == 1))) {
				$email_reminder_1 = $brandEmail[0]['reminder_email_1'];
				$email_reminder_2 = $brandEmail[0]['reminder_email_2'];
				$email_reminder_3 = $brandEmail[0]['reminder_email_3'];
				$email_reminder_4 = $brandEmail[0]['reminder_email_4'];
				$email_reminder_5 = $brandEmail[0]['reminder_email_5'];
				$email_reminder_6 = $brandEmail[0]['reminder_email_6'];

                $email_reminder_1_days = $brandEmail[0]['reminder_email_1_days'];
                $email_reminder_2_days = $brandEmail[0]['reminder_email_2_days'];
                $email_reminder_3_days = $brandEmail[0]['reminder_email_3_days'];
                $email_reminder_4_days = $brandEmail[0]['reminder_email_4_days'];
                $email_reminder_5_days = $brandEmail[0]['reminder_email_5_days'];
                $email_reminder_6_days = $brandEmail[0]['reminder_email_6_days'];
			}
		}

		// duplicate main quote
		$this->strQuery = 'INSERT INTO `packages`(
				`blnProcessed`,
				`region_id`,
				`user_name`,
				`user_email`,
				`domain`,
				`price`,
				`phone`,
				`fax`,
				`cell_phone`,
				`emergency`,
				`address`,
				`city`,
				`state`,
				`country`,
				`zip`,
				`couples_num`,
				`players_num`,
				`ng_num`,
				`players_notes`,
				`golfcourses`,
				`accommodations`,
				`smoking`,
				`bedshare1`,
				`bedshare2`,
				`carts`,
				`shuttle`,
				`dates_arrival`,
				`dates_depart`,
				`dates_booking`,
				`tee_times`,
				`comments`,
				`theorigin`,
				`origin_comment`,
				`admin_note`,
				`voucher_text_1`,
				`voucher_text_2`,
				`voucher_text_3`,
				`voucher_text_4`,
				`voucher_text_5`,
				`mini_content`,
				`cc_form`,
				`order_date`,
				`edit_date`,
				`deleted`,
				`completed`,
				`paid`,
				`invoice`,
				`notes`,
				`mini_enabled`,
				`rounds_num`,
				`date_flex`,
				`last_payment_date`,
				`exempt_from_report`,
				`blnRepeat`,
				`blnNotify`,
				`brandID`,
				`regionID`,
				`bookingID`,
				`total_people`,
				`total_rounds`,
				`total_rooms`,
				`currency`,
				`status`,
				`additional_details`,
				`group_name`,
				`quote_id`,
				`reminder_email_1`,
				`reminder_email_2`,
				`reminder_email_3`,
				`reminder_email_4`,
				`reminder_email_5`,
				`reminder_email_6`,
                `reminder_email_1_days`,
                `reminder_email_2_days`,
                `reminder_email_3_days`,
                `reminder_email_4_days`,
                `reminder_email_5_days`,
                `reminder_email_6_days`
			)
			SELECT `q`.`blnProcessed`,
				   `q`.`region_id`,
				   `q`.`user_name`,
				   `q`.`user_email`,
				   `q`.`domain`,
				   `q`.`price`,
				   `q`.`phone`,
				   `q`.`fax`,
				   `q`.`cell_phone`,
				   `q`.`emergency`,
				   `q`.`address`,
				   `q`.`city`,
				   `q`.`state`,
				   `q`.`country`,
				   `q`.`zip`,
				   `q`.`couples_num`,
				   `q`.`players_num`,
				   `q`.`ng_num`,
				   `q`.`players_notes`,
				   `q`.`golfcourses`,
				   `q`.`accommodations`,
				   `q`.`smoking`,
				   `q`.`bedshare1`,
				   `q`.`bedshare2`,
				   `q`.`carts`,
				   `q`.`shuttle`,
				   `q`.`dates_arrival`,
				   `q`.`dates_depart`,
				   `q`.`dates_booking`,
				   `q`.`tee_times`,
				   `q`.`comments`,
				   `q`.`theorigin`,
				   `q`.`origin_comment`,
				   `q`.`admin_note`,
				   `q`.`voucher_text_1`,
				   `q`.`voucher_text_2`,
				   `q`.`voucher_text_3`,
				   `q`.`voucher_text_4`,
				   `q`.`voucher_text_5`,
				   \'\',
				   `q`.`cc_form`,
				   `q`.`order_date`,
				   \'' . date('Y-m-d G:i:s') . '\',
				   `q`.`deleted`,
				   `q`.`completed`,
				   `q`.`paid`,
				   `q`.`invoice`,
				   `q`.`notes`,
				   `q`.`mini_enabled`,
				   `q`.`rounds_num`,
				   `q`.`date_flex`,
				   `q`.`last_payment_date`,
				   `q`.`exempt_from_report`,
				   `q`.`blnRepeat`,
				   `q`.`blnNotify`,
				   `q`.`brandID`,
				   `q`.`regionID`,
				   `q`.`bookingID`,
				   `q`.`total_people`,
				   `q`.`total_rounds`,
				   `q`.`total_rooms`,
				   `q`.`currency`,
				   "Active",
				   `q`.`additional_details`,
				   (SELECT `group_name`
				   	  FROM `groups` `g`
				   	  JOIN `quote_group` `qg`
				   	    ON `g`.`id` = `qg`.`group_id`
				   	 WHERE `qg`.`quote_id` = `q`.`id`),
				    ' . $intQuoteId . ',
				    \''.$email_reminder_1.'\',
					\''.$email_reminder_2.'\',
					\''.$email_reminder_3.'\',
					\''.$email_reminder_4.'\',
					\''.$email_reminder_5.'\',
					\''.$email_reminder_6.'\',
                    \''.$email_reminder_1_days.'\',
                    \''.$email_reminder_2_days.'\',
                    \''.$email_reminder_3_days.'\',
                    \''.$email_reminder_4_days.'\',
                    \''.$email_reminder_5_days.'\',
                    \''.$email_reminder_6_days.'\'
			FROM `' . $this->strTableName . '` `q`
		   WHERE `id` = ' . $intQuoteId;

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Package Created';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return false;
		}

		$intNewPackageId = $this->mysqli->insert_id;

		// update with md5Session
		$strMD5Session = md5($intNewPackageId);
		$this->strQuery = "UPDATE packages SET session_id='$strMD5Session' WHERE id=" . $intNewPackageId;
		$this->short_query($this->strQuery);

		// duplicate child data
		// quote_brand
		$this->strQuery = 'INSERT INTO `package_brand`(
				`brand_id`,
				`package_id`
			)
			SELECT `brand_id`,
				   ' . $intNewPackageId . '
			FROM `quote_brand`
		   WHERE `quote_id` = ' . $intQuoteId;

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Brand Record Created';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

		// don't duplicate quote_mini_notes
		QuoteCourses::convertToPackageByQuoteId($intNewPackageId, $intQuoteId, $blnDebug);
		Quotehotels::convertToPackageByQuoteId($intNewPackageId, $intQuoteId, $blnDebug);

		// lock quote & quote group	+ update status
		$this->strQuery = "UPDATE `groups` SET status='converted' WHERE id = (SELECT qg.group_id FROM quote_group qg WHERE quote_id = $intQuoteId)";
		$this->short_query($this->strQuery);

		$this->strQuery = "UPDATE quotes SET status='converted' WHERE id = $intQuoteId";
		$this->short_query($this->strQuery);

		//Copy booking people
		$strSql = "INSERT INTO package_booking_people (package_id, booking_people_id, primary_contact, contact, bcc)
	 				(SELECT ".$intNewPackageId.", booking_people_id, primary_contact, contact, bcc FROM quote_booking_people WHERE quote_id = ".$intQuoteId.")";

	 	$this->short_query($strSql);

		return $intNewPackageId;
	}

	public static function getGroupName($intQuoteId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT g.group_name FROM `groups` g JOIN quote_group qg ON g.id = qg.group_id WHERE qg.quote_id = ' . $intQuoteId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults[0]['group_name'];
	}

	public static function getGroupById($intQuoteId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT g.* FROM `groups` g JOIN quote_group qg ON g.id = qg.group_id WHERE qg.quote_id = ' . $intQuoteId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrResults)){
			return null;
		}

		return $arrResults[0];
	}

	public static function duplicateById($intQuoteId, $duplicateQuote = null, $blnDebug = false){
		$objModel = new static;

		return $objModel->duplicateQuote($intQuoteId, $duplicateQuote, $blnDebug);
	}

	public function topdf($filename, $options = "") {

		putenv("HTMLDOC_NOCGI=1");
		# Run HTMLDOC to provide the PDF file to the user...
	    passthru("/usr/bin/htmldoc -t pdf  --jpeg=100 --webpage $options '$filename'");
	}

	public function convertFromPackage($intPackageId, $blnDebug = false){
		// lookup package
		$this->strQuery = 'SELECT p.* FROM packages p  WHERE p.id =' . $intPackageId;

		if($blnDebug){
		 	Util::debugDisplay($this->strQuery);
		}

		$arrResults = $this->getMysqliResults($this->strQuery, true);

		if(empty($arrResults)){
			$this->strErrorMessage = 'No package with id found. (' . $intPackageId . ')';
			return $this;
		}

		$arrPackage = $arrResults[0];

		// make new quote group
		$intNewGroup = Group::createGroup($arrPackage['group_name']);

		if($intNewGroup === false){
			// error occured
			$this->objModel->strErrorMessage = 'Quote group could not be created.';
			return $this;
		}

		// copy main package information
		$this->strQuery = 'INSERT INTO `' . $this->strTableName . '`(
				`blnProcessed`,
				`region_id`,
				`user_name`,
				`user_email`,
				`domain`,
				`price`,
				`phone`,
				`fax`,
				`cell_phone`,
				`emergency`,
				`address`,
				`city`,
				`state`,
				`country`,
				`zip`,
				`couples_num`,
				`players_num`,
				`ng_num`,
				`players_notes`,
				`golfcourses`,
				`accommodations`,
				`smoking`,
				`bedshare1`,
				`bedshare2`,
				`carts`,
				`shuttle`,
				`dates_arrival`,
				`dates_depart`,
				`dates_booking`,
				`tee_times`,
				`comments`,
				`theorigin`,
				`origin_comment`,
				`admin_note`,
				`voucher_text_1`,
				`voucher_text_2`,
				`voucher_text_3`,
				`voucher_text_4`,
				`voucher_text_5`,
				`mini_content`,
				`cc_form`,
				`order_date`,
				`edit_date`,
				`deleted`,
				`completed`,
				`paid`,
				`invoice`,
				`notes`,
				`mini_enabled`,
				`rounds_num`,
				`date_flex`,
				`last_payment_date`,
				`exempt_from_report`,
				`blnRepeat`,
				`blnNotify`,
				`brandID`,
				`regionID`,
				`bookingID`,
				`total_people`,
				`total_rounds`,
				`total_rooms`,
				`currency`,
				`status`,
				`additional_details`,
				`package_id`
			)
			SELECT `blnProcessed`,
				   `region_id`,
				   `user_name`,
				   `user_email`,
				   `domain`,
				   `price`,
				   `phone`,
				   `fax`,
				   `cell_phone`,
				   `emergency`,
				   `address`,
				   `city`,
				   `state`,
				   `country`,
				   `zip`,
				   `couples_num`,
				   `players_num`,
				   `ng_num`,
				   `players_notes`,
				   `golfcourses`,
				   `accommodations`,
				   `smoking`,
				   `bedshare1`,
				   `bedshare2`,
				   `carts`,
				   `shuttle`,
				   `dates_arrival`,
				   `dates_depart`,
				   `dates_booking`,
				   `tee_times`,
				   `comments`,
				   `theorigin`,
				   `origin_comment`,
				   `admin_note`,
				   `voucher_text_1`,
				   `voucher_text_2`,
				   `voucher_text_3`,
				   `voucher_text_4`,
				   `voucher_text_5`,
				   \'\',
				   `cc_form`,
				   `order_date`,
				   \'' . date('Y-m-d G:i:s') . '\',
				   `deleted`,
				   `completed`,
				   `paid`,
				   `invoice`,
				   `notes`,
				   `mini_enabled`,
				   `rounds_num`,
				   `date_flex`,
				   `last_payment_date`,
				   `exempt_from_report`,
				   `blnRepeat`,
				   `blnNotify`,
				   `brandID`,
				   `regionID`,
				   `bookingID`,
				   `total_people`,
				   `total_rounds`,
				   `total_rooms`,
				   `currency`,
				   `status`,
				   `additional_details`,
				   ' . $intPackageId . '
			FROM `packages`
		   WHERE `id` = ' . $intPackageId;

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Duplicated';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return $this;
		}

		$intNewId = $this->mysqli->insert_id;
		$this->intId = $intNewId;
		$this->intGroupID = $intNewGroup;

		// update with md5Session
		$this->md5Session = md5($intNewId);
		$this->strQuery = "UPDATE $this->strTableName SET session_id='$this->md5Session' WHERE id=$intNewId";
		$this->short_query($this->strQuery);

		// add relationship record to group
		$this->strQuery = 'INSERT INTO `quote_group`(
				`group_id`,
				`quote_id`
			) VALUES (
				' . $intNewGroup . ',
				' . $intNewId . '
			)';

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Quote Group Relationship made';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return $this;
		}

		// duplicate child data
		// quote_brand
		$this->strQuery = 'INSERT INTO `quote_brand`(
				`brand_id`,
				`quote_id`
			)
			SELECT `brand_id`,
				   ' . $intNewId . '
			FROM `package_brand`
		   WHERE `package_id` = ' . $intPackageId;

	    if($blnDebug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Brand Record Duplicated';
	    }else{
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
			return $this;
		}

		//Copy booking people
		$strSql = "INSERT INTO quote_booking_people (quote_id, booking_people_id, primary_contact, contact, bcc)
	 				(SELECT ".$intNewId.", booking_people_id, primary_contact, contact, bcc FROM package_booking_people WHERE package_id = ".$intPackageId.")";

	 	$this->short_query($strSql);

		// don't duplicate quote_mini_notes
		QuoteCourses::convertFromPackageId($intNewId, $intPackageId, $blnDebug);
		Quotehotels::convertFromPackageId($intNewId, $intPackageId, $blnDebug);

		return $this;
	}


	public static function getCompletedStatusById($intCompletedStatus, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT * FROM order_status WHERE id = ' . $intCompletedStatus;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		if(empty($arrResults)){
			return null;
		}

		return $arrResults[0];
	}

	public static function updateEditDateById($intQuoteId){
		$objQuote = new static;

		$objQuote->strQuery = "UPDATE quotes SET edit_date = '" . date('Y-m-d G:i:s') . "' WHERE id = " . $intQuoteId;

		if($objQuote->short_query($objQuote->strQuery)) {
			return true;
		} else {
			return false;
		}
	}

    public static function copyQuoteById($intQuoteId) {
        $objQuote = new static;

        $arrQuote = $objQuote->getMysqliResults("SELECT * FROM quotes WHERE id = $intQuoteId", true);
        $arrQuote = $arrQuote[0];

        unset($arrQuote['id']);
        $arrQuote['email_read'] = 0;
        $arrQuote['user_email'] = '';
        $arrQuote['user_name'] = '';
        $arrQuote['fax'] = '';
        $arrQuote['phone'] = '';
        $arrQuote['cell_phone'] = '';
        $arrQuote['mini_content'] = '';
        $arrQuote['order_date'] = '';

        $arrQuote['address'] = '';
        $arrQuote['country'] = '';
        $arrQuote['city'] = '';
        $arrQuote['zip'] = '';
        $arrQuote['state'] = '';

        $strErrorMessage = $objQuote->mysqliinsert('quotes',array_keys($arrQuote),array_values($arrQuote),'');
        $intQuoteCopyId = $objQuote->insert_id;

        // Overwrite Session
        $objQuote->strQuery = "UPDATE quotes SET session_id='".$objQuote->md5Session = md5($intQuoteCopyId)."' WHERE id=".$intQuoteCopyId;
        $objQuote->short_query($objQuote->strQuery);

        $arrQuoteGroup = $objQuote->getMysqliResults("SELECT * FROM quote_group WHERE quote_id = $intQuoteId", true);
        $arrQuoteGroup = $arrQuoteGroup[0];

        $arrGroup = $objQuote->getMysqliResults("SELECT * FROM `groups` WHERE id = ".$arrQuoteGroup['group_id'], true);
        $arrGroup = $arrGroup[0];
        unset($arrGroup['id']);

        $objQuote->mysqliinsert('groups',array_keys($arrGroup),array_values($arrGroup),'');
        $intGroupCopyId = $objQuote->insert_id;
        $objQuote->mysqliinsert('quote_group',array('quote_id', 'group_id'), array($intQuoteCopyId, $intGroupCopyId),'');

        $arrQuoteBP = $objQuote->getMysqliResults("SELECT * FROM quote_booking_people WHERE quote_id = $intQuoteId", true);
        foreach ($arrQuoteBP as $arrQuoteBProw) {
            unset($arrQuoteBProw['id']);
            $arrQuoteBProw['quote_id'] = $intQuoteCopyId;
            $objQuote->mysqliinsert('quote_booking_people',array_keys($arrGroup),array_values($arrGroup),'');
        }

        $arrQuoteGolf = $objQuote->getMysqliResults("SELECT * FROM quote_golf WHERE quote_id = $intQuoteId", true);
        foreach ($arrQuoteGolf as $arrQuoteGolfRow) {
            unset($arrQuoteGolfRow['id']);
            $arrQuoteGolfRow['quote_id'] = $intQuoteCopyId;
            $objQuote->mysqliinsert('quote_golf',array_keys($arrQuoteGolfRow),array_values($arrQuoteGolfRow),'');
        }

        $arrQuoteH = $objQuote->getMysqliResults("SELECT * FROM quote_hotel WHERE quote_id = $intQuoteId", true);

        foreach ($arrQuoteH as $arrQuoteHRow) {
            $intOldQuoteHotelId = $arrQuoteHRow['id'];
            unset($arrQuoteHRow['id']);
            unset($arrQuoteHRow['default']);
            $arrQuoteHRow['quote_id'] = $intQuoteCopyId;

            $objQuote->mysqliinsert('quote_hotel',array_keys($arrQuoteHRow),array_values($arrQuoteHRow),'');
            $intNewQuoteHotelId = $objQuote->insert_id;

            $arrQuoteHD = $objQuote->getMysqliResults("SELECT * FROM quote_hotel_detail WHERE quote_hotel_id = " . $intOldQuoteHotelId);


            foreach ($arrQuoteHD as $arrQuoteHDRow) {
                unset($arrQuoteHDRow['id']);
                $arrQuoteHDRow['quote_hotel_id'] = $intNewQuoteHotelId;
                $objQuote->mysqliinsert('quote_hotel_detail',array_keys($arrQuoteHDRow),array_values($arrQuoteHDRow),'');
            }

        }

        return $intGroupCopyId;
    }
}



?>