<?php


class Profile extends Database  {

	public $strQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $intUserID;



	public function __construct($userID) {

		parent::__construct();
		$this->intUserID = $userID;
		$this->strErrorMessage = "";
		$this->strTableName = 'admins';
		//$this->strTableSlug = $strPageId;

		//page not found
		$this->strTitle = 'Profile';

		

	}

	public function getDetail() {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		From $this->strTableName
		WHERE userID=$this->intUserID
		LIMIT 0,1";

		// Util::debugDisplay($this->strQuery);

		if($this->query($this->strQuery)) {
	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0];

	     	$this->strUserAlias = isset($result['user_alias']) ? $result['user_alias'] : '';
			$this->strUserEmail = isset($result['user_email']) ? $result['user_email'] : '';
			$this->strUserPassword = isset($result['user_password']) ? $result['user_password'] : '';
			$this->strNewPassword = isset($result['new_password']) ? $result['new_password'] : '';
			$this->strNewPassword2 = isset($result['new_password2']) ? $result['new_password2'] : '';

			return $result;



	    } else {
	     	return null;
	    }
	}


	public function handlePost($post,$id) {
		$this->intUserID = $id;
		$this->strUserAlias = isset($post['user_alias']) ? $post['user_alias'] : '';
		$this->strUserEmail = isset($post['user_email']) ? $post['user_email'] : '';
		$this->strUserPassword = isset($post['user_password']) ? $post['user_password'] : '';
		$this->strNewPassword = isset($post['new_password']) ? $post['new_password'] : '';
		$this->strNewPassword2 = isset($post['new_password2']) ? $post['new_password2'] : '';

		// Update our session
		if (!empty($this->strUserAlias)) {
			$_SESSION['user_alias'] = $this->strUserAlias;
		}

		if (!empty($this->strNewPassword)) {

			// Password Validations
			if ($this->strNewPassword !== $this->strNewPassword2) {
				$this->strErrorMessage .= 'Your passwords do not match.<br />';
			} else if (strlen($this->strNewPassword) < 5) {
				$this->strErrorMessage .= 'Your password is too short, must be atleast 5 characters<br />';
			} else {
				// Hash our string
				$hash = Util::bcryptString($this->strNewPassword);
				// Set our new password
				$this->strUserPassword = $hash;
			}

		}

		if($this->strErrorMessage == '') {
			$keys = array(
				'user_alias',
				'user_email',
				'user_password'
			);
			$vals = array(
				$this->strUserAlias,
				$this->strUserEmail,
				$this->strUserPassword
            );
			$types = array('sss');

			$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$id,'userID');
			$this->strSuccessMessage = 'Settings Saved';

        } //error message check

        return $this->intUserID;

	}


}