<?php


class Packagecourses extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;

	public $strTitle;
	public $intCourseId;
	public $intID;

	public $strTeeDate;
	public $strTeeTime;
	public $strTeeAMPM;
	public $strCarts;
	public $strRangeBall;
	public $strGolferNum;
	//public $strTrackCode;
	//public $strNetRate;
	public $strConfirmNum;
	public $strShuttle;
	public $strNotes;
	public $strPublicNotes;
	public $strTeeTimesEmailText;
	public $intRate;

	public function __construct() {

		parent::__construct();
		$this->intRelCourseID = isset($_REQUEST['rel_id']) ? $_REQUEST['rel_id'] : ''; //this is the index of the relationship record between the package and course
		$this->strErrorMessage = "";
		$this->strTableName = 'package_golf';
		$this->strTableSlug = 'package_golf';
		$this->strAdminSlug = '/admin/package/';

		$this->strTitle = 'Package Courses';


	}





	public function handlePost($post,$id, $debug = false) {
		$this->intID = $id;

		$this->intCourseId = isset($post['course_id']) ? $post['course_id'] : '';
		$this->strTeeDate = isset($post['tee_date']) ? $post['tee_date'] : '';
		$this->strTeeTime = isset($post['tee_time']) ? $post['tee_time'] : '';
		$this->strTeeAMPM = isset($post['tee_ap']) ? $post['tee_ap'] : '';
		$this->strCarts = isset($post['carts']) ? $post['carts'] : '';
		$this->strShuttle = isset($post['shuttle']) ? $post['shuttle'] : '';
		$this->strRangeBall = isset($post['range_ball']) ? $post['range_ball'] : '';
		$this->strGolferNum = isset($post['golfer_num']) ? $post['golfer_num'] : '';
		//$this->strTrackCode = isset($post['track_code']) ? $post['track_code'] : '';
		//$this->strNetRate = isset($post['net_rate']) ? $post['net_rate'] : '';
		$this->strConfirmNum = isset($post['confirm_num']) ? $post['confirm_num'] : '';
		$this->strNotes = isset($post['notes']) ? $post['notes'] : '';
		$this->strPublicNotes = isset($post['public_notes']) ? $post['public_notes'] : '';
		$this->strTeeTimesEmailText = isset($post['course_teetimes_update_email']) ? $post['course_teetimes_update_email'] : '';
		$this->intRate = isset($post['rate']) ? $post['rate'] : '';

		if($this->intCourseId == '') { $this->strErrorMessage .= "Please choode a course.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array(
				'package_id',
				'course_id',
				'tee_date',
				'tee_time',
				'tee_ap',
				'carts',
				'shuttle',
				'range_ball',
				'golfer_num',
				'confirm_num',
				'notes',
				'public_notes',
				'course_teetimes_update_email',
				'rate'
			);
			$vals = array(
				$this->intID,
				$this->intCourseId,
				$this->strTeeDate,
				$this->strTeeTime,
				$this->strTeeAMPM,
				$this->strCarts,
				$this->strShuttle,
				$this->strRangeBall,
				$this->strGolferNum,
				$this->strConfirmNum,
				$this->strNotes,
				$this->strPublicNotes,
				$this->strTeeTimesEmailText,
				$this->intRate
			);
			//$types = array('iissssssssss');

			if($this->intRelCourseID == '') {

                if (!is_array($this->intCourseId)) {
                    $arrCourseIds = array($this->intCourseId);
                } else {
                    $arrCourseIds = $this->intCourseId;
                }

                foreach ($arrCourseIds AS $intCourseId) {

                    $vals[1] = $intCourseId;

    				//no ability to add categories is required.
    				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
    				$this->intRelCourseID = $this->insert_id;
    				$this->strSuccessMessage = 'Record Added:'.$this->intRelCourseID;
                }


			} else {

				$this->short_query('UPDATE package_golf SET last_edit = now() WHERE id = ' . $this->intRelCourseID);

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intRelCourseID);
				$this->strSuccessMessage = 'Record Saved';

			}


        } //error message check

        return $this->intRelCourseID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.

		if(empty($id)){
			$id = $this->intRelCourseID;
		}

		$this->strQuery = "SELECT t.*
		From $this->strTableName t
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];


			$this->intCourseId = isset($result['course_id']) ? $result['course_id'] : '';
			$this->strTeeDate = isset($result['tee_date']) ? $result['tee_date'] : '';
			$this->strTeeTime = isset($result['tee_time']) ? $result['tee_time'] : '';
			$this->strTeeAMPM = isset($result['tee_ap']) ? $result['tee_ap'] : '';
			$this->strCarts = isset($result['carts']) ? $result['carts'] : '';
			$this->strShuttle = isset($result['shuttle']) ? $result['shuttle'] : '';
			$this->strRangeBall = isset($result['range_ball']) ? $result['range_ball'] : '';
			$this->strGolferNum = isset($result['golfer_num']) ? $result['golfer_num'] : '';
			//$this->strTrackCode = isset($result['track_code']) ? $result['track_code'] : '';
			//$this->strNetRate = isset($result['net_rate']) ? $result['net_rate'] : '';
			$this->strConfirmNum = isset($result['confirm_num']) ? $result['confirm_num'] : '';
			$this->strNotes = isset($result['notes']) ? $result['notes'] : '';
			$this->strPublicNotes = isset($result['public_notes']) ? $result['public_notes'] : '';
			$this->strTeeTimesEmailText = isset($result['course_teetimes_update_email']) ? $result['course_teetimes_update_email'] : '';
			$this->intRate = isset($result['rate']) ? $result['rate'] : '';

			//$result['images'] = $this->getCourseImageList($id);



	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {

		$debug = true;
		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*
	     From $this->strTableName t
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}

	public function getCourses() {
		$strQuery = "SELECT p.id,  p.type_id, p.course_name, p.address, p.comments, t.title, s.state_name, s.short_name
			FROM course p
			LEFT JOIN course_type y ON y.id = p.type_id
			LEFT JOIN city t ON t.id=p.city_id
			LEFT JOIN state s ON s.id=t.state_id
			LEFT JOIN country c ON c.id=s.country_id
			LEFT JOIN members m ON m.id=p.member_id
			WHERE p.status='Active'
			AND y.status='Active'
			AND (p.type_id='7' OR p.type_id='3')
			ORDER BY p.course_name ASC ";

		//echo '$strQuery='.$strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getTrackCodes() {
		$strQuery = "SELECT * FROM `track_code` WHERE `status`='Active' ORDER BY `name`";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}

	public function getCoursesByPackage($packageID, $debug = false) {
		$strQuery = "SELECT  course.*,
							 package_golf.*
						FROM package_golf
						JOIN course ON (package_golf.course_id = course.id) 
					   WHERE package_golf.package_id = $packageID";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }				   
	}

	public function deleteRecord($id, $debug = false) {

	    $this->strQuery = 'SELECT file_name FROM '.$this->strTableName.' WHERE id=' . $id;

		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$file_name = $res[0]['file_name'];
	     	if(file_exists(ROOT_DIR.$file_name)) {
	     		unlink(ROOT_DIR.$file_name);
	     		Util::debugDisplay('delete='.ROOT_DIR.$file_name);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$file_name='.ROOT_DIR.$file_name);
		}

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>