<?php


class Package extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $records = 1;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strSearchWord;
	public $strGroupName;
	public $strCompleted;
	public $strUserName;
	public $strUserEmail;
	public $strPhone;
	public $strFax;
	public $strCellPhone;
	public $strEmergency;
	public $strAdminNote;
	public $strAddress;
	public $intCityId;
	public $intCountryId;
	public $intStateId;
	public $strZip;
	public $strDatesArrival;
	public $strDatesDepart;
	public $strComments;

	public $intId;
	public $intBrandId;
	public $intBookingId;

	public $strAction;
	public $strPubStatus;
	public $intParentId;
	public $strSmoking;
	public $strBedshare1;
	public $strBedshare2;
	public $strBookingEmail;
	public $strCarts;
	public $strShuttle;
	public $intCouplesNum;
	public $intPlayersNum;
	public $intNgNum;
	public $arrAccommodations;
	public $arrGolfCourses;
	public $intRepeat;
	public $strMiniContent;
	public $strVoucherEmailText;
	public $strNote;
	public $md5Session;
	public $strVoucherText1;
	public $strVoucherText2;
	public $strVoucherText3;
	public $strVoucherText4;

    public $strHotelSpecialInstructions;

	public $strBrandName;
	public $intGridCompleted;
	public $strGridDateType;
	public $strStartDate;
	public $strEndDate;
	public $intYear;
	public $intMonth;
	public $strLatitude;
	public $strLongitude;
	public $strZlevel;
	public $blnNotify;
	public $blnProcessed;
    public $strDatesBooking;
	public $strOrderDate;
	public $intPrice;
	public $intTotalPeople;
	public $intTotalRooms;
	public $intTotalRounds;
	public $strCurrency;
	public $strAdditionalDetails;
	public $intQuoteId;

	public $strReminderEmail0;
	public $strReminderEmail1;
	public $strReminderEmail2;
	public $strReminderEmail3;
	public $strReminderEmail4;
	public $strReminderEmail5;
	public $strReminderEmail6;

	public $intReminderEmailDays0;
	public $intReminderEmailDays1;
	public $intReminderEmailDays2;
	public $intReminderEmailDays3;
	public $intReminderEmailDays4;
	public $intReminderEmailDays5;
	public $intReminderEmailDays6;

	public $strOnTripComments;
	public $strWhereDidYouHear;

	public $arrSelectedBookingPeople;
	public $arrSelectedBookingPeoplePrimary;
	public $arrSelectedBookingPeopleBcc;

	public $arrBookingAgent;
    public $strSlug;

	public function __construct($strPageId = '',$strAction = '') {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'packages';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/package/';

		$this->strTitle = 'Packages';

	}

	public function setStatus($stat) {
		$this->intGridCompleted = $stat;
	}

	public function setDateType($type) {
		$this->strGridDateType = $type;
	}

	public function setStartDate($date) {
		$this->strStartDate = $date;
	}

	public function setEndDate($date) {
		$this->strEndDate = $date;
	}

	public function setYear($date) {
		$this->intYear = $date;
	}

	public function setMonth($date) {
		$this->intMonth = $date;
	}


	public function handlePost($post,$id) {
		$this->intId = $id;
		$this->strGroupName = isset($post['group_name']) ? $post['group_name'] : '';
		$this->strCompleted = isset($post['completed']) ? $post['completed'] : '';
		$this->intBrandId = isset($post['brandID']) ? $post['brandID'] : '0';
		$this->strUserName = isset($post['user_name']) ? $post['user_name'] : '';
		$this->strUserEmail = isset($post['user_email']) ? $post['user_email'] : '';
		$this->strPhone = isset($post['phone']) ? $post['phone'] : '';
		$this->strFax = isset($post['fax']) ? $post['fax'] : '';
		$this->strCellPhone = isset($post['cell_phone']) ? $post['cell_phone'] : '';
		$this->strEmergency = isset($post['emergency']) ? $post['emergency'] : '';
		$this->strAdminNote = isset($post['admin_note']) ? $post['admin_note'] : '';
		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->intCityId = isset($post['city']) ? $post['city'] : '';
		$this->intCountryId = isset($post['country']) ? $post['country'] : '';
		$this->intStateId = isset($post['state']) ? $post['state'] : '';
		$this->strZip = isset($post['zip']) ? $post['zip'] : '';
		$this->intRepeat = isset($post['repeat']) ? $post['repeat'] : '';
		$this->intBookingId = isset($post['bookingID']) ? $post['bookingID'] : '';
		$this->blnNotify = isset($post['blnNotify']) ? $post['blnNotify'] : '';

		$this->strDatesArrival = isset($post['dates_arrival']) ? $post['dates_arrival'] : '';
		$this->strDatesDepart = isset($post['dates_depart']) ? $post['dates_depart'] : '';
		$this->strComments = isset($post['comments']) ? $post['comments'] : '';
		$this->strCompleted = isset($post['completed']) ? $post['completed'] : '0';
		$this->strSmoking = isset($post['smoking']) ? $post['smoking'] : '0';
		$this->strBedshare1 = isset($post['bedshare1']) ? $post['bedshare1'] : '0';
		$this->strBedshare2 = isset($post['bedshare1']) ? $post['bedshare2'] : '0';
		$this->strCarts = isset($post['carts']) ? $post['carts'] : '0';
		$this->strShuttle = isset($post['shuttle']) ? $post['shuttle'] : '0';
		$this->intCouplesNum = isset($post['couples_num']) ? $post['couples_num'] : '0';
		$this->intPlayersNum = isset($post['players_num']) ? $post['players_num'] : '0';
		$this->intNgNum = isset($post['ng_num']) ? $post['ng_num'] : '0';
		$this->blnProcessed = isset($post['blnProcessed']) ? $post['blnProcessed'] : 0;
        $this->strDatesBooking = isset($post['dates_booking']) ? $post['dates_booking'] : '';
		$this->strOrderDate = isset($post['order_date']) ? $post['order_date'] : '';
		$this->strNote = isset($post['note']) ? $post['note'] : '';
		$this->strMiniContent = isset($post['mini_content']) ? $post['mini_content'] : '';
		$this->strVoucherEmailText = isset($post['voucher_email_text']) ? $post['voucher_email_text'] : '';
		$this->strVoucherText1 = isset($post['voucher_text_1']) ? $post['voucher_text_1'] : '';
		$this->strVoucherText2 = isset($post['voucher_text_2']) ? $post['voucher_text_2'] : '';
		$this->strVoucherText3 = isset($post['voucher_text_3']) ? $post['voucher_text_3'] : '';
		$this->strVoucherText4 = isset($post['voucher_text_4']) ? $post['voucher_text_4'] : '';
		$this->strVoucherText5 = isset($post['voucher_text_5']) ? $post['voucher_text_5'] : '';
        $this->strHotelSpecialInstructions = isset($post['hotel_special_instructions']) ? $post['hotel_special_instructions'] : '';
		$this->intPrice = isset($post['price']) ? $post['price'] : 'Null';
		$this->intTotalPeople = isset($post['total_people']) ? $post['total_people'] : 0;
		$this->intTotalRooms = isset($post['total_rooms']) ? $post['total_rooms'] : 0;
		$this->intTotalRounds = isset($post['total_rounds']) ? $post['total_rounds'] : 0;
		$this->strCurrency = isset($post['currency']) ? $post['currency'] : 'CAD';
		$this->strAdditionalDetails = isset($post['additional_details']) ? $post['additional_details'] : '';
		$this->intQuoteId = isset($post['quote_id']) ? $post['quote_id'] : '';

		$this->strReminderEmail0 = isset($post['reminder_email_content_0']) ? $post['reminder_email_content_0'] : '';
		$this->strReminderEmail1 = isset($post['reminder_email_content_1']) ? $post['reminder_email_content_1'] : '';
		$this->strReminderEmail2 = isset($post['reminder_email_content_2']) ? $post['reminder_email_content_2'] : '';
		$this->strReminderEmail3 = isset($post['reminder_email_content_3']) ? $post['reminder_email_content_3'] : '';
		$this->strReminderEmail4 = isset($post['reminder_email_content_4']) ? $post['reminder_email_content_4'] : '';
		$this->strReminderEmail5 = isset($post['reminder_email_content_5']) ? $post['reminder_email_content_5'] : '';
		$this->strReminderEmail6 = isset($post['reminder_email_content_6']) ? $post['reminder_email_content_6'] : '';

		$this->intReminderEmailDays0 = ($post['reminder_email_days_0'] != '') ? $post['reminder_email_days_0'] : 40;
		$this->intReminderEmailDays1 = ($post['reminder_email_days_1'] != '') ? $post['reminder_email_days_1'] : 40;
		$this->intReminderEmailDays2 = ($post['reminder_email_days_2'] != '') ? $post['reminder_email_days_2'] : 30;
		$this->intReminderEmailDays3 = isset($post['reminder_email_days_3']) ? $post['reminder_email_days_3'] : '';
		$this->intReminderEmailDays4 = isset($post['reminder_email_days_4']) ? $post['reminder_email_days_4'] : '';
		$this->intReminderEmailDays5 = isset($post['reminder_email_days_5']) ? $post['reminder_email_days_5'] : '';
		$this->intReminderEmailDays6 = isset($post['reminder_email_days_6']) ? $post['reminder_email_days_6'] : '';

		$this->strOnTripComments = isset($post['on_trip_comments']) ? $post['on_trip_comments'] : '';
		$this->strWhereDidYouHear = isset($post['where_did_you_hear']) ? $post['where_did_you_hear'] : '';

		$this->arrSelectedBookingPeople = isset($post['booking_people_id']) ? $post['booking_people_id'] : array();
		$this->arrSelectedBookingPeopleBcc = isset($post['booking_people_bcc']) ? $post['booking_people_bcc'] : array();
		$this->intSelectedBookingPeoplePrimary = isset($post['booking_people_primary']) ? $post['booking_people_primary'] : 0;

		$arrVoucherNotes = isset($post['voucher_notes'])? $post['voucher_notes'] : array();

		if($this->strGroupName == '') { $this->strErrorMessage .= "Please enter a name for this package.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array(
				'group_name',
				'completed',
				'user_name',
				'user_email',
				'phone',
				'fax',
				'cell_phone',
				'emergency',
				'admin_note',
				'address',
				'city',
				'country',
				'state',
				'zip',
				'dates_arrival',
				'dates_depart',
				'comments',
				'smoking',
				'bedshare1',
				'bedshare2',
				'carts',
				'shuttle',
				'couples_num',
				'players_num',
				'ng_num',
				'price',
				'currency',
				'mini_content',
				'notes',
				'voucher_text_1',
				'voucher_text_2',
				'voucher_text_3',
				'voucher_text_4',
				'voucher_text_5',
                'hotel_special_instructions',
				'brandID',
				'bookingID',
				'blnRepeat',
				'blnNotify',
				'blnProcessed',
				'total_rounds',
				'total_rooms',
				'total_people',
				'dates_booking',
                'order_date',
				'additional_details',
				'voucher_email_text',
				'quote_id',
				'reminder_email_0',
				'reminder_email_1',
				'reminder_email_2',
				'reminder_email_3',
				'reminder_email_4',
				'reminder_email_5',
				'reminder_email_6',
				'reminder_email_0_days',
				'reminder_email_1_days',
				'reminder_email_2_days',
				'reminder_email_3_days',
				'reminder_email_4_days',
				'reminder_email_5_days',
				'reminder_email_6_days',
				'on_trip_comments',
				'where_did_you_hear'
			);
			$vals = array(
				$this->strGroupName,
				$this->strCompleted,
				$this->strUserName,
				$this->strUserEmail,
				$this->strPhone,
				$this->strFax,
				$this->strCellPhone,
				$this->strEmergency,
				$this->strAdminNote,
				$this->strAddress,
				$this->intCityId,
				$this->intCountryId,
				$this->intStateId,
				$this->strZip ,
				$this->strDatesArrival ,
				$this->strDatesDepart,
				$this->strComments,
				$this->strSmoking,
				$this->strBedshare1,
				$this->strBedshare2,
				$this->strCarts,
				$this->strShuttle,
				$this->intCouplesNum,
				$this->intPlayersNum,
				$this->intNgNum,
				$this->intPrice,
				$this->strCurrency,
				$this->strMiniContent,
				$this->strNote,
				$this->strVoucherText1,
				$this->strVoucherText2,
				$this->strVoucherText3,
				$this->strVoucherText4,
				$this->strVoucherText5,
                $this->strHotelSpecialInstructions,
				$this->intBrandId,
				$this->intBookingId,
				$this->intRepeat,
				$this->blnNotify,
				$this->blnProcessed,
				$this->intTotalRounds,
				$this->intTotalRooms,
				$this->intTotalPeople,
                $this->strDatesBooking,
				$this->strOrderDate,
				$this->strAdditionalDetails,
				$this->strVoucherEmailText,
				$this->intQuoteId,
				$this->strReminderEmail0,
				$this->strReminderEmail1,
				$this->strReminderEmail2,
				$this->strReminderEmail3,
				$this->strReminderEmail4,
				$this->strReminderEmail5,
				$this->strReminderEmail6,
				$this->intReminderEmailDays0,
				$this->intReminderEmailDays1,
				$this->intReminderEmailDays2,
				$this->intReminderEmailDays3,
				$this->intReminderEmailDays4,
				$this->intReminderEmailDays5,
				$this->intReminderEmailDays6,
				$this->strOnTripComments,
				$this->strWhereDidYouHear
			);

			if($this->intId == '') {

				if (($this->intBrandId != '') && (is_numeric($this->intBrandId))) {

					//Lookup the default email templates for the selected brand and use them to populate the reminder email content
					$brandEmail = $this->getMysqliResults("SELECT * FROM brands WHERE id = " . $this->intBrandId, true);
					$strDefaultReminder = '';

					for ($i=0; $i<count($keys); $i++) {
						if ($keys[$i] == 'reminder_email_1') {
							$vals[$i] = $brandEmail[0]['reminder_email_1'];
						}

						if ($keys[$i] == 'reminder_email_2') {
							$vals[$i] = $brandEmail[0]['reminder_email_2'];
						}

						if ($keys[$i] == 'reminder_email_3') {
							$vals[$i] = $brandEmail[0]['reminder_email_3'];
						}

						if ($keys[$i] == 'reminder_email_4') {
							$vals[$i] = $brandEmail[0]['reminder_email_4'];
						}

						if ($keys[$i] == 'reminder_email_5') {
							$vals[$i] = $brandEmail[0]['reminder_email_5'];
						}

						if ($keys[$i] == 'reminder_email_6') {
							$vals[$i] = $brandEmail[0]['reminder_email_6'];
						}
					}
				}

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intId = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intId;

				$this->md5Session = md5($this->intId);

			} else {

				// Update the voucher notes
				if (!empty($arrVoucherNotes)) {
					foreach ($arrVoucherNotes as $strType => $arrVouchers) {
						// Switch the database
						if ($strType == 'hotel') {
							$strDatabase = 'package_hotel';
						} else {
							$strDatabase = 'package_golf';
						}

						// Loop through and update the notes
						if (!empty($arrVouchers)) {
							foreach ($arrVouchers as $intId => $strNote) {
								$this->strErrorMessage = $this->mysqliupdate($strDatabase, array('public_notes'), array($strNote), '', $intId);
							}
						}
					}
				}

				$delSql = "DELETE FROM package_booking_people WHERE package_id = " . $this->intId;

				$this->short_query($delSql);

				$arrBookingPeople = array();

				foreach ($this->arrSelectedBookingPeople AS $intBookingPersonId) {
					$arrBookingPeople[$intBookingPersonId]['contact'] = true;
				}

				foreach ($this->arrSelectedBookingPeopleBcc AS $intBookingPersonId) {
					$arrBookingPeople[$intBookingPersonId]['bcc'] = true;
				}

				if ($this->intSelectedBookingPeoplePrimary != '') {
					$arrBookingPeople[$this->intSelectedBookingPeoplePrimary]['primary'] = true;
				}

				foreach ($arrBookingPeople As $intBookingPersonId=>$arrBookingPerson) {
					$strSql = "INSERT INTO package_booking_people (package_id, booking_people_id, primary_contact, contact, bcc)
								VALUES (".$this->intId.", ".$intBookingPersonId.", " . (isset($arrBookingPerson['primary']) ? 1 : 0) . ", " . (isset($arrBookingPerson['contact']) ? 1 : 0) . ", " . (isset($arrBookingPerson['bcc']) ? 1 : 0) . " )";

					$this->short_query($strSql);
				}

				$this->md5Session = md5($this->intId);
				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$id);
				$this->strSuccessMessage = 'Record Saved';

			}

			$this->strQuery = "UPDATE $this->strTableName SET session_id='$this->md5Session' WHERE id=$this->intId";
			$this->short_query($this->strQuery);




        } //error message check





        return $this->intId;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}
    
	public function getAgentDetail($id = '', $session = '') {

		$arrBookingAgent = array();

		if ($session != '') {
			$strSql = "SELECT id FROM packages WHERE session_id = '$session'";

			$arrResults = $this->getMysqliResults($strSql,true);

			if (count($arrResults) == 1) {
				$id = $arrResults[0]['id'];
			}

		}

		if($id != '') {

			$strSql = "SELECT booking_people_id FROM package_booking_people WHERE primary_contact = 1 and package_id = $id";

			$arrResults = $this->getMysqliResults($strSql,true);

			if (count($arrResults) == 1) {

				$intPrimaryBookingPersonId = $arrResults[0]['booking_people_id'];
				$strSql = "SELECT * FROM booking_people WHERE id = $intPrimaryBookingPersonId";

				$arrResults = $this->getMysqliResults($strSql,true);

				if (count($arrResults) == 1) {
					$arrBookingAgent = $arrResults[0];
				}
			}
		}

		return $arrBookingAgent;

	}

	public function getDetail($id = '', $session = '') {
		if($id != '' || $session != ''){
			//page specific SEO settings. These may override the default settings.
			$this->strQuery = "SELECT  r.latitude, r.longitude, r.zlevel, p.*, b2.booking_email,
			(SELECT MIN(check_in_date) FROM package_hotel WHERE package_id=p.`id`) As check_in_date,
			b.address As business_address,
			b.phone As business_phone,
            b.slug AS slug,
			b.business_name,
			b.tollfree As business_tollfree,
			b.zip As business_zip,
			b.fax As business_fax,
			b.display_image As business_logo,
			c.title As business_city,
			b.contact_email As business_email,
			b.terms As business_terms,
			b.mini_page_text As business_text,
			s.state_name As business_state,
			b.background_color,
			b.text_color,
            b.web_url as wl_url,
            b.link_fb,
            b.link_ig,
            b.link_google,
            b.link_youtube,
            b.link_enews,
			s2.status_name,
			s2.color AS status_color,
			m.id AS userID
			From $this->strTableName p
			Left Join region r on r.id=p.region_id
			LEFT join members m on m.email=p.user_email
			LEFT join order_status s2 on s2.id=p.completed
			LEFT join brands b on b.id=p.brandID
			LEFT join booking_people b2 on b2.id=p.bookingID
			LEFT join city c on c.id=b.city_id
			LEFT join state s on s.id=c.state_id ";

			if($id != ''){
				$this->strQuery .= "WHERE p.id=$id ";
			}

			if($session != ''){
				$this->strQuery .= "WHERE p.session_id='$session' ";
			}

			$this->strQuery .= "LIMIT 0,1 ";

			// echo Util::debugDisplay($this->strQuery);


			if($this->query($this->strQuery)) {

		     	if($result = $this->getMysqliResults($this->strQuery,true)) {
			     	$result = $result[0];

			     	$this->strGroupName = isset($result['group_name']) ? $result['group_name'] : '';
			     	$this->strUserName = isset($result['user_name']) ? $result['user_name'] : '';
			     	$this->strUserEmail = isset($result['user_email']) ? $result['user_email'] : '';
			     	$this->intBrandId = isset($result['brandID']) ? $result['brandID'] : '';
					$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
					$this->strFax = isset($result['fax']) ? $result['fax'] : '';
					$this->strCellPhone = isset($result['cell_phone']) ? $result['cell_phone'] : '';
					$this->strEmergency = isset($result['emergency']) ? $result['emergency'] : '';
					$this->strAdminNote = isset($result['admin_note']) ? $result['admin_note'] : '';
					$this->strAddress = isset($result['address']) ? $result['address'] : '';
					$this->intCityId = isset($result['city']) ? $result['city'] : '';
					$this->intCountryId = isset($result['country']) ? $result['country'] : '';
					$this->intStateId = isset($result['state']) ? $result['state'] : '';
					$this->strZip = isset($result['zip']) ? $result['zip'] : '';
					$this->strDatesArrival = isset($result['dates_arrival']) ? $result['dates_arrival'] : '';
					$this->strDatesDepart = isset($result['dates_depart']) ? $result['dates_depart'] : '';
					$this->strComments = isset($result['comments']) ? $result['comments'] : '';
					$this->strCompleted = isset($result['completed']) ? $result['completed'] : '';
					$this->strSmoking = isset($result['smoking']) ? $result['smoking'] : '';
					$this->strBedshare1 = isset($result['bedshare1']) ? $result['bedshare1'] : '';
					$this->strBedshare2 = isset($result['bedshare1']) ? $result['bedshare2'] : '';
					$this->strCarts = isset($result['carts']) ? $result['carts'] : '';
					$this->strShuttle = isset($result['shuttle']) ? $result['shuttle'] : '';
					$this->intCouplesNum = isset($result['couples_num']) ? $result['couples_num'] : '';
					$this->intPlayersNum = isset($result['players_num']) ? $result['players_num'] : '';
					$this->intNgNum = isset($result['ng_num']) ? $result['ng_num'] : '';
					$this->arrGolfCourses = isset($result['golfcourses']) ? $result['golfcourses'] : '';
					$this->arrAccommodations = isset($result['accommodations']) ? $result['accommodations'] : '';
					$this->intRepeat = isset($result['blnRepeat']) ? $result['blnRepeat'] : '';
					$this->strNote = isset($result['note']) ? $result['note'] : '';
					$this->strMiniContent = isset($result['mini_content']) ? $result['mini_content'] : '';
					$this->strVoucherEmailText = isset($result['voucher_email_text']) ? $result['voucher_email_text'] : '';
					$this->md5Session = isset($result['session_id']) ? $result['session_id'] : '';
					$this->strVoucherText1 = isset($result['voucher_text_1']) ? $result['voucher_text_1'] : '';
					$this->strVoucherText2 = isset($result['voucher_text_2']) ? $result['voucher_text_2'] : '';
					$this->strVoucherText3 = isset($result['voucher_text_3']) ? $result['voucher_text_3'] : '';
					$this->strVoucherText4 = isset($result['voucher_text_4']) ? $result['voucher_text_4'] : '';
					$this->strVoucherText5 = isset($result['voucher_text_5']) ? $result['voucher_text_5'] : '';
                    $this->strHotelSpecialInstructions = isset($result['hotel_special_instructions']) ? $result['hotel_special_instructions'] : '';
					$this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
					$this->strBrandLogo = isset($result['business_logo']) ? $result['business_logo'] : '';
					$this->strBusinessTollFree = isset($result['business_tollfree']) ? $result['business_tollfree'] : '';
					$this->strBusinessCity = isset($result['business_city']) ? $result['business_city'] : '';
					$this->strBusinessPhone = isset($result['business_phone']) ? $result['business_phone'] : '';
					$this->strBusinessAddress = isset($result['business_address']) ? $result['business_address'] : '';
					$this->strBusinessProv  = isset($result['business_state']) ? $result['business_state'] : '';
					$this->strBusinessFax    = isset($result['business_fax']) ? $result['business_fax'] : '';
					$this->strBusinessZip    = isset($result['business_zip']) ? $result['business_zip'] : '';
					$this->strBusinessEmail    = isset($result['business_email']) ? $result['business_email'] : '';
					$this->strTerms = isset($result['business_terms']) ? $result['business_terms'] : '';
					$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
					$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
					$this->strZlevel = isset($result['zlevel']) ? $result['zlevel'] : '';
					$this->intBookingId = isset($result['bookingID']) ? $result['bookingID'] : '';
					$this->strBookingEmail = isset($result['booking_email']) ? $result['booking_email'] : '';
					$this->blnNotify = isset($result['blnNotify']) ? $result['blnNotify'] : 0;
					$this->blnProcessed = isset($result['blnProcessed']) ? $result['blnProcessed'] : 0;
                    $this->strDatesBooking = isset($result['dates_booking']) ? $result['dates_booking'] : '';
					$this->strOrderDate = isset($result['order_date']) ? $result['order_date'] : '';
					$this->intPrice = isset($result['price']) ? $result['price'] : '';
					$this->intTotalPeople = isset($result['total_people']) ? $result['total_people'] : 0;
					$this->intTotalRooms = isset($result['total_rooms']) ? $result['total_rooms'] : 0;
					$this->intTotalRounds = isset($result['total_rounds']) ? $result['total_rounds'] : 0;
			     	$this->intId = $result['id'];
			     	$this->strCurrency = isset($result['currency']) ? $result['currency'] : 'CAD';
			     	$this->strAdditionalDetails = isset($result['additional_details']) ? $result['additional_details'] : '';
			     	$this->intQuoteId = isset($result['quote_id']) ? $result['quote_id'] : '';

			     	$this->strReminderEmail0 = isset($result['reminder_email_0']) ? $result['reminder_email_0'] : '';
			     	$this->strReminderEmail1 = isset($result['reminder_email_1']) ? $result['reminder_email_1'] : '';
					$this->strReminderEmail2 = isset($result['reminder_email_2']) ? $result['reminder_email_2'] : '';
					$this->strReminderEmail3 = isset($result['reminder_email_3']) ? $result['reminder_email_3'] : '';
					$this->strReminderEmail4 = isset($result['reminder_email_4']) ? $result['reminder_email_4'] : '';
					$this->strReminderEmail5 = isset($result['reminder_email_5']) ? $result['reminder_email_5'] : '';
					$this->strReminderEmail6 = isset($result['reminder_email_6']) ? $result['reminder_email_6'] : '';

					$this->intReminderEmailDays0 = isset($result['reminder_email_0_days']) ? $result['reminder_email_0_days'] : '';
					$this->intReminderEmailDays1 = isset($result['reminder_email_1_days']) ? $result['reminder_email_1_days'] : '';
					$this->intReminderEmailDays2 = isset($result['reminder_email_2_days']) ? $result['reminder_email_2_days'] : '';
					$this->intReminderEmailDays3 = isset($result['reminder_email_3_days']) ? $result['reminder_email_3_days'] : '';
					$this->intReminderEmailDays4 = isset($result['reminder_email_4_days']) ? $result['reminder_email_4_days'] : '';
					$this->intReminderEmailDays5 = isset($result['reminder_email_5_days']) ? $result['reminder_email_5_days'] : '';
					$this->intReminderEmailDays6 = isset($result['reminder_email_6_days']) ? $result['reminder_email_6_days'] : '';

					$this->arrBookingAgent = $this->getAgentDetail($id, $session);

					$this->strQuery = "SELECT
											pg.id AS pgid,
											pg.course_id,
											p.group_name,
											p.user_name,
											g.*,
                                            g.comments AS description,
											c.title,
                                            c.title AS city,
											s.short_name,
											pg.course_id,
											pg.tee_date,
											pg.tee_time,
											pg.tee_day,
											pg.tee_ap,
											pg.carts,
											pg.range_ball,
											pg.shuttle,
											pg.rental_club,
											pg.confirm_num,
											pg.golfer_num,
											pg.notes,
											pg.public_notes,
											coalesce((SELECT file_name FROM course_img WHERE course_id=pg.course_id AND blnPrimary=1),display_image) As course_image
										FROM
											package_golf pg
											LEFT JOIN packages p On pg.package_id=p.id
											LEFT JOIN course g On  pg.course_id=g.id
											LEFT JOIN  city c On g.city_id=c.id
											LEFT JOIN  state s On c.state_id=s.id
										WHERE
											pg.package_id=".$this->intId."
											order by pg.tee_date asc";

					// echo Util::debugDisplay($this->strQuery);

					$this->arrCourseVouchers = Null;

					if($this->query($this->strQuery)) {
			     		$result2 = $this->getMysqliResults($this->strQuery,true);
			     		if(count($result2) > 0) {

			     			// Add another value called id since we renamed the original id
			     			foreach ($result2 as &$arrValue) {
			     				$arrValue['id'] = $arrValue['pgid'];
			     			}

			     			$this->arrCourseVouchers = $result2;
			     		}
			     	}

			     	$this->strQuery = "SELECT
			     							ph.id As phid,
			     							ph.hotel_id,
			     							p.group_name,
			     							p.user_name,
			     							h.*,
			     							c.title,
                                            c.title AS city,
			     							s.short_name,
			     							ph.hotel_id,
			     							ph.check_in_date,
			     							ph.check_out_date,
			     							ph.confirm_num,
			     							ph.nights,
			     							ph.notes,
			     							ph.public_notes,
			     							coalesce((SELECT file_name FROM hotel_img WHERE hotel_id=ph.hotel_id AND blnPrimary=1),file_name) As hotel_image,
			     							ph.golfers,
			     							ph.non_golfers,
			     							ph.rooms,
			     							ph.guests_name,
			     							ph.`default`,
			     							ph.last_edit
			     						FROM
			     							package_hotel ph
									     	LEFT JOIN packages p ON ph.package_id=p.id
											LEFT JOIN hotel h ON  ph.hotel_id=h.id
											LEFT JOIN city c ON h.city_id=c.id
											LEFT JOIN state s ON c.state_id=s.id
			     						WHERE
			     							ph.package_id='".$this->intId."'
			     						ORDER BY ph.check_in_date asc";

			     	// echo Util::debugDisplay($this->strQuery);

			     	$this->arrHotelVouchers = Null;

					if($this->query($this->strQuery)) {
			     		$result2 = $this->getMysqliResults($this->strQuery,true);
			     		if(count($result2) > 0) {
			     			$this->arrHotelVouchers = $result2;
			     		}
			     	}

			     	$strQuery = "SELECT booking_people_id FROM package_booking_people WHERE package_id=$id";
					if($this->query($strQuery)) {
				     	if($res = $this->getMysqliResults($strQuery,true)){
				     		//$this->arrSelectedCourses = $res;

				     		foreach($res As $r) {
				     			$this->arrSelectedBookingPeople[] = $r['booking_people_id'];
				     		}
				     	}
				     }

				    $result['booking_agent'] = $this->arrBookingAgent;

			     	return $result;

		    	}

		    }

			return null;


		}

	}

    public function getPrimaryPackageHotelDetail($package_id, $debug = false) {
        $this->strQuery = "
            SELECT * FROM package_hotel WHERE package_id = '$package_id' AND `default` = 1
        ";

        if($debug) {
            Util::debugDisplay($this->strQuery);
        }

        if($this->query($this->strQuery)) {
            $result = $this->getMysqliResults($this->strQuery,true);
            if (count($result) == 1) {
                return $this->getPackageHotelDetail($result[0]['id']);
            }
        }
        return false;
    }

	public function getPackageHotelDetail($package_hotel_id, $debug = false) {


		$this->strQuery ="SELECT *
			FROM package_hotel_detail
			where package_hotel_id='$package_hotel_id'
			order by CHAR_LENGTH(room_num) ASC, room_num asc, people_num ASC";

		if($debug){

			Util::debugDisplay($this->strQuery);
		}


		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result;

		}

	}

	public function getPackageHotelImages($hotel_id) {


		$this->strQuery ="SELECT *
			FROM hotel_img
			where hotel_id='$hotel_id'
			AND status='Active'
			order by blnPrimary DESC, display_order asc
			LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result[0];

		}

	}

	public function getPackageCourseImages($course_id) {


		$this->strQuery ="SELECT *
			FROM course_img
			where course_id='$course_id'
			AND status='Active'
			order by blnPrimary DESC, display_order asc
			LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
			return $result[0];

		}

	}

	public function getClientNameForPackage($package_id) {

		$this->strQuery = "SELECT user_name
		From $this->strTableName
		WHERE id=$package_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0]['user_name'];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getSessionForPackage($package_id) {

		$this->strQuery = "SELECT session_id
		From $this->strTableName
		WHERE id=$package_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0]['session_id'];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

	public function getBookingPeople($id, $debug = false) {

		$strQuery = "SELECT id, booking_name, booking_email,
		(SELECT count(booking_people_id) FROM package_booking_people WHERE package_id=$id AND booking_people_id=h.id and contact=1) As blnContact,
		(SELECT count(booking_people_id) FROM package_booking_people WHERE package_id=$id AND booking_people_id=h.id and bcc=1) As blnBCC,
		(SELECT count(booking_people_id) FROM package_booking_people WHERE package_id=$id AND booking_people_id=h.id and primary_contact=1) As blnPrimary
		from booking_people h
		WHERE status='Active'
		ORDER BY booking_name";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getHotelDetailsForPackage($package_id) {

		$this->strQuery = "SELECT p.`group_name`
		From $this->strTableName p
		WHERE p.`id`=$package_id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0];
	     	return $result;

	    } else {
	     	return null;
	    }
	}

    public static function getGroupName($intPackageId, $blnDebug = false){
        $objModel = new static;

        $objModel->strQuery = 'SELECT p.group_name FROM packages p WHERE p.id = ' . $intPackageId;

        if($blnDebug) {
            Util::debugDisplay($objModel->strQuery);
        }

        $arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

        return $arrResults[0]['group_name'];
    }

	public function getEmailsForPackage($package_id) {
/*
		$this->strQuery = "SELECT b.contact_email, p.user_email, p.user_name, b.contact_email2, b.id AS 'brand_id'
		From $this->strTableName p
		LEFT join brands b on b.id=p.brandID
		WHERE p.id=$package_id
		LIMIT 0,1";
		*/

		$this->strQuery = "SELECT
								booking_people.booking_name,
							    booking_people.booking_email,
							    packages.user_email,
							    packages.brandID,
							    package_booking_people.primary_contact,
							    package_booking_people.contact,
							    package_booking_people.bcc
							 FROM booking_people
								JOIN package_booking_people ON (booking_people.id = package_booking_people.booking_people_id)
							    JOIN packages ON (package_booking_people.package_id = packages.id)
							    WHERE package_booking_people.package_id = $package_id";

		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

	     	$arrResult = $this->getMysqliResults($this->strQuery,true);
	     	//$result = $result[0];
	     	return $arrResult;

	    } else {
	     	return null;
	    }
	}

	public function getEmailsForPackageHotel($rel_id) {

		$this->strQuery = "SELECT b.contact_email, b.business_name, b.contact_email2,
		h2.frontdesk_email As hotel_email, b.mini_hotel_text, p.phone, p.cell_phone,
		p.group_name, p.user_name, h.check_in_date, h.check_out_date, h.nights, h.rooms, h.confirm_num
		From package_hotel h
		LEFT JOIN packages p on p.id=h.package_id
		LEFT join brands b on b.id=p.brandID
		LEFT JOIN hotel h2 on h2.id=h.hotel_id
		WHERE h.id=$rel_id
		LIMIT 0,1";



		//echo '<br />'.$this->strQuery;

		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);

	     	//var_dump($result);
	     	//$result = $result[0];
	     	return $result[0];

	    } else {
	     	return null;
	    }
	}

	public function getNotesForPackage($package_id) {

		$this->strQuery = "SELECT p.*, b.contact_person, pk.user_name
		From package_mini_notes p
		LEFT join packages pk on pk.id=p.package_id
		LEFT join brands b on b.id=pk.brandID
		WHERE p.package_id=$package_id";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

	     	if($result = $this->getMysqliResults($this->strQuery,true)) {
				//$result = $result[0];


	     		return $result;
	     	}

	    }

	    return null;
	}


	public function setPackageNote($packageID,$note,$direction = 1){
		$this->strQuery = "INSERT INTO package_mini_notes
		(package_id, comment, timestamp, direction)
		VALUES (".$packageID.",'".$this->mysqli->real_escape_string ($note)."', '".Date('Y-m-d')."',".$direction." ) ";

		$this->short_query($this->strQuery);
	}

    public function sendPackageNoteAlert($packageID, $strNote, $intDirection = 1) {
        // Get the contact details
        //$arrContactInfo = $this->getEmailsForPackage($packageID);

        $strAdminEmail = 'ross@bcgolfguide.com';
        $intBrandId = 18;
        $strUserEmail = '';
        $arrCC = array();
        $arrBCC = array();

        $arrAgents =  $this->getEmailsForPackage($packageID);

		// Determine Primary Contact
		foreach ($arrAgents as $arrAgent) {

			$strUserEmail = $arrAgent['user_email'];
			$intBrandId = $arrAgent['brandID'];

			if ($arrAgent['primary_contact'] == '1') {
				$strAdminEmail = $arrAgent['booking_email'];
			}
		}

        $sentUser = false;

		// Send Emails
		foreach ($arrAgents as $arrAgent) {

        	//Outgoing to user
        	if ($intDirection == 1) {
        		//$strTo = $strUserEmail;

        		$strHeaders = 'From: ' . $strAdminEmail . "\r\n"
                    . 'Reply-To: ' . $strAdminEmail . "\r\n"
                    . 'X-Mailer: PHP/' . phpversion();

		        $strSubject = 'New BCgolfguide.com Message';
		        $strMessage = 'New BCgolfguide.com Message';

		        $strMessage .= ':' . "\r\n\r\n" . $strNote;

		        // Only send to user once
		        if (!$sentUser) {
		        	Util::sendMailCore($strUserEmail, $strSubject, $strMessage, $strHeaders);
		        	$sentUser = true;
		        }

		        Util::sendMailCore($arrAgent['booking_email'], $strSubject, $strMessage, $strHeaders);

		    }

		    //Incoming to Selected Contacts
	        if ($intDirection == 0) {

	        	$strHeaders = 'From: ' . $strUserEmail . "\r\n"
                    . 'Reply-To: ' . $strUserEmail . "\r\n"
                    . 'X-Mailer: PHP/' . phpversion();

	            // Add the group name for admin emails
	            $strSubject = ' from package "' . static::getGroupName($packageID) . '"';
	            $strMessage = ' from package "' . static::getGroupName($packageID) . '":' . "\r\n\r\n" . $strNote;

	            Util::sendMailCore($arrAgent['booking_email'], $strSubject, $strMessage, $strHeaders);

	        }
		}
    }

	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);
		$subquery = "";
		$join = "";
		$extra = "COALESCE((SELECT min(check_in_date) FROM package_hotel WHERE package_id=t.id),'--') As check_in_date ";

		if ($this->strGridDateType != '') {

			if(isset($this->intMonth) && $this->intMonth != "") {
				$searchStart = $this->intYear . "-" . $this->intMonth . "-01";
                $strEnd = '-31';
                if (in_array($this->intMonth, array(4, 6, 9, 11))) {
                    $strEnd = '-30';
                }
                if ($this->intMonth == 2) {
                    $strEnd = '-28';
                }
                $searchEnd = $this->intYear . "-" . $this->intMonth . $strEnd;
			} else {
				$searchStart = $this->intYear . "-01-01";
				$searchEnd = $this->intYear . "-12-31";
			}

	    	switch($this->strGridDateType) {
	    		case 'dates_arrival':
	    			$subquery = " and (h.check_in_date>='$searchStart' and h.check_in_date <='$searchEnd')";
	    			$join = "LEFT JOIN package_hotel h on h.package_id=t.id  ";
	    			//$extra = "check_in_date";
	    			break;
	    		case 'dates_depart':
	    			$subquery = " and (h.check_out_date>='$searchStart' and h.check_out_date <='$searchEnd')";
	    			$join = "LEFT JOIN package_hotel h on h.package_id=t.id  ";
	    			//$extra = "check_in_date";
	    			break;
	    		case 'dates_booking':
	    			$subquery = " and (dates_booking>='$searchStart' and dates_booking <='$searchEnd')";
	    			//$join = "LEFT JOIN package_hotel h on h.package_id=t.id  ";
	    			//$extra = "check_in_date";
	    			break;
	    		default:
	    			$subquery = " and (t.$this->strGridDateType>='$searchStart' and t.$this->strGridDateType <='$searchEnd')";
	    			$extra = "(SELECT check_in_date FROM package_hotel WHERE package_id=t.id AND `default`=1) As check_in_date ";
        			break;
	    	}

        }


		$this->strQuery1 = "SELECT count(DISTINCT t.`id`) as records
	    FROM $this->strTableName t
	    $join
	    LEFT join order_status s on s.id=t.completed
	    WHERE 1 ";


	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND lower(t.status)='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (s.status_name like '%" . $this->getCleanVar($searchWord) . "%' OR group_name like '%" . $this->getCleanVar($searchWord) . "%' OR user_name like '%" . $this->getCleanVar($searchWord) . "%' )";
	    }

	    if($this->intGridCompleted != ''){
	    	$this->strQuery1 .= "AND (t.completed = '$this->intGridCompleted' )";
	    }

	    $this->strQuery1 .=$subquery;

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($this->records/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	    $this->strQuery = "SELECT DISTINCT t.*, b.business_name, p.booking_name, s.status_name, s.color AS status_color,
	    (SELECT count(id) FROM package_hotel_detail WHERE package_hotel_id = (SELECT id FROM package_hotel WHERE package_id=t.id AND `default`=1) and final_price != 0) as golfer_unpaid,
		(SELECT count(id) FROM package_hotel_detail WHERE package_hotel_id = (SELECT id FROM package_hotel WHERE package_id=t.id AND `default`=1)) as golfer_num,
        (SELECT SUM(package_price) FROM package_hotel_detail WHERE package_hotel_id = (SELECT id from package_hotel WHERE package_id=t.id AND `default`=1)) as package_total,
        (SELECT SUM(deposit_price) FROM package_hotel_detail WHERE package_hotel_id = (SELECT id from package_hotel WHERE package_id=t.id AND `default`=1)) as package_paid,
	    $extra
	     FROM $this->strTableName t
	     LEFT JOIN brands b on b.id = t.brandID
	     LEFT JOIN booking_people p on p.id = t.bookingID
	     LEFT JOIN order_status s on s.id=t.completed
         LEFT JOIN package_hotel_detail phd on phd.package_hotel_id = t.id
	     $join
	     WHERE 1 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND lower(t.status)='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (s.status_name like '%" . $this->getCleanVar($searchWord) . "%' OR group_name like '%" . $this->getCleanVar($searchWord) . "%' OR user_name like '%" . $this->getCleanVar($searchWord) . "%' )";
		 }

		 if($this->intGridCompleted != ''){
	    	$this->strQuery .= "AND (t.completed = '$this->intGridCompleted' )";
	     }


	     $this->strQuery .= $subquery;

        $this->strQuery .= " GROUP BY t.id";

		 if($sortBy != '') {
		 		$this->strQuery .= " ORDER BY $sortBy $sortOrder ";
		 }

	     $this->strQuery .= " LIMIT $start,$this->pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getStatus() {
		$strQuery = "SELECT * FROM order_status ORDER BY status_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function updateCompleted($packageID,$stat) {
		$this->strQuery = "UPDATE packages SET completed=$stat WHERE id=$packageID";

		if($this->short_query($this->strQuery)) {
			echo 'Record Saved ';
		} else {
			echo 'SQL error:'.$this->strQuery;
		}
	}

	public function getBooking() {
		$strQuery = "SELECT * FROM booking_people ORDER BY booking_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getBrands() {
		$strQuery = "SELECT * FROM brands ORDER BY business_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getHotels() {
		$strQuery = "SELECT * FROM hotel WHERE status='Active' ORDER BY hotel_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getHotelsNotUsed($strPackageId) {
		$strQuery = "SELECT h.*
					   FROM hotel h
					  WHERE h.status='Active'
						AND h.id NOT IN (
				    		SELECT ph.hotel_id
							  FROM package_hotel ph
							 WHERE ph.package_id = $strPackageId
							)
					  ORDER BY h.hotel_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getCourses() {
		$strQuery = "SELECT p.id,  p.type_id, p.course_name, p.address, p.comments, t.title, s.state_name, s.short_name
			FROM course p
			LEFT JOIN course_type y ON y.id = p.type_id
			LEFT JOIN city t ON t.id=p.city_id
			LEFT JOIN state s ON s.id=t.state_id
			LEFT JOIN country c ON c.id=s.country_id
			LEFT JOIN members m ON m.id=p.member_id
			WHERE p.status='Active'
			AND y.status='Active'
			AND m.confirmed=1
			AND m.approved=1
			AND (p.type_id='7' OR p.type_id='3')
			ORDER BY p.course_name ASC ";

		//echo '$strQuery='.$strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getCoursesForPackage($packageID) {

		$strQuery = "SELECT p.*,
					c.course_name, c.teetimes_phone, c.teetimes_email, c.contact_phone, c.contact_email, c.booking_url, c.booking_password, c.booking_username
		FROM package_golf p
		LEFT JOIN course c on c.id=p.course_id
		WHERE package_id=".$packageID." ORDER BY tee_date ASC";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function getHotelsForPackage($packageID) {

		$strQuery = "SELECT p.*, h.hotel_name, h.contact_phone, h.frontdesk_email, h.booking_url, h.booking_password, h.booking_username
		FROM package_hotel p
		LEFT JOIN hotel h on h.id=p.hotel_id
		WHERE package_id=".$packageID." ORDER BY check_in_date ASC";

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

	public function savePaidStatus($newval,$type,$Index) {

		if($type == 'course') {
	   		$this->strQuery = 'Update package_golf Set paidout='.$newval.' Where id='.$Index;

	   	} elseif ($type == 'hotel') {
	   		$this->strQuery = 'Update package_hotel Set paidout='.$newval.' Where id='.$Index;

	   	}

		if($this->short_query($this->strQuery)) {
			return 'Record Saved';
		} else {
			return 'SQL error: '.$this->strQuery;
		}

	}


	public function topdf($filename, $options = "") {

		putenv("HTMLDOC_NOCGI=1");
		# Run HTMLDOC to provide the PDF file to the user...
	    passthru("/usr/bin/htmldoc -t pdf  --jpeg=100 --webpage $options '$filename'");
	}

}



?>