<?php


class Member extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strFirstName;
	public $strLastName;
	public $strccFirstName;
	public $strccLastName;
	public $strEmail;
	public $strPhone;
	public $strTitle;
	public $intCountryId = 261;
	public $intStateId = 2;
	public $intCityId = 6345;
	public $strCountryName = "CA";
	public $strStateName = "BC";
	public $strCityName = "Kelowna";
	public $intID;
	public $strAction;
	public $strAddress;
	public $strPostalCode ;
	public $strCell ;
	public $strFax ;
	public $strProvider;
	public $strEnableTxt;
	public $strCcCvv;
	public $strCcNumber;
    public $strCcNumber1;
    public $strCcNumber2;
    public $strCcNumber3;
    public $strCcNumber4;
	public $strCcExpMonth;
	public $strCcExpYear;

	public function __construct($strPageId = '',$strAction = '') {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'members';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/member/';

		$this->strTitle = 'Members';



	}


	public function handlePost($post,$id) {
		$this->intID = $id;
		$this->strFirstName = isset($post['first_name']) ? trim($post['first_name']) : '';
		$this->strLastName = isset($post['last_name']) ? trim($post['last_name']) : '';
		$this->strEmail = isset($post['email']) ? $post['email'] : '';
		$this->strPhone = isset($post['phone']) ? $post['phone'] : '';
		$this->strCell = isset($post['cell']) ? $post['cell'] : '';
		$this->strFax = isset($post['fax']) ? $post['fax'] : '';
		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->strPostalCode = isset($post['postal_code']) ? $post['postal_code'] : '';
		$this->intCityId = isset($post['city']) ? $post['city'] : '';
		$this->intCountryId = isset($post['country']) ? $post['country'] : '';
		$this->intStateId = isset($post['state']) ? $post['state'] : '';
		$this->strProvider = isset($post['provider']) ? $post['provider'] : '';

		if($this->strFirstName == '') { $this->strErrorMessage .= "Please enter a first name for this person.<br />"; }
		if($this->strLastName == '') { $this->strErrorMessage .= "Please enter a last name for this person.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array('first_name','last_name','email','phone','city_id','cell','postal_code','address','fax','provider');
			$vals = array( $this->strFirstName,$this->strLastName,
				$this->strEmail,$this->strPhone,$this->intCityId,$this->strCell,
				$this->strPostalCode,$this->strAddress,$this->strFax,$this->strProvider);
			$types = array('ssssssssss');

			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,$types);
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}



        } //error message check

        return $this->intID;

	}
	
	public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function validatePaymentPost($post){
		// clear any previous error messages
		$this->strErrorMessage = null;
		$this->arrErrorFields = array();

		// contact info
		if(!isset($post['first_name']) || empty($post['first_name'])){
			$this->strErrorMessage .= "Please enter a first name.<br />";
			$this->arrErrorFields[] = 'first_name';
		}

		if(!isset($post['last_name']) || empty($post['last_name'])){
			$this->strErrorMessage .= "Please enter a last name.<br />";
			$this->arrErrorFields[] = 'last_name';
		}

		if(!isset($post['email']) || empty($post['email'])){
			$this->strErrorMessage .= "Please enter an email address.<br />";
			$this->arrErrorFields[] = 'email';
		}

		if(!isset($post['phone']) || empty($post['phone'])){
			$this->strErrorMessage .= "Please enter a phone number.<br />";
			$this->arrErrorFields[] = 'phone';
		}

		if(!isset($post['address']) || empty($post['address'])){
			$this->strErrorMessage .= "Please enter an address.<br />";
			$this->arrErrorFields[] = 'address';
		}

		if(!isset($post['country']) || empty($post['country'])){
			$this->strErrorMessage .= "Please select a country.<br />";
			$this->arrErrorFields[] = 'country';
		}

		if(!isset($post['state']) || empty($post['state'])){
			$this->strErrorMessage .= "Please select a province.<br />";
			$this->arrErrorFields[] = 'state';
		}

		if(!isset($post['city']) || empty($post['city'])){
			$this->strErrorMessage .= "Please select a city.<br />";
			$this->arrErrorFields[] = 'city';
		}

		if(!isset($post['postal_code']) || empty($post['postal_code'])){
			$this->strErrorMessage .= "Please enter a postal code.<br />";
			$this->arrErrorFields[] = 'postal_code';
		}

		// credit card info
		if(!isset($post['cc_first_name']) || empty($post['cc_first_name'])){
			$this->strErrorMessage .= "Please enter the first name on the credit card.<br />";
			$this->arrErrorFields[] = 'cc_first_name';
		}

		if(!isset($post['cc_last_name']) || empty($post['cc_last_name'])){
			$this->strErrorMessage .= "Please enter the last name on the credit card.<br />";
			$this->arrErrorFields[] = 'cc_last_name';
		}

		if(!isset($post['cc_number1']) || empty($post['cc_number1'])){
			$this->strErrorMessage .= "Please enter the credit card number.<br />";
			$this->arrErrorFields[] = 'cc_number1';
		}

        if(!isset($post['cc_number2']) || empty($post['cc_number2'])){
            $this->strErrorMessage .= "Please enter the credit card number.<br />";
            $this->arrErrorFields[] = 'cc_number2';
        }

        if(!isset($post['cc_number3']) || empty($post['cc_number3'])){
            $this->strErrorMessage .= "Please enter the credit card number.<br />";
            $this->arrErrorFields[] = 'cc_number3';
        }

        if(!isset($post['cc_number4']) || empty($post['cc_number4'])){
            $this->strErrorMessage .= "Please enter the credit card number.<br />";
            $this->arrErrorFields[] = 'cc_number4';
        }

		if(!isset($post['cc_cvv']) || empty($post['cc_cvv'])){
			$this->strErrorMessage .= "Please enter the CVV number.<br />";
			$this->arrErrorFields[] = 'cc_cvv';
		}

		if(!isset($post['cc_exp_month']) || empty($post['cc_exp_month'])){
			$this->strErrorMessage .= "Please select the credit card expiry month.<br />";
			$this->arrErrorFields[] = 'cc_exp_month';
		}

		if(!isset($post['cc_exp_year']) || empty($post['cc_exp_year'])){
			$this->strErrorMessage .= "Please select the credit card expiry year.<br />";
			$this->arrErrorFields[] = 'cc_exp_year';
		}


		if(!empty($this->strErrorMessage)){
			// there was an issue
			$this->strSuccessMessage = null;
			return false;
		}

		// no issues
		return true;
	}

    public function validatePaymentPostMoneris($post){
        // clear any previous error messages
        $this->strErrorMessage = null;
        $this->arrErrorFields = array();

        // contact info
        if(!isset($post['first_name']) || empty($post['first_name'])){
            $this->strErrorMessage .= "Please enter a first name.<br />";
            $this->arrErrorFields[] = 'first_name';
        }

        if(!isset($post['last_name']) || empty($post['last_name'])){
            $this->strErrorMessage .= "Please enter a last name.<br />";
            $this->arrErrorFields[] = 'last_name';
        }

        if(!isset($post['email']) || empty($post['email'])){
            $this->strErrorMessage .= "Please enter an email address.<br />";
            $this->arrErrorFields[] = 'email';
        }

        if(!isset($post['phone']) || empty($post['phone'])){
            $this->strErrorMessage .= "Please enter a phone number.<br />";
            $this->arrErrorFields[] = 'phone';
        }

        if(!isset($post['address']) || empty($post['address'])){
            $this->strErrorMessage .= "Please enter an address.<br />";
            $this->arrErrorFields[] = 'address';
        }

        if(!isset($post['country']) || empty($post['country'])){
            $this->strErrorMessage .= "Please select a country.<br />";
            $this->arrErrorFields[] = 'country';
        }

        if(!isset($post['state']) || empty($post['state'])){
            $this->strErrorMessage .= "Please select a province.<br />";
            $this->arrErrorFields[] = 'state';
        }

        if(!isset($post['city']) || empty($post['city'])){
            $this->strErrorMessage .= "Please select a city.<br />";
            $this->arrErrorFields[] = 'city';
        }

        if(!isset($post['postal_code']) || empty($post['postal_code'])){
            $this->strErrorMessage .= "Please enter a postal code.<br />";
            $this->arrErrorFields[] = 'postal_code';
        }

        if(!isset($post['moneris_token']) || empty($post['moneris_token'])){
            $this->strErrorMessage .= "Error fetching Moneris Token.<br />";
            $this->arrErrorFields[] = 'moneris_token';
        }

        if(!empty($this->strErrorMessage)){
            // there was an issue
            $this->strSuccessMessage = null;
            return false;
        }

        // no issues
        return true;
    }

	public function handlePayemntPost($post,$id) {

		$this->intID = $id;
		$this->strFirstName = isset($post['first_name']) ? trim($post['first_name']) : '';
		$this->strLastName = isset($post['last_name']) ? trim($post['last_name']) : '';
		$this->strEmail = isset($post['email']) ? $post['email'] : '';
		$this->strPhone = isset($post['phone']) ? $post['phone'] : '';
		$this->strCell = isset($post['cell']) ? $post['cell'] : '';
		$this->strFax = isset($post['fax']) ? $post['fax'] : '';
		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->strPostalCode = isset($post['postal_code']) ? $post['postal_code'] : '';
		$this->intCityId = isset($post['city']) ? $post['city'] : '';
		$this->intCountryId = isset($post['country']) ? $post['country'] : '';
		$this->intStateId = isset($post['state']) ? $post['state'] : '';
		$this->strProvider = isset($post['provider']) ? $post['provider'] : '';
		$this->strEnableTxt = isset($post['enable_txt']) ? $post['enable_txt'] : '';
		$this->strccFirstName = isset($post['cc_first_name']) ? trim($post['cc_first_name']) : '';
		$this->strccLastName = isset($post['cc_last_name']) ? trim($post['cc_last_name']) : '';

        $this->strCcNumber1 = isset($post['cc_number1']) ? trim($post['cc_number1']) : '';
        $this->strCcNumber2 = isset($post['cc_number2']) ? trim($post['cc_number2']) : '';
        $this->strCcNumber3 = isset($post['cc_number3']) ? trim($post['cc_number3']) : '';
        $this->strCcNumber4 = isset($post['cc_number4']) ? trim($post['cc_number4']) : '';

        $this->strCcNumber = $this->strCcNumber1 .''. $this->strCcNumber2 .''. $this->strCcNumber3 .''. $this->strCcNumber4;

        $this->strCcCvv = isset($post['cc_cvv']) ? trim($post['cc_cvv']) : '';
		$this->strCcExpMonth = isset($post['cc_exp_month']) ? trim($post['cc_exp_month']) : '';
		$this->strCcExpYear = isset($post['cc_exp_year']) ? trim($post['cc_exp_year']) : '';

		if($this->strFirstName == '') { $this->strErrorMessage .= "Please enter a first name.<br />"; }
		if($this->strLastName == '') { $this->strErrorMessage .= "Please enter a last name.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array('first_name','last_name','email','phone','city_id','cell','postal_code','address','fax','provider','enable_txt');
			$vals = array( $this->strFirstName,$this->strLastName,
				$this->strEmail,$this->strPhone,$this->intCityId,$this->strCell,
				$this->strPostalCode,$this->strAddress,$this->strFax,$this->strProvider,$this->strEnableTxt);
			$types = array('sssssssssss');

			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,$types);
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Success! Your information has been submitted.';


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$this->intID);
				$this->strSuccessMessage = 'Success! Your information has been saved.';

			}



        } //error message check

        return $this->intID;

	}

    public function handlePayemntPostMoneris($post,$id) {

        $this->intID = $id;
        $this->strFirstName = isset($post['first_name']) ? trim($post['first_name']) : '';
        $this->strLastName = isset($post['last_name']) ? trim($post['last_name']) : '';
        $this->strEmail = isset($post['email']) ? $post['email'] : '';
        $this->strPhone = isset($post['phone']) ? $post['phone'] : '';
        $this->strCell = isset($post['cell']) ? $post['cell'] : '';
        $this->strFax = isset($post['fax']) ? $post['fax'] : '';
        $this->strAddress = isset($post['address']) ? $post['address'] : '';
        $this->strPostalCode = isset($post['postal_code']) ? $post['postal_code'] : '';
        $this->intCityId = isset($post['city']) ? $post['city'] : '';
        $this->intCountryId = isset($post['country']) ? $post['country'] : '';
        $this->intStateId = isset($post['state']) ? $post['state'] : '';
        $this->strProvider = isset($post['provider']) ? $post['provider'] : '';
        $this->strEnableTxt = isset($post['enable_txt']) ? $post['enable_txt'] : '';
        //$this->strccFirstName = isset($post['cc_first_name']) ? trim($post['cc_first_name']) : '';
        //$this->strccLastName = isset($post['cc_last_name']) ? trim($post['cc_last_name']) : '';

        //$this->strCcNumber1 = isset($post['cc_number1']) ? trim($post['cc_number1']) : '';
        //$this->strCcNumber2 = isset($post['cc_number2']) ? trim($post['cc_number2']) : '';
        //$this->strCcNumber3 = isset($post['cc_number3']) ? trim($post['cc_number3']) : '';
        //$this->strCcNumber4 = isset($post['cc_number4']) ? trim($post['cc_number4']) : '';

        //$this->strCcNumber = $this->strCcNumber1 .''. $this->strCcNumber2 .''. $this->strCcNumber3 .''. $this->strCcNumber4;

        //$this->strCcCvv = isset($post['cc_cvv']) ? trim($post['cc_cvv']) : '';
        //$this->strCcExpMonth = isset($post['cc_exp_month']) ? trim($post['cc_exp_month']) : '';
        //$this->strCcExpYear = isset($post['cc_exp_year']) ? trim($post['cc_exp_year']) : '';

        if($this->strFirstName == '') { $this->strErrorMessage .= "Please enter a first name.<br />"; }
        if($this->strLastName == '') { $this->strErrorMessage .= "Please enter a last name.<br />"; }

        if($this->strErrorMessage == '') {

            $keys = array('first_name','last_name','email','phone','city_id','cell','postal_code','address','fax','provider','enable_txt');
            $vals = array( $this->strFirstName,$this->strLastName,
                $this->strEmail,$this->strPhone,$this->intCityId,$this->strCell,
                $this->strPostalCode,$this->strAddress,$this->strFax,$this->strProvider,$this->strEnableTxt);
            $types = array('sssssssssss');

            if($this->intID == '') {

                //no ability to add categories is required.
                $this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,$types);
                $this->intID = $this->insert_id;
                $this->strSuccessMessage = 'Success! Your information has been submitted.';


            } else {

                $this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$this->intID);
                $this->strSuccessMessage = 'Success! Your information has been saved.';

            }



        } //error message check

        return $this->intID;

    }

	public function updateQuotePeopleDetail($post, $debug = false) {
		$arrPeopleName = null;
		if(isset($post['people_name'])){
			$arrPeopleName = $post['people_name'];
		}

		$arrPeoplelName = null;
		if(isset($post['people_lname'])){
			$arrPeoplelName = $post['people_lname'];
		}

		$arrMakePaymentVal = null;
		if(isset($post['make_payment_val'])){
			$arrMakePaymentVal = $post['make_payment_val'];
		}

		$arrPeopleId = null;
		if(isset($post['people_id'])){
			$arrPeopleId = $post['people_id'];
		}

		$arrDeposit = null;
		if(isset($post['deposit'])){
			$arrDeposit = $post['deposit'];
		}

		$session_id = isset($post['session']) ? $post['session'] : '';

		$i = 0;
		foreach($arrPeopleId As $key=>$person) {
			$deposit = $arrDeposit[$i] == '' ? 0 : intval($arrDeposit[$i]);
			$payment = $arrMakePaymentVal[$i] == '' ? 0 : intval($arrMakePaymentVal[$i]);
			$keys = array('people_name','people_lname');
			$vals = array($arrPeopleName[$i],$arrPeoplelName[$i]);

			//echo "val=". implode(',',$vals) . " <br />";
			//echo "keys=". implode(',',$keys) . " <br />";
			//echo "person=$person <br />-------------------------------<br /><br /><br /><br />";



			$this->mysqliupdate('quote_hotel_detail',$keys,$vals,'',$person);
			//$this->strSuccessMessage .= '<br />Detail Record Saved';
			$i++;
		}





	}

	public function updatePeopleDetail($post, $debug = false) {
		$arrPeopleName = null;
		if(isset($post['people_name'])){
			$arrPeopleName = $post['people_name'];
		}

		$arrPeoplelName = null;
		if(isset($post['people_lname'])){
			$arrPeoplelName = $post['people_lname'];
		}

		$arrPeopleEmail = null;
		if(isset($post['people_email'])){
			$arrPeopleEmail = $post['people_email'];
		}

		$arrMakePaymentVal = null;
		if(isset($post['make_payment_val'])){
			$arrMakePaymentVal = $post['make_payment_val'];
		}

		$arrPeopleId = null;
		if(isset($post['people_id'])){
			$arrPeopleId = $post['people_id'];
		}

		$arrDeposit = null;
		if(isset($post['deposit'])){
			$arrDeposit = $post['deposit'];
		}

		$session_id = isset($post['session']) ? $post['session'] : '';

		$i = 0;
		foreach($arrPeopleId As $key=>$person) {
			$deposit = $arrDeposit[$i] == '' ? 0 : intval($arrDeposit[$i]);
			$payment = $arrMakePaymentVal[$i] == '' ? 0 : intval($arrMakePaymentVal[$i]);
			$keys = array('people_name','people_lname','people_email');
			$vals = array($arrPeopleName[$i],$arrPeoplelName[$i],$arrPeopleEmail[$i]);

			//echo "val=". implode(',',$vals) . " <br />";
			//echo "keys=". implode(',',$keys) . " <br />";
			//echo "person=$person <br />-------------------------------<br /><br /><br /><br />";



			$this->mysqliupdate('package_hotel_detail',$keys,$vals,'',$person);
			//$this->strSuccessMessage .= '<br />Detail Record Saved';
			$i++;
		}





	}

	public function updatePaymentDetail($post,$member_id,$email_id, $first_name, $last_name, $debug = false) {

		$csvPeopleName = $post['people_name'];
		$csvPeoplelName = $post['people_lname'];
		$csvPeopleEmail = $post['people_email'];
		$csvMakePaymentVal = $post['make_payment_val'];
		$csvPeopleId = $post['people_id'];
		$csvDeposit = $post['deposit'];
		$csvPackagePrice = $post['package_price'];
		$session_id = isset($post['session']) ? $post['session'] : '';


		//leave unlocked for now
		//$sql = "UPDATE packages SET blnProcessed=1 WHERE session_id='$session_id'";
		//$this->short_query($sql);

		$index = $post['member_id'];

		//var_dump($csvPeopleName);


		$arrPeopleName = explode(',',$csvPeopleName);
		$arrPeoplelName = explode(',',$csvPeoplelName);
		$arrPeopleEmail = explode(',',$csvPeopleEmail);
		$arrMakePaymentVal = explode(',',$csvMakePaymentVal);
		$arrPeopleId = explode(',',$csvPeopleId);
		$arrDeposit = explode(',',$csvDeposit);
		$arrPackagePrice = explode(',',$csvPackagePrice);

		$i = 0;
		foreach($arrPeopleId As $key=>$person) {

			$keys = array('people_name','people_lname','people_email');
			$vals = array($arrPeopleName[$i], $arrPeoplelName[$i], $arrPeopleEmail[$i]);

			if ($arrMakePaymentVal[$i] != '') {

				$deposit = $arrDeposit[$i] == '' ? 0 : intval($arrDeposit[$i]);
				$package_price = $arrPackagePrice[$i] == '' ? 0 : intval($arrPackagePrice[$i]);
				$payment = $arrMakePaymentVal[$i] == '' ? 0 : intval($arrMakePaymentVal[$i]);

				$keys[] = 'deposit_price';
				$keys[] = 'final_price';
				$keys[] = 'last_payment_date';

				$vals[] = $deposit + $payment;
				$vals[] = $package_price - $deposit - $payment;
				$vals[] = Date('Y-m-d H:i:s');

				if (($index == $person) && ($member_id != '')) {
					$keys[] = 'member_id';
					$vals[] = $member_id;
				}

				if (($index == $person) && ($email_id != '')) {
					$keys[] = 'people_email';
					$vals[] = $email_id;
				}
			}
				//$keys = array('deposit_price','final_price','last_payment_date');
				//$vals = array( ($deposit+$payment),'(package_price-'.$payment.')',Date('Y-m-d H:i:s'));

				/*if($index == $person && $member_id != '' && $email_id != '') {

					$vals[] = $first_name;
					$vals[] = $last_name;

					$keys[] = 'member_id';
					$keys[] = 'people_email';
					$vals[] = $member_id;
					$vals[] = $email_id;

				} else {*/

					//$vals[] = $arrPeopleName[$i];
					//$vals[] = $arrPeoplelName[$i];
					//$vals[]
				//}

			//var_dump($keys);
			//var_dump($vals);
			//var_dump($person);

			$this->mysqliupdate('package_hotel_detail',$keys,$vals,'',$person);

			$i++;

		}





/*



		// Country Stuff
		if($this->intCountryId == "261"){
			$this->strCountryName = "CA";
		}else if($this->intCountryId == "148"){
			$this->strCountryName = "US";
		}

		$sql ="select title from city where id='".$this->intCityId."'";
		if($this->query($sql)) {

			$result = $this->getMysqliResults($sql,true);
			$result = $result[0];
			$this->strCityName = $result['title'];
		}

		$sql ="select short_name from state where id='".$this->intStateId."'";
		if($this->query($sql)) {

			$result = $this->getMysqliResults($sql,true);
			$result = $result[0];
			$this->strStateName = $result['short_name'];
		}


 		//test cc number 4716820139292393
		$objPaypal = new PayPal;

		$objPaypal->SetSandbox(true);
		$objPaypal->currency_code("CAD")
			->currency_id("CAD");

		if($debug != true) {
			$objPaypal->username("ross_api1.bcgolfguide.com")
				->password("KU6TT4FHYGZG9F9A")
				->signature("AFcWxV21C7fd0v3bYYYRCpSSRl31As68Ofr5p93eE-juS7i.jXba6TRU");
		}

		$objPaypal->amount(floatval($intTotal))
		->card_security( $this->strCcCvv )
		->card_expiry("year", $this->strCcExpYear)
		->card_expiry("month", $this->strCcExpMonth)
		->card_type( (($this->strCcNumber[0] == "5")? "MasterCard" :  (($this->strCcNumber[0] == "4" )? "Visa" : null )  ) )
		->card_number( str_replace("-","",$this->strCcNumber) )
		->email( $this->strEmail )
		->firstname( $this->strFirstName )
		->lastname( $this->strLastName )
		->address( $this->strAddress )
		->city( $this->strCityName )
		->province( $this->strStateName )
		->postal( $this->strPostalCode )
		->country( $this->strCountryName )
		->custom( "Group Organizer Name: " )
		// "Shipping" information
		->shipping_firstname( $this->strccFirstName )
		->shipping_lastname( $this->strccLastName )
		->shipping_address( $this->strAddress )
		->shipping_city( $this->strCityName )
		->shipping_province( $this->strStateName )
		->shipping_postal( $this->strPostalCode )
		->shipping_country( $this->strCountryName );

		if($objPaypal->valid() || $debug) {
			$objPaypal->exec();

			if($objPaypal->GetMessages(true) == "success" || $debug) {



				//$status['status'] = "true";
				$this->strSuccessMessage .= "<br />Transaction completed.";

			} else {
				//$status['status'] = "false";
				$this->strErrorMessage .= "<br />" . $status['msg'] = $objPaypal->GetMessages(true);
			}
		} else {
			//$status['status'] = "false";
			$this->strErrorMessage .= "<br />" . implode("\n\r", $objPaypal->GetMessages());
		}

		//var_dump($objPaypal);

		//die();
*/




	}










	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*, s.country_id, c.state_id
		From $this->strTableName t
		Left Join city c on c.id=t.city_id
	    Left Join state s on s.id=c.state_id
	    Left Join country co on co.id=s.country_id
		WHERE t.id=$id
		LIMIT 0,1";
		echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$this->strFirstName = isset($result['first_name']) ? trim($result['first_name']) : '';
			$this->strLastName = isset($result['last_name']) ? trim($result['last_name']) : '';
			$this->strEmail = isset($result['email']) ? $result['email'] : '';
			$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
			$this->strCell = isset($result['cell']) ? $result['cell'] : '';
			$this->strFax = isset($result['fax']) ? $result['fax'] : '';
			$this->strAddress = isset($result['address']) ? $result['address'] : '';
			$this->strPostalCode = isset($result['postal_code']) ? $result['postal_code'] : '';
			$this->intCityId = isset($result['city_id']) ? $result['city_id'] : '';
			$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
			$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
			$this->strProvider = isset($result['provider']) ? $result['provider'] : '';
	     	return $result;
	    } else {
	     	return null;
	    }
	}

	public function getDetailByEmail($email) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*, s.country_id, c.state_id
		From $this->strTableName t
		Left Join city c on c.id=t.city_id
	    Left Join state s on s.id=c.state_id
	    Left Join country co on co.id=s.country_id
		WHERE t.email='$email'
		LIMIT 0,1";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			if(count($result)) {
				$result = $result[0];
				$this->strFirstName = isset($result['first_name']) ? trim($result['first_name']) : '';
				$this->strLastName = isset($result['last_name']) ? trim($result['last_name']) : '';
				$this->strEmail = isset($result['email']) ? $result['email'] : '';
				$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
				$this->strCell = isset($result['cell']) ? $result['cell'] : '';
				$this->strFax = isset($result['fax']) ? $result['fax'] : '';
				$this->strAddress = isset($result['address']) ? $result['address'] : '';
				$this->strPostalCode = isset($result['postal_code']) ? $result['postal_code'] : '';
				$this->intCityId = isset($result['city_id']) ? $result['city_id'] : '';
				$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
				$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
				$this->strProvider = isset($result['provider']) ? $result['provider'] : '';
				return $result;
			} else {
				return null;
			}

	    } else {
	     	return null;
	    }
	}


	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    //if($cats != '') {
	   	 	//$this->strQuery1 .= "AND cat_id='$cats' ";
	    //}

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.first_name like '%$searchWord%' OR t.last_name like '%$searchWord%')";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, c.title As city,
	     s.state_name As state, co.country_name As country, s.country_id, c.state_id
	     From $this->strTableName t
	     Left Join city c on c.id=t.city_id
	     Left Join state s on s.id=c.state_id
	     Left Join country co on co.id=s.country_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	    if($searchWord != ''){
	    	$this->strQuery .= "AND (t.first_name like '%$searchWord%' OR t.last_name like '%$searchWord%')";
	    }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}

	public function getProviders() {

		$strQuery = "SELECT id, name FROM mobile_service where activated=1 and (country='Canada' or country='USA') Group BY name ASC";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }


	}

	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>