<?php


class Hotelvideo extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strEmail;
	public $strPhone;
	public $strTitle;
	public $strVideoTitle;

	public $intID;
	public $strAction;
	public $strThumbnailURL;
	public $strThumbnailURL1;
	public $strThumbnailURL2;
	public $strThumbnailURL3;
	public $strDescription;
	public $strKey;
	public $strUrl;


	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->intVideoID = isset($_REQUEST['video_id']) ? $_REQUEST['video_id'] : '';
		$this->strErrorMessage = "";
		$this->strTableName = 'hotel_videos';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/hotel/';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/hotels/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/hotels/'.date('Y').'/';

		$this->strTitle = 'Hotel Videos';





	}




	public function handlePost($post,$id, $debug = false) {
		$this->intID = $id;
		$this->strVideoTitle = isset($post['title']) ? trim($post['title']) : '';
		$this->strDescription = isset($post['description']) ? $post['description'] : '';
		$this->strUrl = isset($post['url']) ? $post['url'] : '';



		if($this->strUrl == '' || strpos($this->strUrl,'youtube.com') === false) { $this->strErrorMessage .= "Please enter a url for this video.<br />"; }

		if($this->strErrorMessage == '') {

			$youtube = new Youtube();

			$res = $youtube->getTYPage($this->strUrl,true);
			if(is_null($res)) {
				//var_dump($res);
				//die();
				$this->strErrorMessage .= '<br />Video Not Found:'.$this->strUrl;

			} else {
				//Util::debugDisplay(
				//var_dump($res)
				//);

				$this->strKey = $res->key;
				$this->strUrl = 'https://youtube.com/v/'.$res->key;
				$this->strDescription = ($this->strDescription =='') ? $res->description : $this->strDescription;
				$this->strVideoTitle = ($this->strVideoTitle =='') ? $res->title : $this->strVideoTitle;
				$this->strThumbnailURL = $res->thumbnailURL;
				$this->strThumbnailURL1 = $res->thumbnailURL1;
				$this->strThumbnailURL2 = $res->thumbnailURL2;
				$this->strThumbnailURL3 = $res->thumbnailURL3;

				if($debug) {
					Util::debugDisplay('<br />$this->strKey='.$this->strKey);
					Util::debugDisplay('<br />$this->strVideoTitle='.$this->strVideoTitle);
					Util::debugDisplay('<br />$this->thumbnailURL='.$this->strThumbnailURL);
					Util::debugDisplay('<br />$this->thumbnailURL1='.$this->strThumbnailURL1);
					Util::debugDisplay('<br />$this->thumbnailURL2='.$this->strThumbnailURL2);
					Util::debugDisplay('<br />$this->thumbnailURL3='.$this->strThumbnailURL3);
					Util::debugDisplay('<br />$this->strDescription='.$this->strDescription);
				}

				$keys = array('ykey','url','title','description','image0','image1','image2','image3','hotel_id');
				$vals = array( $this->strKey,$this->strUrl,$this->strVideoTitle,$this->strDescription,$this->strThumbnailURL,$this->strThumbnailURL1,$this->strThumbnailURL2,$this->strThumbnailURL3,$this->intID);
				$types = array('ssssssssi');

				if($this->intVideoID == '') {

					//no ability to add categories is required.
					$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,$types);
					$this->intVideoID = $this->insert_id;
					$this->strSuccessMessage = 'Record Added';


				} else {

					$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$this->intVideoID);
					$this->strSuccessMessage = 'Record Saved:'.$this->strTitle;

					if($debug) {
				 		Util::debugDisplay('<br />videoID='.$this->intVideoID);
				 		Util::debugDisplay($keys);
				 		Util::debugDisplay($vals);
					}

				}


				//die($this->strSuccessMessage);
			}


        } //error message check

        return $this->intVideoID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*
		From $this->strTableName t
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];

			$this->strVideoTitle = isset($result['title']) ? trim($result['title']) : '';
			$this->strDescription = isset($result['description']) ? $result['description'] : '';
			$this->strUrl = isset($result['url']) ? $result['url'] : '';
			$this->strKey = isset($result['ykey']) ? $result['ykey'] : '';
			$this->strThumbnailURL = isset($result['image0']) ? $result['image0'] : '';
			$this->strThumbnailURL1 = isset($result['image1']) ? $result['image1'] : '';
			$this->strThumbnailURL2 = isset($result['image2']) ? $result['image2'] : '';
			$this->strThumbnailURL3 = isset($result['image3']) ? $result['image3'] : '';
			$this->strThumbnailURL4 = isset($result['image4']) ? $result['image4'] : '';

	     	return $result;

	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name
	     From $this->strTableName t
	     Left Join members m on m.id=t.member_id
	     Left Join course_type c on c.id=t.type_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getCategories() {

		$strQuery = "SELECT *
		FROM course_type WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getManagers() {

		$strQuery = "SELECT *
		FROM members where level>0 and confirmed=1 and approved=1 And status='Active' order by email asc";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}


	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id, $debug = false) {

	    $this->strQuery = 'SELECT file_name FROM '.$this->strTableName.' WHERE id=' . $id;


		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$file_name = $res[0]['file_name'];
	     	if(file_exists(ROOT_DIR.$file_name)) {
	     		unlink(ROOT_DIR.$file_name);
	     		Util::debugDisplay('delete='.ROOT_DIR.$file_name);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$file_name='.ROOT_DIR.$file_name);
		}


		//die();




	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}


}



?>