<?php


class Hotel extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strHotelName;
	public $strEmail;
	public $strPhone;
	public $strTitle;
	public $strSlug;
	public $strAddress;
	public $strZip;
	public $intHits;
	public $strLatitude;
	public $strLongitude;
	public $strContactPerson;
	public $strContactPhone;
	public $strContactFax;
	public $strContactEmail;
	public $strFrontdeskEmail;
    public $strFrontdeskEmailAlt;
	public $strAccountEmail;
	public $strAccountName;
	public $strWebUrl;
	public $strFacebookUrl;
	public $strTwitterUrl;
	public $strFacebookTitle;
	public $strFacebookDescription;
	public $strTwitterTitle;
	public $strTwitterDescription;
	public $strGoogleDescription;
	public $strDescription;
	public $strAmenities;
    public $strSpecialGuestInstructions;
	public $strNotes;
	public $strCheckInTime;
	public $strCheckInAp;
	public $strCheckOutTime;
	public $strCheckOutAp;
	public $intID;
	public $strAction;

	public $strUploadsDir;
    public $strUploadsUrl;
    public $arrFilesToDelete;
    public $strDisplayImage;

	public $strFocusKeyword;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $intScoreSEO;

	public $intLevel;

	public $strBookingReportEmail;
	public $strBookingReportFrequency;

	public $strBookingUrl;
	public $strBookingUsername;
	public $strBookingPassword;

	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'hotel';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/hotel/';

		$this->strTitle = 'Hotels';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/hotels/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/hotels/'.date('Y').'/';

        $this->strSlug = '/golf-accommodations/'.$this->strSlug;

	}


	public function handlePost($post,$id) {

		$this->intID = $id;
		$this->strHotelName = isset($post['hotel_name']) ? $post['hotel_name'] : '';
		$this->intHits = isset($post['hit_counter']) ? $post['hit_counter'] : '';
		$this->intLevel = isset($post['level']) ? $post['level'] : '1';

		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->strZip = isset($post['zip']) ? $post['zip'] : '';
		//$this->intMemberId = isset($result['member_id']) ? $result['member_id'] : '';
		$this->intTypeId = isset($post['type_id']) ? $post['type_id'] : '';
		$this->intCountryId = isset($post['country']) ? $post['country'] : '';
		$this->intStateId = isset($post['state']) ? $post['state'] : '';
		$this->intCityId = isset($post['city']) ? $post['city'] : '';
		$this->strFrontdeskEmail = isset($post['frontdesk_email']) ? $post['frontdesk_email'] : '';
        $this->strFrontdeskEmailAlt = isset($post['frontdesk_email_alt']) ? $post['frontdesk_email_alt'] : '';
		$this->strLatitude = isset($post['latitude']) ? $post['latitude'] : '';
		$this->strLongitude = isset($post['longitude']) ? $post['longitude'] : '';
		$this->strContactPerson = isset($post['contact_person']) ? $post['contact_person'] : '';
		$this->strContactPhone = isset($post['contact_phone']) ? $post['contact_phone'] : '';
		$this->strContactFax = isset($post['contact_fax']) ? $post['contact_fax'] : '';
		$this->strContactEmail = isset($post['contact_email']) ? $post['contact_email'] : '';
		$this->strAccountEmail = isset($post['account_email']) ? $post['account_email'] : '';
		$this->strAccountName = isset($post['account_name']) ? $post['account_name'] : '';
		$this->strWebUrl = isset($post['web_url']) ? $post['web_url'] : '';
		$this->strFacebookUrl = isset($post['facebook_url']) ? $post['facebook_url'] : '';
		$this->strTwitterUrl = isset($post['twitter_url']) ? $post['twitter_url'] : '';
		$this->strDescription = isset($post['description']) ? $post['description'] : '';
		$this->strDescription = Util::cleanWordText($this->strDescription);

		$this->strAmenities = isset($post['amenities']) ? $post['amenities'] : '';
		$this->strAmenities = Util::cleanWordText($this->strAmenities);

        $this->strSpecialGuestInstructions = isset($post['special_instructions']) ? $post['special_instructions'] : '';
        $this->strSpecialGuestInstructions = Util::cleanWordText($this->strSpecialGuestInstructions);

		$this->strNotes = isset($post['notes']) ? $post['notes'] : '';
		$this->strNotes = Util::cleanWordText($this->strNotes);

		$this->strCheckInTime = isset($post['check_in_time']) ? $post['check_in_time'] : '';
		$this->strCheckInAp = isset($post['check_in_ap']) ? $post['check_in_ap'] : '';
		$this->strCheckOutTime = isset($post['check_out_time']) ? $post['check_out_time'] : '';
		$this->strCheckOutAp = isset($post['check_out_ap']) ? $post['check_out_ap'] : '';
		$this->strDisplayImage = isset($post['file_name']) ? $post['file_name'] : '';
		$this->intHits = isset($post['hit_counter']) ? $post['hit_counter'] : '';

		$this->strFocusKeyword = isset($post['focus_keyword']) ? $post['focus_keyword'] : '';
		$this->strMetaTitle = isset($post['meta_title']) ? $post['meta_title'] : '';
		$this->strMetaKeywords = isset($post['meta_keywords']) ? $post['meta_keywords'] : '';
		$this->strMetaDescription = isset($post['meta_description']) ? $post['meta_description'] : '';
		$this->strMetaRobots = isset($post['meta_robots']) ? $post['meta_robots'] : "index,follow";
		$this->intScoreSEO = isset($post['score_seo']) ? $post['score_seo'] : 0;

		$this->strFacebookTitle = isset($post['facebook_title']) ? $post['facebook_title'] : '';
		$this->strFacebookDescription = isset($post['facebook_description']) ? $post['facebook_description'] : '';
		$this->strTwitterTitle = isset($post['twitter_title']) ? $post['twitter_title'] : '';
		$this->strTwitterDescription = isset($post['twitter_description']) ? $post['twitter_description'] : '';
		$this->strGoogleDescription = isset($post['google_description']) ? $post['google_description'] : '';

        $this->arrFilesToDelete = isset($post['files_to_delete']) ? $post['files_to_delete'] : '';

        $this->strBookingReportEmail = isset($post['booking_report_email']) ? $post['booking_report_email'] : '';
		$this->strBookingReportFrequency = isset($post['booking_report_frequency']) ? $post['booking_report_frequency'] : '';

		$this->strBookingUrl = isset($post['booking_url']) ? $post['booking_url'] : '';
		$this->strBookingUsername = isset($post['booking_username']) ? $post['booking_username'] : '';
		$this->strBookingPassword = isset($post['booking_password']) ? $post['booking_password'] : '';

		$this->strSlug = isset($post['slug']) ? $post['slug'] : '';
		$this->strSlug = str_replace('/hotel-detail/','',$this->strSlug);
		$this->strSlug = str_replace('/golf-accommodations/','',$this->strSlug);

		if($this->strHotelName == '') { $this->strErrorMessage .= "Please enter a name for this hotel. r= $this->intCountryId <br />"; }

		if($this->strSlug == '' && $this->strHotelName != '') { $this->strSlug = $this->strHotelName; }
        $this->strSlug = Util::cleanForUrl($this->strSlug);

		$slug_exists = $this->validSlug($this->strTableName, $this->strSlug, $id);

		if(!empty($slug_exists)){
			$this->strErrorMessage .= "Post with this slug already exists.<br />";
		}

		if($this->strErrorMessage == '') {

			$keys = array('hotel_name',
				'slug',
				'hit_counter',
				'address',
				'zip',
				'latitude',
				'longitude',
				'city_id',
				'contact_person',
				'contact_phone',
				'contact_fax',
				'contact_email',
				'account_email',
				'account_name',
				'web_url',
				'facebook_url',
				'twitter_url',
				'description',
				'amenities',
                'special_instructions',
				'notes',
				'check_in_time',
				'check_in_ap',
				'check_out_time',
				'check_out_ap',
				'focus_keyword',
				'meta_title',
				'meta_keywords',
				'meta_description',
				'meta_robots',
				'score_seo',
				'facebook_title',
				'facebook_description',
				'twitter_title',
				'twitter_description',
				'google_description',
				'frontdesk_email',
                'frontdesk_email_alt',
				'type_id',
				'level',
				'edit_date',
				'booking_report_email',
				'booking_report_frequency',
				'booking_url',
				'booking_username',
				'booking_password'
			);
			$vals = array( $this->strHotelName,
				$this->strSlug,
				$this->intHits,
				$this->strAddress,
				$this->strZip,
				$this->strLatitude,
				$this->strLongitude,
				$this->intCityId,
				$this->strContactPerson,
				$this->strContactPhone,
				$this->strContactFax,
				$this->strContactEmail,
				$this->strAccountEmail,
				$this->strAccountName,
				$this->strWebUrl,
				$this->strFacebookUrl,
				$this->strTwitterUrl,
				$this->strDescription,
				$this->strAmenities,
                $this->strSpecialGuestInstructions,
				$this->strNotes,
				$this->strCheckInTime,
				$this->strCheckInAp,
				$this->strCheckOutTime,
				$this->strCheckOutAp,
				$this->strFocusKeyword,
				$this->strMetaTitle,
				$this->strMetaKeywords,
				$this->strMetaDescription,
				$this->strMetaRobots,
				$this->intScoreSEO,
				$this->strFacebookTitle,
				$this->strFacebookDescription,
				$this->strTwitterTitle,
				$this->strTwitterDescription,
				$this->strGoogleDescription,
				$this->strFrontdeskEmail,
                $this->strFrontdeskEmailAlt,
				$this->intTypeId,
				$this->intLevel,
				Date('Y-m-d'),
				$this->strBookingReportEmail,
				$this->strBookingReportFrequency,
				$this->strBookingUrl,
				$this->strBookingUsername,
				$this->strBookingPassword
			);
			//$types = array('ss');

			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;

			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}

			// Delete any files that were checked for deletion
            if (!empty($this->arrFilesToDelete)) {
                foreach ($this->arrFilesToDelete as $strFieldName => $strFilePath) {
                    if (Util::deleteFile($strFilePath)) {
                        $this->strQuery = "UPDATE $this->strTableName SET `$strFieldName` = NULL WHERE `id` = $this->intID";
                        $this->short_query($this->strQuery);
                    }
                }
            }

            if($_FILES['display_image']['error'] != 4) {
				// Upload our image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['display_image'],
	                $this->strUploadsDir,
	                $this->intID.'_hotel_img',
	                array('image/*'),
	                true,
	                true
	            );

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET file_name = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br /> Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


	        if($_FILES['facebook_image']['error'] != 4) {
	            // Upload our Facebook image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['facebook_image'],
	                $this->strUploadsDir,
	                $this->intID.'_facebook',
	                array('image/*')
	            );
	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET `facebook_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br> Facebook Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


	        if($_FILES['twitter_image']['error'] != 4) {
	            // Upload our twitter image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['twitter_image'],
	                $this->strUploadsDir,
	                $this->intID.'_twitter',
	                array('image/*')
	            );

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET `twitter_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br> Twitter Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


        } //error message check

        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.* , c.id As country_id, s.id As state_id
		From $this->strTableName t
		Left Join city c2 on c2.id=t.city_id
		Left Join state s on s.id=c2.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];

			$this->strHotelName = isset($result['hotel_name']) ? $result['hotel_name'] : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
			$this->strDescription = isset($result['description']) ? $result['description'] : '';
			$this->strAddress = isset($result['address']) ? $result['address'] : '';
			$this->strZip = isset($result['zip']) ? $result['zip'] : '';
			$this->intMemberId = isset($result['member_id']) ? $result['member_id'] : '';
			$this->intTypeId = isset($result['type_id']) ? $result['type_id'] : '';
			$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
			$this->intCityId = isset($result['city_id']) ? $result['city_id'] : '';
			$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
			$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
			$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
			$this->strContactPerson = isset($result['contact_person']) ? $result['contact_person'] : '';
			$this->strContactPhone = isset($result['contact_phone']) ? $result['contact_phone'] : '';
			$this->strContactFax = isset($result['contact_fax']) ? $result['contact_fax'] : '';
			$this->strContactEmail = isset($result['contact_email']) ? $result['contact_email'] : '';
			$this->strAccountEmail = isset($result['account_email']) ? $result['account_email'] : '';
			$this->strAccountName = isset($result['account_name']) ? $result['account_name'] : '';
			$this->strWebUrl = isset($result['web_url']) ? $result['web_url'] : '';
			$this->strFacebookUrl = isset($result['facebook_url']) ? $result['facebook_url'] : '';
			$this->strTwitterUrl = isset($result['twitter_url']) ? $result['twitter_url'] : '';
			$this->strAmenities = isset($result['amenities']) ? $result['amenities'] : '';
            $this->strSpecialGuestInstructions = isset($result['special_instructions']) ? $result['special_instructions'] : '';
			$this->strNotes = isset($result['notes']) ? $result['notes'] : '';
			$this->strCheckInTime = isset($result['check_in_time']) ? $result['check_in_time'] : '';
			$this->strCheckInAp = isset($result['check_in_ap']) ? $result['check_in_ap'] : '';
			$this->strCheckOutTime = isset($result['check_out_time']) ? $result['check_out_time'] : '';
			$this->strCheckOutAp = isset($result['check_out_ap']) ? $result['check_out_ap'] : '';
			$this->strDisplayImage = isset($result['file_name']) ? $result['file_name'] : '';
			$this->intHits = isset($result['hit_counter']) ? $result['hit_counter'] : '';
			$this->strFrontdeskEmail = isset($result['frontdesk_email']) ? $result['frontdesk_email'] : '';
            $this->strFrontdeskEmailAlt = isset($result['frontdesk_email_alt']) ? $result['frontdesk_email_alt'] : '';
			$this->strSlug = '/golf-accommodations/'.$this->strSlug;
			$this->intLevel = isset($result['level']) ? $result['level'] : '1';

			$this->strFocusKeyword = isset($result['focus_keyword']) ? $result['focus_keyword'] : '';
			$this->strMetaTitle = isset($result['meta_title']) ? $result['meta_title'] : '';
			$this->strMetaKeywords = isset($result['meta_keywords']) ? $result['meta_keywords'] : '';
			$this->strMetaDescription = isset($result['meta_description']) ? $result['meta_description'] : '';
			$this->strMetaRobots = isset($result['meta_robots']) ? $result['meta_robots'] : "index,follow";
			$this->strFacebookTitle = isset($result['facebook_title']) ? $result['facebook_title'] : '';
			$this->strFacebookDescription = isset($result['facebook_description']) ? $result['facebook_description'] : '';
			$this->strTwitterTitle = isset($result['twitter_title']) ? $result['twitter_title'] : '';
			$this->strTwitterDescription = isset($result['twitter_description']) ? $result['twitter_description'] : '';
			$this->strGoogleDescription = isset($result['google_description']) ? $result['google_description'] : '';

			$this->strBookingReportEmail = isset($result['booking_report_email']) ? $result['booking_report_email'] : '';
			$this->strBookingReportFrequency = isset($result['booking_report_frequency']) ? $result['booking_report_frequency'] : '';

            $this->strBookingUrl = isset($result['booking_url']) ? $result['booking_url'] : '';
            $this->strBookingUsername = isset($result['booking_username']) ? $result['booking_username'] : '';
            $this->strBookingPassword = isset($result['booking_password']) ? $result['booking_password'] : '';

			// Score the SEO content of the page
            if (class_exists('SEO_Scorer')) {
                $objScore = new SEO_Scorer(array(
                    'keyword' => $this->strFocusKeyword,
                    'meta_title' => $this->strMetaTitle,
                    'meta_description' => $this->strMetaDescription,
                    'meta_robots' => $this->strMetaRobots,
                    'content' => $this->strDescription,
                    'url' => $this->strSlug
                ));
                $this->arrScore = $objScore->getScore();
            }

	     	return $result;
	    } else {
	     	return null;
	    }
	}

	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name
	     From $this->strTableName t
	     Left Join members m on m.id=t.member_id
	     Left Join hotel_type c on c.id=t.type_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}


	public function getCategories() {

		$strQuery = "SELECT *
		FROM hotel_type WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getManagers() {

		$strQuery = "SELECT *
		FROM members where level>0 and confirmed=1 and approved=1 And status='Active' order by email asc";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getHotelDocList($hotel_id) {
		/*
		Import sql to insert new records from the files table

		INSERT INTO hotel_img (title,file_name,hotel_id,display_order)
		SELECT file_title As title, concat('/application/uploads/hotels/2013/',file_name) As file_name,
		cat_id As hotel_id, file_num As display_order FROM files WHERE section_name='hotel' ANd file_type='Image'

		*/

		$strQuery = "SELECT *
		FROM hotel_files where hotel_id=$hotel_id AND status = 'Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}




	public function getHotelImageList($hotel_id) {
		/*
		Import sql to insert new records from the files table

		INSERT INTO hotel_img (title,file_name,hotel_id,display_order)
		SELECT file_title As title, concat('/application/uploads/hotels/2013/',file_name) As file_name,
		cat_id As hotel_id, file_num As display_order FROM files WHERE section_name='hotel' ANd file_type='Image'

		*/

		$strQuery = "SELECT *
		FROM hotel_img where hotel_id=$hotel_id AND status = 'Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}




	public function getHotelVideoList($hotel_id) {
		/*
		Import sql to insert new records from the files table
		INSERT INTO hotel_videos (title, embed_code, hotel_id, display_order)
		SELECT file_title As title, embed_code, cat_id As hotel_id, file_num As display_order FROM files WHERE section_name='hotel' ANd file_type='youtube'

		UPDATE hotel_videos SET url= REPLACE(REPLACE(SUBSTRING_INDEX(SUBSTRING_INDEX( embed_code , 'youtube.com' ,-1 ), '?',1) ,'/v/','') ,'/embed/','')

		*/

		$strQuery = "SELECT *
		FROM hotel_videos where hotel_id=$hotel_id";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}




}



?>