<?php


class Group extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strGroupName;
	public $strSlug;
	public $strStatus;
	public $intID;
	public $strAction;
    public $strGridAgency;
    public $strGridAgent;
    public $strGridEmailRead;
    public $strGridDateType;
	public $strStartDate;
	public $strEndDate;
	public $intYear;
	public $intMonth;
	public $strAdminNote;

	public $intLevel;


	public function __construct($strPageId = null,$strAction = null) {

		parent::__construct();

		$this->strErrorMessage = "";
		$this->strTableName = 'groups';

		if(empty($strPageId) && empty($strAction)){
			// called from another page, we don't need all the page setup
			return;
		}

		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/quote/';

		$this->strTitle = 'Quote Groups';
	}

    public function setAgency($type) {
        $this->strGridAgency = $type;
    }

    public function setAgent($type) {
        $this->strGridAgent = $type;
    }

    public function setEmailRead($type) {
        $this->strGridEmailRead = $type;
    }

	public function setDateType($type) {
		$this->strGridDateType = $type;
	}

	public function setStartDate($date) {
		$this->strStartDate = $date;
	}

	public function setEndDate($date) {
		$this->strEndDate = $date;
	}

	public function setYear($date) {
		$this->intYear = $date;
	}

	public function setMonth($date) {
		$this->intMonth = $date;
	}


	public function handlePost($post,$id) {
		$this->intID = $id;
		$this->strGroupName = isset($post['group_name']) ? $post['group_name'] : '';
		$this->strStatus = isset($post['status']) ? $post['status'] : '';
		$this->strAdminNote = isset($post['admin_note']) ? $post['admin_note'] : '';

		if(empty($this->strGroupName) && empty($this->strStatus)){
			// no information to update
			return $this->intID;
		}

		if($this->strErrorMessage == '') {

			$keys = array(
				'group_name',
				'status',
				'admin_note'
			);
			$vals = array(
				$this->strGroupName,
				$this->strStatus,
				$this->strAdminNote
			);
			//$types = array('ss');

			if($this->intID == '') {

				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;

			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}

        } //error message check

        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		// //page specific SEO settings. These may override the default settings.
		// $this->strQuery = "SELECT t.* , c.id As country_id, s.id As state_id
		// From $this->strTableName t
		// Left Join city c2 on c2.id=t.city_id
		// Left Join state s on s.id=c2.state_id
		// Left Join country c on c.id=s.country_id
		// WHERE t.id=$id
		// LIMIT 0,1";
		// //echo $this->strQuery;

		// if($this->query($this->strQuery)) {

		// 	$result = $this->getMysqliResults($this->strQuery,true);
		// 	$result = $result[0];

		// 	$this->strGroupName = isset($result['group_name']) ? $result['group_name'] : '';
		// 	$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
		// 	$this->strDescription = isset($result['description']) ? $result['description'] : '';
		// 	$this->strAddress = isset($result['address']) ? $result['address'] : '';
		// 	$this->strZip = isset($result['zip']) ? $result['zip'] : '';
		// 	$this->intMemberId = isset($result['member_id']) ? $result['member_id'] : '';
		// 	$this->intTypeId = isset($result['type_id']) ? $result['type_id'] : '';
		// 	$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
		// 	$this->intCityId = isset($result['city_id']) ? $result['city_id'] : '';
		// 	$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
		// 	$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
		// 	$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
		// 	$this->strContactPerson = isset($result['contact_person']) ? $result['contact_person'] : '';
		// 	$this->strContactPhone = isset($result['contact_phone']) ? $result['contact_phone'] : '';
		// 	$this->strContactFax = isset($result['contact_fax']) ? $result['contact_fax'] : '';
		// 	$this->strContactEmail = isset($result['contact_email']) ? $result['contact_email'] : '';
		// 	$this->strAccountEmail = isset($result['account_email']) ? $result['account_email'] : '';
		// 	$this->strAccountName = isset($result['account_name']) ? $result['account_name'] : '';
		// 	$this->strWebUrl = isset($result['web_url']) ? $result['web_url'] : '';
		// 	$this->strFacebookUrl = isset($result['facebook_url']) ? $result['facebook_url'] : '';
		// 	$this->strTwitterUrl = isset($result['twitter_url']) ? $result['twitter_url'] : '';
		// 	$this->strAmenities = isset($result['amenities']) ? $result['amenities'] : '';
		// 	$this->strNotes = isset($result['notes']) ? $result['notes'] : '';
		// 	$this->strCheckInTime = isset($result['check_in_time']) ? $result['check_in_time'] : '';
		// 	$this->strCheckInAp = isset($result['check_in_ap']) ? $result['check_in_ap'] : '';
		// 	$this->strCheckOutTime = isset($result['check_out_time']) ? $result['check_out_time'] : '';
		// 	$this->strCheckOutAp = isset($result['check_out_ap']) ? $result['check_out_ap'] : '';
		// 	$this->strDisplayImage = isset($result['file_name']) ? $result['file_name'] : '';
		// 	$this->intHits = isset($result['hit_counter']) ? $result['hit_counter'] : '';
		// 	$this->strFrontdeskEmail = isset($result['frontdesk_email']) ? $result['frontdesk_email'] : '';
		// 	$this->strSlug = '/golf-accommodations/'.$this->strSlug;
		// 	$this->intLevel = isset($result['level']) ? $result['level'] : '1';

		// 	$this->strFocusKeyword = isset($result['focus_keyword']) ? $result['focus_keyword'] : '';
		// 	$this->strMetaTitle = isset($result['meta_title']) ? $result['meta_title'] : '';
		// 	$this->strMetaKeywords = isset($result['meta_keywords']) ? $result['meta_keywords'] : '';
		// 	$this->strMetaDescription = isset($result['meta_description']) ? $result['meta_description'] : '';
		// 	$this->strMetaRobots = isset($result['meta_robots']) ? $result['meta_robots'] : "index,follow";
		// 	$this->strFacebookTitle = isset($result['facebook_title']) ? $result['facebook_title'] : '';
		// 	$this->strFacebookDescription = isset($result['facebook_description']) ? $result['facebook_description'] : '';
		// 	$this->strTwitterTitle = isset($result['twitter_title']) ? $result['twitter_title'] : '';
		// 	$this->strTwitterDescription = isset($result['twitter_description']) ? $result['twitter_description'] : '';
		// 	$this->strGoogleDescription = isset($result['google_description']) ? $result['google_description'] : '';

		// 	// Score the SEO content of the page
  //           if (class_exists('SEO_Scorer')) {
  //               $objScore = new SEO_Scorer(array(
  //                   'keyword' => $this->strFocusKeyword,
  //                   'meta_title' => $this->strMetaTitle,
  //                   'meta_description' => $this->strMetaDescription,
  //                   'meta_robots' => $this->strMetaRobots,
  //                   'content' => $this->strDescription,
  //                   'url' => $this->strSlug
  //               ));
  //               $this->arrScore = $objScore->getScore();
  //           }

	 //     	return $result;
	 //    } else {
	 //     	return null;
	 //    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {

        $this->pgSize = $pgSize;
        $this->pg = ($pg > 0 ? $pg : 1);
        $start = $pg - 1 < 0 ? 0 : ($pg-1) * $pgSize;

        // Since these are aliases, we have to repeat them in the where clauses if we want to filter by them
        $strAgencyClause  = "SELECT business_name FROM brands WHERE id = (SELECT brandID From quotes WHERE id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1)";
        $strAgentClause   = "SELECT booking_name FROM booking_people WHERE id = (SELECT bookingID From quotes WHERE id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1)";
        $strEmailClause   = "SELECT email_read FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1";

	    $this->strQuery = "SELECT t.*,
	    (SELECT COUNT('x') FROM quote_group WHERE group_id = t.id) AS quote_count,
        (SELECT quote_name FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS quote_name,
        (SELECT edit_date FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS quote_last_edit,
        (SELECT order_date FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS quote_order_date,
        (SELECT check_in_date FROM quote_hotel qh JOIN quotes q ON qh.quote_id = q.id WHERE quote_id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY q.edit_date DESC limit 1) AS quote_arrival_date,
	    (SELECT user_name FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS user_name,
        (SELECT user_email FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS user_email,
		(SELECT status_name FROM order_status WHERE id = (SELECT completed From quotes WHERE id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1)) AS quote_status,
		(SELECT color FROM order_status WHERE id = (SELECT completed From quotes WHERE id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1)) AS quote_status_color,
        (SELECT phone FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS phone,
        (SELECT cell_phone FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS cell_phone,
        (SELECT state FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS state,
        (SELECT country FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS country,
        (SELECT golfers FROM quote_hotel qh JOIN quotes q ON qh.quote_id = q.id WHERE qh.default = 1 AND quote_id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY q.edit_date DESC limit 1) as players_num,
        (SELECT blnRepeat FROM quotes WHERE quotes.id IN (SELECT quote_id FROM quote_group WHERE group_id = t.id) ORDER BY edit_date DESC limit 1) AS blnRepeat,
        ($strAgencyClause) AS agency,
        ($strAgentClause) AS booking_person,
        ($strEmailClause) AS email_read
	    From `$this->strTableName` t ";

	    $this->strQuery .= "WHERE t.`id` > 0 ";

	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   		$this->strQuery .= "AND t.status='$status' ";
	    }

	    if($searchWord != ''){
			$this->strQuery .= "AND t.group_name like '%" . $this->getCleanVar($searchWord) . "%' ";
		}

        if ($this->strGridAgency != '') {
            $this->strQuery .= " AND ($strAgencyClause) = '" . $this->getCleanVar($this->strGridAgency) . "' ";
        }

        if ($this->strGridAgent != '') {
            $this->strQuery .= " AND ($strAgentClause) = '" . $this->getCleanVar($this->strGridAgent) . "' ";
        }

        if ($this->strGridEmailRead != '') {
            $this->strQuery .= " AND ($strEmailClause) = '" . $this->getCleanVar($this->strGridEmailRead) . "' ";
        }

 		if($this->strGridDateType != ''){

			if(isset($this->intMonth) && $this->intMonth != "") {
                $searchStart = $this->intYear . "-" . $this->intMonth . "-01";
                $strEnd = '-31';
                if (in_array($this->intMonth, array(4, 6, 9, 11))) {
                    $strEnd = '-30';
                }
                if ($this->intMonth == 2) {
                    $strEnd = '-28';
                }
                $searchEnd = $this->intYear . "-" . $this->intMonth . $strEnd;
            } else {
                $searchStart = $this->intYear . "-01-01";
                $searchEnd = $this->intYear . "-12-31";
            }

	    	switch($this->strGridDateType) {
	    		case 'dates_arrival':
	    			$this->strQuery .= " AND 0 < ( SELECT COUNT('x') FROM quote_group qg "
	    							 . " JOIN quotes q ON qg.quote_id = q.id "
	    							 . " JOIN quote_hotel qh ON qh.quote_id = q.id "
	    							 . " WHERE qg.group_id = t.id "
	    							 . " AND qh.check_in_date >= '" . $searchStart . "' "
	    							 . " AND qh.check_in_date <= '" . $searchEnd . "')";

	    			break;
	    		case 'dates_depart':
	    			$this->strQuery .= " AND 0 < ( SELECT COUNT('x') FROM quote_group qg "
	    							 . " JOIN quotes q ON qg.quote_id = q.id "
	    							 . " JOIN quote_hotel qh ON qh.quote_id = q.id "
	    							 . " WHERE qg.group_id = t.id "
	    							 . " AND qh.check_out_date >= '" . $searchStart . "' "
	    							 . " AND qh.check_out_date <= '" . $searchEnd . "')";

	    			break;
	    		default:
	    			$this->strQuery .= " AND 0 < ( SELECT COUNT('x') FROM quote_group qg "
	    							 . " JOIN quotes q ON qg.quote_id = q.id "
	    							 . " WHERE qg.group_id = t.id "
	    							 . " AND q." . $this->strGridDateType . " >= '" . $searchStart . "' "
	    							 . " AND q." . $this->strGridDateType . " <= '" . $searchEnd . "')";

        			break;
	    	}

        }

		if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

        // Get the records for the pagination
        $arrResults = $this->getMysqliResults($this->strQuery, true);
        $this->records = count($arrResults);
        $this->intPageCount = $this->records > 0 && $this->pgSize > 0 ? ceil($this->records / $this->pgSize) : 1;

	    $this->strQuery .= " LIMIT $start,$pgSize ";

		if($debug) {
            Util::debugDisplay($this->strQuery);
		}

	    if($this->query($this->strQuery)) {
	    	$arrResults =  $this->getMysqliResults($this->strQuery,true);
	    	return $arrResults;
	    } else {
	    	return null;
	    }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from `$this->strTableName` t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}

	public function getStatus() {
		$strQuery = "SELECT `status` FROM `$this->strTableName` GROUP BY `status` ORDER BY `status`";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE `'.$this->strTableName.'` SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id, $blnDebug = false) {
		// delete all quotes for this group
		Quotegroups::deleteByGroup($id, $blnDebug);

		// delete group record
	    $this->strQuery = 'DELETE FROM `'.$this->strTableName.'` WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

	public static function createGroup($strGroupName = null){
		// create a new quote group you can add quotes too

		// create new instance of this model to do operations too
		$objModel = new static;

		// insert new db record
		$arrKeys = array('status');
		$arrValues = array("'Active'");

		if(!empty($strGroupName)){
			$arrKeys[] = 'group_name';
			$arrValues[] = "'" . str_replace("'", "\'", $strGroupName) . "'";
		}

		$objModel->strQuery = 'INSERT INTO `' . $objModel->strTableName . '` (' . implode(',', $arrKeys) . ') VALUES (' . implode(',', $arrValues) . ') ';

		if($objModel->short_query($objModel->strQuery)) {
			$objModel->strSuccessMessage = 'Record Created';
		} else {
			$objModel->strErrorMessage = 'SQL error:'.$objModel->strQuery;
			return false;
		}

		// return group id that was just created
		return $objModel->mysqli->insert_id;
	}

	public static function getGroupName($intGroupId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT group_name FROM `groups` WHERE id = ' . $intGroupId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults[0]['group_name'];
	}


	public static function getGroupStatus($intGroupId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT status FROM `groups` WHERE id = ' . $intGroupId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults[0]['status'];
	}

	public static function getGroupAdminNote($intGroupId, $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT admin_note FROM `groups` WHERE id = ' . $intGroupId;

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults[0]['admin_note'];
	}

	public static function getAllGroups($arrStatus = null, $strOrderBy = null, $blnDebug = false){
		$objModel = new Static;

		$objModel->strQuery = 'SELECT * FROM `' . $objModel->strTableName . '` WHERE 1 = 1 ';

		if(!empty($arrStatus)){
			if(!is_array($arrStatus)){
				$arrStatus = array($arrStatus);
			}

			$arrStatus = array_map(function($strStatus){
				return "'" . $strStatus . "'";
			}, $arrStatus);

			$objModel->strQuery .= " AND `status` IN (" . implode(',', $arrStatus) . ") ";
		}

		if(!empty($strOrderBy)){
			$objModel->strQuery .= ' ORDER BY ' . $strOrderBy;
		}

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults;
	}

	public static function getGroupQuotes($intGroupId, $arrOptions = array(), $blnDebug = false){
		$objModel = new static;

		$objModel->strQuery = 'SELECT q.*,
									  b.business_name as agency,
									  bp.booking_name as booking_person
								FROM quotes q
								JOIN quote_group qg
								  ON q.id = qg.quote_id
								JOIN brands b
								  ON b.id = q.brandID
								JOIN booking_people bp
								  ON bp.id = q.bookingID
							   WHERE qg.group_id = ' . $intGroupId;

		if(isset($arrOptions['order_by']) && !empty($arrOptions['order_by'])){
			$objModel->strQuery .= ' ORDER BY ' . $arrOptions['order_by'];

			if(isset($arrOptions['order']) && !empty($arrOptions['order'])){
				$objModel->strQuery .= ' ' . $arrOptions['order'];
			}
		}

		if(isset($arrOptions['limit']) && !empty($arrOptions['limit'])){
			$objModel->strQuery .= ' LIMIT ' . $arrOptions['limit'];
		}

		if($blnDebug) {
		 	Util::debugDisplay($objModel->strQuery);
		}

		$arrResults = $objModel->getMysqliResults($objModel->strQuery, true);

		return $arrResults;
	}

    public function getAgency() {
        $strQuery = "SELECT `business_name` FROM `brands` WHERE `status` = 'Active' ORDER BY `business_name`";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            $data = array_column($res, 'business_name');
            return $data;
        } else {
            return null;
        }
    }

    public function getAgencyAll() {
        $strQuery = "SELECT * FROM `brands` WHERE `status` = 'Active' ORDER BY `business_name`";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

     public function getAgentAll() {
        $strQuery = "SELECT * FROM `booking_people` WHERE `status` = 'Active' ORDER BY `booking_name`";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getAgent() {
        $strQuery = "SELECT `booking_name` FROM `booking_people` WHERE `status` = 'Active' ORDER BY `booking_name`";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            $data = array_column($res, 'booking_name');
            return $data;
        } else {
            return null;
        }
    }

}



?>