<?php


class FeaturedPackage extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strPackageName;
	public $strSearchWord;

	public $intID;
	public $intPriority;
	public $intCatID;
	public $intRegionId;
	public $strAction;
	public $strSlug;
	public $strPrice;
	public $strMargin;
	public $strStartDate;
	public $strEndDate;
	public $strDescription;
	public $strShortDescription;
	public $strMiniDescription;

	public $strHotel;
	public $strGolfCourse;
	public $strFacebookTitle;
	public $strFacebookDescription;
	public $strTwitterTitle;
	public $strTwitterDescription;
	public $strGoogleDescription;
	public $intHits;

	public $strFocusKeyword;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $intScoreSEO;

	public $arrHotels;
	public $arrCourse;
	public $arrSelectedBrands;

    public $strVideoEmbed;
    public $strVideoSmallHeading;
    public $strVideoLargeHeading;
    public $strVideoText;
    public $strVideoBtnText;
    public $strVideoLink;

	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'feature_packages';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/featured_package/';

		$this->strTitle = 'Featured Packages';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/packages/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/packages/'.date('Y').'/';

	}

	public function reCalculateCost($intPackageId) {

		$strSQL = "SELECT * FROM feature_packages_hotel
					JOIN hotel_rates ON (hotel_rates.id = feature_packages_hotel.rateID)
					WHERE packageID = $intPackageId";

		$arrPackageHotels = $this->getMysqliResults($strSQL,true);

		$strSQL = "SELECT * FROM feature_packages_course
					JOIN course_rates ON (course_rates.id = feature_packages_course.rateID)
					WHERE packageID = $intPackageId";

		$arrPackageCourses = $this->getMysqliResults($strSQL,true);

		$dblTotalCost = 0;
		$dblFeeTotal = 0;

		foreach ($arrPackageHotels AS $arrPackageHotel) {

			$dblBaseCost = $arrPackageHotel['private_price'] * $arrPackageHotel['room_nights'];

			// Rate Fees
			$strSQL = "SELECT * FROM fees WHERE hotel_rate_id = " . $arrPackageHotel['rateID'];

			$arrFees = $this->getMysqliResults($strSQL, true);

			foreach ($arrFees AS $arrFee) {
				if ($arrFee['private'] == '1') {
					if ($arrFee['calculation_type'] == 'percentage') {
						$dblFeeTotal += ($dblBaseCost * ($arrFee['amount'] / 100));
					}

					if ($arrFee['calculation_type'] == 'flat') {
						if ($arrFee['per_night'] == '1' && $arrFee['per_room'] == '1') {
							$dblFeeTotal += ($arrFee['amount'] * $arrPackageHotel['room_nights']);
						} else {
							$dblFeeTotal += $arrFee['amount'];
						}
					}
				}
			}


			//Season Fees
			$strSQL = "SELECT * FROM fees WHERE hotel_rate_id = (SELECT parent_id FROM hotel_rates WHERE id = " . $arrPackageHotel['rateID'] . ") ";
			$arrFees = $this->getMysqliResults($strSQL,true);

			foreach ($arrFees AS $arrFee) {
				if ($arrFee['private'] == '1') {
					if ($arrFee['calculation_type'] == 'percentage') {
						$dblFeeTotal += ($dblBaseCost * ($arrFee['amount'] / 100));
					}

					if ($arrFee['calculation_type'] == 'flat') {
						if ($arrFee['per_night'] == '1' && $arrFee['per_room'] == '1') {
							$dblFeeTotal += ($arrFee['amount'] * $arrPackageHotel['room_nights']);
						} else {
							$dblFeeTotal += $arrFee['amount'];
						}
					}
				}
			}

			if ($arrPackageHotel['occupancy'] == 0) {
				$arrPackageHotel['occupancy'] = 1;
			}

			$dblTotalCost += ($dblBaseCost + $dblFeeTotal) / $arrPackageHotel['occupancy'];
		}

		$dblFeeTotal = 0;

		foreach ($arrPackageCourses AS $arrPackageCourse) {

			$dblBaseCost = $arrPackageCourse['private_price'] * $arrPackageCourse['rounds'];

			// Rate Fees
			$strSQL = "SELECT * FROM fees WHERE course_rate_id = " . $arrPackageCourse['rateID'];
			$arrFees = $this->getMysqliResults($strSQL, true);

			foreach ($arrFees AS $arrFee) {
				if ($arrFee['private'] == '1') {
					if ($arrFee['calculation_type'] == 'percentage') {
						$dblFeeTotal += ($dblBaseCost * ($arrFee['amount'] / 100));
					}

					if ($arrFee['calculation_type'] == 'flat') {
						if ($arrFee['per_person'] == '1') {
							$dblFeeTotal += ($arrFee['amount'] * $arrPackageCourse['rounds']);
						} else {
							$dblFeeTotal += $arrFee['amount'];
						}
					}
				}
			}

			//Season Fees
			$strSQL = "SELECT * FROM fees WHERE course_rate_id = (SELECT parent_id FROM course_rates WHERE id = " . $arrPackageCourse['rateID'] . ") ";
			$arrFees = $this->getMysqliResults($strSQL, true);

			foreach ($arrFees AS $arrFee) {
				if ($arrFee['private'] == '1') {
					if ($arrFee['calculation_type'] == 'percentage') {
						$dblFeeTotal += ($dblBaseCost * ($arrFee['amount'] / 100));
					}

					if ($arrFee['calculation_type'] == 'flat') {
						if ($arrFee['per_person'] == '1') {
							$dblFeeTotal += ($arrFee['amount'] * $arrPackageCourse['rounds']);
						} else {
							$dblFeeTotal += $arrFee['amount'];
						}
					}
				}
			}

			$dblTotalCost += $dblBaseCost + $dblFeeTotal;
		}

		return $dblTotalCost;
	}

	public function handlePost($post,$id,$debug = false) {

		$this->intID = $id;
		$this->strPackageName = isset($post['title']) ? $post['title'] : '';
		$this->strSlug = isset($post['slug']) ? $post['slug'] : '';
		$this->strPrice = isset($post['price']) ? $post['price'] : '';
		$this->strMargin = isset($post['margin']) ? $post['margin'] : '';
		$this->strStartDate = isset($post['start_date']) ? $post['start_date'] : '';
		$this->strEndDate = isset($post['end_date']) ? $post['end_date'] : '';
		$this->strDescription = isset($post['description']) ? $post['description'] : '';
		$this->strShortDescription = isset($post['short_description']) ? $post['short_description'] : '';
		$this->strMiniDescription = isset($post['mini_description']) ? $post['mini_description'] : '';
		$this->intHits = isset($post['hits']) ? $post['hits'] : '';
		$this->intPriority = isset($post['priority']) ? $post['priority'] : '';
		$this->intRegionId = isset($post['region_id']) ? $post['region_id'] : '';

		$this->strFocusKeyword = isset($post['focus_keyword']) ? $post['focus_keyword'] : '';
		$this->strMetaTitle = isset($post['meta_title']) ? $post['meta_title'] : '';
		$this->strMetaKeywords = isset($post['meta_keywords']) ? $post['meta_keywords'] : '';
		$this->strMetaDescription = isset($post['meta_description']) ? $post['meta_description'] : '';
		$this->strMetaRobots = isset($post['meta_robots']) ? $post['meta_robots'] : "index,follow";
		$this->intScoreSEO = isset($post['score_seo']) ? $post['score_seo'] : 0;

		$this->strFacebookTitle = isset($post['facebook_title']) ? $post['facebook_title'] : '';
		$this->strFacebookDescription = isset($post['facebook_description']) ? $post['facebook_description'] : '';
		$this->strTwitterTitle = isset($post['twitter_title']) ? $post['twitter_title'] : '';
		$this->strTwitterDescription = isset($post['twitter_description']) ? $post['twitter_description'] : '';
		$this->strGoogleDescription = isset($post['google_description']) ? $post['google_description'] : '';

		$this->arrHotel = isset($post['hotel_selected']) ? $post['hotel_selected'] : array();
		$this->arrCourse = isset($post['course_selected']) ? $post['course_selected'] : array();

		$this->arrSelectedBrands = isset($post['brandID']) ? $post['brandID'] : array();

        $this->strVideoEmbed = isset($post['video_embed']) ? $post['video_embed'] : '';
        $this->strVideoSmallHeading = isset($post['video_smallheading']) ? $post['video_smallheading'] : '';
        $this->strVideoLargeHeading= isset($post['video_largeheading']) ? $post['video_largeheading'] : '';
        $this->strVideoText = isset($post['video_text']) ? $post['video_text'] : '';
        $this->strVideoBtnText = isset($post['video_buttontext']) ? $post['video_buttontext'] : '';
        $this->strVideoLink = isset($post['video_link']) ? $post['video_link'] : '';

		//util::debugDisplay($this->arrSelectedBrands);

		if($this->strPackageName == '') { $this->strErrorMessage .= "Please enter a title for this category.<br />"; }
		if($this->strSlug == '' && $this->strPackageName != '') { $this->strSlug = $this->strPackageName; }
		$this->strSlug = str_replace('/featured-golf-packages/','',$this->strSlug);
        $this->strSlug = Util::cleanForUrl($this->strSlug);

		$slug_exists = $this->validSlug($this->strTableName, $this->strSlug, $id);
		if(!empty($slug_exists)){
			$this->strErrorMessage .= "Package with this slug already exists.<br />";
		}


		if($this->strErrorMessage == '') {

			$keys = array('title',
				'slug',
				'price',
				'margin',
				'start_date',
				'end_date',
				'description',
				'focus_keyword',
				'meta_title',
				'meta_keywords',
				'meta_description',
				'meta_robots',
				'score_seo',
				'facebook_title',
				'facebook_description',
				'twitter_title',
				'twitter_description',
				'google_description',
				'priority',
				'short_description',
				'mini_description',
				'region_id',
				'hits',
                'video_embed',
                'video_smallheading',
                'video_largeheading',
                'video_text',
                'video_buttontext',
                'video_link'
			);
			$vals = array( $this->strPackageName,
				$this->strSlug,
				$this->strPrice,
				$this->strMargin,
				$this->strStartDate,
				$this->strEndDate,
				$this->strDescription,
				$this->strFocusKeyword,
				$this->strMetaTitle,
				$this->strMetaKeywords,
				$this->strMetaDescription,
				$this->strMetaRobots,
				$this->intScoreSEO,
                $this->strFacebookTitle,
                $this->strFacebookDescription,
                $this->strTwitterTitle,
                $this->strTwitterDescription,
                $this->strGoogleDescription,
                $this->intPriority,
                $this->strShortDescription,
                $this->strMiniDescription,
                $this->intRegionId,
                $this->intHits,
                $this->strVideoEmbed,
                $this->strVideoSmallHeading,
                $this->strVideoLargeHeading,
                $this->strVideoText,
                $this->strVideoBtnText,
                $this->strVideoLink
			);


			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$id);
				$this->strSuccessMessage = 'Record Saved';

			}


			//insert relationship records
			foreach($this->arrSelectedBrands As $k=>$h) {
				$sql = "INSERT INTO package_brand (brand_id,package_id) Values (".$h.",".$this->intID." ) ON DUPLICATE KEY UPDATE package_id=".$this->intID;
				//echo "<br />".$sql;
				$this->short_query($sql);
			}
			$this->csvBrand = implode(',',$this->arrSelectedBrands);

			//Update Package Course Records
			$sql = "DELETE FROM feature_packages_course WHERE packageID=$this->intID";
			$this->short_query($sql);

			$arrSelectedCourses = array();
			foreach($this->arrCourse As $k=>$h) {

				$strRounds = $_POST['course_rounds'][$k];
				$strRateSelected = $_POST['course_rate'][$k];

				if ($strRounds == '') {
					$strRounds = 'NULL';
				}

				if ($strRateSelected == '') {
					$strRateSelected = 'NULL';
				}

				$sql = "INSERT INTO feature_packages_course (courseID,packageID,rounds,rateID) Values (".$k.",".$this->intID.",$strRounds, $strRateSelected )";

				$this->short_query($sql);
				$arrSelectedCourses[] = $k;
			}

			//Package Hotel Records
			$sql = "DELETE FROM feature_packages_hotel WHERE packageID=$this->intID";
			$this->short_query($sql);

			$arrSelectedHotels = array();
			foreach($this->arrHotel As $k=>$h) {

				$strRoomNights = $_POST['hotel_room_nights'][$k];
				$strRateSelected = $_POST['hotel_rate'][$k];

				if ($strRoomNights == '') {
					$strRoomNights = 'NULL';
				}

				if ($strRateSelected == '') {
					$strRateSelected = 'NULL';
				}

				$sql = "INSERT INTO feature_packages_hotel (hotelID,packageID,room_nights,rateID) Values (".$k.",".$this->intID.",$strRoomNights, $strRateSelected )";

				$this->short_query($sql);
				$arrSelectedHotels[] = $k;

			}

			//Automatically Calculate price
			if (isset($_POST['recalc_price']) && $_POST['recalc_price'] == 'true') {

				$dblCost = $this->reCalculateCost($this->intID) * ($this->strMargin + 1);
				$strSQL = "UPDATE feature_packages SET price = " . number_format($dblCost, 2) . " WHERE id = " . $this->intID;
				$this->short_query($strSQL);
			}


			$sql = "DELETE FROM package_brand WHERE package_id=$this->intID AND brand_id not in ($this->csvBrand)";
			$this->short_query($sql);
			//Util::debugDisplay($sql);


            if($_FILES['file_name']['error'] != 4) {
				$arrUploaded = Util::uploadFile(
	                $_FILES['file_name'],
	                $this->strUploadsDir,
	                $this->intID.'_course_img',
	                array('image/*'),
	                true,
	                true
	            );

				if($debug) {
	            	Util::debugDisplay($arrUploaded);
	            }

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET file_name = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($debug) {
		                Util::debugDisplay('<br />strQuery='.$this->strQuery);
		            }
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br /> Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }



			$arrUploaded = Util::uploadFile(
                $_FILES['facebook_image'],
                $this->strUploadsDir,
                $this->intID.'_facebook_img',
                array('image/*'),
                true,
                true
            );

			if($debug) {
            	Util::debugDisplay($arrUploaded);
            }


            if ($arrUploaded) {
                // If the file uploaded successfully
                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                $fileName = $url.$arrUploaded['file'];

                $this->strQuery = 'UPDATE '.$this->strTableName.' SET facebook_image = \''.$fileName.'\' WHERE id=' . $this->intID;
                if($debug) {
	                Util::debugDisplay('<br />strQuery='.$this->strQuery);
	            }
                if($this->short_query($this->strQuery)) {
                    $this->strSuccessMessage .= '<br /> Facebook Image Updated';
                } else {
                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                }
            }

			$arrUploaded = Util::uploadFile(
                $_FILES['twitter_image'],
                $this->strUploadsDir,
                $this->intID.'_twitter_img',
                array('image/*'),
                true,
                true
            );

			if($debug) {
            	Util::debugDisplay($arrUploaded);
            }


            if ($arrUploaded) {
                // If the file uploaded successfully
                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                $fileName = $url.$arrUploaded['file'];

                $this->strQuery = 'UPDATE '.$this->strTableName.' SET twitter_image = \''.$fileName.'\' WHERE id=' . $this->intID;
                if($debug) {
	                Util::debugDisplay('<br />strQuery='.$this->strQuery);
	            }
                if($this->short_query($this->strQuery)) {
                    $this->strSuccessMessage .= '<br /> Twitter Image Updated';
                } else {
                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                }
            }









        } //error message check





        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		$this->intID = $id;

		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		From $this->strTableName
		WHERE id=$id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {
	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0];


	     	$this->strPackageName = isset($result['title']) ? $result['title'] : '';
	     	$this->strFileName = isset($result['file_name']) ? $result['file_name'] : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
			$this->strPrice = isset($result['price']) ? $result['price'] : '';
			$this->strMargin = isset($result['margin']) ? $result['margin'] : '';
			$this->strStartDate = isset($result['start_date']) ? $result['start_date'] : '';
			$this->strEndDate = isset($result['end_date']) ? $result['end_date'] : '';
			$this->strDescription = isset($result['description']) ? $result['description'] : '';
			$this->strShortDescription = isset($result['short_description']) ? $result['short_description'] : '';
			$this->strMiniDescription = isset($result['mini_description']) ? $result['mini_description'] : '';
			$this->intPriority = isset($result['priority']) ? $result['priority'] : '';
			$this->intRegionId = isset($result['region_id']) ? $result['region_id'] : '';
			$this->intHits = isset($result['hits']) ? $result['hits'] : '';

			$this->strFocusKeyword = isset($result['focus_keyword']) ? $result['focus_keyword'] : '';
			$this->strMetaTitle = isset($result['meta_title']) ? $result['meta_title'] : '';
			$this->strMetaKeywords = isset($result['meta_keywords']) ? $result['meta_keywords'] : '';
			$this->strMetaDescription = isset($result['meta_description']) ? $result['meta_description'] : '';
			$this->strMetaRobots = isset($result['meta_robots']) ? $result['meta_robots'] : "index,follow";
			$this->strFacebookTitle = isset($result['facebook_title']) ? $result['facebook_title'] : '';
			$this->strFacebookDescription = isset($result['facebook_description']) ? $result['facebook_description'] : '';
			$this->strTwitterTitle = isset($result['twitter_title']) ? $result['twitter_title'] : '';
			$this->strTwitterDescription = isset($result['twitter_description']) ? $result['twitter_description'] : '';
			$this->strGoogleDescription = isset($result['google_description']) ? $result['google_description'] : '';
			$this->strFacebookImage = isset($result['facebook_image']) ? $result['facebook_image'] : '';
			$this->strTwitterImage = isset($result['twitter_image']) ? $result['twitter_image'] : '';

			$this->strHotel = isset($result['hotel']) ? $result['hotel'] : '';
			$this->strGolfCourse = isset($result['golf_course']) ? $result['golf_course'] : '';
			$this->strSlug = '/featured-golf-packages/'.$this->strSlug;

            $this->strVideoEmbed = isset($result['video_embed']) ? $result['video_embed'] : '';
            $this->strVideoSmallHeading = isset($result['video_smallheading']) ? $result['video_smallheading'] : '';
            $this->strVideoLargeHeading= isset($result['video_largeheading']) ? $result['video_largeheading'] : '';
            $this->strVideoText = isset($result['video_text']) ? $result['video_text'] : '';
            $this->strVideoBtnText = isset($result['video_buttontext']) ? $result['video_buttontext'] : '';
            $this->strVideoLink = isset($result['video_link']) ? $result['video_link'] : '';


			$strQuery = "SELECT *
			From feature_packages_hotel
			WHERE packageID=$id";
			if($this->query($strQuery)) {
	     		$result2 = $this->getMysqliResults($strQuery,true);
	     		$this->arrHotels = $result2;
	     	}

	     	$strQuery = "SELECT *
			From feature_packages_course
			WHERE packageID=$id";
			if($this->query($strQuery)) {
	     		$result2 = $this->getMysqliResults($strQuery,true);
	     		$this->arrCourse = $result2;
	     	}

	     	$this->arrSelectedBrands = array();

	     	$strQuery = "SELECT brand_id
			From package_brand
			WHERE package_id=$id";
			if($this->query($strQuery)) {
	     		$result2 = $this->getMysqliResults($strQuery,true);
	     		//$this->arrSelectedBrands = $result2;
	     		foreach($result2 AS $r){
	     			$this->arrSelectedBrands[] = $r['brand_id'];
	     		}

	     	}

	     	// Score the SEO content of the page
            if (class_exists('SEO_Scorer')) {
                $objScore = new SEO_Scorer(array(
                    'keyword' => $this->strFocusKeyword,
                    'meta_title' => $this->strMetaTitle,
                    'meta_description' => $this->strMetaDescription,
                    'meta_robots' => $this->strMetaRobots,
                    'content' => $this->strDescription,
                    'url' => $this->strSlug
                ));
                $this->arrScore = $objScore->getScore();
            }

	     	return $result;

	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.type_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, r.`region_name`
	     FROM $this->strTableName t
	     LEFT JOIN region r on r.`id`=t.`region_id`
	     WHERE t.id>0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.title like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getStatus() {
		$strQuery = "SELECT * FROM order_status ORDER BY status_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getBooking() {
		$strQuery = "SELECT * FROM booking_people ORDER BY booking_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getBrands() {
		$strQuery = "SELECT * FROM brands ORDER BY business_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getSelectedBrands($package_id,$debug = false) {
		$strQuery = "SELECT brand_id FROM package_brand WHERE package_id=$package_id";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}


	public function getRegions() {
		$strQuery = "SELECT * FROM region WHERE status='Active' ORDER BY region_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getHotels() {
		$strQuery = "SELECT h.*, t.title
		FROM hotel h
		LEFT JOIN city t ON t.id=h.city_id
		WHERE h.status='Active'
		ORDER BY h.hotel_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getCourses() {
		$strQuery = "SELECT p.id,  p.type_id, p.course_name, p.address, p.comments, t.title, s.state_name, s.short_name
			FROM course p
			LEFT JOIN course_type y ON y.id = p.type_id
			LEFT JOIN city t ON t.id=p.city_id
			LEFT JOIN state s ON s.id=t.state_id
			LEFT JOIN country c ON c.id=s.country_id
			LEFT JOIN members m ON m.id=p.member_id
			WHERE p.status='Active'
			AND (p.type_id='7' OR p.type_id='3')
			ORDER BY p.course_name ASC ";

		//echo '$strQuery='.$strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }
	}

	public function getCoursesForPackage($packageID) {

		$strQuery = "SELECT p.*, c.course_name
		FROM package_golf p
		LEFT JOIN course c on c.id=p.course_id
		WHERE package_id=".$packageID;

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function getHotelsForPackage($packageID) {

		$strQuery = "SELECT p.*, h.hotel_name
		FROM package_hotel p
		LEFT JOIN hotel h on h.id=p.hotel_id
		WHERE package_id=".$packageID;

		//echo $strQuery;

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	     	return null;
	    }


	}

	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}



}



?>