<?php


class Coursereview extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $intID;
	public $intReviewID;
	public $strAction;
	public $strFirstName;
	public $strLastName;
	public $strEmail;
	public $strPlayedDate;
	public $strPostedDate ;
	public $strDetail;
	public $blnApproved;




	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->intReviewID = isset($_REQUEST['review_id']) ? $_REQUEST['review_id'] : '';
		$this->strErrorMessage = "";
		$this->strTableName = 'course_reviews';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/course/';

		//$this->strUploadsDir = ROOT_DIR.'/application/uploads/courses/'.date('Y').'/';
        //$this->strUploadsUrl = ROOT_URL.'/application/uploads/courses/'.date('Y').'/';

		$this->strTitle = 'Course Reviews';





	}




	public function handlePost($post,$id, $debug = false) {
		$this->intID = $id;

		$this->strFirstName = isset($post['first_name']) ? trim($post['first_name']) : '';
		$this->strLastName = isset($post['last_name']) ? $post['last_name'] : '';
		$this->strEmail = isset($post['user_email']) ? $post['user_email'] : '';
		$this->strPlayedDate = isset($post['played_date']) ? $post['played_date'] : '';
		$this->strPostedDate  = isset($post['post_date']) ? $post['post_date'] : '';
		$this->strDetail = isset($post['detail']) ? $post['detail'] : '';
		$this->blnApproved = isset($post['approved']) ? $post['approved'] : 0;


		if($this->strFirstName == '') { $this->strErrorMessage = "Please enter a first name."; }
		if($this->strLastName == '') { $this->strErrorMessage = "Please enter a last name."; }
		if($this->strEmail == '') { $this->strErrorMessage = "Please enter a email."; }
		if($this->strPlayedDate == '') { $this->strErrorMessage = "Please enter a played date."; }
		if($this->strPostedDate == '') { $this->strErrorMessage = "Please enter a posted date."; }
		if($this->strDetail == '') { $this->strErrorMessage = "Please enter the comment."; }


		if($this->strErrorMessage == '') {


			$keys = array('first_name','last_name','user_email','played_date','post_date','detail','approved','course_id');
			$vals = array( $this->strFirstName,$this->strLastName,$this->strEmail,$this->strPlayedDate,$this->strPostedDate ,$this->strDetail,$this->blnApproved,$this->intID);
			

			if($this->intReviewID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intReviewID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added';


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intReviewID);
				$this->strSuccessMessage = 'Record Saved:';

				if($debug) {
			 		Util::debugDisplay('<br />intReviewID='.$this->intReviewID);
			 		Util::debugDisplay($keys);
			 		Util::debugDisplay($vals);
				}

			}


        } //error message check

        return $this->intReviewID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.* 
		From $this->strTableName t   
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];

			$this->strFirstName = isset($result['first_name']) ? trim($result['first_name']) : '';
			$this->strLastName = isset($result['last_name']) ? $result['last_name'] : '';
			$this->strEmail = isset($result['user_email']) ? $result['user_email'] : '';
			$this->strPlayedDate = isset($result['played_date']) ? $result['played_date'] : '';
			$this->strPostedDate  = isset($result['post_date']) ? $result['post_date'] : '';
			$this->strDetail = isset($result['detail']) ? $result['detail'] : '';
			$this->blnApproved = isset($result['approved']) ? $result['approved'] : '';

	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name  
	     From $this->strTableName t  
	     Left Join members m on m.id=t.member_id 
	     Left Join course_type c on c.id=t.type_id 
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getCategories() {

		$strQuery = "SELECT * 
		FROM course_type WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getManagers() {

		$strQuery = "SELECT * 
		FROM members where level>0 and confirmed=1 and approved=1 And status='Active' order by email asc";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}


	public function getCourseImageList($course_id, $debug = false) {
		/*
		Import sql to insert new records from the files table 
		INSERT INTO course_img (title,file_name,course_id,display_order)
		SELECT file_title As title, concat('/application/uploads/courses/',file_name) As file_name, cat_id As course_id, file_num As display_order FROM files WHERE section_name='golf course' 

		*/

		$strQuery = "SELECT * 
		FROM course_img where course_id=$course_id";
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }






	}




	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id, $debug = false) {
/*
	    $this->strQuery = 'SELECT file_name FROM '.$this->strTableName.' WHERE id=' . $id;
	    

		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$file_name = $res[0]['file_name'];
	     	if(file_exists(ROOT_DIR.$file_name)) {
	     		unlink(ROOT_DIR.$file_name);
	     		Util::debugDisplay('delete='.ROOT_DIR.$file_name);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$file_name='.ROOT_DIR.$file_name);
		}
*/

		//die();



	
	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>