<?php


class Courseimg extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strEmail;
	public $strPhone;
	public $strTitle;

	public $intID;
	public $strImageName;
	public $strAltText;
	public $blnPrimary;
	public $strDisplayOrder;
	public $strAction;




	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->imgID = isset($_REQUEST['img_id']) ? $_REQUEST['img_id'] : '';
		$this->strErrorMessage = "";
		$this->strTableName = 'course_img';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/course/';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/courses/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/courses/'.date('Y').'/';

		$this->strTitle = 'Course Images';




	}


    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function handlePost($post,$id, $debug = false) {
		$this->intID = $id;
		$this->strImageName = isset($post['title']) ? trim($post['title']) : '';
		$this->strAltText = isset($post['alt']) ? trim($post['alt']) : '';
		$this->blnPrimary = isset($post['blnPrimary']) ? $post['blnPrimary'] : '';
		$this->strDisplayOrder = isset($post['display_order']) ? $post['display_order'] : '';

		if(!is_numeric($this->strDisplayOrder)) { $this->strDisplayOrder = 1; }

		//if($this->strCourseName == '') { $this->strErrorMessage .= "Please enter a name for this course.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array(
				'title',
				'alt',
				'blnPrimary',
				'course_id',
				'display_order'
			);
			$vals = array(
				$this->strImageName,
				$this->strAltText,
				$this->blnPrimary,
				$this->intID,
				$this->strDisplayOrder
			);
			// $types = array('siii');

			if($this->imgID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->imgID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added';


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->imgID);
				$this->strSuccessMessage = 'Record Saved:'.$this->strImageName;

				if($debug) {
			 		Util::debugDisplay('<br />imageID='.$this->imgID);
			 		Util::debugDisplay($keys);
			 		Util::debugDisplay($vals);
				}

			}

			if($this->blnPrimary) {
				$sql = "UPDATE $this->strTableName SET `blnPrimary`=0 WHERE course_id=$this->intID AND id <> $this->imgID";
				//Util::debugDisplay($sql);
				//die();
				$this->short_query($sql);
			}




			// Upload our image
			//uploadFile($file, $path, $newFileName = null, $allowedTypes = null, $fileOverwrite = true, $debug = false)
            $arrUploaded = Util::uploadFile(
                $_FILES['file_name'],
                $this->strUploadsDir,
                $this->imgID.'_course_img',
                array('image/*'),
                true,
                true
            );

			if($debug) {
            	Util::debugDisplay($arrUploaded);
            }


            if ($arrUploaded) {
                // If the file uploaded successfully
                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                $fileName = $url.$arrUploaded['file'];

                $this->strQuery = 'UPDATE '.$this->strTableName.' SET file_name = \''.$fileName.'\' WHERE id=' . $this->imgID;
                if($debug) {
	                Util::debugDisplay('<br />strQuery='.$this->strQuery);
	            }
                if($this->short_query($this->strQuery)) {
                    $this->strSuccessMessage .= '<br /> Image Updated';
                } else {
                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                }
            }

			if($debug) {
			 	Util::debugDisplay('<br />imageID='.$this->imgID);
			}


        } //error message check

        return $this->imgID;

	}



	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*
		From $this->strTableName t
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {
			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];

			$this->strImageName = isset($result['title']) ? trim($result['title']) : '';
			$this->strAltText = isset($result['alt']) ? trim($result['alt']) : '';
			$this->strDisplayOrder = isset($result['display_order']) ? $result['display_order'] : '';
			$this->blnPrimary = isset($result['blnPrimary']) ? $result['blnPrimary'] : '';
			$this->strFileName = isset($result['file_name']) ? $result['file_name'] : '';

	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.hotel_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, m.email, c.type_name
	     From $this->strTableName t
	     Left Join members m on m.id=t.member_id
	     Left Join course_type c on c.id=t.type_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.hotel_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getCategories() {

		$strQuery = "SELECT *
		FROM course_type WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getManagers() {

		$strQuery = "SELECT *
		FROM members where level>0 and confirmed=1 and approved=1 And status='Active' order by email asc";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}


	public function getCourseImageList($course_id, $debug = false) {
		/*
		Import sql to insert new records from the files table
		INSERT INTO course_img (title,file_name,course_id,display_order)
		SELECT file_title As title, concat('/application/uploads/courses/',file_name) As file_name, cat_id As course_id, file_num As display_order FROM files WHERE section_name='golf course'

		*/

		$strQuery = "SELECT *
		FROM course_img where course_id=$course_id";
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }






	}




	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id, $debug = false) {

	    $this->strQuery = 'SELECT file_name FROM '.$this->strTableName.' WHERE id=' . $id;


		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$file_name = $res[0]['file_name'];
	     	if(file_exists(ROOT_DIR.$file_name)) {
	     		unlink(ROOT_DIR.$file_name);
	     		Util::debugDisplay('delete='.ROOT_DIR.$file_name);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$file_name='.ROOT_DIR.$file_name);
		}


		//die();




	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>