<?php


class Coursedoc extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strEmail;
	public $strPhone;
	public $strTitle;

	public $intID;
	public $strAction;

	public $strDescription;
	public $strFileName;

	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->imgID = isset($_REQUEST['img_id']) ? $_REQUEST['img_id'] : '';
		$this->strErrorMessage = "";
		$this->strTableName = 'course_files';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/course/';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/courses/docs/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/courses/docs/'.date('Y').'/';

		$this->strTitle = 'Course Documents';




	}




	public function handlePost($post,$id, $debug = false) {
		$this->intID = $id;
		$this->strDescription = isset($post['description']) ? trim($post['description']) : '';

		//if($this->strCourseName == '') { $this->strErrorMessage .= "Please enter a name for this course.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array('description','course_id');
			$vals = array( $this->strDescription,$this->intID);
			$types = array('si');

			if($this->imgID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,$types);
				$this->imgID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added';


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$this->imgID);
				$this->strSuccessMessage = 'Record Saved:'.$this->strTitle;

				if($debug) {
			 		Util::debugDisplay('<br />docID='.$this->imgID);
			 		Util::debugDisplay($keys);
			 		Util::debugDisplay($vals);
				}

			}


			// Upload our image
			//uploadFile($file, $path, $newFileName = null, $allowedTypes = null, $fileOverwrite = true, $debug = false)
            $arrUploaded = Util::uploadFile(
                $_FILES['file_name'],
                $this->strUploadsDir,
                $this->imgID.'_course_doc',
                array('application/excel','application/mspowerpoint','application/msword','application/powerpoint','application/pdf','application/zip','application/rar','application/xml','application/rtf','application/plain'), //options are image/*
                true,
                false
            );

			if($debug) {
            	Util::debugDisplay($arrUploaded);
            }


            if (is_array($arrUploaded)) {
                // If the file uploaded successfully
                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                $fileName = $url.$arrUploaded['file'];

                $this->strQuery = 'UPDATE '.$this->strTableName.' SET file_name = \''.$fileName.'\' WHERE id=' . $this->imgID;
                if($debug) {
	                Util::debugDisplay('<br />strQuery='.$this->strQuery);
	            }
                if($this->short_query($this->strQuery)) {
                    $this->strSuccessMessage .= '<br /> Document Updated';
                } else {
                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                }
            } else {

            	$this->strErrorMessage = $arrUploaded;
            }

			if($debug) {
			 	Util::debugDisplay('<br />docID='.$this->imgID);
			}


        } //error message check

        return $this->imgID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id, $debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*
		From $this->strTableName t
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);

			$this->strDescription = $result[0]['description'];
			$this->strFileName = $result[0]['file_name'];

	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.file_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*
	     From $this->strTableName t
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.file_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}




	public function getCourseDocList($course_id, $debug = false) {

		/*
		UPDATE hotel_files SET file_name= concat('/application/uploads/hotels/docs/2013/',file_name)

		*/


		$strQuery = "SELECT *
		FROM hotel_files where hotel_id=$course_id";
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}




	public function updateStatus($id,$status, $debug = false) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id, $debug = false) {

	    $this->strQuery = 'SELECT file_name FROM '.$this->strTableName.' WHERE id=' . $id;


		if($this->query($this->strQuery)) {
	     	$res = $this->getMysqliResults($this->strQuery,true);
	     	$file_name = $res[0]['file_name'];
	     	if(file_exists(ROOT_DIR.$file_name)) {
	     		unlink(ROOT_DIR.$file_name);
	     		Util::debugDisplay('delete='.ROOT_DIR.$file_name);
	     	}
	    }

	    if($debug) {
	    	Util::debugDisplay($this->strQuery);
		 	Util::debugDisplay('$file_name='.ROOT_DIR.$file_name);
		}


		//die();




	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}


	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>