<?php


class Course extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strCourseName;
	public $strEmail;
	public $strPhone;
	public $strTitle;
	public $strSlug;
	public $intStateId;
	public $intCountryId;
	public $intCityId;
	public $intTypeId;
	public $intHits;
	public $strAddress;
	public $strZip;
	public $records;

	public $strLatitude;
	public $strLongitude;
	public $strContactPerson;
	public $strContactPhone;
	public $strContactFax;
	public $strContactEmail;
	public $strTeetimesPhone;
	public $strTeetimesEmail;
	public $strClubhousePhone;
	public $strProshopPhone;
	public $strAccountName ;
	public $strAccountEmail;
	public $strWebUrl ;
	public $strFacebookUrl;
	public $strTwitterUrl ;
	public $strComments ;

	public $strTeeBoxes = array();
	public $str9Holes = array();
	public $str18Holes = array();
	public $strSearchWord;
	public $strPromotions;
	public $strDirections;
	public $strBookingPolicies;

	public $strFocusKeyword;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
	public $intScoreSEO;
	public $strFacebookTitle;
	public $strFacebookDescription;
	public $strTwitterTitle;
	public $strTwitterDescription;
	public $strGoogleDescription;

	public $strUploadsDir;
    public $strUploadsUrl;
    public $arrFilesToDelete;
    public $strDisplayImage;

	public $intID;
	public $strAction;
	public $strFeeNote;
	public $strTaxInc;
	public $strGm;
	public $strDirGolf;
	public $strHeadPro;
	public $strSeasonal;
	public $strMembershipType;
	public $strHoles;
	public $strCoursePar;
	public $strTeachingProfessionals;
	public $strCourseSuperintendent;
	public $strBanqFac;
	public $strMaxCap;
	public $strCoordinator;
	public $strCourseAmenities ;
	public $strCourseArchitects ;
	public $strCourseComments ;
	public $strCourseAComments ;
	public $strStatus;
	public $intLevel;

	public $strBookingReportEmail;
	public $strBookingReportFrequency;

	public $strBookingUrl;
	public $strBookingUsername;
	public $strBookingPassword;

	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'course';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/course/';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/courses/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/courses/'.date('Y').'/';

		$this->strTitle = 'Courses';

		$tb = array('Tee_Box'=>'','Yardage'=>'','Par'=>'','Rating'=>'','Slope'=>'');
		for($i=1;$i <=6;$i++) {
			$this->strTeeBoxes[] = $tb;
		}

		$this->strTeeBoxes = json_encode($this->strTeeBoxes);


		$h9 = array('hole9'=>'','mon'=>'','tue'=>'','wed'=>'','thu'=>'','fri'=>'','sat'=>'','sun'=>'');
		for($i=1;$i <=6;$i++) {
			$this->str9Holes[] = $h9;
		}

		$this->str9Holes = json_encode($this->str9Holes);

		$h18 = array('hole18'=>'','mon2'=>'','tue2'=>'','wed2'=>'','thu2'=>'','fri2'=>'','sat2'=>'','sun2'=>'');
		for($i=1;$i <=6;$i++) {
			$this->str18Holes[] = $h18;
		}

		$this->str18Holes = json_encode($this->str18Holes);

	}


	public function handlePost($post,$id,$debug = false) {
		$this->intID = $id;
		$this->strCourseName = isset($post['course_name']) ? trim($post['course_name']) : '';
		$this->strStatus = isset($post['status']) ? trim($post['status']) : '';
		$this->strSlug = isset($post['slug']) ? $post['slug'] : '';
		$this->intTypeId = isset($post['type_id']) ? $post['type_id'] : '';
		$this->intHits = isset($post['hit_counter']) ? $post['hit_counter'] : '';
		$this->intCityId = isset($post['city_id']) ? $post['city_id'] : '';
		$this->intLevel = isset($post['level']) ? $post['level'] : '';

		$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
		$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->strZip = isset($post['zip']) ? $post['zip'] : '';
		$this->strLatitude = isset($post['latitude']) ? $post['latitude'] : '';
		$this->strLongitude = isset($post['longitude']) ? $post['longitude'] : '';
		$this->strContactPerson = isset($post['contact_person']) ? $post['contact_person'] : '';
		$this->strContactPhone = isset($post['contact_phone']) ? $post['contact_phone'] : '';
		$this->strContactFax = isset($post['contact_fax']) ? $post['contact_fax'] : '';
		$this->strContactEmail = isset($post['contact_email']) ? $post['contact_email'] : '';
		$this->strAccountEmail = isset($post['account_email']) ? $post['account_email'] : '';
		$this->strAccountName = isset($post['account_name']) ? $post['account_name'] : '';
		$this->strWebUrl = isset($post['web_url']) ? $post['web_url'] : '';
		$this->strFacebookUrl = isset($post['facebook_url']) ? $post['facebook_url'] : '';
		$this->strTwitterUrl = isset($post['twitter_url']) ? $post['twitter_url'] : '';
		$this->strComments = isset($post['comments']) ? $post['comments'] : '';
		$this->strComments = Util::cleanWordText($this->strComments);

		$this->strTeetimesPhone = isset($post['teetimes_phone']) ? $post['teetimes_phone'] : '';
		$this->strTeetimesEmail = isset($post['teetimes_email']) ? $post['teetimes_email'] : '';
		$this->strClubhousePhone = isset($post['clubhouse_phone']) ? $post['clubhouse_phone'] : '';
		$this->strProshopPhone = isset($post['proshop_phone']) ? $post['proshop_phone'] : '';
		$this->strPromotions = isset($post['promotions']) ? $post['promotions'] : '';
		$this->strDirections = isset($post['directions']) ? $post['directions'] : '';
		$this->strBookingPolicies = isset($post['booking_policies']) ? $post['booking_policies'] : '';

		$this->strFocusKeyword = isset($post['focus_keyword']) ? $post['focus_keyword'] : '';
		$this->strMetaTitle = isset($post['meta_title']) ? $post['meta_title'] : '';
		$this->strMetaKeywords = isset($post['meta_keywords']) ? $post['meta_keywords'] : '';
		$this->strMetaDescription = isset($post['meta_description']) ? $post['meta_description'] : '';
		$this->strMetaRobots = isset($post['meta_robots']) ? $post['meta_robots'] : "index,follow";
		$this->intScoreSEO = isset($post['score_seo']) ? $post['score_seo'] : 0;
		$this->strFacebookTitle = isset($post['facebook_title']) ? $post['facebook_title'] : '';
		$this->strFacebookDescription = isset($post['facebook_description']) ? $post['facebook_description'] : '';
		$this->strTwitterTitle = isset($post['twitter_title']) ? $post['twitter_title'] : '';
		$this->strTwitterDescription = isset($post['twitter_description']) ? $post['twitter_description'] : '';
		$this->strGoogleDescription = isset($post['google_description']) ? $post['google_description'] : '';

		$this->strFeeNote = isset($post['fee_note']) ? $post['fee_note'] : '';
		$this->strTaxInc = isset($post['tax_inc']) ? $post['tax_inc'] : '';
		$this->strGm = isset($post['gm']) ? $post['gm'] : '';
		$this->strDirGolf = isset($post['dir_golf']) ? $post['dir_golf'] : '';
		$this->strHeadPro = isset($post['head_pro']) ? $post['head_pro'] : '';
		$this->strSeasonal = isset($post['seasonal']) ? $post['seasonal'] : '';
		$this->strMembershipType = isset($post['membership_type']) ? $post['membership_type'] : '';
		$this->strHoles = isset($post['holes']) ? $post['holes'] : '';
		$this->strCoursePar = isset($post['course_par']) ? $post['course_par'] : '';
		$this->strTeachingProfessionals = isset($post['teaching_professionals']) ? $post['teaching_professionals'] : '';
		$this->strCourseSuperintendent = isset($post['course_superintendent']) ? $post['course_superintendent'] : '';
		$this->strBanqFac = isset($post['banq_fac']) ? $post['banq_fac'] : '';
		$this->strMaxCap = isset($post['max_cap']) ? $post['max_cap'] : '';
		$this->strCoordinator = isset($post['coordinator']) ? $post['coordinator'] : '';
		$this->strCourseAmenities = isset($post['course_amenities']) ? $post['course_amenities'] : '';
		$this->strCourseArchitects = isset($post['course_architects']) ? $post['course_architects'] : '';
		$this->strCourseComments = isset($post['course_comments']) ? $post['course_comments'] : '';
		$this->strCourseAComments = isset($post['course_a_comments']) ? $post['course_a_comments'] : '';

		$this->arrFilesToDelete = isset($post['files_to_delete']) ? $post['files_to_delete'] : '';

		$this->strBookingReportEmail = isset($post['booking_report_email']) ? $post['booking_report_email'] : '';
		$this->strBookingReportFrequency = isset($post['booking_report_frequency']) ? $post['booking_report_frequency'] : '';

		$this->strBookingUrl = isset($post['booking_url']) ? $post['booking_url'] : '';
		$this->strBookingUsername = isset($post['booking_username']) ? $post['booking_username'] : '';
		$this->strBookingPassword = isset($post['booking_password']) ? $post['booking_password'] : '';

		$tb = $post['Tee_Boxes'];
		$y = $post['Yardage'];
		$p = $post['Par'];
		$r = $post['Rating'];
		$s = $post['Slope'];

		$tb2[] = array();
		$i = 0;
		foreach($tb As $data){
			$tb2[$i]['Tee_Box'] = $data;
			$i++;
		}
		$i = 0;
		foreach($y As $data){
			$tb2[$i]['Yardage'] = $data;
			$i++;
		}
		$i = 0;
		foreach($p As $data){
			$tb2[$i]['Par'] = $data;
			$i++;
		}
		$i = 0;
		foreach($r As $data){
			$tb2[$i]['Rating'] = $data;
			$i++;
		}
		$i = 0;
		foreach($s As $data){
			$tb2[$i]['Slope'] = $data;
			$i++;
		}

		$this->strTeeBoxes = json_encode($tb2);



		$h9 = $post['9_Holes'];
		$mon = $post['mon'];
		$tue = $post['tue'];
		$wed = $post['wed'];
		$thu = $post['thu'];
		$fri = $post['fri'];
		$sat = $post['sat'];
		$sun = $post['sun'];

		$h2[] = array();
		$i = 0;
		foreach($h9 As $data){
			$h2[$i]['hole9'] = $data;
			$i++;
		}

		$i = 0;
		foreach($mon As $data){
			$h2[$i]['mon'] = $data;
			$i++;
		}

		$i = 0;
		foreach($tue As $data){
			$h2[$i]['tue'] = $data;
			$i++;
		}

		$i = 0;
		foreach($wed As $data){
			$h2[$i]['wed'] = $data;
			$i++;
		}

		$i = 0;
		foreach($thu As $data){
			$h2[$i]['thu'] = $data;
			$i++;
		}
		$i = 0;
		foreach($tue As $data){
			$h2[$i]['fri'] = $data;
			$i++;
		}
		$i = 0;
		foreach($sat As $data){
			$h2[$i]['sat'] = $data;
			$i++;
		}
		$i = 0;
		foreach($sun As $data){
			$h2[$i]['sun'] = $data;
			$i++;
		}

		$this->str9Holes = json_encode($h2);


		$h18 = $post['18_Holes'];
		$mon = $post['mon2'];
		$tue = $post['tue2'];
		$wed = $post['wed2'];
		$thu = $post['thu2'];
		$fri = $post['fri2'];
		$sat = $post['sat2'];
		$sun = $post['sun2'];

		$h3[] = array();
		$i = 0;
		foreach($h18 As $data){
			$h3[$i]['hole18'] = $data;
			$i++;
		}

		$i = 0;
		foreach($mon As $data){
			$h3[$i]['mon2'] = $data;
			$i++;
		}

		$i = 0;
		foreach($tue As $data){
			$h3[$i]['tue2'] = $data;
			$i++;
		}

		$i = 0;
		foreach($wed As $data){
			$h3[$i]['wed2'] = $data;
			$i++;
		}

		$i = 0;
		foreach($thu As $data){
			$h3[$i]['thu2'] = $data;
			$i++;
		}
		$i = 0;
		foreach($fri As $data){
			$h3[$i]['fri2'] = $data;
			$i++;
		}
		$i = 0;
		foreach($sat As $data){
			$h3[$i]['sat2'] = $data;
			$i++;
		}
		$i = 0;
		foreach($sun As $data){
			$h3[$i]['sun2'] = $data;
			$i++;
		}

		$this->str18Holes = json_encode($h3);


		if($this->strSlug == '' && $this->strCourseName != '') { $this->strSlug = $this->strCourseName; }
		$this->strSlug = str_replace('/golf-courses/','',$this->strSlug);
        $this->strSlug = Util::cleanForUrl($this->strSlug);

		$slug_exists = $this->validSlug($this->strTableName, $this->strSlug, $id);

		if(!empty($slug_exists)){
			$this->strErrorMessage .= "Post with this slug already exists.<br />";
		}


		if($this->strCourseName == '') { $this->strErrorMessage .= "Please enter a name for this course.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array(
				'course_name',
				'slug',
				'type_id',
				'city_id',
				'address',
				'zip',
				'latitude',
				'longitude',
				'contact_person',
				'contact_phone',
				'contact_fax',
				'contact_email',
				'account_email',
				'account_name',
				'web_url',
				'facebook_url',
				'twitter_url',
				'comments',
				'teetimes_phone',
				'teetimes_email',
				'clubhouse_phone',
				'proshop_phone',
				'promotions',
				'directions',
				'booking_policies',
				'tee_boxes',
				'9holes',
				'18holes',
				'tax_inc',
				'fee_note',
				'gm',
				'dir_golf',
				'head_pro',
				'seasonal',
				'membership_type',
				'holes',
				'course_par',
				'teaching_professionals',
				'course_superintendent',
				'banq_fac',
				'max_cap',
				'coordinator',
				'course_amenities',
				'course_architects',
				'course_comments',
				'course_a_comments',
				'hit_counter',
				'status',
				'edit_date',
				'level',
				'focus_keyword',
				'meta_title',
				'meta_keywords',
				'meta_description',
				'meta_robots',
				'score_seo',
				'facebook_title',
				'facebook_description',
				'twitter_title',
				'twitter_description',
				'google_description',
				'booking_report_email',
				'booking_report_frequency',
				'booking_url',
				'booking_username',
				'booking_password'
			);
			$vals = array(
				$this->strCourseName,
				$this->strSlug,
				$this->intTypeId,
				$this->intCityId,
				$this->strAddress,
				$this->strZip,
				$this->strLatitude,
				$this->strLongitude,
				$this->strContactPerson,
				$this->strContactPhone,
				$this->strContactFax,
				$this->strContactEmail,
				$this->strAccountEmail,
				$this->strAccountName,
				$this->strWebUrl,
				$this->strFacebookUrl,
				$this->strTwitterUrl,
				$this->strComments,
				$this->strTeetimesPhone,
				$this->strTeetimesEmail,
				$this->strClubhousePhone,
				$this->strProshopPhone,
                $this->strPromotions,
                $this->strDirections,
                $this->strBookingPolicies,
                $this->strTeeBoxes,
                $this->str9Holes,
                $this->str18Holes,
                $this->strTaxInc,
                $this->strFeeNote,
                $this->strGm,
                $this->strDirGolf,
                $this->strHeadPro,
                $this->strSeasonal,
                $this->strMembershipType,
                $this->strHoles,
                $this->strCoursePar,
                $this->strTeachingProfessionals,
                $this->strCourseSuperintendent,
                $this->strBanqFac,
                $this->strMaxCap,
                $this->strCoordinator,
                $this->strCourseAmenities,
                $this->strCourseArchitects,
                $this->strCourseComments,
                $this->strCourseAComments,
                $this->intHits,
                $this->strStatus,
                Date('Y-m-d'),
                $this->intLevel,
                $this->strFocusKeyword,
				$this->strMetaTitle,
				$this->strMetaKeywords,
				$this->strMetaDescription,
				$this->strMetaRobots,
				$this->intScoreSEO,
				$this->strFacebookTitle,
				$this->strFacebookDescription,
				$this->strTwitterTitle,
				$this->strTwitterDescription,
				$this->strGoogleDescription,
				$this->strBookingReportEmail,
				$this->strBookingReportFrequency,
				$this->strBookingUrl,
				$this->strBookingUsername,
				$this->strBookingPassword
           	);


			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;

			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}

			// Delete any files that were checked for deletion
            if (!empty($this->arrFilesToDelete)) {
                foreach ($this->arrFilesToDelete as $strFieldName => $strFilePath) {
                    if (Util::deleteFile($strFilePath)) {
                        $this->strQuery = "UPDATE $this->strTableName SET `$strFieldName` = NULL WHERE `id` = $this->intID";
                        $this->short_query($this->strQuery);
                    }
                }
            }


            if($_FILES['display_image']['error'] != 4) {
				// Upload our image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['display_image'],
	                $this->strUploadsDir,
	                $this->intID.'_course_img',
	                array('image/*'),
	                true,
	                true
	            );

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET display_image = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br /> Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }

			if($_FILES['facebook_image']['error'] != 4) {
	            // Upload our Facebook image
				$arrUploaded = Util::uploadFile(
	                $_FILES['facebook_image'],
	                $this->strUploadsDir,
	                $this->intID.'_facebook',
	                array('image/*'),
	                true,
	                true
	            );

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET facebook_image = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br />Facebook Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


	        if($_FILES['twitter_image']['error'] != 4) {
	            // Upload our twitter image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['twitter_image'],
	                $this->strUploadsDir,
	                $this->intID.'_twitter',
	                array('image/*'),
	                true,
	                true
	            );

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET twitter_image = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br />Twitter Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


        } //error message check

        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.* , c.id As country_id, s.id As state_id, r.region_name
		From $this->strTableName t
		Left Join region r on r.id=t.region_id
		Left Join city c1 on c1.id=t.city_id
		Left Join state s on s.id=c1.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.id=$id
		LIMIT 0,1";

		//Util::debugDisplay($this->strQuery);

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$this->strCourseName = isset($result['course_name']) ? trim($result['course_name']) : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
			$this->intTypeId = isset($result['type_id']) ? $result['type_id'] : '';
			$this->intHits = isset($result['hit_counter']) ? $result['hit_counter'] : '';
			$this->intCityId = isset($result['city_id']) ? $result['city_id'] : '';
			$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
			$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
			$this->strAddress = isset($result['address']) ? $result['address'] : '';
			$this->strZip = isset($result['zip']) ? $result['zip'] : '';
			$this->strLatitude = isset($result['latitude']) ? $result['latitude'] : '';
			$this->strLongitude = isset($result['longitude']) ? $result['longitude'] : '';
			$this->strContactPerson = isset($result['contact_person']) ? $result['contact_person'] : '';
			$this->strContactPhone = isset($result['contact_phone']) ? $result['contact_phone'] : '';
			$this->strContactFax = isset($result['contact_fax']) ? $result['contact_fax'] : '';
			$this->strContactEmail = isset($result['contact_email']) ? $result['contact_email'] : '';
			$this->strAccountEmail = isset($result['account_email']) ? $result['account_email'] : '';
			$this->strAccountName = isset($result['account_name']) ? $result['account_name'] : '';
			$this->strWebUrl = isset($result['web_url']) ? $result['web_url'] : '';
			$this->strFacebookUrl = isset($result['facebook_url']) ? $result['facebook_url'] : '';
			$this->strTwitterUrl = isset($result['twitter_url']) ? $result['twitter_url'] : '';
			$this->strComments = isset($result['comments']) ? $result['comments'] : '';

			$this->strFocusKeyword = isset($result['focus_keyword']) ? $result['focus_keyword'] : '';
			$this->strMetaTitle = isset($result['meta_title']) ? $result['meta_title'] : '';
			$this->strMetaKeywords = isset($result['meta_keywords']) ? $result['meta_keywords'] : '';
			$this->strMetaDescription = isset($result['meta_description']) ? $result['meta_description'] : '';
			$this->strMetaRobots = isset($result['meta_robots']) ? $result['meta_robots'] : "index,follow";
			$this->strFacebookTitle = isset($result['facebook_title']) ? $result['facebook_title'] : '';
			$this->strFacebookDescription = isset($result['facebook_description']) ? $result['facebook_description'] : '';
			$this->strTwitterTitle = isset($result['twitter_title']) ? $result['twitter_title'] : '';
			$this->strTwitterDescription = isset($result['twitter_description']) ? $result['twitter_description'] : '';
			$this->strGoogleDescription = isset($result['google_description']) ? $result['google_description'] : '';

			$this->strTeetimesPhone = isset($result['teetimes_phone']) ? $result['teetimes_phone'] : '';
			$this->strTeetimesEmail = isset($result['teetimes_email']) ? $result['teetimes_email'] : '';
			$this->strClubhousePhone = isset($result['clubhouse_phone']) ? $result['clubhouse_phone'] : '';
			$this->strProshopPhone = isset($result['proshop_phone']) ? $result['proshop_phone'] : '';
			$this->strDisplayImage = isset($result['display_image']) ? $result['display_image'] : '';
			$this->strPromotions = isset($result['promotions']) ? $result['promotions'] : '';
			$this->strDirections = isset($result['directions']) ? $result['directions'] : '';
			$this->strBookingPolicies = isset($result['booking_policies']) ? $result['booking_policies'] : '';
			//$this->strTeeBoxes = isset($result['tee_boxes']) ? $result['tee_boxes'] : array('Tee Box'=>'','Yardage'=>'','Par'=>'','Rating'=>'','Slope'=>'');
			$this->strTeeBoxes = isset($result['tee_boxes']) ? $result['tee_boxes'] : $this->strTeeBoxes;
			$this->str9Holes = isset($result['9holes']) ? $result['9holes'] : $this->str9Holes;
			$this->strFeeNote = isset($result['fee_note']) ? $result['fee_note'] : '';
			$this->strTaxInc = isset($result['tax_inc']) ? $result['tax_inc'] : '';
			$this->strGm = isset($result['gm']) ? $result['gm'] : '';
			$this->strDirGolf = isset($result['dir_golf']) ? $result['dir_golf'] : '';
			$this->strHeadPro = isset($result['head_pro']) ? $result['head_pro'] : '';
			$this->strSeasonal = isset($result['seasonal']) ? $result['seasonal'] : '';
			$this->strMembershipType = isset($result['membership_type']) ? $result['membership_type'] : '';
			$this->strHoles = isset($result['holes']) ? $result['holes'] : '';
			$this->strCoursePar = isset($result['course_par']) ? $result['course_par'] : '';
			$this->strTeachingProfessionals = isset($result['teaching_professionals']) ? $result['teaching_professionals'] : '';
			$this->strCourseSuperintendent = isset($result['course_superintendent']) ? $result['course_superintendent'] : '';
			$this->strBanqFac = isset($result['banq_fac']) ? $result['banq_fac'] : '';
			$this->strMaxCap = isset($result['max_cap']) ? $result['max_cap'] : '';
			$this->strCoordinator = isset($result['coordinator']) ? $result['coordinator'] : '';
			$this->strCourseAmenities = isset($result['course_amenities']) ? $result['course_amenities'] : '';
			$this->strCourseArchitects = isset($result['course_architects']) ? $result['course_architects'] : '';
			$this->strCourseComments = isset($result['course_comments']) ? $result['course_comments'] : '';
			$this->strCourseAComments = isset($result['course_a_comments']) ? $result['course_a_comments'] : '';
			$this->str18Holes = (isset($result['18holes']) && !is_null($result['18holes']) && $result['18holes'] != '') ? $result['18holes'] : $this->str18Holes;
			$this->strStatus = isset($result['status']) ? trim($result['status']) : '';
			$this->strSlug = '/golf-courses/'.$this->strSlug;
			$this->intLevel = isset($result['level']) ? $result['level'] : '';

			$this->strBookingReportEmail = isset($result['booking_report_email']) ? $result['booking_report_email'] : '';
			$this->strBookingReportFrequency = isset($result['booking_report_frequency']) ? $result['booking_report_frequency'] : '';

            $this->strBookingUrl = isset($result['booking_url']) ? $result['booking_url'] : '';
            $this->strBookingUsername = isset($result['booking_username']) ? $result['booking_username'] : '';
            $this->strBookingPassword = isset($result['booking_password']) ? $result['booking_password'] : '';

			// Score the SEO content of the page
            if (class_exists('SEO_Scorer')) {
                $objScore = new SEO_Scorer(array(
                    'keyword' => $this->strFocusKeyword,
                    'meta_title' => $this->strMetaTitle,
                    'meta_description' => $this->strMetaDescription,
                    'meta_robots' => $this->strMetaRobots,
                    'content' => $this->strComments,
                    'url' => $this->strSlug
                ));
                $this->arrScore = $objScore->getScore();
            }


			//Util::debugDisplay('<br /><br /><br />h2='.$this->str18Holes);

			//$result['images'] = $this->getCourseImageList($id);
			//$tb1 = array('Tee Box'=>'Blue','Yardage'=>'6600','Par'=>'71','Rating'=>'70.1','Slope'=>'131');
			//$tb2 = array('Tee Box'=>'White','Yardage'=>'6244','Par'=>'71','Rating'=>'69.3','Slope'=>'123');
			//$tb3 = array('Tee Box'=>'Red','Yardage'=>'5747','Par'=>'74','Rating'=>'67.2','Slope'=>'118');
			//$tb = array($tb1,$tb2,$tb3);
			//$this->strTeeBoxes = json_encode($tb);
			/*


[{"Tee_Box":"Blue","Yardage":"6600","Par":"71","Rating":"70.1","Slope":"131"},{"Tee_Box":"White","Yardage":"6244","Par":"71","Rating":"69.3","Slope":"123"},{"Tee_Box":"Red","Yardage":"5747","Par":"74","Rating":"67.2","Slope":"118"},{"Tee_Box":"","Yardage":"","Par":"","Rating":"","Slope":""},{"Tee_Box":"","Yardage":"","Par":"","Rating":"","Slope":""},{"Tee_Box":"","Yardage":"","Par":"","Rating":"","Slope":""}]
			*/
	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
	   	 	$this->strQuery1 .= "AND t.status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.course_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, contact_email, c.type_name , s.state_name
	     From $this->strTableName t
	     Left Join course_type c on c.id=t.type_id
	     Left Join city c2 on c2.id=t.city_id
	     Left Join state s on s.id=c2.state_id
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.course_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery1);
		 	echo '<br />';
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }


	     //We marked most courses as Trash at Ross's request with this statement. The records are left in case any back pages are need.

	     /*


		Select c.id,c.course_name,type_name,region_id,r.region_name FROM course c
		Left Join region r on r.id=c.region_id
		left join course_type t on t.id=c.type_id
		WHERE r.state_id=2
		OR type_id in (3,7)

		UPDATE course SET status='Trash'

		UPDATE course c
		Left Join region r on r.id=c.region_id
		SET status='Active'
		WHERE r.state_id=2
		OR type_id in (3,7)
		AND deleted=0

	     */






	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getCategories() {

		$strQuery = "SELECT *
		FROM course_type WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getManagers() {

		$strQuery = "SELECT *
		FROM members where level>0 and confirmed=1 and approved=1 And status='Active' order by email asc";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}


	public function getCourseImageList($course_id) {
		/*
		Import sql to insert new records from the files table
		INSERT INTO course_img (title,file_name,course_id,display_order)
		SELECT file_title As title, concat('/application/uploads/courses/2013/',file_name) As file_name,
		cat_id As course_id, file_num As display_order FROM files WHERE section_name='golf course' ANd file_type='Image'

		*/

		$strQuery = "SELECT *
		FROM course_img where course_id=$course_id AND status = 'Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}

	public function getCourseDocList($course_id) {
		/*
		Import sql to insert new records from the files table
		INSERT INTO course_img (title,file_name,course_id,display_order)
		SELECT file_title As title, concat('/application/uploads/courses/2013/',file_name) As file_name,
		cat_id As course_id, file_num As display_order FROM files WHERE section_name='golf course' ANd file_type='Image'

		*/

		$strQuery = "SELECT *
		FROM course_files where course_id=$course_id AND status = 'Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}



	public function getCourseVideoList($course_id) {
		/*
		Import sql to insert new records from the files table
		INSERT INTO course_videos (title, embed_code, course_id, display_order)
		SELECT file_title As title, embed_code, cat_id As course_id, file_num As display_order FROM files WHERE section_name='golf course' ANd file_type='youtube'

		UPDATE course_videos SET url= REPLACE(REPLACE(SUBSTRING_INDEX(SUBSTRING_INDEX( embed_code , 'youtube.com' ,-1 ), '?',1) ,'/v/','') ,'/embed/','')

		*/

		$strQuery = "SELECT *
		FROM course_videos where course_id=$course_id";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return 0;
	    }

	}


	public function getCourseReviewList($course_id, $debug = false) {

		$strQuery = "SELECT *
		FROM course_reviews where course_id=$course_id";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}


		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getCourseTestimonialList($course_id, $debug = false) {

		$strQuery = "SELECT *
		FROM testimonial where course_id=$course_id";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}


		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

	public function getCourseExport() {
		$strQuery = "
			SELECT t.*,
				contact_email,
				c.type_name,
				s.state_name,
				c2.title as city_name,
				cn.country_name as country_name
			     From course t
			     Left Join course_type c on c.id=t.type_id
			     Left Join city c2 on c2.id=t.city_id
			     Left Join state s on s.id=c2.state_id
			     left join country cn on c2.country_id = cn.id
			     WHERE t.`id` > 0 AND t.status='Active' ORDER BY course_name
		";

		$arrRecords = $this->getMysqliResults($strQuery,true);

		foreach ($arrRecords as $intIndex => $arrRecord) {
			$strTestimonialQuery = "
				SELECT * FROM testimonial WHERE course_id = '".$arrRecord['id']."'
			";

			$arrTestimonials = $this->getMysqliResults($strTestimonialQuery, true);

			if (empty($arrTestimonials)) {
				$arrRecords[$intIndex]['testimonial'] = '';
			} else {

				$strTestimonial = '';
				foreach ($arrTestimonials as $arrTestimonial) {
					$strTestimonial .= "
						First Name: " . $arrTestimonial['first_name'] . " \n
						Last Name: " . $arrTestimonial['last_name'] . " \n
						City: " . $arrTestimonial['city'] . " \n
						State: " . $arrTestimonial['state'] . " \n
						Country: " . $arrTestimonial['country'] . " \n
						Testimonial: " . str_replace('"','',str_replace("'", "", $arrTestimonial['detail'])) . " \n
						Timestamp: " . $arrTestimonial['timestamp_post'] . " \n \n
					";
				}

				$arrRecords[$intIndex]['testimonial'] = $strTestimonial;
			}
		}

		return $arrRecords;
	}

}



?>