<?php


class Brand extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strBrandName;
	public $blnLinks;
	public $blnLogo;
	public $strTitle;
	public $strSlug;
	public $strSearchWord;

	public $strAddress;
	public $strPhone;
	public $strFax;
	public $strTollFree;

	public $strWebUrl ;
	public $strEmailText;
	public $strInquiryText;

	public $strUploadsDir;
    public $strUploadsUrl;
    public $arrFilesToDelete;
    public $strDisplayImage;

	public $intID;
	public $intCatID;
	public $intCountryId = 261;
	public $intStateId = 2;
	public $intCityId = 6345;
	public $intRegionId;
	public $strAction;
	public $strTollfree ;
	public $strContactPerson;
	public $strContactPerson2;
	public $strContactEmail;
	public $strContactEmail2;
	public $strMiniPageText;
	public $strMiniQuotePageText;
	public $strVoucherEmailText;
	public $strMiniPageContent;
	public $strMiniQuotePageContent;
	public $strMiniPaymentText;
	public $strTerms;
	public $strBackgroundColor;
	public $strTextColor;
	public $strTVoucherText1;
	public $strTVoucherText2;
	public $strTVoucherText3;
	public $strTVoucherText4;
	public $strTVoucherText5;
	public $strMiniHotelText;
	public $strTeeTimesEmailText;
	public $strOneMonthText;
	public $strTwoWeekText;
    public $strSixMonthText;
	public $strfirstEmailNotice;
	public $strReminderEmail0;
	public $strReminderEmail1;
	public $strReminderEmail2;
	public $strReminderEmail3;
	public $strReminderEmail4;
	public $strReminderEmail5;
	public $strReminderEmail6;
    public $intReminderEmailDays0;
    public $intReminderEmailDays1;
    public $intReminderEmailDays2;
    public $intReminderEmailDays3;
    public $intReminderEmailDays4;
    public $intReminderEmailDays5;
    public $intReminderEmailDays6;

    public $strLinkFb;
    public $strLinkIg;
    public $strLinkGo;
    public $strLinkYt;
    public $strLinkEn;

	public function __construct($strPageId = '',$strAction = '') {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'brands';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/brand/';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/brands/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/brands/'.date('Y').'/';

		$this->strTitle = 'Brands';

	}

	public function handlePost($post,$id) {
		$this->intID = $id;
		$this->strBrandName = isset($post['business_name']) ? $post['business_name'] : '';
		$this->strSlug = isset($post['slug']) ? $post['slug'] : '';
		$this->strSlug = str_replace('/partner/','',$this->strSlug);
		$this->blnLinks = isset($post['blnLinks']) ? $post['blnLinks'] : '';
		$this->blnLogo = isset($post['blnLogo']) ? $post['blnLogo'] : '';
		$this->strAddress = isset($post['address']) ? $post['address'] : '';
		$this->strPhone = isset($post['phone']) ? $post['phone'] : '';
		$this->strFax = isset($post['fax']) ? $post['fax'] : '';
		$this->strTollFree = isset($post['tollfree']) ? $post['tollfree'] : '';
		$this->strContactEmail = isset($post['contact_email']) ? $post['contact_email'] : '';
		$this->strContactPerson = isset($post['contact_person']) ? $post['contact_person'] : '';
		$this->strContactEmail2 = isset($post['contact_email2']) ? $post['contact_email2'] : '';
		$this->strContactPerson2 = isset($post['contact_person2']) ? $post['contact_person2'] : '';

		$this->strWebUrl = isset($post['web_url']) ? $post['web_url'] : '';
		$this->strEmailText = isset($post['email_text']) ? $post['email_text'] : '';
		$this->strInquiryText = isset($post['inquiry_text']) ? $post['inquiry_text'] : '';
		$this->strMiniPageText = isset($post['mini_page_text']) ? $post['mini_page_text'] : '';
		$this->strMiniQuotePageText = isset($post['mini_quote_page_text']) ? $post['mini_quote_page_text'] : '';
		$this->strVoucherEmailText = isset($post['package_voucher_email_text']) ? $post['package_voucher_email_text'] : '';
		$this->strMiniPageContent = isset($post['mini_page_content']) ? $post['mini_page_content'] : '';
		$this->strMiniQuotePageContent = isset($post['mini_quote_page_content']) ? $post['mini_quote_page_content'] : '';
		$this->strTerms = isset($post['terms']) ? $post['terms'] : '';
		$this->strTVoucherText1 = isset($post['voucher_text_1']) ? $post['voucher_text_1'] : '';
		$this->strTVoucherText2 = isset($post['voucher_text_2']) ? $post['voucher_text_2'] : '';
		$this->strTVoucherText3 = isset($post['voucher_text_3']) ? $post['voucher_text_3'] : '';
		$this->strTVoucherText4 = isset($post['voucher_text_4']) ? $post['voucher_text_4'] : '';
		$this->strTVoucherText5 = isset($post['voucher_text_5']) ? $post['voucher_text_5'] : '';
		$this->strMiniHotelText = isset($post['mini_hotel_text']) ? $post['mini_hotel_text'] : '';
		$this->strTeeTimesEmailText = isset($post['course_teetimes_update_email']) ? $post['course_teetimes_update_email'] : '';
		$this->strMiniPaymentText = isset($post['mini_payment_text']) ? $post['mini_payment_text'] : '';
		$this->strOneMonthText = isset($post['oneMonthEmail']) ? $post['oneMonthEmail'] : '';
		$this->strTwoWeekText = isset($post['twoWeekSurvey']) ? $post['twoWeekSurvey'] : '';
        $this->strSixMonthText = isset($post['SixMonthFollowup']) ? $post['SixMonthFollowup'] : '';
		$this->strfirstEmailNotice = isset($post['firstEmailNotice']) ? $post['firstEmailNotice'] : '';
		$this->strTextColor = isset($post['text_color']) ? $post['text_color'] : '';
		$this->strBackgroundColor = isset($post['background_color']) ? $post['background_color'] : '';
		$this->intRegionId = isset($post['region_id']) ? $post['region_id'] : '';
		$this->arrSelectedCourses = isset($post['course_id']) ? $post['course_id'] : array();
		$this->arrSelectedHotels = isset($post['hotel_id']) ? $post['hotel_id'] : array();
		$this->arrSelectedBookingPeople = isset($post['booking_people_id']) ? $post['booking_people_id'] : array();

		$this->strReminderEmail0 = isset($post['reminder_email_0']) ? $post['reminder_email_0'] : '';
		$this->strReminderEmail1 = isset($post['reminder_email_1']) ? $post['reminder_email_1'] : '';
		$this->strReminderEmail2 = isset($post['reminder_email_2']) ? $post['reminder_email_2'] : '';
		$this->strReminderEmail3 = isset($post['reminder_email_3']) ? $post['reminder_email_3'] : '';
		$this->strReminderEmail4 = isset($post['reminder_email_4']) ? $post['reminder_email_4'] : '';
		$this->strReminderEmail5 = isset($post['reminder_email_5']) ? $post['reminder_email_5'] : '';
		$this->strReminderEmail6 = isset($post['reminder_email_6']) ? $post['reminder_email_6'] : '';

        $this->intReminderEmailDays0 = isset($post['reminder_email_days_0']) ? $post['reminder_email_days_0'] : '';
        $this->intReminderEmailDays1 = isset($post['reminder_email_days_1']) ? $post['reminder_email_days_1'] : '';
        $this->intReminderEmailDays2 = isset($post['reminder_email_days_2']) ? $post['reminder_email_days_2'] : '';
        $this->intReminderEmailDays3 = isset($post['reminder_email_days_3']) ? $post['reminder_email_days_3'] : '';
        $this->intReminderEmailDays4 = isset($post['reminder_email_days_4']) ? $post['reminder_email_days_4'] : '';
        $this->intReminderEmailDays5 = isset($post['reminder_email_days_5']) ? $post['reminder_email_days_5'] : '';
        $this->intReminderEmailDays6 = isset($post['reminder_email_days_6']) ? $post['reminder_email_days_6'] : '';

        $this->strLinkFb = isset($post['link_fb']) ? $post['link_fb'] : '';
        $this->strLinkIg = isset($post['link_ig']) ? $post['link_ig'] : '';
        $this->strLinkGo = isset($post['link_google']) ? $post['link_google'] : '';
        $this->strLinkYt = isset($post['link_youtube']) ? $post['link_youtube'] : '';
        $this->strLinkEn = isset($post['link_enews']) ? $post['link_enews'] : '';

        $this->arrFilesToDelete = isset($post['files_to_delete']) ? $post['files_to_delete'] : '';

		if($this->strBrandName == '') { $this->strErrorMessage .= "Please enter a name for this brand.<br />"; }
		if($this->strSlug == '') { $this->strErrorMessage .= "Please enter a slug for this brand.<br />"; }

		if($this->strSlug == '' && $this->strBrandName != '') { $this->strSlug = $this->strBrandName; }
        //$this->strSlug = Util::cleanForUrl($this->strSlug);

		$slug_exists = $this->validSlug($this->strTableName, $this->strSlug, $this->intID);
		if(!empty($slug_exists)){
			$this->strErrorMessage .= "Brand with this slug already exists.<br />";
		}

		if($this->strErrorMessage == '') {

			$keys = array(
				'business_name',
				'slug',
				'blnLinks',
				'blnLogo',
				'address',
				'phone',
				'fax',
				'tollfree',
				'contact_email',
				'contact_person',
				'web_url',
				'email_text',
				'inquiry_text',
				'mini_email_text',
				'mini_quote_email_text',
				'terms',
				'voucher_text_1',
				'voucher_text_2',
				'voucher_text_3',
				'voucher_text_4',
				'voucher_text_5',
				'text_color',
				'background_color',
				'region_id',
				'mini_page_text',
				'mini_quote_page_text',
				'contact_person2',
				'contact_email2',
				'mini_hotel_text',
				'course_teetimes_update_email',
				'mini_payment_text',
				'oneMonthEmail',
				'twoWeekSurvey',
                'sixMonthFollowup',
				'firstEmailNotice',
				'voucher_email_text',
				'reminder_email_0',
				'reminder_email_1',
				'reminder_email_2',
				'reminder_email_3',
				'reminder_email_4',
				'reminder_email_5',
				'reminder_email_6',
                'reminder_email_0_days',
                'reminder_email_1_days',
                'reminder_email_2_days',
                'reminder_email_3_days',
                'reminder_email_4_days',
                'reminder_email_5_days',
                'reminder_email_6_days',
                'link_fb',
                'link_ig',
                'link_google',
                'link_youtube',
                'link_enews'
			);
			$vals = array(
				$this->strBrandName,
				$this->strSlug,
				$this->blnLinks,
				$this->blnLogo,
				$this->strAddress,
				$this->strPhone,
				$this->strFax,
				$this->strTollFree,
				$this->strContactEmail,
				$this->strContactPerson,
				$this->strWebUrl,
				$this->strEmailText,
				$this->strInquiryText,
				$this->strMiniPageText,
				$this->strMiniQuotePageText,
				$this->strTerms,
				$this->strTVoucherText1,
				$this->strTVoucherText2,
				$this->strTVoucherText3,
				$this->strTVoucherText4,
				$this->strTVoucherText5,
				$this->strTextColor,
				$this->strBackgroundColor,
				$this->intRegionId,
				$this->strMiniPageContent,
				$this->strMiniQuotePageContent,
				$this->strContactPerson2,
				$this->strContactEmail2,
				$this->strMiniHotelText,
				$this->strTeeTimesEmailText,
				$this->strMiniPaymentText,
				$this->strOneMonthText,
				$this->strTwoWeekText,
                $this->strSixMonthText,
				$this->strfirstEmailNotice,
				$this->strVoucherEmailText,
				$this->strReminderEmail0,
				$this->strReminderEmail1,
				$this->strReminderEmail2,
				$this->strReminderEmail3,
				$this->strReminderEmail4,
				$this->strReminderEmail5,
				$this->strReminderEmail6,
                $this->intReminderEmailDays0,
                $this->intReminderEmailDays1,
                $this->intReminderEmailDays2,
                $this->intReminderEmailDays3,
                $this->intReminderEmailDays4,
                $this->intReminderEmailDays5,
                $this->intReminderEmailDays6,
                $this->strLinkFb,
                $this->strLinkIg,
                $this->strLinkGo,
                $this->strLinkYt,
                $this->strLinkEn
			);
			//$types = array('ssiissssssssssssssssssi');

			if($this->intID == '') {
				// No ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;
			} else {
				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				$this->strSuccessMessage = 'Record Saved';
			}

			// Delete any files that were checked for deletion
            if (!empty($this->arrFilesToDelete)) {
                foreach ($this->arrFilesToDelete as $strFieldName => $strFilePath) {
                    if (Util::deleteFile($strFilePath)) {
                        $this->strQuery = "UPDATE $this->strTableName SET `$strFieldName` = NULL WHERE `id` = $this->intID";
                        $this->short_query($this->strQuery);
                    }
                }
            }

            if($_FILES['display_image']['error'] != 4) {
                // Upload our display image
                $arrUploaded = Util::uploadFile(
                    $_FILES['display_image'],
                    $this->strUploadsDir,
                    $this->intID.'_logo',
                    array('image/*')
                );
                if ($arrUploaded) {
                    // If the file uploaded successfully
                    $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                    $fileName = $url.$arrUploaded['file'];

                    $this->strQuery = 'UPDATE '.$this->strTableName.' SET `display_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
                    if($this->short_query($this->strQuery)) {
                        $this->strSuccessMessage .= '<br> Logo Image Updated';
                    } else {
                        $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                    }
                }
            }

			if(count($this->arrSelectedCourses) == 0) {
				$delSql = "DELETE FROM brand_courses WHERE brand_id=$this->intID";
			} else {
				$csvSelectedCourses = implode(",",$this->arrSelectedCourses);
				$delSql = "DELETE FROM brand_courses WHERE brand_id=$this->intID AND course_id not in ($csvSelectedCourses)";
			}

			$this->short_query($delSql);
			foreach($this->arrSelectedCourses As $k=>$c) {
				$sql = "INSERT INTO brand_courses (brand_id, course_id)
				VALUES ($this->intID, ".$c.")
				ON DUPLICATE KEY UPDATE brand_id=$this->intID";

				$this->short_query($sql);
			}


			if(count($this->arrSelectedHotels) == 0) {
				$delSql = "DELETE FROM brand_hotels WHERE brand_id=$this->intID";
			} else {
				$csvSelectedHotels = implode(",",$this->arrSelectedHotels);
				$delSql = "DELETE FROM brand_hotels WHERE brand_id=$this->intID AND hotel_id not in ($csvSelectedHotels)";
			}


			$this->short_query($delSql);
			foreach($this->arrSelectedHotels As $k=>$h) {
				$sql = "INSERT INTO brand_hotels (brand_id, hotel_id)
				VALUES ($this->intID, ".$h.")
				ON DUPLICATE KEY UPDATE brand_id=$this->intID";

				$this->short_query($sql);
			}

			$delSql = "DELETE FROM brand_booking_people WHERE brand_id=$this->intID";
			$this->short_query($delSql);

			foreach($this->arrSelectedBookingPeople As $k=>$h) {
				$sql = "INSERT INTO brand_booking_people (brand_id, booking_people_id)
				VALUES ($this->intID, ".$h.")";

				$this->short_query($sql);
			}

        } //error message check

        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getMiniEmailContent($id,$debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT b.mini_email_text, mini_page_text
		From $this->strTableName b
		WHERE b.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;

		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$this->strMiniEmailText = isset($result['mini_email_text']) ? $result['mini_email_text'] : '';
			return $this->strMiniEmailText;
		} else {
			return null;
		}

	}

	public function getMiniPaymentEmailContent($id,$debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT b.mini_email_text, mini_payment_text, business_name
		From $this->strTableName b
		WHERE b.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;

		if($debug) {
		 	Util::debugDisplay($this->strQuery);
		}

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			$this->strMiniEmailText = isset($result['mini_payment_text']) ? $result['mini_payment_text'] : '';
			$this->strBusinessName = $result['business_name'];
			return $this->strMiniEmailText;
		} else {
			return null;
		}

	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.*, c.id As country_id, s.id As state_id
		From $this->strTableName t
		Left Join region r on r.id=t.region_id
		Left Join state s on s.id=r.state_id
		Left Join country c on c.id=s.country_id
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);

			$result = $result[0];
			$this->arrSelectedCourses = array();
			$this->arrSelectedHotels = array();
			$this->arrSelectedBookingPeople = array();
			$this->strBrandName = isset($result['business_name']) ? $result['business_name'] : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
            $this->strDisplayImage = isset($result['display_image']) ? $result['display_image'] : '';
			$this->blnLinks = isset($result['blnLinks']) ? $result['blnLinks'] : '';
			$this->blnLogo = isset($result['blnLogo']) ? $result['blnLogo'] : '';
			$this->strAddress = isset($result['address']) ? $result['address'] : '';
			$this->strPhone = isset($result['phone']) ? $result['phone'] : '';
			$this->strFax = isset($result['fax']) ? $result['fax'] : '';
			$this->strTollFree = isset($result['tollfree']) ? $result['tollfree'] : '';
			$this->strContactEmail = isset($result['contact_email']) ? $result['contact_email'] : '';
			$this->strContactPerson = isset($result['contact_person']) ? $result['contact_person'] : '';
			$this->strWebUrl = isset($result['web_url']) ? $result['web_url'] : '';
			$this->strEmailText = isset($result['email_text']) ? $result['email_text'] : '';
			$this->strMiniPageContent = isset($result['mini_page_text']) ? $result['mini_page_text'] : '';
			$this->strMiniQuotePageContent = isset($result['mini_quote_page_text']) ? $result['mini_quote_page_text'] : '';
			$this->strVoucherEmailText = isset($result['voucher_email_text']) ? $result['voucher_email_text'] : '';
			$this->strMiniPaymentText = isset($result['mini_payment_text']) ? $result['mini_payment_text'] : '';
			$this->strInquiryText = isset($result['inquiry_text']) ? $result['inquiry_text'] : '';
			$this->intCountryId = isset($result['country_id']) ? $result['country_id'] : '';
			$this->intStateId = isset($result['state_id']) ? $result['state_id'] : '';
			$this->strMiniPageText = isset($result['mini_email_text']) ? $result['mini_email_text'] : '';
			$this->strMiniQuotePageText = isset($result['mini_quote_email_text']) ? $result['mini_quote_email_text'] : '';
			$this->strContactEmail2 = isset($result['contact_email2']) ? $result['contact_email2'] : '';
			$this->strContactPerson2 = isset($result['contact_person2']) ? $result['contact_person2'] : '';
			$this->strTerms = isset($result['terms']) ? $result['terms'] : '';
			$this->strTextColor = isset($result['text_color']) ? $result['text_color'] : '';
			$this->strBackgroundColor = isset($result['background_color']) ? $result['background_color'] : '';
			$this->strTVoucherText1 = isset($result['voucher_text_1']) ? $result['voucher_text_1'] : '';
			$this->strTVoucherText2 = isset($result['voucher_text_2']) ? $result['voucher_text_2'] : '';
			$this->strTVoucherText3 = isset($result['voucher_text_3']) ? $result['voucher_text_3'] : '';
			$this->strTVoucherText4 = isset($result['voucher_text_4']) ? $result['voucher_text_4'] : '';
			$this->strTVoucherText5 = isset($result['voucher_text_5']) ? $result['voucher_text_5'] : '';

			$this->strReminderEmail0 = isset($result['reminder_email_0']) ? $result['reminder_email_0'] : '';
			$this->strReminderEmail1 = isset($result['reminder_email_1']) ? $result['reminder_email_1'] : '';
			$this->strReminderEmail2 = isset($result['reminder_email_2']) ? $result['reminder_email_2'] : '';
			$this->strReminderEmail3 = isset($result['reminder_email_3']) ? $result['reminder_email_3'] : '';
			$this->strReminderEmail4 = isset($result['reminder_email_4']) ? $result['reminder_email_4'] : '';
			$this->strReminderEmail5 = isset($result['reminder_email_5']) ? $result['reminder_email_5'] : '';
			$this->strReminderEmail6 = isset($result['reminder_email_6']) ? $result['reminder_email_6'] : '';

            $this->intReminderEmailDays0 = isset($result['reminder_email_0_days']) ? $result['reminder_email_0_days'] : '';
            $this->intReminderEmailDays1 = isset($result['reminder_email_1_days']) ? $result['reminder_email_1_days'] : '';
            $this->intReminderEmailDays2 = isset($result['reminder_email_2_days']) ? $result['reminder_email_2_days'] : '';
            $this->intReminderEmailDays3 = isset($result['reminder_email_3_days']) ? $result['reminder_email_3_days'] : '';
            $this->intReminderEmailDays4 = isset($result['reminder_email_4_days']) ? $result['reminder_email_4_days'] : '';
            $this->intReminderEmailDays5 = isset($result['reminder_email_5_days']) ? $result['reminder_email_5_days'] : '';
            $this->intReminderEmailDays6 = isset($result['reminder_email_6_days']) ? $result['reminder_email_6_days'] : '';

            $this->strLinkFb = isset($result['link_fb']) ? $result['link_fb'] : '';
            $this->strLinkIg = isset($result['link_ig']) ? $result['link_ig'] : '';
            $this->strLinkGo = isset($result['link_google']) ? $result['link_google'] : '';
            $this->strLinkYt = isset($result['link_youtube']) ? $result['link_youtube'] : '';
            $this->strLinkEn = isset($result['link_enews']) ? $result['link_enews'] : '';

			$this->strMiniHotelText = isset($result['mini_hotel_text']) ? $result['mini_hotel_text'] : '';
			$this->strTeeTimesEmailText = isset($result['course_teetimes_update_email']) ? $result['course_teetimes_update_email'] : '';
			$this->intRegionId = isset($result['region_id']) ? $result['region_id'] : '';
			$this->strOneMonthText = isset($result['oneMonthEmail']) ? $result['oneMonthEmail'] : '';
			$this->strTwoWeekText = isset($result['twoWeekSurvey']) ? $result['twoWeekSurvey'] : '';
            $this->strSixMonthText = isset($result['sixMonthFollowup']) ? $result['sixMonthFollowup'] : '';
			$this->strfirstEmailNotice = isset($result['firstEmailNotice']) ? $result['firstEmailNotice'] : '';
			$this->strSlug = '/partner/'.$this->strSlug;



			$strQuery = "SELECT course_id FROM brand_courses WHERE brand_id=$id";
			if($this->query($strQuery)) {
		     	if($res = $this->getMysqliResults($strQuery,true)){
		     		//$this->arrSelectedCourses = $res;

		     		foreach($res As $r) {
		     			$this->arrSelectedCourses[] = $r['course_id'];
		     		}


		     	}
		     }


		    $strQuery = "SELECT hotel_id FROM brand_hotels WHERE brand_id=$id";
			if($this->query($strQuery)) {
		     	if($res = $this->getMysqliResults($strQuery,true)){
		     		//$this->arrSelectedCourses = $res;

		     		foreach($res As $r) {
		     			$this->arrSelectedHotels[] = $r['hotel_id'];
		     		}


		     	}
		     }

		    $strQuery = "SELECT booking_people_id FROM brand_booking_people WHERE brand_id=$id";
			if($this->query($strQuery)) {
		     	if($res = $this->getMysqliResults($strQuery,true)){
		     		//$this->arrSelectedCourses = $res;

		     		foreach($res As $r) {
		     			$this->arrSelectedBookingPeople[] = $r['booking_people_id'];
		     		}
		     	}
		     }



	     	return $result;
	    } else {
	     	return null;
	    }
	}

	public function getMiniDetail($brandID) {

		$this->strQuery = "SELECT mini_email_text, mini_quote_email_text, voucher_email_text, mini_hotel_text, voucher_text_1, voucher_text_2, voucher_text_3, voucher_text_4, voucher_text_5
		From $this->strTableName t
		WHERE t.id=$brandID
		LIMIT 0,1";

		if($this->query($this->strQuery)) {
			$result = $this->getMysqliResults($this->strQuery,true);
			$result = $result[0];
			return $result;
	    } else {
	     	return null;
	    }

		//return 'yay!'.$brandID;
	}




	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.business_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, r.`region_name` , s.state_name
	     From $this->strTableName t
	     Left Join region r on r.`id`=t.`region_id`
	     Left Join state s on s.`id`=r.`state_id`
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.business_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

		 if($pgSize != -1){
		     $this->strQuery .= " LIMIT $start,$pgSize ";
		 }

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}




	public function getHotels($id, $debug = false) {

		$strQuery = "SELECT id, hotel_name,
		(SELECT count(hotel_id) FROM brand_hotels WHERE brand_id=$id AND hotel_id=id) As blnActive
		from hotel h
		WHERE status='Active'
		ORDER BY hotel_name";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getBookingPeople($id, $debug = false) {

		$strQuery = "SELECT id, booking_name, booking_email,
		(SELECT count(booking_people_id) FROM brand_booking_people WHERE brand_id=$id AND booking_people_id=id) As blnActive,
		(SELECT business_name FROM brands WHERE id = $id) as business_name
		from booking_people h
		WHERE status='Active'
		ORDER BY booking_name";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getBrandEmails($id) {

		$arrSelectedBookingPeople = $this->getBookingPeople($id);
		$arrReturn = array();

		foreach ($arrSelectedBookingPeople as $arrSelectedBookingPerson) {
			if ($arrSelectedBookingPerson['blnActive'] == '1') {
				$arrReturn[] = $arrSelectedBookingPerson['booking_email'];
			}
		}

		if (count($arrReturn) > 0) {
			return $arrReturn;
		} else {
			return array('ross@bcgolfguide.com');
		}
	}

	public function getCourses($id, $debug = false) {

		$strQuery = "SELECT id, course_name ,
		(SELECT count(course_id) FROM brand_courses WHERE brand_id=$id AND course_id=id) As blnActive
		from course c
		WHERE status='Active'
		ORDER BY course_name";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		}

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public static function getCoursesByBrand($intBrandId, $blnDebug = false){
		if(empty($intBrandId)){
			// no brand to lookup
			return false;
		}

		$objBrand = new static;

		$objBrand->strQuery = "SELECT b.id AS brand_id, b.business_name, c.id AS course_id, c.course_name
								FROM brands b
								LEFT JOIN brand_courses bc
									ON bc.brand_id = b.id
								LEFT JOIN course c
									ON c.id = bc.course_id
								WHERE b.id = $intBrandId
								ORDER BY b.business_name, c.course_name";

		if(!$objBrand->query($objBrand->strQuery)){
			// mysql issue
			return false;
		}

		$arrResult = $objBrand->getMysqliResults($objBrand->strQuery,true);

		foreach($arrResult as &$arrBrand){
			$arrBrand['course_name'] = ucwords($arrBrand['course_name']);
		}

		return $arrResult;
	}

	public static function getHotelsByBrand($intBrandId, $blnDebug = false){
		if(empty($intBrandId)){
			// no brand to lookup
			return false;
		}

		$objBrand = new static;

		$objBrand->strQuery = "SELECT b.id AS brand_id, b.business_name, h.id AS hotel_id, h.hotel_name
								FROM brands b
								LEFT JOIN brand_hotels bh
									ON bh.brand_id = b.id
								LEFT JOIN hotel h
									ON h.id = bh.hotel_id
								WHERE b.id = $intBrandId
								ORDER BY b.business_name, h.hotel_name";

		if(!$objBrand->query($objBrand->strQuery)){
			// mysql issue
			return false;
		}

		$arrResult = $objBrand->getMysqliResults($objBrand->strQuery,true);

		return $arrResult;
	}

	public static function getBrandContacts($intBrandId, $blnDebug = false){
		if(empty($intBrandId)){
			// no brand to lookup
			return false;
		}

		$objBrand = new static;

		$objBrand->strQuery = "SELECT * FROM booking_people
								JOIN brand_booking_people ON (booking_people.id = brand_booking_people.booking_people_id)
							    WHERE brand_id = $intBrandId";

		$arrResult = $objBrand->getMysqliResults($objBrand->strQuery,true);

		return $arrResult;

	}

}



?>